/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.dependency;

import com.android.build.gradle.internal.dependency.GenericTransformParameters;
import com.android.build.gradle.internal.dependency.JacocoInstrumentationService;
import com.android.build.gradle.internal.tasks.JacocoTask;
import com.android.build.gradle.tasks.IncrementalChangesUtils;
import com.android.builder.files.RelativeFile;
import com.android.builder.files.SerializableChange;
import com.android.builder.files.SerializableFileChanges;
import com.android.ide.common.resources.FileStatus;
import com.android.utils.FileUtils;
import com.google.common.io.ByteStreams;
import com.google.common.io.Files;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.gradle.api.artifacts.transform.CacheableTransform;
import org.gradle.api.artifacts.transform.InputArtifact;
import org.gradle.api.artifacts.transform.TransformAction;
import org.gradle.api.artifacts.transform.TransformOutputs;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileSystemLocation;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.Internal;
import org.gradle.work.Incremental;
import org.gradle.work.InputChanges;
import org.jetbrains.annotations.NotNull;

@CacheableTransform
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\b'\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u00010B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J \u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J.\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u001a2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c2\u0006\u0010\u001e\u001a\u00020\u0014H\u0002J\u0018\u0010\u001f\u001a\u00020\u000f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0002J\u0010\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u0014H\u0002J\u0018\u0010'\u001a\u00020\u000f2\u0006\u0010(\u001a\u00020\u00142\u0006\u0010)\u001a\u00020\u0014H\u0002J\u0018\u0010*\u001a\u00020\u000f2\u0006\u0010+\u001a\u00020!2\u0006\u0010,\u001a\u00020\u0014H\u0002J\u000e\u0010-\u001a\u00020.2\u0006\u0010 \u001a\u00020!J\u000e\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u00020\u001aR\u0014\u0010\u0005\u001a\u00020\u00068gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u00061"}, d2={"Lcom/android/build/gradle/internal/dependency/JacocoTransform;", "Lorg/gradle/api/artifacts/transform/TransformAction;", "Lcom/android/build/gradle/internal/dependency/JacocoTransform$Params;", "<init>", "()V", "inputChanges", "Lorg/gradle/work/InputChanges;", "getInputChanges", "()Lorg/gradle/work/InputChanges;", "inputArtifact", "Lorg/gradle/api/provider/Provider;", "Lorg/gradle/api/file/FileSystemLocation;", "getInputArtifact", "()Lorg/gradle/api/provider/Provider;", "transform", "", "transformOutputs", "Lorg/gradle/api/artifacts/transform/TransformOutputs;", "transformDirectory", "rootDir", "Ljava/io/File;", "changes", "Lcom/android/builder/files/SerializableFileChanges;", "processIncrementalClasspathFileChange", "file", "normalizedPath", "", "fileStatuses", "", "Lcom/android/ide/common/resources/FileStatus;", "classOutputDir", "cleanTransformOutputFile", "relativeFile", "Lcom/android/builder/files/RelativeFile;", "classesOutputPath", "Ljava/nio/file/Path;", "isJarFile", "", "candidateFile", "instrumentJar", "inputJar", "outputJar", "instrumentFile", "sourceFile", "outputDir", "getInstrumentationAction", "Lcom/android/build/gradle/internal/tasks/JacocoTask$Action;", "relativePath", "Params", "gradle-core"})
@SourceDebugExtension(value={"SMAP\nJacocoTransform.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JacocoTransform.kt\ncom/android/build/gradle/internal/dependency/JacocoTransform\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,242:1\n1485#2:243\n1510#2,3:244\n1513#2,3:254\n1557#2:257\n1628#2,3:258\n381#3,7:247\n*S KotlinDebug\n*F\n+ 1 JacocoTransform.kt\ncom/android/build/gradle/internal/dependency/JacocoTransform\n*L\n100#1:243\n100#1:244,3\n100#1:254,3\n105#1:257\n105#1:258,3\n100#1:247,7\n*E\n"})
public abstract class JacocoTransform
implements TransformAction<Params> {
    @Inject
    @NotNull
    public abstract InputChanges getInputChanges();

    @InputArtifact
    @Classpath
    @Incremental
    @NotNull
    public abstract Provider<FileSystemLocation> getInputArtifact();

    public void transform(@NotNull TransformOutputs transformOutputs) {
        Intrinsics.checkNotNullParameter((Object)transformOutputs, (String)"transformOutputs");
        File inputArtifactFile = ((FileSystemLocation)this.getInputArtifact().get()).getAsFile();
        Intrinsics.checkNotNull((Object)inputArtifactFile);
        if (this.isJarFile(inputArtifactFile)) {
            File outputFile = transformOutputs.file((Object)("instrumented_" + inputArtifactFile.getName()));
            Intrinsics.checkNotNull((Object)outputFile);
            this.instrumentJar(inputArtifactFile, outputFile);
        } else {
            Iterable iterable = this.getInputChanges().getFileChanges(this.getInputArtifact());
            Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"getFileChanges(...)");
            SerializableFileChanges changes = IncrementalChangesUtils.toSerializable(iterable);
            this.transformDirectory(inputArtifactFile, changes, transformOutputs);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void transformDirectory(File rootDir, SerializableFileChanges changes, TransformOutputs transformOutputs) {
        Map $this$getOrPut$iv$iv$iv;
        void $this$groupByTo$iv$iv;
        if (!rootDir.isDirectory()) {
            throw new IOException(rootDir + " must be a directory.");
        }
        File classOutputDir = transformOutputs.dir((Object)"instrumented_classes");
        Iterable $this$groupBy$iv = changes.getFileChanges();
        boolean $i$f$groupBy = false;
        Iterable iterable = $this$groupBy$iv;
        Object destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            SerializableChange it = (SerializableChange)element$iv$iv;
            boolean bl = false;
            String key$iv$iv = FilesKt.getInvariantSeparatorsPath((File)it.getFile());
            $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        Map fileChanges = destination$iv$iv;
        Iterator iterator2 = fileChanges.entrySet().iterator();
        while (iterator2.hasNext()) {
            Collection<FileStatus> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            List changesForAbsoluteFilepath = (List)iterator2.next().getValue();
            destination$iv$iv = changesForAbsoluteFilepath;
            String string = ((SerializableChange)CollectionsKt.first((List)changesForAbsoluteFilepath)).getNormalizedPath();
            File file = ((SerializableChange)CollectionsKt.first((List)changesForAbsoluteFilepath)).getFile();
            JacocoTransform jacocoTransform = this;
            boolean $i$f$map = false;
            Iterator iterator3 = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                $this$getOrPut$iv$iv$iv = (SerializableChange)item$iv$iv;
                collection = destination$iv$iv2;
                boolean bl = false;
                collection.add(it.getFileStatus());
            }
            collection = (List)destination$iv$iv2;
            Intrinsics.checkNotNull((Object)classOutputDir);
            jacocoTransform.processIncrementalClasspathFileChange(file, string, (List<? extends FileStatus>)collection, classOutputDir);
        }
    }

    private final void processIncrementalClasspathFileChange(File file, String normalizedPath, List<? extends FileStatus> fileStatuses, File classOutputDir) {
        RelativeFile relativeFile = RelativeFile.fileInDirectory((String)StringsKt.replace$default((String)normalizedPath, (char)File.separatorChar, (char)'/', (boolean)false, (int)4, null), (File)file);
        if (fileStatuses.size() == 1 && CollectionsKt.first(fileStatuses) == FileStatus.REMOVED) {
            Intrinsics.checkNotNull((Object)relativeFile);
            Path path = classOutputDir.toPath();
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toPath(...)");
            this.cleanTransformOutputFile(relativeFile, path);
        } else if (fileStatuses.contains(FileStatus.NEW) || fileStatuses.contains(FileStatus.CHANGED)) {
            Intrinsics.checkNotNull((Object)relativeFile);
            this.instrumentFile(relativeFile, classOutputDir);
        } else {
            throw new IllegalStateException(("Incremental Jacoco instrumentation failure: Invalid FileStatus '" + CollectionsKt.joinToString$default((Iterable)fileStatuses, null, null, null, (int)0, null, null, (int)63, null) + "' for normalised path '" + file.getAbsolutePath() + "'.").toString());
        }
    }

    private final void cleanTransformOutputFile(RelativeFile relativeFile, Path classesOutputPath) {
        String string = relativeFile.getRelativePath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getRelativePath(...)");
        if (this.getInstrumentationAction(string) == JacocoTask.Action.IGNORE) {
            return;
        }
        String[] stringArray = new String[]{relativeFile.getRelativePath()};
        File fileToRemove = FileUtils.join((File)classesOutputPath.toFile(), (String[])stringArray);
        FileUtils.deleteIfExists((File)fileToRemove);
    }

    private final boolean isJarFile(File candidateFile) {
        return candidateFile.isFile() && Intrinsics.areEqual((Object)FilesKt.getExtension((File)candidateFile), (Object)"jar");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void instrumentJar(File inputJar, File outputJar) {
        try {
            Closeable closeable = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(outputJar)));
            Throwable throwable = null;
            try {
                ZipOutputStream instrumentedJar = (ZipOutputStream)closeable;
                boolean bl = false;
                Closeable closeable2 = new ZipFile(inputJar);
                Throwable throwable2 = null;
                try {
                    ZipFile zip = (ZipFile)closeable2;
                    boolean bl2 = false;
                    Enumeration<? extends ZipEntry> entries2 = zip.entries();
                    block17: while (entries2.hasMoreElements()) {
                        byte[] byArray;
                        ZipEntry entry2 = entries2.nextElement();
                        String entryName = entry2.getName();
                        Intrinsics.checkNotNull((Object)entryName);
                        switch (WhenMappings.$EnumSwitchMapping$0[this.getInstrumentationAction(entryName).ordinal()]) {
                            case 1: {
                                continue block17;
                            }
                            case 2: {
                                byArray = ByteStreams.toByteArray((InputStream)zip.getInputStream(entry2));
                                break;
                            }
                            case 3: {
                                JacocoInstrumentationService jacocoInstrumentationService = (JacocoInstrumentationService)((Params)this.getParameters()).getJacocoInstrumentationService().get();
                                InputStream inputStream = zip.getInputStream(entry2);
                                Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"getInputStream(...)");
                                Iterable iterable = (Iterable)((Params)this.getParameters()).getJacocoConfiguration();
                                Object object = ((Params)this.getParameters()).getJacocoVersion().get();
                                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
                                byArray = jacocoInstrumentationService.instrument(inputStream, entryName, iterable, (String)object);
                                break;
                            }
                            default: {
                                throw new NoWhenBranchMatchedException();
                            }
                        }
                        byte[] data = byArray;
                        ZipEntry nextEntry = new ZipEntry(entryName);
                        nextEntry.setTime(-1L);
                        instrumentedJar.putNextEntry(nextEntry);
                        instrumentedJar.write(data);
                        instrumentedJar.closeEntry();
                    }
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException("Unable to instrument file with Jacoco: " + inputJar, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void instrumentFile(RelativeFile sourceFile, File outputDir) {
        JacocoTask.Action instrumentationAction = this.getInstrumentationAction(sourceFile);
        if (instrumentationAction == JacocoTask.Action.IGNORE) {
            return;
        }
        String string = sourceFile.getRelativePath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getRelativePath(...)");
        File outputFile = FilesKt.resolve((File)outputDir, (String)string);
        if (!outputFile.exists()) {
            Files.createParentDirs((File)outputFile);
        }
        if (instrumentationAction == JacocoTask.Action.INSTRUMENT) {
            byte[] byArray;
            File file = sourceFile.getFile();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getFile(...)");
            Object object = file;
            object = new FileInputStream((File)object);
            File file2 = outputFile;
            Throwable throwable = null;
            try {
                FileInputStream it = (FileInputStream)object;
                boolean bl = false;
                JacocoInstrumentationService jacocoInstrumentationService = (JacocoInstrumentationService)((Params)this.getParameters()).getJacocoInstrumentationService().get();
                InputStream inputStream = it;
                String string2 = sourceFile.getRelativePath();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getRelativePath(...)");
                Iterable iterable = (Iterable)((Params)this.getParameters()).getJacocoConfiguration();
                Object object2 = ((Params)this.getParameters()).getJacocoVersion().get();
                Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"get(...)");
                byArray = jacocoInstrumentationService.instrument(inputStream, string2, iterable, (String)object2);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
            }
            FilesKt.writeBytes((File)file2, (byte[])byArray);
        } else {
            FileUtils.copyFile((File)sourceFile.getFile(), (File)outputFile);
        }
    }

    @NotNull
    public final JacocoTask.Action getInstrumentationAction(@NotNull RelativeFile relativeFile) {
        Intrinsics.checkNotNullParameter((Object)relativeFile, (String)"relativeFile");
        String string = relativeFile.getRelativePath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getRelativePath(...)");
        return this.getInstrumentationAction(string);
    }

    @NotNull
    public final JacocoTask.Action getInstrumentationAction(@NotNull String relativePath) {
        Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
        return JacocoTask.Companion.calculateAction(relativePath);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\n8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00058gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\b\u00a8\u0006\u0010"}, d2={"Lcom/android/build/gradle/internal/dependency/JacocoTransform$Params;", "Lcom/android/build/gradle/internal/dependency/GenericTransformParameters;", "<init>", "()V", "jacocoVersion", "Lorg/gradle/api/provider/Property;", "", "getJacocoVersion", "()Lorg/gradle/api/provider/Property;", "jacocoConfiguration", "Lorg/gradle/api/file/ConfigurableFileCollection;", "getJacocoConfiguration", "()Lorg/gradle/api/file/ConfigurableFileCollection;", "jacocoInstrumentationService", "Lcom/android/build/gradle/internal/dependency/JacocoInstrumentationService;", "getJacocoInstrumentationService", "gradle-core"})
    public static abstract class Params
    implements GenericTransformParameters {
        @Internal
        @NotNull
        public abstract Property<String> getJacocoVersion();

        @Classpath
        @NotNull
        public abstract ConfigurableFileCollection getJacocoConfiguration();

        @Internal
        @NotNull
        public abstract Property<JacocoInstrumentationService> getJacocoInstrumentationService();
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[JacocoTask.Action.values().length];
            try {
                nArray[JacocoTask.Action.IGNORE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JacocoTask.Action.COPY.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JacocoTask.Action.INSTRUMENT.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

