/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.ndk;

import com.android.build.gradle.internal.core.Abi;
import com.android.build.gradle.internal.ndk.AbiInfo;
import com.android.build.gradle.internal.ndk.DefaultNdkInfo;
import com.android.build.gradle.internal.ndk.Stl;
import com.android.build.gradle.tasks.NativeBuildSystem;
import com.google.common.base.Preconditions;
import java.io.File;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0016\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0014J\u0010\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0018\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u000eH\u0016J\u0010\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u000eH\u0016J\u0010\u0010\u0016\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u000eH\u0016J\n\u0010\u0017\u001a\u0004\u0018\u00010\u000eH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0018"}, d2={"Lcom/android/build/gradle/internal/ndk/NdkR19Info;", "Lcom/android/build/gradle/internal/ndk/DefaultNdkInfo;", "root", "Ljava/io/File;", "<init>", "(Ljava/io/File;)V", "getRoot", "()Ljava/io/File;", "supportedStls", "", "Lcom/android/build/gradle/internal/ndk/Stl;", "getSupportedStls", "()Ljava/util/List;", "getToolchainAbi", "", "abi", "getDefaultStl", "buildSystem", "Lcom/android/build/gradle/tasks/NativeBuildSystem;", "getStlSharedObjectFile", "stl", "getStripExecutable", "getObjcopyExecutable", "validate", "gradle-core"})
@SourceDebugExtension(value={"SMAP\nNdkR19Info.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NdkR19Info.kt\ncom/android/build/gradle/internal/ndk/NdkR19Info\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,102:1\n626#2,12:103\n626#2,12:115\n*S KotlinDebug\n*F\n+ 1 NdkR19Info.kt\ncom/android/build/gradle/internal/ndk/NdkR19Info\n*L\n78#1:103,12\n85#1:115,12\n*E\n"})
public class NdkR19Info
extends DefaultNdkInfo {
    @NotNull
    private final File root;
    @NotNull
    private final List<Stl> supportedStls;

    public NdkR19Info(@NotNull File root) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        super(root);
        this.root = root;
        Stl[] stlArray = new Stl[]{Stl.LIBCXX_SHARED, Stl.LIBCXX_STATIC, Stl.NONE, Stl.SYSTEM};
        this.supportedStls = CollectionsKt.listOf((Object[])stlArray);
    }

    @NotNull
    public final File getRoot() {
        return this.root;
    }

    @Override
    @NotNull
    public List<Stl> getSupportedStls() {
        return this.supportedStls;
    }

    @Override
    @NotNull
    protected String getToolchainAbi(@NotNull String abi) {
        String string;
        Intrinsics.checkNotNullParameter((Object)abi, (String)"abi");
        if (Intrinsics.areEqual((Object)abi, (Object)Abi.MIPS.getTag())) {
            String string2 = Abi.MIPS64.getTag();
            Intrinsics.checkNotNull((Object)string2);
            string = string2;
        } else {
            string = abi;
        }
        return string;
    }

    @Override
    @NotNull
    public Stl getDefaultStl(@NotNull NativeBuildSystem buildSystem) {
        Stl stl;
        Intrinsics.checkNotNullParameter((Object)((Object)buildSystem), (String)"buildSystem");
        switch (WhenMappings.$EnumSwitchMapping$0[buildSystem.ordinal()]) {
            case 1: {
                stl = Stl.LIBCXX_STATIC;
                break;
            }
            case 2: {
                stl = Stl.SYSTEM;
                break;
            }
            case 3: {
                stl = Stl.UNKNOWN;
                break;
            }
            default: {
                throw new IllegalStateException(String.valueOf((Object)buildSystem).toString());
            }
        }
        return stl;
    }

    @Override
    @NotNull
    public File getStlSharedObjectFile(@NotNull Stl stl, @NotNull String abi) {
        String string;
        Intrinsics.checkNotNullParameter((Object)((Object)stl), (String)"stl");
        Intrinsics.checkNotNullParameter((Object)abi, (String)"abi");
        Preconditions.checkArgument((stl == Stl.LIBCXX_SHARED ? 1 : 0) != 0, (String)"Only c++_shared is valid for packaging as of NDK r19", (Object[])new Object[0]);
        Preconditions.checkArgument((boolean)this.getSupportedAbis().contains(abi), (String)("Unsupported ABI for NDK r19+: " + abi), (Object[])new Object[0]);
        String string2 = abi;
        if (Intrinsics.areEqual((Object)string2, (Object)Abi.ARM64_V8A.getTag())) {
            string = "aarch64-linux-android";
        } else if (Intrinsics.areEqual((Object)string2, (Object)Abi.ARMEABI_V7A.getTag())) {
            string = "arm-linux-androideabi";
        } else if (Intrinsics.areEqual((Object)string2, (Object)Abi.X86.getTag())) {
            string = "i686-linux-android";
        } else if (Intrinsics.areEqual((Object)string2, (Object)Abi.X86_64.getTag())) {
            string = "x86_64-linux-android";
        } else {
            throw new RuntimeException("Unsupported ABI for NDK r19+: " + abi);
        }
        String sysrootTriple = string;
        File file = FilesKt.resolve((File)this.getRootDirectory(), (String)("toolchains/llvm/prebuilt/" + this.getHostTag() + "/sysroot/usr/lib/" + sysrootTriple + "/" + stl.getLibraryName()));
        Preconditions.checkState((boolean)file.isFile(), (String)("Expected NDK STL shared object file at " + file), (Object[])new Object[0]);
        return file;
    }

    @Override
    @NotNull
    public File getStripExecutable(@NotNull String abi) {
        Intrinsics.checkNotNullParameter((Object)abi, (String)"abi");
        Iterable $this$single$iv = this.getAbiInfoList();
        boolean $i$f$single = false;
        Object single$iv = null;
        boolean found$iv = false;
        for (Object element$iv : $this$single$iv) {
            AbiInfo info2 = (AbiInfo)element$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)info2.getName(), (Object)abi)) continue;
            if (found$iv) {
                throw new IllegalArgumentException("Collection contains more than one matching element.");
            }
            single$iv = element$iv;
            found$iv = true;
        }
        if (!found$iv) {
            throw new NoSuchElementException("Collection contains no element matching the predicate.");
        }
        String triple = ((AbiInfo)single$iv).getTriple();
        return FilesKt.resolve((File)this.getRootDirectory(), (String)("toolchains/llvm/prebuilt/" + this.getHostTag() + "/bin/" + triple + "-strip"));
    }

    @Override
    @NotNull
    public File getObjcopyExecutable(@NotNull String abi) {
        Intrinsics.checkNotNullParameter((Object)abi, (String)"abi");
        Iterable $this$single$iv = this.getAbiInfoList();
        boolean $i$f$single = false;
        Object single$iv = null;
        boolean found$iv = false;
        for (Object element$iv : $this$single$iv) {
            AbiInfo info2 = (AbiInfo)element$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)info2.getName(), (Object)abi)) continue;
            if (found$iv) {
                throw new IllegalArgumentException("Collection contains more than one matching element.");
            }
            single$iv = element$iv;
            found$iv = true;
        }
        if (!found$iv) {
            throw new NoSuchElementException("Collection contains no element matching the predicate.");
        }
        String triple = ((AbiInfo)single$iv).getTriple();
        return FilesKt.resolve((File)this.getRootDirectory(), (String)("toolchains/llvm/prebuilt/" + this.getHostTag() + "/bin/" + triple + "-objcopy"));
    }

    @Override
    @Nullable
    public String validate() {
        File toolchainsDir = FilesKt.resolve((File)this.getRootDirectory(), (String)"toolchains");
        if (!toolchainsDir.isDirectory()) {
            return toolchainsDir + " is not a directory.";
        }
        return null;
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[NativeBuildSystem.values().length];
            try {
                nArray[NativeBuildSystem.CMAKE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NativeBuildSystem.NDK_BUILD.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NativeBuildSystem.NINJA.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

