/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.services;

import com.android.SdkConstants;
import com.android.build.gradle.internal.LoggerWrapper;
import com.android.build.gradle.internal.services.Aapt2Daemon;
import com.android.build.gradle.internal.services.Aapt2DaemonManagerMaintainer;
import com.android.build.gradle.internal.services.Aapt2DaemonServiceKey;
import com.android.build.gradle.internal.services.Aapt2Input;
import com.android.build.gradle.internal.services.Aapt2ThreadPoolBuildServiceKt;
import com.android.build.gradle.internal.services.PartialInProcessResourceProcessor;
import com.android.build.gradle.internal.services.ServiceRegistrationAction;
import com.android.build.gradle.options.ProjectOptions;
import com.android.build.gradle.options.SyncOptions;
import com.android.builder.internal.aapt.v2.Aapt2;
import com.android.builder.internal.aapt.v2.Aapt2DaemonImpl;
import com.android.builder.internal.aapt.v2.Aapt2DaemonManager;
import com.android.utils.ILogger;
import com.google.common.io.Closer;
import java.io.Closeable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.Project;
import org.gradle.api.provider.Property;
import org.gradle.api.services.BuildService;
import org.gradle.api.services.BuildServiceParameters;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\b&\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00060\u0003j\u0002`\u0004:\u0002!\"B\u0007\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015J\u0016\u0010\u0016\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aJ\u0018\u0010\u001b\u001a\u00020\f2\u0006\u0010\u001c\u001a\u00020\t2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u000e\u0010\u001d\u001a\u00020\u001a2\u0006\u0010\u001e\u001a\u00020\u0015J\b\u0010\u001f\u001a\u00020 H\u0016R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\r\u001a\n \u000f*\u0004\u0018\u00010\u000e0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/android/build/gradle/internal/services/Aapt2DaemonBuildService;", "Lorg/gradle/api/services/BuildService;", "Lcom/android/build/gradle/internal/services/Aapt2DaemonBuildService$Parameters;", "Ljava/lang/AutoCloseable;", "Lkotlin/AutoCloseable;", "<init>", "()V", "registeredServices", "", "Lcom/android/build/gradle/internal/services/Aapt2DaemonServiceKey;", "services", "", "Lcom/android/builder/internal/aapt/v2/Aapt2DaemonManager;", "closer", "Lcom/google/common/io/Closer;", "kotlin.jvm.PlatformType", "logger", "Lcom/android/utils/ILogger;", "getLeasingAapt2", "Lcom/android/builder/internal/aapt/v2/Aapt2;", "aapt2Input", "Lcom/android/build/gradle/internal/services/Aapt2Input;", "registerAaptService", "aapt2Version", "", "aaptExecutablePath", "Ljava/nio/file/Path;", "getManager", "key", "getAapt2ExecutablePath", "aapt2", "close", "", "Parameters", "RegistrationAction", "gradle-core"})
@SourceDebugExtension(value={"SMAP\nAapt2DaemonBuildService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Aapt2DaemonBuildService.kt\ncom/android/build/gradle/internal/services/Aapt2DaemonBuildService\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,272:1\n381#2,7:273\n1#3:280\n*S KotlinDebug\n*F\n+ 1 Aapt2DaemonBuildService.kt\ncom/android/build/gradle/internal/services/Aapt2DaemonBuildService\n*L\n110#1:273,7\n*E\n"})
public abstract class Aapt2DaemonBuildService
implements BuildService<Parameters>,
AutoCloseable {
    @NotNull
    private final Set<Aapt2DaemonServiceKey> registeredServices = new LinkedHashSet();
    @NotNull
    private final Map<Aapt2DaemonServiceKey, Aapt2DaemonManager> services = new LinkedHashMap();
    private final Closer closer = Closer.create();
    @NotNull
    private final ILogger logger;

    public Aapt2DaemonBuildService() {
        LoggerWrapper loggerWrapper = LoggerWrapper.getLogger(this.getClass());
        Intrinsics.checkNotNullExpressionValue((Object)loggerWrapper, (String)"getLogger(...)");
        this.logger = loggerWrapper;
    }

    @NotNull
    public final Aapt2 getLeasingAapt2(@NotNull Aapt2Input aapt2Input) {
        Intrinsics.checkNotNullParameter((Object)aapt2Input, (String)"aapt2Input");
        Object object = aapt2Input.getVersion().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        Aapt2DaemonManager manager = this.getManager(new Aapt2DaemonServiceKey((String)object), this.getAapt2ExecutablePath(aapt2Input));
        Aapt2 leasingAapt2 = manager.getLeasingAapt2Daemon();
        return new PartialInProcessResourceProcessor(leasingAapt2);
    }

    @NotNull
    public final synchronized Aapt2DaemonServiceKey registerAaptService(@NotNull String aapt2Version, @NotNull Path aaptExecutablePath) {
        Intrinsics.checkNotNullParameter((Object)aapt2Version, (String)"aapt2Version");
        Intrinsics.checkNotNullParameter((Object)aaptExecutablePath, (String)"aaptExecutablePath");
        Aapt2DaemonServiceKey key = new Aapt2DaemonServiceKey(aapt2Version);
        if (this.registeredServices.add(key)) {
            Aapt2DaemonManager manager = this.getManager(key, aaptExecutablePath);
            this.closer.register(Aapt2Daemon.getAapt2DaemonServiceRegistry().registerServiceAsCloseable(key, manager));
        }
        return key;
    }

    /*
     * WARNING - void declaration
     */
    private final synchronized Aapt2DaemonManager getManager(Aapt2DaemonServiceKey key, Path aaptExecutablePath) {
        Object object;
        void $this$getOrPut$iv;
        Map<Aapt2DaemonServiceKey, Object> map = this.services;
        Aapt2DaemonServiceKey key$iv = key;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            boolean bl = false;
            Aapt2DaemonManager answer$iv = new Aapt2DaemonManager(this.logger, (Function1)new Function1<Integer, com.android.builder.internal.aapt.v2.Aapt2Daemon>(aaptExecutablePath, this){
                final /* synthetic */ Path $aaptExecutablePath;
                final /* synthetic */ Aapt2DaemonBuildService this$0;
                {
                    this.$aaptExecutablePath = $aaptExecutablePath;
                    this.this$0 = $receiver;
                    super(1);
                }

                public final com.android.builder.internal.aapt.v2.Aapt2Daemon invoke(int displayId) {
                    return (com.android.builder.internal.aapt.v2.Aapt2Daemon)new Aapt2DaemonImpl("#" + displayId, this.$aaptExecutablePath, Aapt2Daemon.access$getDaemonTimeouts$p(), Aapt2DaemonBuildService.access$getLogger$p(this.this$0));
                }
            }, Aapt2Daemon.access$getDaemonExpiryTimeSeconds$p(), TimeUnit.SECONDS, (Aapt2DaemonManager.Listener)new Aapt2DaemonManagerMaintainer(), null, 32, null);
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        map = object;
        Aapt2DaemonManager it = (Aapt2DaemonManager)map;
        boolean bl = false;
        this.closer.register(new Closeable(it){
            final /* synthetic */ Aapt2DaemonManager $it;
            {
                this.$it = $it;
            }

            public final void close() {
                this.$it.shutdown();
            }
        });
        return (Aapt2DaemonManager)map;
    }

    @NotNull
    public final Path getAapt2ExecutablePath(@NotNull Aapt2Input aapt22) {
        Path path;
        Intrinsics.checkNotNullParameter((Object)aapt22, (String)"aapt2");
        Path it = path = aapt22.getBinaryDirectory().getSingleFile().toPath().resolve(SdkConstants.FN_AAPT2);
        boolean bl = false;
        if (!Files.exists(it, new LinkOption[0])) {
            throw new InvalidUserDataException("Specified AAPT2 executable does not exist: " + it + ". Must supply one of aapt2 from maven or custom location.");
        }
        Path path2 = path;
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"also(...)");
        return path2;
    }

    @Override
    public void close() {
        this.closer.close();
    }

    public static final /* synthetic */ ILogger access$getLogger$p(Aapt2DaemonBuildService $this) {
        return $this.logger;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0018\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lcom/android/build/gradle/internal/services/Aapt2DaemonBuildService$Parameters;", "Lorg/gradle/api/services/BuildServiceParameters;", "<init>", "()V", "errorFormatMode", "Lorg/gradle/api/provider/Property;", "Lcom/android/build/gradle/options/SyncOptions$ErrorFormatMode;", "getErrorFormatMode", "()Lorg/gradle/api/provider/Property;", "gradle-core"})
    public static abstract class Parameters
    implements BuildServiceParameters {
        @NotNull
        public abstract Property<SyncOptions.ErrorFormatMode> getErrorFormatMode();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0003H\u0016R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u000f"}, d2={"Lcom/android/build/gradle/internal/services/Aapt2DaemonBuildService$RegistrationAction;", "Lcom/android/build/gradle/internal/services/ServiceRegistrationAction;", "Lcom/android/build/gradle/internal/services/Aapt2DaemonBuildService;", "Lcom/android/build/gradle/internal/services/Aapt2DaemonBuildService$Parameters;", "project", "Lorg/gradle/api/Project;", "projectOptions", "Lcom/android/build/gradle/options/ProjectOptions;", "<init>", "(Lorg/gradle/api/Project;Lcom/android/build/gradle/options/ProjectOptions;)V", "getProjectOptions", "()Lcom/android/build/gradle/options/ProjectOptions;", "configure", "", "parameters", "gradle-core"})
    public static final class RegistrationAction
    extends ServiceRegistrationAction<Aapt2DaemonBuildService, Parameters> {
        @NotNull
        private final ProjectOptions projectOptions;

        public RegistrationAction(@NotNull Project project, @NotNull ProjectOptions projectOptions) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)projectOptions, (String)"projectOptions");
            super(project, Aapt2DaemonBuildService.class, Aapt2ThreadPoolBuildServiceKt.computeMaxAapt2Daemons(projectOptions), null, 8, null);
            this.projectOptions = projectOptions;
        }

        @NotNull
        public final ProjectOptions getProjectOptions() {
            return this.projectOptions;
        }

        @Override
        public void configure(@NotNull Parameters parameters) {
            Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
            parameters.getErrorFormatMode().set((Object)SyncOptions.getErrorFormatMode(this.projectOptions));
        }
    }
}

