/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.api.variant.ApkInstallGroup;
import com.android.build.gradle.internal.BuildToolsExecutableInput;
import com.android.build.gradle.internal.LoggerWrapper;
import com.android.build.gradle.internal.SdkComponentsKt;
import com.android.build.gradle.internal.component.ApkCreationConfig;
import com.android.build.gradle.internal.dependency.VariantDependencies;
import com.android.build.gradle.internal.profile.ProfileAwareWorkAction;
import com.android.build.gradle.internal.publishing.AndroidArtifacts;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.tasks.BuildAnalyzer;
import com.android.build.gradle.internal.tasks.InstallVariantViaBundleTask;
import com.android.build.gradle.internal.tasks.NonIncrementalTask;
import com.android.build.gradle.internal.tasks.factory.VariantTaskCreationAction;
import com.android.build.gradle.internal.testing.ConnectedDeviceProvider;
import com.android.build.gradle.internal.utils.BundleApkFetcher;
import com.android.build.gradle.internal.utils.InstallApkUtilsKt;
import com.android.build.gradle.internal.utils.SdkApkInstallGroup;
import com.android.build.gradle.internal.utils.ViaBundleDeviceApkOutput;
import com.android.buildanalyzer.common.TaskCategory;
import com.android.builder.testing.api.DeviceConnector;
import com.android.builder.testing.api.DeviceProvider;
import com.android.bundle.Devices;
import com.android.sdklib.AndroidVersion;
import com.android.utils.FileUtils;
import com.android.utils.ILogger;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.function.Function;
import java.util.stream.Collectors;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.Task;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.work.DisableCachingByDefault;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@DisableCachingByDefault
@BuildAnalyzer(primaryTaskCategory=TaskCategory.DEPLOYMENT)
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\b'\u0018\u00002\u00020\u0001:\u0003\u0019\u001a\u001bB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0017\u001a\u00020\u0018H\u0014R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00070\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\f8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u00108gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u00148gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006\u001c"}, d2={"Lcom/android/build/gradle/internal/tasks/InstallVariantViaBundleTask;", "Lcom/android/build/gradle/internal/tasks/NonIncrementalTask;", "<init>", "()V", "minSdkVersion", "", "minSdkCodename", "", "timeOutInMs", "installOptions", "", "buildTools", "Lcom/android/build/gradle/internal/BuildToolsExecutableInput;", "getBuildTools", "()Lcom/android/build/gradle/internal/BuildToolsExecutableInput;", "apkBundle", "Lorg/gradle/api/file/RegularFileProperty;", "getApkBundle", "()Lorg/gradle/api/file/RegularFileProperty;", "privacySandboxSdkApksFiles", "Lorg/gradle/api/file/ConfigurableFileCollection;", "getPrivacySandboxSdkApksFiles", "()Lorg/gradle/api/file/ConfigurableFileCollection;", "doTaskAction", "", "Params", "InstallRunnable", "CreationAction", "gradle-core"})
public abstract class InstallVariantViaBundleTask
extends NonIncrementalTask {
    private int minSdkVersion;
    @Nullable
    private String minSdkCodename;
    private int timeOutInMs;
    @NotNull
    private List<String> installOptions = new ArrayList();

    public InstallVariantViaBundleTask() {
        this.getOutputs().upToDateWhen((Spec)1.INSTANCE);
    }

    @Nested
    @NotNull
    public abstract BuildToolsExecutableInput getBuildTools();

    @InputFile
    @PathSensitive(value=PathSensitivity.NAME_ONLY)
    @NotNull
    public abstract RegularFileProperty getApkBundle();

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @Optional
    @NotNull
    public abstract ConfigurableFileCollection getPrivacySandboxSdkApksFiles();

    @Override
    protected void doTaskAction() {
        this.getWorkerExecutor().noIsolation().submit(InstallRunnable.class, new Action(this){
            final /* synthetic */ InstallVariantViaBundleTask this$0;
            {
                this.this$0 = $receiver;
            }

            public final void execute(Params it) {
                it.initializeFromBaseTask(this.this$0);
                it.getAdbExe().set(this.this$0.getBuildTools().adbExecutable());
                it.getApkBundle().set(((RegularFile)this.this$0.getApkBundle().get()).getAsFile());
                it.getTimeOutInMs().set((Object)InstallVariantViaBundleTask.access$getTimeOutInMs$p(this.this$0));
                it.getInstallOptions().set((Iterable)InstallVariantViaBundleTask.access$getInstallOptions$p(this.this$0));
                it.getVariantName().set((Object)this.this$0.getVariantName());
                it.getMinApiCodeName().set((Object)InstallVariantViaBundleTask.access$getMinSdkCodename$p(this.this$0));
                it.getMinSdkVersion().set((Object)InstallVariantViaBundleTask.access$getMinSdkVersion$p(this.this$0));
                it.getPrivacySandboxSdkApksFiles().setFrom((Iterable)this.this$0.getPrivacySandboxSdkApksFiles());
            }
        });
    }

    public static final /* synthetic */ int access$getTimeOutInMs$p(InstallVariantViaBundleTask $this) {
        return $this.timeOutInMs;
    }

    public static final /* synthetic */ String access$getMinSdkCodename$p(InstallVariantViaBundleTask $this) {
        return $this.minSdkCodename;
    }

    public static final /* synthetic */ int access$getMinSdkVersion$p(InstallVariantViaBundleTask $this) {
        return $this.minSdkVersion;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0002H\u0016J\u0016\u0010\u0012\u001a\u00020\u00102\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00020\u0014H\u0016R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0015"}, d2={"Lcom/android/build/gradle/internal/tasks/InstallVariantViaBundleTask$CreationAction;", "Lcom/android/build/gradle/internal/tasks/factory/VariantTaskCreationAction;", "Lcom/android/build/gradle/internal/tasks/InstallVariantViaBundleTask;", "Lcom/android/build/gradle/internal/component/ApkCreationConfig;", "creationConfig", "<init>", "(Lcom/android/build/gradle/internal/component/ApkCreationConfig;)V", "name", "", "getName", "()Ljava/lang/String;", "type", "Ljava/lang/Class;", "getType", "()Ljava/lang/Class;", "configure", "", "task", "handleProvider", "taskProvider", "Lorg/gradle/api/tasks/TaskProvider;", "gradle-core"})
    public static final class CreationAction
    extends VariantTaskCreationAction<InstallVariantViaBundleTask, ApkCreationConfig> {
        public CreationAction(@NotNull ApkCreationConfig creationConfig) {
            Intrinsics.checkNotNullParameter((Object)creationConfig, (String)"creationConfig");
            super(creationConfig, false, 2, null);
        }

        @Override
        @NotNull
        public String getName() {
            return this.computeTaskName("install");
        }

        @Override
        @NotNull
        public Class<InstallVariantViaBundleTask> getType() {
            return InstallVariantViaBundleTask.class;
        }

        @Override
        public void configure(@NotNull InstallVariantViaBundleTask task) {
            Intrinsics.checkNotNullParameter((Object)task, (String)"task");
            super.configure((Task)task);
            task.setDescription("Installs the " + ((ApkCreationConfig)this.creationConfig).getDescription());
            task.setGroup("Install");
            Object it = ((ApkCreationConfig)this.creationConfig).getMinSdk();
            boolean bl = false;
            task.minSdkVersion = it.getApiLevel();
            task.minSdkCodename = it.getCodename();
            it = ((ApkCreationConfig)this.creationConfig).getGlobal().getInstallationOptions().getInstallOptions();
            boolean bl2 = false;
            task.installOptions.addAll((Collection)it);
            ((ApkCreationConfig)this.creationConfig).getArtifacts().setTaskInputToFinalProduct(InternalArtifactType.APKS_FROM_BUNDLE.INSTANCE, (Property)task.getApkBundle());
            task.timeOutInMs = ((ApkCreationConfig)this.creationConfig).getGlobal().getInstallationOptions().getTimeOutInMs();
            SdkComponentsKt.initialize(task.getBuildTools(), (Task)task, this.creationConfig);
            if (((ApkCreationConfig)this.creationConfig).getPrivacySandboxCreationConfig() != null) {
                task.getPrivacySandboxSdkApksFiles().setFrom((Iterable)VariantDependencies.getArtifactFileCollection$default(((ApkCreationConfig)this.creationConfig).getVariantDependencies(), AndroidArtifacts.ConsumedConfigType.RUNTIME_CLASSPATH, AndroidArtifacts.ArtifactScope.ALL, AndroidArtifacts.ArtifactType.ANDROID_PRIVACY_SANDBOX_EXTRACTED_SDK_APKS, null, 8, null));
            }
            task.getPrivacySandboxSdkApksFiles().disallowChanges();
            ((ApkCreationConfig)this.creationConfig).getLifecycleTasks().invokeApkInstallationActions$gradle_core((Task)task);
        }

        @Override
        public void handleProvider(@NotNull TaskProvider<InstallVariantViaBundleTask> taskProvider) {
            Intrinsics.checkNotNullParameter(taskProvider, (String)"taskProvider");
            super.handleProvider(taskProvider);
            ((ApkCreationConfig)this.creationConfig).getTaskContainer().setInstallTask(taskProvider);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J&\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000fH\u0014\u00a8\u0006\u0012"}, d2={"Lcom/android/build/gradle/internal/tasks/InstallVariantViaBundleTask$InstallRunnable;", "Lcom/android/build/gradle/internal/profile/ProfileAwareWorkAction;", "Lcom/android/build/gradle/internal/tasks/InstallVariantViaBundleTask$Params;", "Lcom/android/build/gradle/internal/utils/BundleApkFetcher;", "<init>", "()V", "run", "", "installPackages", "device", "Lcom/android/builder/testing/api/DeviceConnector;", "apkFiles", "", "Ljava/io/File;", "iLogger", "Lcom/android/utils/ILogger;", "createDeviceProvider", "Lcom/android/builder/testing/api/DeviceProvider;", "gradle-core"})
    public static abstract class InstallRunnable
    extends ProfileAwareWorkAction<Params>
    implements BundleApkFetcher {
        @Override
        public void run() {
            Logger logger = Logging.getLogger(InstallVariantViaBundleTask.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
            Logger logger2 = logger;
            LoggerWrapper iLogger = new LoggerWrapper(logger2);
            DeviceProvider deviceProvider = this.createDeviceProvider(iLogger);
            Object object = ((Params)this.getParameters()).getMinSdkVersion().get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
            AndroidVersion androidVersion = new AndroidVersion(((Number)object).intValue(), (String)((Params)this.getParameters()).getMinApiCodeName().getOrNull());
            Provider provider2 = (Provider)((Params)this.getParameters()).getApkBundle();
            FileCollection fileCollection2 = (FileCollection)((Params)this.getParameters()).getPrivacySandboxSdkApksFiles();
            Object object2 = ((Params)this.getParameters()).getVariantName().get();
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"get(...)");
            String string = (String)object2;
            Object object3 = ((Params)this.getParameters()).getProjectPath().get();
            Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"get(...)");
            ViaBundleDeviceApkOutput apkOutput = new ViaBundleDeviceApkOutput((Provider<RegularFile>)provider2, androidVersion, fileCollection2, string, (String)object3, this);
            deviceProvider.use(new Callable(deviceProvider, apkOutput, logger2, this, iLogger){
                final /* synthetic */ DeviceProvider $deviceProvider;
                final /* synthetic */ ViaBundleDeviceApkOutput $apkOutput;
                final /* synthetic */ Logger $logger;
                final /* synthetic */ InstallRunnable this$0;
                final /* synthetic */ LoggerWrapper $iLogger;
                {
                    this.$deviceProvider = $deviceProvider;
                    this.$apkOutput = $apkOutput;
                    this.$logger = $logger;
                    this.this$0 = $receiver;
                    this.$iLogger = $iLogger;
                }

                /*
                 * WARNING - void declaration
                 */
                public final void call() {
                    int successfulInstallCount = 0;
                    List devices = this.$deviceProvider.getDevices();
                    for (DeviceConnector device : devices) {
                        Intrinsics.checkNotNull((Object)device);
                        List<ApkInstallGroup> apkInstallGroups2 = this.$apkOutput.getApks(InstallApkUtilsKt.getDeviceSpec(device));
                        if (apkInstallGroups2.isEmpty()) continue;
                        for (ApkInstallGroup apkInstallGroup : apkInstallGroups2) {
                            Object[] objectArray;
                            List<T> apkFiles2 = apkInstallGroup.getApks().stream().map((Function)run.apkFiles.1.INSTANCE).collect(Collectors.toList());
                            if (apkInstallGroup instanceof SdkApkInstallGroup) {
                                void $this$mapTo$iv$iv;
                                Iterable $this$map$iv = apkInstallGroup.getApks();
                                boolean $i$f$map = false;
                                Iterable iterable = $this$map$iv;
                                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                                boolean $i$f$mapTo = false;
                                for (T item$iv$iv : $this$mapTo$iv$iv) {
                                    void it;
                                    RegularFile regularFile = (RegularFile)item$iv$iv;
                                    Collection collection = destination$iv$iv;
                                    boolean bl = false;
                                    collection.add(it.getAsFile());
                                }
                                List apks = (List)destination$iv$iv;
                                Object[] objectArray2 = new Object[]{FileUtils.getNamesAsCommaSeparatedList((Iterable)apks), device.getName(), ((Params)this.this$0.getParameters()).getProjectPath().get(), ((Params)this.this$0.getParameters()).getVariantName().get()};
                                this.$logger.lifecycle("Installing privacy sandbox SDK APKs '{}' on '{}' for {}:{}", objectArray2);
                                InstallRunnable.access$installPackages(this.this$0, device, apks, this.$iLogger);
                                ++successfulInstallCount;
                                continue;
                            }
                            if (apkFiles2.isEmpty()) {
                                objectArray = new Object[]{device.getName(), ((Params)this.this$0.getParameters()).getProjectPath().get(), ((Params)this.this$0.getParameters()).getVariantName().get()};
                                this.$logger.lifecycle("Skipping device '{}' for '{}:{}': No APK generated", objectArray);
                                continue;
                            }
                            objectArray = new Object[]{FileUtils.getNamesAsCommaSeparatedList((Iterable)apkFiles2), device.getName(), ((Params)this.this$0.getParameters()).getProjectPath().get(), ((Params)this.this$0.getParameters()).getVariantName().get()};
                            this.$logger.lifecycle("Installing APKs '{}' on '{}' for {}:{}", objectArray);
                            Intrinsics.checkNotNull(apkFiles2);
                            InstallRunnable.access$installPackages(this.this$0, device, apkFiles2, this.$iLogger);
                            ++successfulInstallCount;
                        }
                    }
                    if (successfulInstallCount == 0) {
                        throw new GradleException("Failed to install on any devices.");
                    }
                    Object[] objectArray = new Object[]{successfulInstallCount, successfulInstallCount == 1 ? "device" : "devices"};
                    this.$logger.quiet("Installed on {} {}.", objectArray);
                }
            });
        }

        private final void installPackages(DeviceConnector device, List<? extends File> apkFiles2, ILogger iLogger) {
            if (apkFiles2.size() > 1) {
                Collection collection = (Collection)((Params)this.getParameters()).getInstallOptions().get();
                Object object = ((Params)this.getParameters()).getTimeOutInMs().get();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
                device.installPackages(apkFiles2, collection, ((Number)object).intValue(), iLogger);
            } else {
                Collection collection = (Collection)((Params)this.getParameters()).getInstallOptions().get();
                Object object = ((Params)this.getParameters()).getTimeOutInMs().get();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
                device.installPackage(apkFiles2.get(0), collection, ((Number)object).intValue(), iLogger);
            }
        }

        @NotNull
        protected DeviceProvider createDeviceProvider(@NotNull ILogger iLogger) {
            Intrinsics.checkNotNullParameter((Object)iLogger, (String)"iLogger");
            File file = ((RegularFile)((Params)this.getParameters()).getAdbExe().get()).getAsFile();
            Object object = ((Params)this.getParameters()).getTimeOutInMs().get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
            return new ConnectedDeviceProvider(file, ((Number)object).intValue(), iLogger, System.getenv("ANDROID_SERIAL"));
        }

        @Override
        @NotNull
        public List<Path> getApkFiles(@NotNull Collection<? extends Path> apkBundles, @NotNull Devices.DeviceSpec deviceSpec) {
            return BundleApkFetcher.super.getApkFiles(apkBundles, deviceSpec);
        }

        public static final /* synthetic */ void access$installPackages(InstallRunnable $this, DeviceConnector device, List apkFiles2, ILogger iLogger) {
            $this.installPackages(device, apkFiles2, iLogger);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0012\u0010\u0004\u001a\u00020\u0005X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0012\u0010\b\u001a\u00020\u0005X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0007R\u0018\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0018\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0018\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00110\u000bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u000eR\u001a\u0010\u0016\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00110\u000bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u000eR\u0018\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u000eR\u0012\u0010\u001a\u001a\u00020\u001bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001d\u00a8\u0006\u001e"}, d2={"Lcom/android/build/gradle/internal/tasks/InstallVariantViaBundleTask$Params;", "Lcom/android/build/gradle/internal/profile/ProfileAwareWorkAction$Parameters;", "<init>", "()V", "adbExe", "Lorg/gradle/api/file/RegularFileProperty;", "getAdbExe", "()Lorg/gradle/api/file/RegularFileProperty;", "apkBundle", "getApkBundle", "timeOutInMs", "Lorg/gradle/api/provider/Property;", "", "getTimeOutInMs", "()Lorg/gradle/api/provider/Property;", "installOptions", "Lorg/gradle/api/provider/ListProperty;", "", "getInstallOptions", "()Lorg/gradle/api/provider/ListProperty;", "variantName", "getVariantName", "minApiCodeName", "getMinApiCodeName", "minSdkVersion", "getMinSdkVersion", "privacySandboxSdkApksFiles", "Lorg/gradle/api/file/ConfigurableFileCollection;", "getPrivacySandboxSdkApksFiles", "()Lorg/gradle/api/file/ConfigurableFileCollection;", "gradle-core"})
    public static abstract class Params
    extends ProfileAwareWorkAction.Parameters {
        @NotNull
        public abstract RegularFileProperty getAdbExe();

        @NotNull
        public abstract RegularFileProperty getApkBundle();

        @NotNull
        public abstract Property<Integer> getTimeOutInMs();

        @NotNull
        public abstract ListProperty<String> getInstallOptions();

        @NotNull
        public abstract Property<String> getVariantName();

        @NotNull
        public abstract Property<String> getMinApiCodeName();

        @NotNull
        public abstract Property<Integer> getMinSdkVersion();

        @NotNull
        public abstract ConfigurableFileCollection getPrivacySandboxSdkApksFiles();
    }
}

