/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.api.artifact.Artifact;
import com.android.build.api.artifact.MultipleArtifact;
import com.android.build.gradle.internal.component.ApplicationCreationConfig;
import com.android.build.gradle.internal.component.features.NativeBuildCreationConfig;
import com.android.build.gradle.internal.dependency.VariantDependencies;
import com.android.build.gradle.internal.dsl.NdkOptions;
import com.android.build.gradle.internal.profile.ProfileAwareWorkAction;
import com.android.build.gradle.internal.publishing.AndroidArtifacts;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.tasks.BuildAnalyzer;
import com.android.build.gradle.internal.tasks.MergeNativeDebugMetadataTask;
import com.android.build.gradle.internal.tasks.NonIncrementalTask;
import com.android.build.gradle.internal.tasks.factory.VariantTaskCreationAction;
import com.android.build.gradle.internal.utils.HasConfigurableValuesKt;
import com.android.buildanalyzer.common.TaskCategory;
import com.android.builder.packaging.JarFlinger;
import com.android.utils.FileUtils;
import com.google.common.annotations.VisibleForTesting;
import java.io.Closeable;
import java.io.File;
import java.util.Collection;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gradle.api.Action;
import org.gradle.api.Task;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.Directory;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileTree;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.IgnoreEmptyDirectories;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.SkipWhenEmpty;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.util.PatternFilterable;
import org.gradle.api.tasks.util.PatternSet;
import org.gradle.work.DisableCachingByDefault;
import org.jetbrains.annotations.NotNull;

@DisableCachingByDefault
@BuildAnalyzer(primaryTaskCategory=TaskCategory.NATIVE, secondaryTaskCategories={TaskCategory.METADATA, TaskCategory.MERGING})
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\b'\u0018\u0000 \u000f2\u00020\u0001:\u0003\u000e\u000f\u0010B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\f\u001a\u00020\rH\u0014R\u0014\u0010\u0004\u001a\u00020\u00058gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\t8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0011"}, d2={"Lcom/android/build/gradle/internal/tasks/MergeNativeDebugMetadataTask;", "Lcom/android/build/gradle/internal/tasks/NonIncrementalTask;", "<init>", "()V", "inputFiles", "Lorg/gradle/api/file/ConfigurableFileCollection;", "getInputFiles", "()Lorg/gradle/api/file/ConfigurableFileCollection;", "outputFile", "Lorg/gradle/api/file/RegularFileProperty;", "getOutputFile", "()Lorg/gradle/api/file/RegularFileProperty;", "doTaskAction", "", "MergeNativeDebugMetadataWorkAction", "Companion", "CreationAction", "gradle-core"})
public abstract class MergeNativeDebugMetadataTask
extends NonIncrementalTask {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final PatternSet patternSet;

    @SkipWhenEmpty
    @IgnoreEmptyDirectories
    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @NotNull
    public abstract ConfigurableFileCollection getInputFiles();

    @OutputFile
    @NotNull
    public abstract RegularFileProperty getOutputFile();

    @Override
    protected void doTaskAction() {
        this.getWorkerExecutor().noIsolation().submit(MergeNativeDebugMetadataWorkAction.class, new Action(this){
            final /* synthetic */ MergeNativeDebugMetadataTask this$0;
            {
                this.this$0 = $receiver;
            }

            public final void execute(MergeNativeDebugMetadataWorkAction.Parameters it) {
                it.initializeFromBaseTask(this.this$0);
                Object[] objectArray = new Object[]{this.this$0.getInputFiles()};
                it.getInputFiles().from(objectArray);
                it.getOutputFile().set((Provider)this.this$0.getOutputFile());
            }
        });
    }

    static {
        String[] stringArray = new String[]{"**/*.dbg"};
        PatternSet patternSet = new PatternSet().include(stringArray);
        stringArray = new String[]{"**/*.sym"};
        MergeNativeDebugMetadataTask.patternSet = patternSet.include(stringArray);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J#\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\bH\u0001\u00a2\u0006\u0002\b\nJ<\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00120\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u000e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\f\u001a\u00020\rR\u0016\u0010\u0019\u001a\n \u001b*\u0004\u0018\u00010\u001a0\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/android/build/gradle/internal/tasks/MergeNativeDebugMetadataTask$Companion;", "", "<init>", "()V", "mergeFiles", "", "inputFiles", "", "Ljava/io/File;", "outputFile", "mergeFiles$gradle_core", "collectDebugSymbols", "variant", "Lcom/android/build/gradle/internal/component/ApplicationCreationConfig;", "nativeDebugMetadataDirs", "Lorg/gradle/api/file/ConfigurableFileCollection;", "extractedDebugSymbolsArtifact", "Lcom/android/build/api/artifact/Artifact$Single;", "Lorg/gradle/api/file/Directory;", "externalDebugSymbolArtifacts", "Lcom/android/build/api/artifact/Artifact$Multiple;", "reverseMetadataDebugSymbolArtifactType", "Lcom/android/build/gradle/internal/publishing/AndroidArtifacts$ArtifactType;", "getNativeDebugMetadataFiles", "Lorg/gradle/api/file/FileCollection;", "patternSet", "Lorg/gradle/api/tasks/util/PatternSet;", "kotlin.jvm.PlatformType", "gradle-core"})
    @SourceDebugExtension(value={"SMAP\nMergeNativeDebugMetadataTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MergeNativeDebugMetadataTask.kt\ncom/android/build/gradle/internal/tasks/MergeNativeDebugMetadataTask$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,194:1\n1863#2,2:195\n*S KotlinDebug\n*F\n+ 1 MergeNativeDebugMetadataTask.kt\ncom/android/build/gradle/internal/tasks/MergeNativeDebugMetadataTask$Companion\n*L\n100#1:195,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @VisibleForTesting
        public final void mergeFiles$gradle_core(@NotNull Collection<? extends File> inputFiles, @NotNull File outputFile) {
            Intrinsics.checkNotNullParameter(inputFiles, (String)"inputFiles");
            Intrinsics.checkNotNullParameter((Object)outputFile, (String)"outputFile");
            FileUtils.deleteIfExists((File)outputFile);
            Closeable closeable = (Closeable)new JarFlinger(outputFile.toPath(), null);
            Throwable throwable = null;
            try {
                JarFlinger zipCreator = (JarFlinger)closeable;
                boolean bl = false;
                Iterable $this$forEach$iv = inputFiles;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    File it = (File)element$iv;
                    boolean bl2 = false;
                    zipCreator.addFile(it.getParentFile().getName() + "/" + it.getName(), it.toPath());
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }

        private final void collectDebugSymbols(ApplicationCreationConfig variant, ConfigurableFileCollection nativeDebugMetadataDirs, Artifact.Single<Directory> extractedDebugSymbolsArtifact, Artifact.Multiple<Directory> externalDebugSymbolArtifacts, AndroidArtifacts.ArtifactType reverseMetadataDebugSymbolArtifactType) {
            Object[] objectArray = new Object[]{variant.getArtifacts().get(extractedDebugSymbolsArtifact)};
            nativeDebugMetadataDirs.from(objectArray);
            objectArray = new Object[]{variant.getArtifacts().getAll(externalDebugSymbolArtifacts)};
            nativeDebugMetadataDirs.from(objectArray);
            objectArray = new Object[]{VariantDependencies.getArtifactFileCollection$default(variant.getVariantDependencies(), AndroidArtifacts.ConsumedConfigType.REVERSE_METADATA_VALUES, AndroidArtifacts.ArtifactScope.PROJECT, reverseMetadataDebugSymbolArtifactType, null, 8, null)};
            nativeDebugMetadataDirs.from(objectArray);
        }

        @NotNull
        public final FileCollection getNativeDebugMetadataFiles(@NotNull ApplicationCreationConfig variant) {
            Intrinsics.checkNotNullParameter((Object)variant, (String)"variant");
            ConfigurableFileCollection nativeDebugMetadataDirs = variant.getServices().fileCollection();
            NativeBuildCreationConfig nativeBuildCreationConfig2 = variant.getNativeBuildCreationConfig();
            NdkOptions.DebugSymbolLevel debugSymbolLevel = nativeBuildCreationConfig2 != null ? nativeBuildCreationConfig2.getNativeDebugSymbolLevel() : null;
            switch (debugSymbolLevel == null ? -1 : WhenMappings.$EnumSwitchMapping$0[debugSymbolLevel.ordinal()]) {
                case 1: {
                    this.collectDebugSymbols(variant, nativeDebugMetadataDirs, (Artifact.Single<Directory>)((Artifact.Single)InternalArtifactType.NATIVE_DEBUG_METADATA.INSTANCE), (Artifact.Multiple<Directory>)((Artifact.Multiple)MultipleArtifact.NATIVE_DEBUG_METADATA.INSTANCE), AndroidArtifacts.ArtifactType.REVERSE_METADATA_NATIVE_DEBUG_METADATA);
                    break;
                }
                case 2: {
                    this.collectDebugSymbols(variant, nativeDebugMetadataDirs, (Artifact.Single<Directory>)((Artifact.Single)InternalArtifactType.NATIVE_SYMBOL_TABLES.INSTANCE), (Artifact.Multiple<Directory>)((Artifact.Multiple)MultipleArtifact.NATIVE_SYMBOL_TABLES.INSTANCE), AndroidArtifacts.ArtifactType.REVERSE_METADATA_NATIVE_SYMBOL_TABLES);
                    break;
                }
                case 3: {
                    break;
                }
                case -1: {
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            nativeDebugMetadataDirs.disallowChanges();
            FileTree fileTree = nativeDebugMetadataDirs.getAsFileTree().matching((PatternFilterable)patternSet);
            Intrinsics.checkNotNullExpressionValue((Object)fileTree, (String)"matching(...)");
            return (FileCollection)fileTree;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 0, 0}, k=3, xi=48)
        public static final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[NdkOptions.DebugSymbolLevel.values().length];
                try {
                    nArray[NdkOptions.DebugSymbolLevel.FULL.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[NdkOptions.DebugSymbolLevel.SYMBOL_TABLE.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[NdkOptions.DebugSymbolLevel.NONE.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0016\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0002H\u0016R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0015"}, d2={"Lcom/android/build/gradle/internal/tasks/MergeNativeDebugMetadataTask$CreationAction;", "Lcom/android/build/gradle/internal/tasks/factory/VariantTaskCreationAction;", "Lcom/android/build/gradle/internal/tasks/MergeNativeDebugMetadataTask;", "Lcom/android/build/gradle/internal/component/ApplicationCreationConfig;", "componentProperties", "<init>", "(Lcom/android/build/gradle/internal/component/ApplicationCreationConfig;)V", "name", "", "getName", "()Ljava/lang/String;", "type", "Ljava/lang/Class;", "getType", "()Ljava/lang/Class;", "handleProvider", "", "taskProvider", "Lorg/gradle/api/tasks/TaskProvider;", "configure", "task", "gradle-core"})
    public static final class CreationAction
    extends VariantTaskCreationAction<MergeNativeDebugMetadataTask, ApplicationCreationConfig> {
        public CreationAction(@NotNull ApplicationCreationConfig componentProperties) {
            Intrinsics.checkNotNullParameter((Object)componentProperties, (String)"componentProperties");
            super(componentProperties, false, 2, null);
        }

        @Override
        @NotNull
        public String getName() {
            return this.computeTaskName("merge", "NativeDebugMetadata");
        }

        @Override
        @NotNull
        public Class<MergeNativeDebugMetadataTask> getType() {
            return MergeNativeDebugMetadataTask.class;
        }

        @Override
        public void handleProvider(@NotNull TaskProvider<MergeNativeDebugMetadataTask> taskProvider) {
            Intrinsics.checkNotNullParameter(taskProvider, (String)"taskProvider");
            super.handleProvider(taskProvider);
            ((ApplicationCreationConfig)this.creationConfig).getArtifacts().setInitialProvider(taskProvider, (Function1)handleProvider.1.INSTANCE).withName("native-debug-symbols.zip").on(InternalArtifactType.MERGED_NATIVE_DEBUG_METADATA.INSTANCE);
        }

        @Override
        public void configure(@NotNull MergeNativeDebugMetadataTask task) {
            Intrinsics.checkNotNullParameter((Object)task, (String)"task");
            super.configure((Task)task);
            Object[] objectArray = new Object[]{Companion.getNativeDebugMetadataFiles((ApplicationCreationConfig)this.creationConfig)};
            HasConfigurableValuesKt.fromDisallowChanges(task.getInputFiles(), objectArray);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\b&\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0007B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\b"}, d2={"Lcom/android/build/gradle/internal/tasks/MergeNativeDebugMetadataTask$MergeNativeDebugMetadataWorkAction;", "Lcom/android/build/gradle/internal/profile/ProfileAwareWorkAction;", "Lcom/android/build/gradle/internal/tasks/MergeNativeDebugMetadataTask$MergeNativeDebugMetadataWorkAction$Parameters;", "<init>", "()V", "run", "", "Parameters", "gradle-core"})
    public static abstract class MergeNativeDebugMetadataWorkAction
    extends ProfileAwareWorkAction<Parameters> {
        @Override
        public void run() {
            Set set = ((Parameters)this.getParameters()).getInputFiles().getFiles();
            Intrinsics.checkNotNullExpressionValue((Object)set, (String)"getFiles(...)");
            Collection collection = set;
            Object object = ((Parameters)this.getParameters()).getOutputFile().getAsFile().get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
            Companion.mergeFiles$gradle_core(collection, (File)object);
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0012\u0010\u0004\u001a\u00020\u0005X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0012\u0010\b\u001a\u00020\tX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lcom/android/build/gradle/internal/tasks/MergeNativeDebugMetadataTask$MergeNativeDebugMetadataWorkAction$Parameters;", "Lcom/android/build/gradle/internal/profile/ProfileAwareWorkAction$Parameters;", "<init>", "()V", "inputFiles", "Lorg/gradle/api/file/ConfigurableFileCollection;", "getInputFiles", "()Lorg/gradle/api/file/ConfigurableFileCollection;", "outputFile", "Lorg/gradle/api/file/RegularFileProperty;", "getOutputFile", "()Lorg/gradle/api/file/RegularFileProperty;", "gradle-core"})
        public static abstract class Parameters
        extends ProfileAwareWorkAction.Parameters {
            @NotNull
            public abstract ConfigurableFileCollection getInputFiles();

            @NotNull
            public abstract RegularFileProperty getOutputFile();
        }
    }
}

