/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks.manifest;

import com.android.ide.common.blame.SourceFile;
import com.android.ide.common.blame.SourceFilePosition;
import com.android.ide.common.blame.SourcePosition;
import com.android.manifmerger.ManifestMerger2;
import com.android.manifmerger.ManifestProvider;
import com.android.manifmerger.ManifestSystemProperty;
import com.android.manifmerger.MergingReport;
import com.android.utils.ILogger;
import com.google.common.base.Charsets;
import com.google.common.io.CharSink;
import com.google.common.io.FileWriteMode;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000l\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a\u00b7\u0002\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u00052\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00030\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\r\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u000b2\b\u0010\u0013\u001a\u0004\u0018\u00010\u000b2\b\u0010\u0014\u001a\u0004\u0018\u00010\u000b2\b\u0010\u0015\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0016\u001a\u00020\u000f2\b\u0010\u0017\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0018\u001a\u0004\u0018\u00010\u000b2\b\u0010\u0019\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u001a\u001a\u00020\u001b2\u0012\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u001e0\u001d2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020 0\t2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u000b0\t2\b\u0010\"\u001a\u0004\u0018\u00010\u000b2\b\u0010#\u001a\u0004\u0018\u00010\u00032\u0006\u0010$\u001a\u00020%2\b\b\u0002\u0010&\u001a\u00020\u000f2\b\b\u0002\u0010'\u001a\u00020\u000f2\n\b\u0002\u0010(\u001a\u0004\u0018\u00010\u00112\b\b\u0002\u0010)\u001a\u00020\u000f\u00a2\u0006\u0002\u0010*\u001a\u001c\u0010+\u001a\u00020,2\f\u0010-\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00052\u0006\u0010.\u001a\u00020,\u001au\u0010/\u001a\u0002002\u0006\u00101\u001a\u0002022\b\u0010\f\u001a\u0004\u0018\u00010\u000b2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u000b2\b\u0010\u0013\u001a\u0004\u0018\u00010\u000b2\b\u0010\u0014\u001a\u0004\u0018\u00010\u000b2\b\u0010\u0015\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u000f2\b\u0010(\u001a\u0004\u0018\u00010\u00112\b\u0010\u0017\u001a\u0004\u0018\u00010\u000fH\u0002\u00a2\u0006\u0002\u00103\u001a\u001a\u00104\u001a\u0002002\b\u00105\u001a\u0004\u0018\u00010\u000b2\u0006\u00106\u001a\u00020\u0003H\u0002\u00a8\u00067"}, d2={"mergeManifests", "Lcom/android/manifmerger/MergingReport;", "mainManifest", "Ljava/io/File;", "manifestOverlays", "", "dependencies", "Lcom/android/manifmerger/ManifestProvider;", "navigationJsons", "", "featureName", "", "packageOverride", "namespace", "profileable", "", "versionCode", "", "versionName", "minSdkVersion", "targetSdkVersion", "maxSdkVersion", "testOnly", "extractNativeLibs", "outMergedManifestLocation", "outAaptSafeManifestLocation", "mergeType", "Lcom/android/manifmerger/ManifestMerger2$MergeType;", "placeHolders", "", "", "optionalFeatures", "Lcom/android/manifmerger/ManifestMerger2$Invoker$Feature;", "dependencyFeatureNames", "generatedLocaleConfigAttribute", "reportFile", "logger", "Lcom/android/utils/ILogger;", "checkIfPackageInMainManifest", "checkIfInstantModule", "compileSdk", "usesSdkInManifestLenientHandling", "(Ljava/io/File;Ljava/util/List;Ljava/util/List;Ljava/util/Collection;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;ZLjava/lang/Integer;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/Integer;ZLjava/lang/Boolean;Ljava/lang/String;Ljava/lang/String;Lcom/android/manifmerger/ManifestMerger2$MergeType;Ljava/util/Map;Ljava/util/Collection;Ljava/util/Collection;Ljava/lang/String;Ljava/io/File;Lcom/android/utils/ILogger;ZZLjava/lang/Integer;Z)Lcom/android/manifmerger/MergingReport;", "findOriginalManifestFilePosition", "Lcom/android/ide/common/blame/SourceFilePosition;", "manifestMergeBlameContents", "mergedFilePosition", "setInjectableValues", "", "invoker", "Lcom/android/manifmerger/ManifestMerger2$Invoker;", "(Lcom/android/manifmerger/ManifestMerger2$Invoker;Ljava/lang/String;Ljava/lang/Integer;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/Integer;ZZLjava/lang/Integer;Ljava/lang/Boolean;)V", "save", "xmlDocument", "out", "gradle-core"})
@SourceDebugExtension(value={"SMAP\nManifestHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ManifestHelper.kt\ncom/android/build/gradle/internal/tasks/manifest/ManifestHelperKt\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,291:1\n37#2,2:292\n37#2,2:294\n1863#3,2:296\n*S KotlinDebug\n*F\n+ 1 ManifestHelper.kt\ncom/android/build/gradle/internal/tasks/manifest/ManifestHelperKt\n*L\n81#1:292,2\n84#1:294,2\n187#1:296,2\n*E\n"})
public final class ManifestHelperKt {
    @NotNull
    public static final MergingReport mergeManifests(@NotNull File mainManifest, @NotNull List<? extends File> manifestOverlays, @NotNull List<? extends ManifestProvider> dependencies2, @NotNull Collection<? extends File> navigationJsons, @Nullable String featureName2, @Nullable String packageOverride, @NotNull String namespace2, boolean profileable, @Nullable Integer versionCode2, @Nullable String versionName2, @Nullable String minSdkVersion2, @Nullable String targetSdkVersion2, @Nullable Integer maxSdkVersion2, boolean testOnly2, @Nullable Boolean extractNativeLibs2, @Nullable String outMergedManifestLocation, @Nullable String outAaptSafeManifestLocation, @NotNull ManifestMerger2.MergeType mergeType, @NotNull Map<String, ? extends Object> placeHolders, @NotNull Collection<? extends ManifestMerger2.Invoker.Feature> optionalFeatures, @NotNull Collection<String> dependencyFeatureNames, @Nullable String generatedLocaleConfigAttribute, @Nullable File reportFile2, @NotNull ILogger logger, boolean checkIfPackageInMainManifest, boolean checkIfInstantModule, @Nullable Integer compileSdk2, boolean usesSdkInManifestLenientHandling) {
        Intrinsics.checkNotNullParameter((Object)mainManifest, (String)"mainManifest");
        Intrinsics.checkNotNullParameter(manifestOverlays, (String)"manifestOverlays");
        Intrinsics.checkNotNullParameter(dependencies2, (String)"dependencies");
        Intrinsics.checkNotNullParameter(navigationJsons, (String)"navigationJsons");
        Intrinsics.checkNotNullParameter((Object)namespace2, (String)"namespace");
        Intrinsics.checkNotNullParameter((Object)mergeType, (String)"mergeType");
        Intrinsics.checkNotNullParameter(placeHolders, (String)"placeHolders");
        Intrinsics.checkNotNullParameter(optionalFeatures, (String)"optionalFeatures");
        Intrinsics.checkNotNullParameter(dependencyFeatureNames, (String)"dependencyFeatureNames");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        try {
            String annotatedDocument;
            boolean injectProfileable;
            ManifestMerger2.Invoker.Feature[] $this$toTypedArray$iv = (ManifestMerger2.Invoker.Feature[])manifestOverlays;
            boolean $i$f$toTypedArray = false;
            ManifestMerger2.Invoker.Feature[] thisCollection$iv = $this$toTypedArray$iv;
            File[] fileArray = thisCollection$iv.toArray(new File[0]);
            ManifestMerger2.Invoker invoker = ManifestMerger2.newMerger((File)mainManifest, (ILogger)logger, (ManifestMerger2.MergeType)mergeType).setPlaceHolderValues(placeHolders).addFlavorAndBuildTypeManifests(Arrays.copyOf(fileArray, fileArray.length)).addManifestProviders((Iterable)dependencies2).addNavigationJsons((Iterable)navigationJsons);
            $this$toTypedArray$iv = optionalFeatures;
            $i$f$toTypedArray = false;
            thisCollection$iv = $this$toTypedArray$iv;
            fileArray = thisCollection$iv.toArray(new ManifestMerger2.Invoker.Feature[0]);
            ManifestMerger2.Invoker invoker2 = invoker.withFeatures((ManifestMerger2.Invoker.Feature[])Arrays.copyOf(fileArray, fileArray.length)).setMergeReportFile(reportFile2).setFeatureName(featureName2).addDependencyFeatureNames((Iterable)dependencyFeatureNames).setNamespace(namespace2);
            Intrinsics.checkNotNullExpressionValue((Object)invoker2, (String)"setNamespace(...)");
            ManifestMerger2.Invoker manifestMergerInvoker = invoker2;
            if (checkIfPackageInMainManifest) {
                ManifestMerger2.Invoker.Feature[] featureArray = new ManifestMerger2.Invoker.Feature[]{ManifestMerger2.Invoker.Feature.CHECK_IF_PACKAGE_IN_MAIN_MANIFEST};
                manifestMergerInvoker.withFeatures(featureArray);
            }
            boolean isAppMerge = mergeType == ManifestMerger2.MergeType.APPLICATION;
            boolean bl = injectProfileable = isAppMerge && profileable;
            if (isAppMerge) {
                $this$toTypedArray$iv = new ManifestMerger2.Invoker.Feature[]{ManifestMerger2.Invoker.Feature.REMOVE_TOOLS_DECLARATIONS};
                manifestMergerInvoker.withFeatures($this$toTypedArray$iv);
            }
            if (checkIfInstantModule) {
                $this$toTypedArray$iv = new ManifestMerger2.Invoker.Feature[]{ManifestMerger2.Invoker.Feature.CHECK_INSTANT_FLAG};
                manifestMergerInvoker.withFeatures($this$toTypedArray$iv);
            }
            if (outAaptSafeManifestLocation != null) {
                $this$toTypedArray$iv = new ManifestMerger2.Invoker.Feature[]{ManifestMerger2.Invoker.Feature.MAKE_AAPT_SAFE};
                manifestMergerInvoker.withFeatures($this$toTypedArray$iv);
            }
            if (usesSdkInManifestLenientHandling) {
                $this$toTypedArray$iv = new ManifestMerger2.Invoker.Feature[]{ManifestMerger2.Invoker.Feature.USES_SDK_IN_MANIFEST_LENIENT_HANDLING};
                manifestMergerInvoker.withFeatures($this$toTypedArray$iv);
            }
            manifestMergerInvoker.setGeneratedLocaleConfigAttribute(generatedLocaleConfigAttribute);
            ManifestHelperKt.setInjectableValues(manifestMergerInvoker, packageOverride, versionCode2, versionName2, minSdkVersion2, targetSdkVersion2, maxSdkVersion2, injectProfileable, testOnly2, compileSdk2, extractNativeLibs2);
            MergingReport mergingReport = manifestMergerInvoker.merge();
            Intrinsics.checkNotNullExpressionValue((Object)mergingReport, (String)"merge(...)");
            MergingReport mergingReport2 = mergingReport;
            Object[] $i$f$toTypedArray2 = new Object[]{mergingReport2.getResult()};
            logger.verbose("Merging result: %1$s", $i$f$toTypedArray2);
            if (mergingReport2.getResult() == MergingReport.Result.ERROR) {
                mergingReport2.log(logger);
                throw new RuntimeException(mergingReport2.getReportString());
            }
            if (mergingReport2.getResult() == MergingReport.Result.WARNING) {
                mergingReport2.log(logger);
            }
            if ((annotatedDocument = mergingReport2.getMergedDocument(MergingReport.MergedManifestKind.BLAME)) != null) {
                logger.verbose(annotatedDocument, new Object[0]);
            }
            logger.verbose("Merged manifest saved to " + outMergedManifestLocation, new Object[0]);
            if (outMergedManifestLocation != null) {
                ManifestHelperKt.save(mergingReport2.getMergedDocument(MergingReport.MergedManifestKind.MERGED), new File(outMergedManifestLocation));
            }
            if (outAaptSafeManifestLocation != null) {
                ManifestHelperKt.save(mergingReport2.getMergedDocument(mergingReport2.isAaptSafeManifestUnchanged() ? MergingReport.MergedManifestKind.MERGED : MergingReport.MergedManifestKind.AAPT_SAFE), new File(outAaptSafeManifestLocation));
            }
            return mergingReport2;
        }
        catch (ManifestMerger2.MergeFailureException e) {
            throw new RuntimeException(e);
        }
    }

    public static /* synthetic */ MergingReport mergeManifests$default(File file, List list, List list2, Collection collection, String string, String string2, String string3, boolean bl, Integer n, String string4, String string5, String string6, Integer n2, boolean bl2, Boolean bl3, String string7, String string8, ManifestMerger2.MergeType mergeType, Map map, Collection collection2, Collection collection3, String string9, File file2, ILogger iLogger, boolean bl4, boolean bl5, Integer n3, boolean bl6, int n4, Object object) {
        if ((n4 & 0x1000000) != 0) {
            bl4 = true;
        }
        if ((n4 & 0x2000000) != 0) {
            bl5 = false;
        }
        if ((n4 & 0x4000000) != 0) {
            n3 = null;
        }
        if ((n4 & 0x8000000) != 0) {
            bl6 = true;
        }
        return ManifestHelperKt.mergeManifests(file, list, list2, collection, string, string2, string3, bl, n, string4, string5, string6, n2, bl2, bl3, string7, string8, mergeType, map, collection2, collection3, string9, file2, iLogger, bl4, bl5, n3, bl6);
    }

    @NotNull
    public static final SourceFilePosition findOriginalManifestFilePosition(@NotNull List<String> manifestMergeBlameContents, @NotNull SourceFilePosition mergedFilePosition) {
        block12: {
            block11: {
                boolean bl;
                Intrinsics.checkNotNullParameter(manifestMergeBlameContents, (String)"manifestMergeBlameContents");
                Intrinsics.checkNotNullParameter((Object)mergedFilePosition, (String)"mergedFilePosition");
                if (Intrinsics.areEqual((Object)mergedFilePosition.getFile(), (Object)SourceFile.UNKNOWN)) break block11;
                Object object = mergedFilePosition.getFile().getSourceFile();
                if (object != null && (object = ((File)object).getAbsolutePath()) != null) {
                    Object it = object;
                    boolean bl2 = false;
                    boolean bl3 = StringsKt.contains$default((CharSequence)((CharSequence)it), (CharSequence)"merged_manifests", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)((CharSequence)it), (CharSequence)"packaged_manifests", (boolean)false, (int)2, null);
                    bl = !bl3;
                } else {
                    bl = false;
                }
                if (!bl) break block12;
            }
            return mergedFilePosition;
        }
        try {
            String linePrefix = mergedFilePosition.getPosition().getStartLine() + 1 + "-->";
            Iterable $this$forEach$iv = manifestMergeBlameContents;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                SourceFilePosition sourceFilePosition;
                int index;
                int closingIndex;
                String position;
                String line = (String)element$iv;
                boolean bl = false;
                String trimmed = ((Object)StringsKt.trim((CharSequence)line)).toString();
                if (!StringsKt.startsWith$default((String)trimmed, (String)linePrefix, (boolean)false, (int)2, null)) continue;
                Intrinsics.checkNotNullExpressionValue((Object)trimmed.substring(linePrefix.length()), (String)"substring(...)");
                if (StringsKt.startsWith$default((String)position, (String)"[", (boolean)false, (int)2, null) && (closingIndex = StringsKt.indexOf$default((CharSequence)position, (String)"] ", (int)0, (boolean)false, (int)6, null)) >= 0) {
                    String string = position.substring(closingIndex + 2);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                    position = string;
                }
                if ((index = StringsKt.indexOf$default((CharSequence)position, (String)".xml", (int)0, (boolean)false, (int)6, null)) == -1) continue;
                String string = position.substring(0, index + 4);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                String file = string;
                if (!Intrinsics.areEqual((Object)file, (Object)position)) {
                    String string2 = position.substring(index + 4 + 1);
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                    String sourcePosition = string2;
                    sourceFilePosition = new SourceFilePosition(new File(file), SourcePosition.fromString((String)sourcePosition));
                } else {
                    sourceFilePosition = new SourceFilePosition(new File(file), SourcePosition.UNKNOWN);
                }
                return sourceFilePosition;
            }
        }
        catch (Exception e) {
            return mergedFilePosition;
        }
        return mergedFilePosition;
    }

    private static final void setInjectableValues(ManifestMerger2.Invoker invoker, String packageOverride, Integer versionCode2, String versionName2, String minSdkVersion2, String targetSdkVersion2, Integer maxSdkVersion2, boolean profileable, boolean testOnly2, Integer compileSdk2, Boolean extractNativeLibs2) {
        if (packageOverride != null && ((CharSequence)packageOverride).length() > 0) {
            invoker.setOverride((ManifestSystemProperty)ManifestSystemProperty.Document.PACKAGE, packageOverride);
        }
        Integer n = versionCode2;
        if (n != null) {
            int it = ((Number)n).intValue();
            boolean bl = false;
            if (it > 0) {
                invoker.setOverride((ManifestSystemProperty)ManifestSystemProperty.Manifest.VERSION_CODE, String.valueOf(it));
            }
        }
        if (versionName2 != null && ((CharSequence)versionName2).length() > 0) {
            invoker.setOverride((ManifestSystemProperty)ManifestSystemProperty.Manifest.VERSION_NAME, versionName2);
        }
        if (minSdkVersion2 != null && ((CharSequence)minSdkVersion2).length() > 0) {
            invoker.setOverride((ManifestSystemProperty)ManifestSystemProperty.UsesSdk.MIN_SDK_VERSION, minSdkVersion2);
        }
        if (targetSdkVersion2 != null && ((CharSequence)targetSdkVersion2).length() > 0) {
            invoker.setOverride((ManifestSystemProperty)ManifestSystemProperty.UsesSdk.TARGET_SDK_VERSION, targetSdkVersion2);
        }
        if (maxSdkVersion2 != null) {
            invoker.setOverride((ManifestSystemProperty)ManifestSystemProperty.UsesSdk.MAX_SDK_VERSION, maxSdkVersion2.toString());
        }
        if (profileable) {
            invoker.setOverride((ManifestSystemProperty)ManifestSystemProperty.Profileable.SHELL, "true");
            if (compileSdk2 != null && compileSdk2 >= 30) {
                invoker.setOverride((ManifestSystemProperty)ManifestSystemProperty.Profileable.ENABLED, "true");
            }
        }
        if (testOnly2) {
            invoker.setOverride((ManifestSystemProperty)ManifestSystemProperty.Application.TEST_ONLY, "true");
        }
        if (extractNativeLibs2 != null && (compileSdk2 == null || compileSdk2 >= 23)) {
            invoker.setOverride((ManifestSystemProperty)ManifestSystemProperty.Application.EXTRACT_NATIVE_LIBS, extractNativeLibs2.toString());
        }
    }

    private static final void save(String xmlDocument, File out) {
        try {
            Files.createParentDirs((File)out);
            CharSink charSink = Files.asCharSink((File)out, (Charset)Charsets.UTF_8, (FileWriteMode[])new FileWriteMode[0]);
            String string = xmlDocument;
            Intrinsics.checkNotNull((Object)string);
            charSink.write((CharSequence)string);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

