/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.testing.androidtest;

import com.android.build.gradle.internal.testing.androidtest.AdbApkInstaller;
import com.android.utils.GrabProcessOutput;
import java.io.File;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 82\u00020\u0001:\u000589:;<Bd\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u0012)\b\u0002\u0010\r\u001a#\u0012\u0019\u0012\u0017\u0012\u0004\u0012\u00020\u00060\u000f\u00a2\u0006\f\b\u0010\u0012\b\b\u0011\u0012\u0004\b\b(\u0012\u0012\u0004\u0012\u00020\u00130\u000e\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u000e\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0006J\u0016\u0010\u001e\u001a\u00020\u001c2\u0006\u0010\u001f\u001a\u00020\u00032\u0006\u0010 \u001a\u00020!J\u001c\u0010\"\u001a\u00020\u001c2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00030\u000f2\u0006\u0010 \u001a\u00020!J\u000e\u0010$\u001a\u00020\u001c2\u0006\u0010\u001f\u001a\u00020\u0003J\u0010\u0010%\u001a\u00020\u001c2\u0006\u0010&\u001a\u00020\u0006H\u0002J\u0006\u0010'\u001a\u00020\u001cJ \u0010(\u001a\u00020)2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00060\u000f2\b\u0010*\u001a\u0004\u0018\u00010+H\u0002J\"\u0010,\u001a\u00020)2\f\u0010-\u001a\b\u0012\u0004\u0012\u00020\u00060\u000f2\n\b\u0002\u0010*\u001a\u0004\u0018\u00010+H\u0002J\"\u0010.\u001a\u00020)2\f\u0010-\u001a\b\u0012\u0004\u0012\u00020\u00060\u000f2\n\b\u0002\u0010*\u001a\u0004\u0018\u00010+H\u0002J\u001e\u0010/\u001a\b\u0012\u0004\u0012\u00020\u00060\u000f2\u0006\u0010 \u001a\u00020!2\u0006\u00100\u001a\u000201H\u0002J\u0012\u00102\u001a\u0004\u0018\u00010\u00062\u0006\u00103\u001a\u00020\u0006H\u0002J\u0018\u00104\u001a\u00020\u001c2\u0006\u0010\u001f\u001a\u00020\u00032\u0006\u00105\u001a\u000206H\u0002J\u0018\u00107\u001a\u00020\u001c2\u0006\u0010&\u001a\u00020\u00062\u0006\u00105\u001a\u000206H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R/\u0010\r\u001a#\u0012\u0019\u0012\u0017\u0012\u0004\u0012\u00020\u00060\u000f\u00a2\u0006\f\b\u0010\u0012\b\b\u0011\u0012\u0004\b\b(\u0012\u0012\u0004\u0012\u00020\u00130\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u0016\u001a\u0004\u0018\u00010\u00068BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0019\u0010\u001a\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006="}, d2={"Lcom/android/build/gradle/internal/testing/androidtest/AdbApkInstaller;", "", "adb", "Ljava/io/File;", "aapt", "deviceSerial", "", "deviceApiLevel", "", "installTimeoutMs", "", "logger", "Lorg/gradle/api/logging/Logger;", "processBuilder", "Lkotlin/Function1;", "", "Lkotlin/ParameterName;", "name", "command", "Ljava/lang/ProcessBuilder;", "<init>", "(Ljava/io/File;Ljava/io/File;Ljava/lang/String;IJLorg/gradle/api/logging/Logger;Lkotlin/jvm/functions/Function1;)V", "userId", "getUserId", "()Ljava/lang/String;", "userId$delegate", "Lkotlin/Lazy;", "preInstallationSetup", "", "instrumentationTargetPackageId", "installApk", "apk", "options", "Lcom/android/build/gradle/internal/testing/androidtest/AdbApkInstaller$InstallOptions;", "installSplitApk", "apks", "uninstallApk", "uninstallPackage", "packageName", "postTestCleanup", "runCommand", "Lcom/android/build/gradle/internal/testing/androidtest/AdbApkInstaller$CommandResult;", "timeout", "Ljava/time/Duration;", "runAdbCommand", "args", "runAdbShellCommand", "getInstallCmd", "useMultipleInstall", "", "getPackageNameFromApk", "apkPath", "forceCompilationApk", "mode", "Lcom/android/build/gradle/internal/testing/androidtest/AdbApkInstaller$ForceCompilation;", "forceCompilationPackage", "Companion", "InstallOptions", "ForceCompilation", "MinFeatureApiLevel", "CommandResult", "gradle-core"})
@SourceDebugExtension(value={"SMAP\nAdbApkInstaller.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AdbApkInstaller.kt\ncom/android/build/gradle/internal/testing/androidtest/AdbApkInstaller\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,342:1\n1#2:343\n1557#3:344\n1628#3,3:345\n*S KotlinDebug\n*F\n+ 1 AdbApkInstaller.kt\ncom/android/build/gradle/internal/testing/androidtest/AdbApkInstaller\n*L\n190#1:344\n190#1:345,3\n*E\n"})
public final class AdbApkInstaller {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final File adb;
    @NotNull
    private final File aapt;
    @NotNull
    private final String deviceSerial;
    private final int deviceApiLevel;
    private final long installTimeoutMs;
    @NotNull
    private final Logger logger;
    @NotNull
    private final Function1<List<String>, ProcessBuilder> processBuilder;
    @NotNull
    private final Lazy userId$delegate;
    @NotNull
    private static final Regex packageNameRegex = new Regex("package:\\sname='(\\S*)'.*$");

    public AdbApkInstaller(@NotNull File adb2, @NotNull File aapt, @NotNull String deviceSerial, int deviceApiLevel, long installTimeoutMs, @NotNull Logger logger, @NotNull Function1<? super List<String>, ProcessBuilder> processBuilder2) {
        Intrinsics.checkNotNullParameter((Object)adb2, (String)"adb");
        Intrinsics.checkNotNullParameter((Object)aapt, (String)"aapt");
        Intrinsics.checkNotNullParameter((Object)deviceSerial, (String)"deviceSerial");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter(processBuilder2, (String)"processBuilder");
        this.adb = adb2;
        this.aapt = aapt;
        this.deviceSerial = deviceSerial;
        this.deviceApiLevel = deviceApiLevel;
        this.installTimeoutMs = installTimeoutMs;
        this.logger = logger;
        this.processBuilder = processBuilder2;
        this.userId$delegate = LazyKt.lazy((Function0)((Function0)new Function0<String>(this){
            final /* synthetic */ AdbApkInstaller this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final String invoke() {
                String string;
                if (AdbApkInstaller.access$getDeviceApiLevel$p(this.this$0) < MinFeatureApiLevel.USER_ID.getApiLevel()) {
                    return null;
                }
                Object[] objectArray = new String[]{"am", "get-current-user"};
                CommandResult result2 = AdbApkInstaller.runAdbShellCommand$default(this.this$0, CollectionsKt.listOf((Object[])objectArray), null, 2, null);
                if (result2.getExitCode() != 0) {
                    AdbApkInstaller.access$getLogger$p(this.this$0).warn("Failed to get current user ID from device " + AdbApkInstaller.access$getDeviceSerial$p(this.this$0) + ".");
                    return null;
                }
                String userId2 = ((Object)StringsKt.trim((CharSequence)result2.getOutput())).toString();
                if (StringsKt.toIntOrNull((String)userId2) != null) {
                    string = userId2;
                } else {
                    AdbApkInstaller.access$getLogger$p(this.this$0).warn("Unexpected output from 'get-current-user': " + userId2);
                    string = null;
                }
                return string;
            }
        }));
    }

    public /* synthetic */ AdbApkInstaller(File file, File file2, String string, int n, long l, Logger logger, Function1 function1, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 0x20) != 0) {
            Logger logger2 = Logging.getLogger(AdbApkInstaller.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getLogger(...)");
            logger = logger2;
        }
        if ((n2 & 0x40) != 0) {
            function1 = 1.INSTANCE;
        }
        this(file, file2, string, n, l, logger, (Function1<? super List<String>, ProcessBuilder>)function1);
    }

    private final String getUserId() {
        Lazy lazy = this.userId$delegate;
        return (String)lazy.getValue();
    }

    public final void preInstallationSetup(@NotNull String instrumentationTargetPackageId) {
        Intrinsics.checkNotNullParameter((Object)instrumentationTargetPackageId, (String)"instrumentationTargetPackageId");
        if (this.deviceApiLevel >= MinFeatureApiLevel.DISABLE_VERIFIER.getApiLevel()) {
            Object[] objectArray = new String[]{"settings", "put", "global", "verifier_verify_adb_installs", "0"};
            AdbApkInstaller.runAdbShellCommand$default(this, CollectionsKt.listOf((Object[])objectArray), null, 2, null);
        }
        if (this.deviceApiLevel >= MinFeatureApiLevel.SET_DEBUG_APP.getApiLevel()) {
            Object[] objectArray = new String[]{"am", "set-debug-app", instrumentationTargetPackageId};
            CommandResult result2 = AdbApkInstaller.runAdbShellCommand$default(this, CollectionsKt.listOf((Object[])objectArray), null, 2, null);
            if (result2.getExitCode() != 0) {
                this.logger.warn("Failed to set debug app '" + instrumentationTargetPackageId + "'. Output: " + result2.getOutput() + " \n Error Output: " + result2.getErrorOutput());
            }
        }
    }

    public final void installApk(@NotNull File apk, @NotNull InstallOptions options) {
        Intrinsics.checkNotNullParameter((Object)apk, (String)"apk");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        Duration timeout = this.installTimeoutMs > 0L ? Duration.ofMillis(this.installTimeoutMs) : null;
        List<String> installCmd = this.getInstallCmd(options, false);
        List fullCommand = CollectionsKt.plus((Collection)installCmd, (Object)apk.getAbsolutePath());
        this.logger.info("Installing with command: adb " + CollectionsKt.joinToString$default((Iterable)fullCommand, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null));
        CommandResult result2 = this.runAdbCommand(fullCommand, timeout);
        if (result2.getExitCode() != 0) {
            throw new RuntimeException("Failed to install APK " + apk + ": " + result2.getOutput() + " " + result2.getErrorOutput());
        }
        if (this.deviceApiLevel >= MinFeatureApiLevel.FORCE_COMPILATION.getApiLevel() && options.getForceCompilation() != ForceCompilation.NO_FORCE_COMPILATION) {
            this.forceCompilationApk(apk, options.getForceCompilation());
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void installSplitApk(@NotNull List<? extends File> apks, @NotNull InstallOptions options) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(apks, (String)"apks");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        if (!(!((Collection)apks).isEmpty())) {
            boolean $i$a$-check-AdbApkInstaller$installSplitApk$22 = false;
            String $i$a$-check-AdbApkInstaller$installSplitApk$22 = "No APKs provided for installation.";
            throw new IllegalStateException($i$a$-check-AdbApkInstaller$installSplitApk$22.toString());
        }
        if (this.deviceApiLevel < MinFeatureApiLevel.SPLIT_APK.getApiLevel()) {
            throw new RuntimeException("Split APK installation requires API level " + MinFeatureApiLevel.SPLIT_APK.getApiLevel() + ", but device is API level " + this.deviceApiLevel + ".");
        }
        Duration timeout = this.installTimeoutMs > 0L ? Duration.ofMillis(this.installTimeoutMs) : null;
        List<String> installCmd = this.getInstallCmd(options, true);
        Iterable iterable = apks;
        Collection collection = installCmd;
        boolean $i$f$map = false;
        void var8_10 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            File file = (File)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add(it.getAbsolutePath());
        }
        List fullCommand = CollectionsKt.plus((Collection)collection, (Iterable)((List)destination$iv$iv));
        this.logger.info("Installing split-apk with command: adb " + CollectionsKt.joinToString$default((Iterable)fullCommand, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null));
        CommandResult result2 = this.runAdbCommand(fullCommand, timeout);
        if (result2.getExitCode() != 0) {
            throw new RuntimeException("Failed to install APKs " + CollectionsKt.joinToString$default((Iterable)apks, null, null, null, (int)0, null, null, (int)63, null) + ": " + result2.getOutput() + " " + result2.getErrorOutput());
        }
        if (this.deviceApiLevel >= MinFeatureApiLevel.FORCE_COMPILATION.getApiLevel() && options.getForceCompilation() != ForceCompilation.NO_FORCE_COMPILATION) {
            this.forceCompilationApk((File)CollectionsKt.first(apks), options.getForceCompilation());
        }
    }

    public final void uninstallApk(@NotNull File apk) {
        Intrinsics.checkNotNullParameter((Object)apk, (String)"apk");
        String string = apk.getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAbsolutePath(...)");
        String string2 = this.getPackageNameFromApk(string);
        if (string2 != null) {
            String packageName = string2;
            boolean bl = false;
            this.uninstallPackage(packageName);
        } else {
            this.logger.warn("Could not get package name from " + apk.getPath() + " to uninstall.");
        }
    }

    private final void uninstallPackage(String packageName) {
        this.logger.info("Uninstalling " + packageName + " from device " + this.deviceSerial + ".");
        Object[] objectArray = new String[]{"uninstall", packageName};
        CommandResult result2 = AdbApkInstaller.runAdbCommand$default(this, CollectionsKt.listOf((Object[])objectArray), null, 2, null);
        if (result2.getExitCode() != 0) {
            this.logger.warn("Failed to uninstall package " + packageName + ". Output: " + result2.getOutput() + " \n Error Output: " + result2.getErrorOutput());
        }
    }

    public final void postTestCleanup() {
        Object[] objectArray = new String[]{"am", "clear-debug-app"};
        CommandResult result2 = AdbApkInstaller.runAdbShellCommand$default(this, CollectionsKt.listOf((Object[])objectArray), null, 2, null);
        boolean bl = false;
        if (result2.getExitCode() != 0) {
            this.logger.info("Failed to execute clear-debug-app command. It may not be supported on this device.");
        }
    }

    private final CommandResult runCommand(List<String> command, Duration timeout) {
        Process process2 = ((ProcessBuilder)this.processBuilder.invoke(command)).start();
        List outputLines = new ArrayList();
        List errorLines = new ArrayList();
        GrabProcessOutput.IProcessOutput handler2 = new GrabProcessOutput.IProcessOutput(outputLines, errorLines){
            final /* synthetic */ List<String> $outputLines;
            final /* synthetic */ List<String> $errorLines;
            {
                this.$outputLines = $outputLines;
                this.$errorLines = $errorLines;
            }

            public void out(String line) {
                block0: {
                    String string = line;
                    if (string == null) break block0;
                    String string2 = string;
                    List<String> list = this.$outputLines;
                    String it = string2;
                    boolean bl = false;
                    list.add(it);
                }
            }

            public void err(String line) {
                block0: {
                    String string = line;
                    if (string == null) break block0;
                    String string2 = string;
                    List<String> list = this.$errorLines;
                    String it = string2;
                    boolean bl = false;
                    list.add(it);
                }
            }
        };
        Duration duration = timeout;
        GrabProcessOutput.grabProcessOutput((Process)process2, (GrabProcessOutput.Wait)GrabProcessOutput.Wait.WAIT_FOR_READERS, (GrabProcessOutput.IProcessOutput)handler2, (Long)(duration != null ? Long.valueOf(duration.toMillis()) : null), (TimeUnit)TimeUnit.MILLISECONDS);
        return new CommandResult(process2.exitValue(), CollectionsKt.joinToString$default((Iterable)outputLines, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null), CollectionsKt.joinToString$default((Iterable)errorLines, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null));
    }

    private final CommandResult runAdbCommand(List<String> args, Duration timeout) {
        Object[] objectArray = new String[]{this.adb.getAbsolutePath(), "-s", this.deviceSerial};
        List command = CollectionsKt.plus((Collection)CollectionsKt.listOf((Object[])objectArray), (Iterable)args);
        return this.runCommand(command, timeout);
    }

    static /* synthetic */ CommandResult runAdbCommand$default(AdbApkInstaller adbApkInstaller, List list, Duration duration, int n, Object object) {
        if ((n & 2) != 0) {
            duration = null;
        }
        return adbApkInstaller.runAdbCommand(list, duration);
    }

    private final CommandResult runAdbShellCommand(List<String> args, Duration timeout) {
        return this.runAdbCommand(CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)"shell"), (Iterable)args), timeout);
    }

    static /* synthetic */ CommandResult runAdbShellCommand$default(AdbApkInstaller adbApkInstaller, List list, Duration duration, int n, Object object) {
        if ((n & 2) != 0) {
            duration = null;
        }
        return adbApkInstaller.runAdbShellCommand(list, duration);
    }

    private final List<String> getInstallCmd(InstallOptions options, boolean useMultipleInstall) {
        String command = useMultipleInstall ? "install-multiple" : "install";
        Object[] objectArray = new String[]{command};
        List cmd = CollectionsKt.mutableListOf((Object[])objectArray);
        if (this.deviceApiLevel >= 34) {
            cmd.add("--bypass-low-target-sdk-block");
        }
        cmd.add("-t");
        if (options.getForceReinstall()) {
            objectArray = new String[]{"-r", "-d"};
            cmd.addAll(CollectionsKt.listOf((Object[])objectArray));
        }
        if (options.getGrantPermissions() && this.deviceApiLevel >= MinFeatureApiLevel.GRANT_PERMISSIONS.getApiLevel()) {
            cmd.add("-g");
        }
        if (options.getForceQueryable() && this.deviceApiLevel >= MinFeatureApiLevel.FORCE_QUERYABLE.getApiLevel()) {
            cmd.add("--force-queryable");
        }
        String string = this.getUserId();
        if (string != null) {
            String it = string;
            boolean bl = false;
            Object[] objectArray2 = new String[]{"--user", it};
            cmd.addAll(CollectionsKt.listOf((Object[])objectArray2));
        }
        cmd.addAll((Collection)options.getExtraArgs());
        return cmd;
    }

    private final String getPackageNameFromApk(String apkPath) {
        Object[] objectArray = new String[]{this.aapt.getAbsolutePath(), "dump", "badging", apkPath};
        CommandResult result2 = this.runCommand(CollectionsKt.listOf((Object[])objectArray), null);
        return (String)SequencesKt.firstOrNull((Sequence)SequencesKt.mapNotNull((Sequence)StringsKt.lineSequence((CharSequence)result2.getOutput()), (Function1)getPackageNameFromApk.1.INSTANCE));
    }

    private final void forceCompilationApk(File apk, ForceCompilation mode) {
        String string = apk.getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAbsolutePath(...)");
        String string2 = this.getPackageNameFromApk(string);
        if (string2 != null) {
            String packageName = string2;
            boolean bl = false;
            this.forceCompilationPackage(packageName, mode);
        } else {
            this.logger.warn("Could not get package name from " + apk.getPath() + " to force compilation.");
        }
    }

    private final void forceCompilationPackage(String packageName, ForceCompilation mode) {
        String string;
        switch (WhenMappings.$EnumSwitchMapping$0[mode.ordinal()]) {
            case 1: {
                string = "speed";
                break;
            }
            case 2: {
                string = "speed-profile";
                break;
            }
            case 3: {
                return;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        String compileMode = string;
        this.logger.info("Running force AOT compilation (" + compileMode + ") for " + packageName);
        Object[] objectArray = new String[]{"cmd", "package", "compile", "-m", compileMode, "-f", packageName};
        List command = CollectionsKt.listOf((Object[])objectArray);
        AdbApkInstaller.runAdbShellCommand$default(this, command, null, 2, null);
    }

    public static final /* synthetic */ Regex access$getPackageNameRegex$cp() {
        return packageNameRegex;
    }

    public static final /* synthetic */ int access$getDeviceApiLevel$p(AdbApkInstaller $this) {
        return $this.deviceApiLevel;
    }

    public static final /* synthetic */ Logger access$getLogger$p(AdbApkInstaller $this) {
        return $this.logger;
    }

    public static final /* synthetic */ String access$getDeviceSerial$p(AdbApkInstaller $this) {
        return $this.deviceSerial;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0082\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0005H\u00c6\u0003J'\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\f\u00a8\u0006\u0017"}, d2={"Lcom/android/build/gradle/internal/testing/androidtest/AdbApkInstaller$CommandResult;", "", "exitCode", "", "output", "", "errorOutput", "<init>", "(ILjava/lang/String;Ljava/lang/String;)V", "getExitCode", "()I", "getOutput", "()Ljava/lang/String;", "getErrorOutput", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "toString", "gradle-core"})
    private static final class CommandResult {
        private final int exitCode;
        @NotNull
        private final String output;
        @NotNull
        private final String errorOutput;

        public CommandResult(int exitCode, @NotNull String output2, @NotNull String errorOutput) {
            Intrinsics.checkNotNullParameter((Object)output2, (String)"output");
            Intrinsics.checkNotNullParameter((Object)errorOutput, (String)"errorOutput");
            this.exitCode = exitCode;
            this.output = output2;
            this.errorOutput = errorOutput;
        }

        public final int getExitCode() {
            return this.exitCode;
        }

        @NotNull
        public final String getOutput() {
            return this.output;
        }

        @NotNull
        public final String getErrorOutput() {
            return this.errorOutput;
        }

        public final int component1() {
            return this.exitCode;
        }

        @NotNull
        public final String component2() {
            return this.output;
        }

        @NotNull
        public final String component3() {
            return this.errorOutput;
        }

        @NotNull
        public final CommandResult copy(int exitCode, @NotNull String output2, @NotNull String errorOutput) {
            Intrinsics.checkNotNullParameter((Object)output2, (String)"output");
            Intrinsics.checkNotNullParameter((Object)errorOutput, (String)"errorOutput");
            return new CommandResult(exitCode, output2, errorOutput);
        }

        public static /* synthetic */ CommandResult copy$default(CommandResult commandResult, int n, String string, String string2, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = commandResult.exitCode;
            }
            if ((n2 & 2) != 0) {
                string = commandResult.output;
            }
            if ((n2 & 4) != 0) {
                string2 = commandResult.errorOutput;
            }
            return commandResult.copy(n, string, string2);
        }

        @NotNull
        public String toString() {
            return "CommandResult(exitCode=" + this.exitCode + ", output=" + this.output + ", errorOutput=" + this.errorOutput + ")";
        }

        public int hashCode() {
            int result2 = Integer.hashCode(this.exitCode);
            result2 = result2 * 31 + this.output.hashCode();
            result2 = result2 * 31 + this.errorOutput.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof CommandResult)) {
                return false;
            }
            CommandResult commandResult = (CommandResult)other;
            if (this.exitCode != commandResult.exitCode) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.output, (Object)commandResult.output)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.errorOutput, (Object)commandResult.errorOutput);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/android/build/gradle/internal/testing/androidtest/AdbApkInstaller$Companion;", "", "<init>", "()V", "packageNameRegex", "Lkotlin/text/Regex;", "gradle-core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lcom/android/build/gradle/internal/testing/androidtest/AdbApkInstaller$ForceCompilation;", "", "<init>", "(Ljava/lang/String;I)V", "NO_FORCE_COMPILATION", "FULL_COMPILATION", "PROFILE_BASED_COMPILATION", "gradle-core"})
    public static final class ForceCompilation
    extends Enum<ForceCompilation> {
        public static final /* enum */ ForceCompilation NO_FORCE_COMPILATION = new ForceCompilation();
        public static final /* enum */ ForceCompilation FULL_COMPILATION = new ForceCompilation();
        public static final /* enum */ ForceCompilation PROFILE_BASED_COMPILATION = new ForceCompilation();
        private static final /* synthetic */ ForceCompilation[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static ForceCompilation[] values() {
            return (ForceCompilation[])$VALUES.clone();
        }

        public static ForceCompilation valueOf(String value) {
            return Enum.valueOf(ForceCompilation.class, value);
        }

        @NotNull
        public static EnumEntries<ForceCompilation> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = forceCompilationArray = new ForceCompilation[]{ForceCompilation.NO_FORCE_COMPILATION, ForceCompilation.FULL_COMPILATION, ForceCompilation.PROFILE_BASED_COMPILATION};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0013\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B?\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0004\b\u000b\u0010\fJ\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0007H\u00c6\u0003J\u000f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u00c6\u0003JA\u0010\u001a\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u00072\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u00c6\u0001J\u0013\u0010\u001b\u001a\u00020\u00032\b\u0010\u001c\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001d\u001a\u00020\u001eH\u00d6\u0001J\t\u0010\u001f\u001a\u00020\nH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000eR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000eR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006 "}, d2={"Lcom/android/build/gradle/internal/testing/androidtest/AdbApkInstaller$InstallOptions;", "", "grantPermissions", "", "forceQueryable", "forceReinstall", "forceCompilation", "Lcom/android/build/gradle/internal/testing/androidtest/AdbApkInstaller$ForceCompilation;", "extraArgs", "", "", "<init>", "(ZZZLcom/android/build/gradle/internal/testing/androidtest/AdbApkInstaller$ForceCompilation;Ljava/util/List;)V", "getGrantPermissions", "()Z", "getForceQueryable", "getForceReinstall", "getForceCompilation", "()Lcom/android/build/gradle/internal/testing/androidtest/AdbApkInstaller$ForceCompilation;", "getExtraArgs", "()Ljava/util/List;", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "other", "hashCode", "", "toString", "gradle-core"})
    public static final class InstallOptions {
        private final boolean grantPermissions;
        private final boolean forceQueryable;
        private final boolean forceReinstall;
        @NotNull
        private final ForceCompilation forceCompilation;
        @NotNull
        private final List<String> extraArgs;

        public InstallOptions(boolean grantPermissions, boolean forceQueryable, boolean forceReinstall, @NotNull ForceCompilation forceCompilation, @NotNull List<String> extraArgs) {
            Intrinsics.checkNotNullParameter((Object)((Object)forceCompilation), (String)"forceCompilation");
            Intrinsics.checkNotNullParameter(extraArgs, (String)"extraArgs");
            this.grantPermissions = grantPermissions;
            this.forceQueryable = forceQueryable;
            this.forceReinstall = forceReinstall;
            this.forceCompilation = forceCompilation;
            this.extraArgs = extraArgs;
        }

        public /* synthetic */ InstallOptions(boolean bl, boolean bl2, boolean bl3, ForceCompilation forceCompilation, List list, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                bl = false;
            }
            if ((n & 2) != 0) {
                bl2 = false;
            }
            if ((n & 4) != 0) {
                bl3 = false;
            }
            if ((n & 8) != 0) {
                forceCompilation = ForceCompilation.NO_FORCE_COMPILATION;
            }
            if ((n & 0x10) != 0) {
                list = CollectionsKt.emptyList();
            }
            this(bl, bl2, bl3, forceCompilation, list);
        }

        public final boolean getGrantPermissions() {
            return this.grantPermissions;
        }

        public final boolean getForceQueryable() {
            return this.forceQueryable;
        }

        public final boolean getForceReinstall() {
            return this.forceReinstall;
        }

        @NotNull
        public final ForceCompilation getForceCompilation() {
            return this.forceCompilation;
        }

        @NotNull
        public final List<String> getExtraArgs() {
            return this.extraArgs;
        }

        public final boolean component1() {
            return this.grantPermissions;
        }

        public final boolean component2() {
            return this.forceQueryable;
        }

        public final boolean component3() {
            return this.forceReinstall;
        }

        @NotNull
        public final ForceCompilation component4() {
            return this.forceCompilation;
        }

        @NotNull
        public final List<String> component5() {
            return this.extraArgs;
        }

        @NotNull
        public final InstallOptions copy(boolean grantPermissions, boolean forceQueryable, boolean forceReinstall, @NotNull ForceCompilation forceCompilation, @NotNull List<String> extraArgs) {
            Intrinsics.checkNotNullParameter((Object)((Object)forceCompilation), (String)"forceCompilation");
            Intrinsics.checkNotNullParameter(extraArgs, (String)"extraArgs");
            return new InstallOptions(grantPermissions, forceQueryable, forceReinstall, forceCompilation, extraArgs);
        }

        public static /* synthetic */ InstallOptions copy$default(InstallOptions installOptions, boolean bl, boolean bl2, boolean bl3, ForceCompilation forceCompilation, List list, int n, Object object) {
            if ((n & 1) != 0) {
                bl = installOptions.grantPermissions;
            }
            if ((n & 2) != 0) {
                bl2 = installOptions.forceQueryable;
            }
            if ((n & 4) != 0) {
                bl3 = installOptions.forceReinstall;
            }
            if ((n & 8) != 0) {
                forceCompilation = installOptions.forceCompilation;
            }
            if ((n & 0x10) != 0) {
                list = installOptions.extraArgs;
            }
            return installOptions.copy(bl, bl2, bl3, forceCompilation, list);
        }

        @NotNull
        public String toString() {
            return "InstallOptions(grantPermissions=" + this.grantPermissions + ", forceQueryable=" + this.forceQueryable + ", forceReinstall=" + this.forceReinstall + ", forceCompilation=" + this.forceCompilation + ", extraArgs=" + this.extraArgs + ")";
        }

        public int hashCode() {
            int result2 = Boolean.hashCode(this.grantPermissions);
            result2 = result2 * 31 + Boolean.hashCode(this.forceQueryable);
            result2 = result2 * 31 + Boolean.hashCode(this.forceReinstall);
            result2 = result2 * 31 + this.forceCompilation.hashCode();
            result2 = result2 * 31 + ((Object)this.extraArgs).hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof InstallOptions)) {
                return false;
            }
            InstallOptions installOptions = (InstallOptions)other;
            if (this.grantPermissions != installOptions.grantPermissions) {
                return false;
            }
            if (this.forceQueryable != installOptions.forceQueryable) {
                return false;
            }
            if (this.forceReinstall != installOptions.forceReinstall) {
                return false;
            }
            if (this.forceCompilation != installOptions.forceCompilation) {
                return false;
            }
            return Intrinsics.areEqual(this.extraArgs, installOptions.extraArgs);
        }

        public InstallOptions() {
            this(false, false, false, null, null, 31, null);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\b\n\u0002\b\f\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0011\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\fj\u0002\b\rj\u0002\b\u000e\u00a8\u0006\u000f"}, d2={"Lcom/android/build/gradle/internal/testing/androidtest/AdbApkInstaller$MinFeatureApiLevel;", "", "apiLevel", "", "<init>", "(Ljava/lang/String;II)V", "getApiLevel", "()I", "SPLIT_APK", "USER_ID", "FORCE_COMPILATION", "GRANT_PERMISSIONS", "FORCE_QUERYABLE", "DISABLE_VERIFIER", "SET_DEBUG_APP", "gradle-core"})
    private static final class MinFeatureApiLevel
    extends Enum<MinFeatureApiLevel> {
        private final int apiLevel;
        public static final /* enum */ MinFeatureApiLevel SPLIT_APK = new MinFeatureApiLevel(21);
        public static final /* enum */ MinFeatureApiLevel USER_ID = new MinFeatureApiLevel(24);
        public static final /* enum */ MinFeatureApiLevel FORCE_COMPILATION = new MinFeatureApiLevel(24);
        public static final /* enum */ MinFeatureApiLevel GRANT_PERMISSIONS = new MinFeatureApiLevel(23);
        public static final /* enum */ MinFeatureApiLevel FORCE_QUERYABLE = new MinFeatureApiLevel(30);
        public static final /* enum */ MinFeatureApiLevel DISABLE_VERIFIER = new MinFeatureApiLevel(33);
        public static final /* enum */ MinFeatureApiLevel SET_DEBUG_APP = new MinFeatureApiLevel(35);
        private static final /* synthetic */ MinFeatureApiLevel[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private MinFeatureApiLevel(int apiLevel) {
            this.apiLevel = apiLevel;
        }

        public final int getApiLevel() {
            return this.apiLevel;
        }

        public static MinFeatureApiLevel[] values() {
            return (MinFeatureApiLevel[])$VALUES.clone();
        }

        public static MinFeatureApiLevel valueOf(String value) {
            return Enum.valueOf(MinFeatureApiLevel.class, value);
        }

        @NotNull
        public static EnumEntries<MinFeatureApiLevel> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = minFeatureApiLevelArray = new MinFeatureApiLevel[]{MinFeatureApiLevel.SPLIT_APK, MinFeatureApiLevel.USER_ID, MinFeatureApiLevel.FORCE_COMPILATION, MinFeatureApiLevel.GRANT_PERMISSIONS, MinFeatureApiLevel.FORCE_QUERYABLE, MinFeatureApiLevel.DISABLE_VERIFIER, MinFeatureApiLevel.SET_DEBUG_APP};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ForceCompilation.values().length];
            try {
                nArray[ForceCompilation.FULL_COMPILATION.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ForceCompilation.PROFILE_BASED_COMPILATION.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ForceCompilation.NO_FORCE_COMPILATION.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

