/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.dsl;

import com.android.build.api.dsl.DensitySplit;
import com.android.build.gradle.internal.dsl.SplitOptions;
import com.android.build.gradle.internal.dsl.decorator.annotation.WithLazyInitialization;
import com.android.build.gradle.internal.errors.DeprecationReporter;
import com.android.build.gradle.internal.services.DslServices;
import com.android.resources.Density;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0004\n\u0002\u0010 \n\u0000\b&\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J!\u0010\u0011\u001a\u00020\u00122\u0012\u0010\u0013\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00150\u0014\"\u00020\u0015H\u0016\u00a2\u0006\u0002\u0010\u0016J\u000e\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00150\u0018H\u0014J\u000e\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00150\u001aH\u0014J\b\u0010\u001b\u001a\u00020\u0012H\u0004J\u0010\u0010\u001c\u001a\u00020\u00122\u0006\u0010\u001d\u001a\u00020\u0007H\u0007J\u0014\u0010\u001e\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u001fR\u0018\u0010\u0006\u001a\u00020\u0007X\u00a4\u000e\u00a2\u0006\f\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR$\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u00078V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u000f\u0010\t\"\u0004\b\u0010\u0010\u000b\u00a8\u0006 "}, d2={"Lcom/android/build/gradle/internal/dsl/DensitySplitOptions;", "Lcom/android/build/gradle/internal/dsl/SplitOptions;", "Lcom/android/build/api/dsl/DensitySplit;", "dslServices", "Lcom/android/build/gradle/internal/services/DslServices;", "(Lcom/android/build/gradle/internal/services/DslServices;)V", "_isEnable", "", "get_isEnable", "()Z", "set_isEnable", "(Z)V", "getDslServices", "()Lcom/android/build/gradle/internal/services/DslServices;", "value", "isEnable", "setEnable", "compatibleScreens", "", "sizes", "", "", "([Ljava/lang/String;)V", "getAllowedValues", "Lcom/google/common/collect/ImmutableSet;", "getDefaultValues", "", "lazyInit", "setAuto", "auto", "setCompatibleScreens", "", "gradle-core"})
public abstract class DensitySplitOptions
extends SplitOptions
implements DensitySplit {
    @NotNull
    private final DslServices dslServices;

    @Inject
    @WithLazyInitialization(methodName="lazyInit")
    public DensitySplitOptions(@NotNull DslServices dslServices2) {
        Intrinsics.checkNotNullParameter((Object)dslServices2, (String)"dslServices");
        this.dslServices = dslServices2;
    }

    @NotNull
    public final DslServices getDslServices() {
        return this.dslServices;
    }

    protected final void lazyInit() {
        this.setStrict(true);
        this.init();
    }

    protected abstract boolean get_isEnable();

    protected abstract void set_isEnable(boolean var1);

    public boolean isEnable() {
        return this.get_isEnable();
    }

    public void setEnable(boolean value) {
        this.dslServices.getDeprecationReporter().reportDeprecatedApi(null, "splits.density", "https://developer.android.com/studio/build/configure-apk-splits#configure-density-split", DeprecationReporter.DeprecationTarget.DENSITY_SPLIT_API);
        this.set_isEnable(value);
    }

    @Override
    @NotNull
    protected Set<String> getDefaultValues() {
        Set values = Density.getRecommendedValuesForDevice();
        HashSet hashSet = Sets.newHashSetWithExpectedSize((int)values.size());
        Intrinsics.checkNotNullExpressionValue((Object)hashSet, (String)"newHashSetWithExpectedSize(values.size)");
        Set fullList = hashSet;
        for (Density value : values) {
            String string = value.getResourceValue();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"value.resourceValue");
            fullList.add(string);
        }
        return fullList;
    }

    @Override
    @NotNull
    protected ImmutableSet<String> getAllowedValues() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (Density value : Density.values()) {
            if (value == Density.NODPI || value == Density.ANYDPI) continue;
            builder.add((Object)value.getResourceValue());
        }
        ImmutableSet immutableSet = builder.build();
        Intrinsics.checkNotNullExpressionValue((Object)immutableSet, (String)"builder.build()");
        return immutableSet;
    }

    public final void setCompatibleScreens(@NotNull List<String> sizes) {
        Intrinsics.checkNotNullParameter(sizes, (String)"sizes");
        List copiedValues = CollectionsKt.toList((Iterable)sizes);
        this.getCompatibleScreens().clear();
        this.getCompatibleScreens().addAll(copiedValues);
    }

    public void compatibleScreens(String ... sizes) {
        Intrinsics.checkNotNullParameter((Object)sizes, (String)"sizes");
        this.getCompatibleScreens().addAll(CollectionsKt.listOf((Object[])Arrays.copyOf(sizes, sizes.length)));
    }

    @Deprecated(message="DensitySplitOptions.auto is not supported anymore.")
    public final void setAuto(boolean auto) {
        throw new RuntimeException("DensitySplitOptions.auto is not supported anymore.");
    }
}

