/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.lint;

import com.android.build.gradle.internal.lint.AndroidLintInputs;
import com.android.build.gradle.internal.lint.AndroidLintWorkAction;
import com.android.build.gradle.internal.lint.LintMode;
import com.android.build.gradle.internal.lint.LintTool;
import com.android.build.gradle.internal.services.BuildServicesKt;
import com.android.build.gradle.internal.services.LintClassLoaderBuildService;
import com.android.build.gradle.internal.services.LintParallelBuildService;
import com.android.build.gradle.internal.services.TaskCreationServices;
import com.android.build.gradle.internal.utils.HasConfigurableValuesKt;
import com.android.build.gradle.options.BooleanOption;
import com.android.build.gradle.options.ProjectOptions;
import com.android.build.gradle.options.StringOption;
import com.android.utils.PathUtils;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.function.BiFunction;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.gradle.api.Action;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.services.BuildServiceRegistry;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Optional;
import org.gradle.workers.ProcessWorkerSpec;
import org.gradle.workers.WorkQueue;
import org.gradle.workers.WorkerExecutor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00140\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\u0019H\u0002J\u0016\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001e\u001a\u00020\u0014J\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00140 J,\u0010!\u001a\u00020\u001d2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u00142\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00140 2\u0006\u0010&\u001a\u00020'JX\u0010!\u001a\u00020\u001d2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u00142\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00140 2\u0006\u0010(\u001a\u00020\u00112\u0006\u0010)\u001a\u00020\u00112\u0006\u0010*\u001a\u00020\u00112\u0006\u0010&\u001a\u00020'2\u0006\u0010+\u001a\u00020\u00112\n\b\u0002\u0010,\u001a\u0004\u0018\u00010-R\u0014\u0010\u0003\u001a\u00020\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\b8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\f8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u000fR\u001a\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\f8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u000fR\u001a\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00140\f8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u000f\u00a8\u0006."}, d2={"Lcom/android/build/gradle/internal/lint/LintTool;", "", "()V", "classpath", "Lorg/gradle/api/file/ConfigurableFileCollection;", "getClasspath", "()Lorg/gradle/api/file/ConfigurableFileCollection;", "lintCacheDirectory", "Lorg/gradle/api/file/DirectoryProperty;", "getLintCacheDirectory", "()Lorg/gradle/api/file/DirectoryProperty;", "lintClassLoaderBuildService", "Lorg/gradle/api/provider/Property;", "Lcom/android/build/gradle/internal/services/LintClassLoaderBuildService;", "getLintClassLoaderBuildService", "()Lorg/gradle/api/provider/Property;", "runInProcess", "", "getRunInProcess", "versionKey", "", "getVersionKey", "workerHeapSize", "getWorkerHeapSize", "deriveVersionKey", "Lorg/gradle/api/provider/Provider;", "taskCreationServices", "Lcom/android/build/gradle/internal/services/TaskCreationServices;", "initialize", "", "taskName", "initializeLintCacheDir", "", "submit", "workerExecutor", "Lorg/gradle/workers/WorkerExecutor;", "mainClass", "arguments", "lintMode", "Lcom/android/build/gradle/internal/lint/LintMode;", "android", "fatalOnly", "await", "hasBaseline", "returnValueOutputFile", "Ljava/io/File;", "gradle-core"})
@SourceDebugExtension(value={"SMAP\nAndroidLintInputs.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AndroidLintInputs.kt\ncom/android/build/gradle/internal/lint/LintTool\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 buildServices.kt\ncom/android/build/gradle/internal/services/BuildServicesKt\n*L\n1#1,2515:1\n1#2:2516\n67#3:2517\n*S KotlinDebug\n*F\n+ 1 AndroidLintInputs.kt\ncom/android/build/gradle/internal/lint/LintTool\n*L\n193#1:2517\n*E\n"})
public abstract class LintTool {
    @Classpath
    @NotNull
    public abstract ConfigurableFileCollection getClasspath();

    @Input
    @NotNull
    public abstract Property<String> getVersionKey();

    @Input
    @NotNull
    public abstract Property<Boolean> getRunInProcess();

    @Input
    @Optional
    @NotNull
    public abstract Property<String> getWorkerHeapSize();

    @Internal
    @NotNull
    public abstract DirectoryProperty getLintCacheDirectory();

    @NotNull
    public final List<String> initializeLintCacheDir() {
        String previousVersion;
        String string;
        Path path;
        Path directory2 = ((Directory)this.getLintCacheDirectory().get()).getAsFile().toPath();
        Path lintVersionMarkerFile = directory2.resolve("lint-cache-version.txt");
        String currentVersion = "Cache for Android Lint" + this.getVersionKey().get();
        Path it = path = lintVersionMarkerFile;
        boolean bl = false;
        Path path2 = Files.exists(it, new LinkOption[0]) ? path : null;
        if (path2 != null) {
            it = path2;
            boolean bl2 = false;
            List<String> list = Files.readAllLines(it);
            Intrinsics.checkNotNullExpressionValue(list, (String)"readAllLines(it)");
            string = (String)CollectionsKt.singleOrNull(list);
        } else {
            string = previousVersion = null;
        }
        if (!Intrinsics.areEqual(previousVersion, (Object)currentVersion)) {
            PathUtils.deleteRecursivelyIfExists((Path)directory2);
            Files.createDirectories(directory2, new FileAttribute[0]);
            Files.write(lintVersionMarkerFile, (Iterable<? extends CharSequence>)CollectionsKt.listOf((Object)currentVersion), new OpenOption[0]);
        }
        Object[] objectArray = new String[]{"--cache-dir", ((Object)directory2).toString()};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @Internal
    @NotNull
    public abstract Property<LintClassLoaderBuildService> getLintClassLoaderBuildService();

    public final void initialize(@NotNull TaskCreationServices taskCreationServices, @NotNull String taskName) {
        Intrinsics.checkNotNullParameter((Object)taskCreationServices, (String)"taskCreationServices");
        Intrinsics.checkNotNullParameter((Object)taskName, (String)"taskName");
        Object[] objectArray = new Object[]{taskCreationServices.getLintFromMaven().getFiles()};
        HasConfigurableValuesKt.fromDisallowChanges(this.getClasspath(), objectArray);
        BuildServiceRegistry buildServiceRegistry$iv = taskCreationServices.getBuildServiceRegistry();
        boolean $i$f$getBuildService = false;
        HasConfigurableValuesKt.setDisallowChanges(this.getLintClassLoaderBuildService(), BuildServicesKt.getBuildService(buildServiceRegistry$iv, LintClassLoaderBuildService.class));
        HasConfigurableValuesKt.setDisallowChanges(this.getVersionKey(), this.deriveVersionKey(taskCreationServices, (Provider<LintClassLoaderBuildService>)((Provider)this.getLintClassLoaderBuildService())));
        ProjectOptions projectOptions = taskCreationServices.getProjectOptions();
        Property<Boolean> property = this.getRunInProcess();
        Provider<Boolean> provider2 = projectOptions.getProvider(BooleanOption.RUN_LINT_IN_PROCESS);
        Intrinsics.checkNotNullExpressionValue(provider2, (String)"projectOptions.getProvid\u2026tion.RUN_LINT_IN_PROCESS)");
        HasConfigurableValuesKt.setDisallowChanges(property, provider2);
        Property<String> property2 = this.getWorkerHeapSize();
        Provider<String> provider3 = projectOptions.getProvider(StringOption.LINT_HEAP_SIZE);
        Intrinsics.checkNotNullExpressionValue(provider3, (String)"projectOptions.getProvid\u2026ingOption.LINT_HEAP_SIZE)");
        HasConfigurableValuesKt.setDisallowChanges(property2, provider3);
        Property property3 = (Property)this.getLintCacheDirectory();
        Provider provider4 = taskCreationServices.getProjectInfo().getBuildDirectory().dir("intermediates/lint-cache/" + taskName);
        Intrinsics.checkNotNullExpressionValue((Object)provider4, (String)"taskCreationServices.pro\u2026S}/lint-cache/$taskName\")");
        HasConfigurableValuesKt.setDisallowChanges(property3, provider4);
    }

    private final Provider<String> deriveVersionKey(TaskCreationServices taskCreationServices, Provider<LintClassLoaderBuildService> lintClassLoaderBuildService) {
        Provider provider2;
        String string = taskCreationServices.getProjectOptions().get(StringOption.LINT_VERSION_OVERRIDE);
        String lintVersion = AndroidLintInputs.getLintMavenArtifactVersion$default(string != null ? ((Object)StringsKt.trim((CharSequence)string)).toString() : null, null, null, null, 12, null);
        Provider versionProvider2 = taskCreationServices.provider((Function0)new Function0<String>(lintVersion){
            final /* synthetic */ String $lintVersion;
            {
                this.$lintVersion = $lintVersion;
                super(0);
            }

            @Nullable
            public final String invoke() {
                return this.$lintVersion;
            }
        });
        if (StringsKt.endsWith$default((String)lintVersion, (String)"-dev", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)lintVersion, (String)"SNAPSHOT", (boolean)false, (int)2, null)) {
            Provider jarsHash2 = lintClassLoaderBuildService.zip(this.getClasspath().getElements(), (BiFunction)deriveVersionKey.jarsHash.1.INSTANCE);
            Provider provider3 = versionProvider2.zip(jarsHash2, (BiFunction)deriveVersionKey.1.INSTANCE);
            provider2 = provider3;
            Intrinsics.checkNotNullExpressionValue((Object)provider3, (String)"{\n                val ja\u2026n}_$hash\" }\n            }");
        } else {
            provider2 = versionProvider2;
        }
        return provider2;
    }

    public final void submit(@NotNull WorkerExecutor workerExecutor, @NotNull String mainClass, @NotNull List<String> arguments, @NotNull LintMode lintMode) {
        Intrinsics.checkNotNullParameter((Object)workerExecutor, (String)"workerExecutor");
        Intrinsics.checkNotNullParameter((Object)mainClass, (String)"mainClass");
        Intrinsics.checkNotNullParameter(arguments, (String)"arguments");
        Intrinsics.checkNotNullParameter((Object)((Object)lintMode), (String)"lintMode");
        LintTool.submit$default(this, workerExecutor, mainClass, arguments, true, false, false, lintMode, false, null, 256, null);
    }

    public final void submit(@NotNull WorkerExecutor workerExecutor, @NotNull String mainClass, @NotNull List<String> arguments, boolean android, boolean fatalOnly, boolean await, @NotNull LintMode lintMode, boolean hasBaseline, @Nullable File returnValueOutputFile) {
        Intrinsics.checkNotNullParameter((Object)workerExecutor, (String)"workerExecutor");
        Intrinsics.checkNotNullParameter((Object)mainClass, (String)"mainClass");
        Intrinsics.checkNotNullParameter(arguments, (String)"arguments");
        Intrinsics.checkNotNullParameter((Object)((Object)lintMode), (String)"lintMode");
        Object object = this.getRunInProcess().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"runInProcess.get()");
        WorkQueue workQueue2 = (Boolean)object != false ? workerExecutor.noIsolation() : workerExecutor.processIsolation(new Action(this){
            final /* synthetic */ LintTool this$0;
            {
                this.this$0 = $receiver;
            }

            public final void execute(ProcessWorkerSpec it) {
                Object[] objectArray = new Object[]{this.this$0.getClasspath()};
                it.getClasspath().from(objectArray);
                it.getForkOptions().setMaxHeapSize(LintParallelBuildService.Companion.calculateLintHeapSize((String)this.this$0.getWorkerHeapSize().getOrNull(), Runtime.getRuntime().maxMemory()));
            }
        });
        workQueue2.submit(AndroidLintWorkAction.class, new Action(mainClass, arguments, this, android, fatalOnly, returnValueOutputFile, lintMode, hasBaseline){
            final /* synthetic */ String $mainClass;
            final /* synthetic */ List<String> $arguments;
            final /* synthetic */ LintTool this$0;
            final /* synthetic */ boolean $android;
            final /* synthetic */ boolean $fatalOnly;
            final /* synthetic */ File $returnValueOutputFile;
            final /* synthetic */ LintMode $lintMode;
            final /* synthetic */ boolean $hasBaseline;
            {
                this.$mainClass = $mainClass;
                this.$arguments = $arguments;
                this.this$0 = $receiver;
                this.$android = $android;
                this.$fatalOnly = $fatalOnly;
                this.$returnValueOutputFile = $returnValueOutputFile;
                this.$lintMode = $lintMode;
                this.$hasBaseline = $hasBaseline;
            }

            public final void execute(AndroidLintWorkAction.LintWorkActionParameters parameters) {
                parameters.getMainClass().set((Object)this.$mainClass);
                parameters.getArguments().set((Iterable)this.$arguments);
                Object[] objectArray = new Object[]{this.this$0.getClasspath()};
                parameters.getClasspath().from(objectArray);
                parameters.getVersionKey().set((Provider)this.this$0.getVersionKey());
                parameters.getAndroid().set((Object)this.$android);
                parameters.getFatalOnly().set((Object)this.$fatalOnly);
                parameters.getRunInProcess().set(this.this$0.getRunInProcess().get());
                parameters.getReturnValueOutputFile().set(this.$returnValueOutputFile);
                parameters.getLintMode().set((Object)((Object)this.$lintMode));
                parameters.getHasBaseline().set((Object)this.$hasBaseline);
            }
        });
        if (await) {
            workQueue2.await();
        }
    }

    public static /* synthetic */ void submit$default(LintTool lintTool, WorkerExecutor workerExecutor, String string, List list, boolean bl, boolean bl2, boolean bl3, LintMode lintMode, boolean bl4, File file, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: submit");
        }
        if ((n & 0x100) != 0) {
            file = null;
        }
        lintTool.submit(workerExecutor, string, list, bl, bl2, bl3, lintMode, bl4, file);
    }
}

