/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.profile;

import com.android.build.gradle.internal.LoggerWrapper;
import com.android.build.gradle.internal.profile.AnalyticsResourceManager;
import com.android.build.gradle.internal.profile.AnalyticsService;
import com.android.build.gradle.internal.services.BuildServicesKt;
import com.android.build.gradle.internal.services.ServiceRegistrationAction;
import com.android.builder.profile.Recorder;
import com.google.wireless.android.sdk.stats.GradleBuildProfile;
import com.google.wireless.android.sdk.stats.GradleBuildProfileSpan;
import com.google.wireless.android.sdk.stats.GradleBuildProject;
import com.google.wireless.android.sdk.stats.GradleBuildVariant;
import java.util.concurrent.ConcurrentHashMap;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.execution.TaskExecutionGraph;
import org.gradle.api.invocation.Gradle;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.services.BuildService;
import org.gradle.api.services.BuildServiceParameters;
import org.gradle.api.services.BuildServiceRegistry;
import org.gradle.build.event.BuildEventsListenerRegistry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0003'()B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\f\u001a\u00020\rH\u0002J \u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u001a\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u0019H\u0016J\u0010\u0010\u001d\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0016\u0010\u001e\u001a\u00020\u000f2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00190 H\u0016J*\u0010!\u001a\u00020\u000f2\u0006\u0010\"\u001a\u00020#2\u0006\u0010\u0018\u001a\u00020\u00192\b\u0010$\u001a\u0004\u0018\u00010\u00192\u0006\u0010%\u001a\u00020&H\u0016R\u0014\u0010\u0004\u001a\u00020\u00058gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lcom/android/build/gradle/internal/profile/AnalyticsConfiguratorService;", "Lorg/gradle/api/services/BuildService;", "Lcom/android/build/gradle/internal/profile/AnalyticsConfiguratorService$Params;", "()V", "objectFactory", "Lorg/gradle/api/model/ObjectFactory;", "getObjectFactory", "()Lorg/gradle/api/model/ObjectFactory;", "resourcesManager", "Lcom/android/build/gradle/internal/profile/AnalyticsResourceManager;", "state", "Lcom/android/build/gradle/internal/profile/AnalyticsConfiguratorService$State;", "configureOnDemandDisabled", "", "createAnalyticsService", "", "project", "Lorg/gradle/api/Project;", "registry", "Lorg/gradle/build/event/BuildEventsListenerRegistry;", "parameters", "Lcom/android/build/gradle/internal/profile/AnalyticsService$Params;", "getProjectBuilder", "Lcom/google/wireless/android/sdk/stats/GradleBuildProject$Builder;", "projectPath", "", "getVariantBuilder", "Lcom/google/wireless/android/sdk/stats/GradleBuildVariant$Builder;", "variantName", "instantiateAnalyticsService", "recordApplicationId", "applicationId", "Lorg/gradle/api/provider/Provider;", "recordBlock", "executionType", "Lcom/google/wireless/android/sdk/stats/GradleBuildProfileSpan$ExecutionType;", "variant", "block", "Lcom/android/builder/profile/Recorder$VoidBlock;", "Params", "RegistrationAction", "State", "gradle-core"})
public abstract class AnalyticsConfiguratorService
implements BuildService<Params> {
    @NotNull
    private final AnalyticsResourceManager resourcesManager;
    @NotNull
    private State state;

    public AnalyticsConfiguratorService() {
        GradleBuildProfile.Builder builder = GradleBuildProfile.newBuilder();
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"newBuilder()");
        this.resourcesManager = new AnalyticsResourceManager(builder, new ConcurrentHashMap(), false, null, new ConcurrentHashMap(), null, this.getObjectFactory().setProperty(String.class), null, 128, null);
        this.state = State.COLLECTING_DATA;
    }

    @Inject
    @NotNull
    public abstract ObjectFactory getObjectFactory();

    @Nullable
    public GradleBuildProject.Builder getProjectBuilder(@NotNull String projectPath) {
        Intrinsics.checkNotNullParameter((Object)projectPath, (String)"projectPath");
        if (this.state == State.ANALYTICS_SERVICE_CREATED && this.configureOnDemandDisabled()) {
            LoggerWrapper.getLogger(this.getClass()).info("GradleBuildProject.Builder should not be accessed through AnalyticsConfiguratorService after AnalyticsService is created. Analytics information of this build might be incomplete.", new Object[0]);
        }
        return this.resourcesManager.getProjectBuilder(projectPath);
    }

    @Nullable
    public GradleBuildVariant.Builder getVariantBuilder(@NotNull String projectPath, @NotNull String variantName) {
        Intrinsics.checkNotNullParameter((Object)projectPath, (String)"projectPath");
        Intrinsics.checkNotNullParameter((Object)variantName, (String)"variantName");
        if (this.state == State.ANALYTICS_SERVICE_CREATED && this.configureOnDemandDisabled()) {
            LoggerWrapper.getLogger(this.getClass()).info("GradleBuildProject.Builder should not be accessed through AnalyticsConfiguratorService after AnalyticsService is created. Analytics information of this build might be incomplete.", new Object[0]);
        }
        return this.resourcesManager.getVariantBuilder(projectPath, variantName);
    }

    private final boolean configureOnDemandDisabled() {
        return (Boolean)((Params)this.getParameters()).getConfigureOnDemand().get() == false;
    }

    public void recordBlock(@NotNull GradleBuildProfileSpan.ExecutionType executionType, @NotNull String projectPath, @Nullable String variant, @NotNull Recorder.VoidBlock block2) {
        Intrinsics.checkNotNullParameter((Object)executionType, (String)"executionType");
        Intrinsics.checkNotNullParameter((Object)projectPath, (String)"projectPath");
        Intrinsics.checkNotNullParameter((Object)block2, (String)"block");
        this.resourcesManager.recordBlockAtConfiguration(executionType, projectPath, variant, block2);
    }

    public void recordApplicationId(@NotNull Provider<String> applicationId2) {
        Intrinsics.checkNotNullParameter(applicationId2, (String)"applicationId");
        this.resourcesManager.recordApplicationId(applicationId2);
    }

    public void createAnalyticsService(@NotNull Project project, @NotNull BuildEventsListenerRegistry registry, @NotNull AnalyticsService.Params parameters) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)registry, (String)"registry");
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        if (this.state == State.CALLBACK_REGISTERED) {
            return;
        }
        this.state = State.CALLBACK_REGISTERED;
        if (project.getGradle().getStartParameter().getTaskNames().isEmpty()) {
            project.getGradle().projectsEvaluated(new Action(this, project, parameters){
                final /* synthetic */ AnalyticsConfiguratorService this$0;
                final /* synthetic */ Project $project;
                final /* synthetic */ AnalyticsService.Params $parameters;
                {
                    this.this$0 = $receiver;
                    this.$project = $project;
                    this.$parameters = $parameters;
                }

                public final void execute(Gradle it) {
                    AnalyticsConfiguratorService.access$getResourcesManager$p(this.this$0).recordGlobalProperties(this.$project);
                    AnalyticsConfiguratorService.access$getResourcesManager$p(this.this$0).configureAnalyticsService(this.$parameters);
                    AnalyticsConfiguratorService.access$instantiateAnalyticsService(this.this$0, this.$project);
                }
            });
        } else {
            project.getGradle().getTaskGraph().whenReady(new Action(this, project, parameters, registry){
                final /* synthetic */ AnalyticsConfiguratorService this$0;
                final /* synthetic */ Project $project;
                final /* synthetic */ AnalyticsService.Params $parameters;
                final /* synthetic */ BuildEventsListenerRegistry $registry;
                {
                    this.this$0 = $receiver;
                    this.$project = $project;
                    this.$parameters = $parameters;
                    this.$registry = $registry;
                }

                public final void execute(TaskExecutionGraph it) {
                    AnalyticsConfiguratorService.access$getResourcesManager$p(this.this$0).recordGlobalProperties(this.$project);
                    AnalyticsResourceManager analyticsResourceManager = AnalyticsConfiguratorService.access$getResourcesManager$p(this.this$0);
                    Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                    analyticsResourceManager.collectTaskMetadata(it);
                    AnalyticsConfiguratorService.access$getResourcesManager$p(this.this$0).recordTaskNames(it);
                    AnalyticsConfiguratorService.access$getResourcesManager$p(this.this$0).configureAnalyticsService(this.$parameters);
                    AnalyticsConfiguratorService.access$instantiateAnalyticsService(this.this$0, this.$project);
                    BuildServiceRegistry buildServiceRegistry = this.$project.getGradle().getSharedServices();
                    Intrinsics.checkNotNullExpressionValue((Object)buildServiceRegistry, (String)"project.gradle.sharedServices");
                    this.$registry.onTaskCompletion(BuildServicesKt.getBuildService(buildServiceRegistry, AnalyticsService.class));
                }
            });
        }
    }

    private final void instantiateAnalyticsService(Project project) {
        if (this.state == State.ANALYTICS_SERVICE_CREATED) {
            return;
        }
        BuildServiceRegistry buildServiceRegistry = project.getGradle().getSharedServices();
        Intrinsics.checkNotNullExpressionValue((Object)buildServiceRegistry, (String)"project.gradle.sharedServices");
        Provider<AnalyticsService> analyticsService = BuildServicesKt.getBuildService(buildServiceRegistry, AnalyticsService.class);
        ((AnalyticsService)analyticsService.get()).setInitialMemorySampleForConfiguration(this.resourcesManager.getInitialMemorySample());
        ((AnalyticsService)analyticsService.get()).setConfigurationSpans(this.resourcesManager.getConfigurationSpans());
        this.state = State.ANALYTICS_SERVICE_CREATED;
    }

    public static final /* synthetic */ AnalyticsResourceManager access$getResourcesManager$p(AnalyticsConfiguratorService $this) {
        return $this.resourcesManager;
    }

    public static final /* synthetic */ void access$instantiateAnalyticsService(AnalyticsConfiguratorService $this, Project project) {
        $this.instantiateAnalyticsService(project);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\bf\u0018\u00002\u00020\u0001R\u0018\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007\u00c0\u0006\u0003"}, d2={"Lcom/android/build/gradle/internal/profile/AnalyticsConfiguratorService$Params;", "Lorg/gradle/api/services/BuildServiceParameters;", "configureOnDemand", "Lorg/gradle/api/provider/Property;", "", "getConfigureOnDemand", "()Lorg/gradle/api/provider/Property;", "gradle-core"})
    public static interface Params
    extends BuildServiceParameters {
        @NotNull
        public Property<Boolean> getConfigureOnDemand();
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0003H\u0016\u00a8\u0006\n"}, d2={"Lcom/android/build/gradle/internal/profile/AnalyticsConfiguratorService$RegistrationAction;", "Lcom/android/build/gradle/internal/services/ServiceRegistrationAction;", "Lcom/android/build/gradle/internal/profile/AnalyticsConfiguratorService;", "Lcom/android/build/gradle/internal/profile/AnalyticsConfiguratorService$Params;", "project", "Lorg/gradle/api/Project;", "(Lorg/gradle/api/Project;)V", "configure", "", "parameters", "gradle-core"})
    public static final class RegistrationAction
    extends ServiceRegistrationAction<AnalyticsConfiguratorService, Params> {
        public RegistrationAction(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            super(project, AnalyticsConfiguratorService.class, null, null, 12, null);
        }

        @Override
        public void configure(@NotNull Params parameters) {
            Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
            parameters.getConfigureOnDemand().set((Object)this.getProject().getGradle().getStartParameter().isConfigureOnDemand());
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/android/build/gradle/internal/profile/AnalyticsConfiguratorService$State;", "", "(Ljava/lang/String;I)V", "COLLECTING_DATA", "CALLBACK_REGISTERED", "ANALYTICS_SERVICE_CREATED", "gradle-core"})
    private static final class State
    extends Enum<State> {
        public static final /* enum */ State COLLECTING_DATA = new State();
        public static final /* enum */ State CALLBACK_REGISTERED = new State();
        public static final /* enum */ State ANALYTICS_SERVICE_CREATED = new State();
        private static final /* synthetic */ State[] $VALUES;

        public static State[] values() {
            return (State[])$VALUES.clone();
        }

        public static State valueOf(String value) {
            return Enum.valueOf(State.class, value);
        }

        static {
            $VALUES = stateArray = new State[]{State.COLLECTING_DATA, State.CALLBACK_REGISTERED, State.ANALYTICS_SERVICE_CREATED};
        }
    }
}

