/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.api.artifact.impl.ArtifactsImpl;
import com.android.build.gradle.internal.component.ComponentCreationConfig;
import com.android.build.gradle.internal.component.VariantCreationConfig;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.tasks.AssetPackPreBundleTask;
import com.android.build.gradle.internal.tasks.AssetPackPreBundleTaskRunnable;
import com.android.build.gradle.internal.tasks.BuildAnalyzer;
import com.android.build.gradle.internal.tasks.NonIncrementalTask;
import com.android.build.gradle.internal.tasks.VariantAwareTask;
import com.android.build.gradle.internal.tasks.VariantAwareTaskKt;
import com.android.build.gradle.internal.tasks.factory.TaskCreationAction;
import com.android.build.gradle.internal.tasks.factory.VariantTaskCreationAction;
import com.android.buildanalyzer.common.TaskCategory;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.Action;
import org.gradle.api.Task;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileCollection;
import org.gradle.api.provider.Property;
import org.gradle.api.services.BuildServiceRegistry;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.work.DisableCachingByDefault;
import org.jetbrains.annotations.NotNull;

@DisableCachingByDefault
@BuildAnalyzer(primaryTaskCategory=TaskCategory.BUNDLE_PACKAGING)
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\b'\u0018\u00002\u00020\u0001:\u0002\u000f\u0010B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\r\u001a\u00020\u000eH\u0014R\u0014\u0010\u0003\u001a\u00020\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\b8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\b8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\n\u00a8\u0006\u0011"}, d2={"Lcom/android/build/gradle/internal/tasks/AssetPackPreBundleTask;", "Lcom/android/build/gradle/internal/tasks/NonIncrementalTask;", "()V", "assetsFiles", "Lorg/gradle/api/file/ConfigurableFileCollection;", "getAssetsFiles", "()Lorg/gradle/api/file/ConfigurableFileCollection;", "manifestFiles", "Lorg/gradle/api/file/DirectoryProperty;", "getManifestFiles", "()Lorg/gradle/api/file/DirectoryProperty;", "outputDir", "getOutputDir", "doTaskAction", "", "CreationAction", "CreationForAssetPackBundleAction", "gradle-core"})
public abstract class AssetPackPreBundleTask
extends NonIncrementalTask {
    @OutputDirectory
    @NotNull
    public abstract DirectoryProperty getOutputDir();

    @InputFiles
    @PathSensitive(value=PathSensitivity.NAME_ONLY)
    @NotNull
    public abstract DirectoryProperty getManifestFiles();

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @NotNull
    public abstract ConfigurableFileCollection getAssetsFiles();

    @Override
    protected void doTaskAction() {
        for (Object e : this.getManifestFiles().getAsFileTree().getFiles()) {
            Intrinsics.checkNotNullExpressionValue(e, (String)"manifestFiles.asFileTree.files");
            File manifestFile2 = (File)e;
            String assetPackName = manifestFile2.getParentFile().getName();
            Directory packDir = (Directory)this.getOutputDir().dir(assetPackName).get();
            this.getWorkerExecutor().noIsolation().submit(AssetPackPreBundleTaskRunnable.class, new Action(this, packDir, assetPackName, manifestFile2){
                final /* synthetic */ AssetPackPreBundleTask this$0;
                final /* synthetic */ Directory $packDir;
                final /* synthetic */ String $assetPackName;
                final /* synthetic */ File $manifestFile;
                {
                    this.this$0 = $receiver;
                    this.$packDir = $packDir;
                    this.$assetPackName = $assetPackName;
                    this.$manifestFile = $manifestFile;
                }

                public final void execute(AssetPackPreBundleTaskRunnable.Params it) {
                    it.initializeFromAndroidVariantTask(this.this$0);
                    it.getPackDir().set((Object)this.$packDir);
                    it.getPackFile().set((Object)this.$packDir.file(this.$assetPackName + ".zip"));
                    it.getAssetsFilesPath().set((Object)this.this$0.getAssetsFiles().filter(new Spec(this.$assetPackName){
                        final /* synthetic */ String $assetPackName;
                        {
                            this.$assetPackName = $assetPackName;
                        }

                        public final boolean isSatisfiedBy(File assetPack) {
                            String string = assetPack.getAbsolutePath();
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"assetPack.absolutePath");
                            return StringsKt.contains$default((CharSequence)string, (CharSequence)(this.$assetPackName + File.separator + "src" + File.separator + "main" + File.separator + "assets"), (boolean)false, (int)2, null);
                        }
                    }).getAsPath());
                    it.getManifestFile().set(this.$manifestFile);
                }
            });
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0015\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0002H\u0016J\u0016\u0010\u0013\u001a\u00020\u00112\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00020\u0015H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0016"}, d2={"Lcom/android/build/gradle/internal/tasks/AssetPackPreBundleTask$CreationAction;", "Lcom/android/build/gradle/internal/tasks/factory/VariantTaskCreationAction;", "Lcom/android/build/gradle/internal/tasks/AssetPackPreBundleTask;", "Lcom/android/build/gradle/internal/component/VariantCreationConfig;", "creationConfig", "assetFileCollection", "Lorg/gradle/api/file/FileCollection;", "(Lcom/android/build/gradle/internal/component/VariantCreationConfig;Lorg/gradle/api/file/FileCollection;)V", "name", "", "getName", "()Ljava/lang/String;", "type", "Ljava/lang/Class;", "getType", "()Ljava/lang/Class;", "configure", "", "task", "handleProvider", "taskProvider", "Lorg/gradle/api/tasks/TaskProvider;", "gradle-core"})
    public static final class CreationAction
    extends VariantTaskCreationAction<AssetPackPreBundleTask, VariantCreationConfig> {
        @NotNull
        private final FileCollection assetFileCollection;
        @NotNull
        private final Class<AssetPackPreBundleTask> type;
        @NotNull
        private final String name;

        public CreationAction(@NotNull VariantCreationConfig creationConfig, @NotNull FileCollection assetFileCollection) {
            Intrinsics.checkNotNullParameter((Object)creationConfig, (String)"creationConfig");
            Intrinsics.checkNotNullParameter((Object)assetFileCollection, (String)"assetFileCollection");
            super((ComponentCreationConfig)creationConfig);
            this.assetFileCollection = assetFileCollection;
            this.type = AssetPackPreBundleTask.class;
            this.name = this.computeTaskName("assetPack", "PreBundleTask");
        }

        @Override
        @NotNull
        public Class<AssetPackPreBundleTask> getType() {
            return this.type;
        }

        @Override
        @NotNull
        public String getName() {
            return this.name;
        }

        @Override
        public void handleProvider(@NotNull TaskProvider<AssetPackPreBundleTask> taskProvider) {
            Intrinsics.checkNotNullParameter(taskProvider, (String)"taskProvider");
            super.handleProvider(taskProvider);
            ((VariantCreationConfig)this.creationConfig).getArtifacts().setInitialProvider(taskProvider, (Function1)handleProvider.1.INSTANCE).on(InternalArtifactType.ASSET_PACK_BUNDLE.INSTANCE);
        }

        @Override
        public void configure(@NotNull AssetPackPreBundleTask task) {
            Intrinsics.checkNotNullParameter((Object)task, (String)"task");
            super.configure((Task)task);
            ((VariantCreationConfig)this.creationConfig).getArtifacts().setTaskInputToFinalProduct(InternalArtifactType.LINKED_RES_FOR_ASSET_PACK.INSTANCE, (Property)task.getManifestFiles());
            Object[] objectArray = new Object[]{this.assetFileCollection};
            task.getAssetsFiles().from(objectArray);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0002H\u0016J\u0016\u0010\u0013\u001a\u00020\u00112\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00020\u0015H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\tX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0016"}, d2={"Lcom/android/build/gradle/internal/tasks/AssetPackPreBundleTask$CreationForAssetPackBundleAction;", "Lcom/android/build/gradle/internal/tasks/factory/TaskCreationAction;", "Lcom/android/build/gradle/internal/tasks/AssetPackPreBundleTask;", "artifacts", "Lcom/android/build/api/artifact/impl/ArtifactsImpl;", "assetFileCollection", "Lorg/gradle/api/file/FileCollection;", "(Lcom/android/build/api/artifact/impl/ArtifactsImpl;Lorg/gradle/api/file/FileCollection;)V", "name", "", "getName", "()Ljava/lang/String;", "type", "Ljava/lang/Class;", "getType", "()Ljava/lang/Class;", "configure", "", "task", "handleProvider", "taskProvider", "Lorg/gradle/api/tasks/TaskProvider;", "gradle-core"})
    public static final class CreationForAssetPackBundleAction
    extends TaskCreationAction<AssetPackPreBundleTask> {
        @NotNull
        private final ArtifactsImpl artifacts;
        @NotNull
        private final FileCollection assetFileCollection;
        @NotNull
        private final Class<AssetPackPreBundleTask> type;
        @NotNull
        private final String name;

        public CreationForAssetPackBundleAction(@NotNull ArtifactsImpl artifacts2, @NotNull FileCollection assetFileCollection) {
            Intrinsics.checkNotNullParameter((Object)artifacts2, (String)"artifacts");
            Intrinsics.checkNotNullParameter((Object)assetFileCollection, (String)"assetFileCollection");
            this.artifacts = artifacts2;
            this.assetFileCollection = assetFileCollection;
            this.type = AssetPackPreBundleTask.class;
            this.name = "assetPackPreBundleTask";
        }

        @Override
        @NotNull
        public Class<AssetPackPreBundleTask> getType() {
            return this.type;
        }

        @Override
        @NotNull
        public String getName() {
            return this.name;
        }

        @Override
        public void handleProvider(@NotNull TaskProvider<AssetPackPreBundleTask> taskProvider) {
            Intrinsics.checkNotNullParameter(taskProvider, (String)"taskProvider");
            super.handleProvider(taskProvider);
            this.artifacts.setInitialProvider(taskProvider, (Function1)handleProvider.1.INSTANCE).on(InternalArtifactType.ASSET_PACK_BUNDLE.INSTANCE);
        }

        @Override
        public void configure(@NotNull AssetPackPreBundleTask task) {
            Intrinsics.checkNotNullParameter((Object)task, (String)"task");
            VariantAwareTask variantAwareTask = task;
            BuildServiceRegistry buildServiceRegistry = task.getProject().getGradle().getSharedServices();
            Intrinsics.checkNotNullExpressionValue((Object)buildServiceRegistry, (String)"task.project.gradle.sharedServices");
            VariantAwareTaskKt.configureVariantProperties(variantAwareTask, "", buildServiceRegistry);
            this.artifacts.setTaskInputToFinalProduct(InternalArtifactType.LINKED_RES_FOR_ASSET_PACK.INSTANCE, (Property)task.getManifestFiles());
            Object[] objectArray = new Object[]{this.assetFileCollection};
            task.getAssetsFiles().from(objectArray);
        }
    }
}

