/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks;

import com.android.build.gradle.tasks.JdkImageInput;
import java.io.File;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Transformer;
import org.gradle.api.file.FileCollection;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Classpath;
import org.gradle.process.CommandLineArgumentProvider;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\f\u001a\u0010\u0012\f\u0012\n \u000f*\u0004\u0018\u00010\u000e0\u000e0\rH\u0016R\u0019\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068G\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068G\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\t\u00a8\u0006\u0010"}, d2={"Lcom/android/build/gradle/tasks/JdkImageInput;", "Lorg/gradle/process/CommandLineArgumentProvider;", "jdkImage", "Lorg/gradle/api/file/FileCollection;", "(Lorg/gradle/api/file/FileCollection;)V", "generatedModuleFile", "Lorg/gradle/api/provider/Provider;", "Ljava/io/File;", "getGeneratedModuleFile", "()Lorg/gradle/api/provider/Provider;", "jrtFsJar", "getJrtFsJar", "asArguments", "", "", "kotlin.jvm.PlatformType", "gradle-core"})
public final class JdkImageInput
implements CommandLineArgumentProvider {
    @NotNull
    private final FileCollection jdkImage;
    @NotNull
    private final Provider<File> generatedModuleFile;
    @NotNull
    private final Provider<File> jrtFsJar;

    public JdkImageInput(@NotNull FileCollection jdkImage) {
        Intrinsics.checkNotNullParameter((Object)jdkImage, (String)"jdkImage");
        this.jdkImage = jdkImage;
        Provider provider2 = this.jdkImage.getElements().map((Transformer)generatedModuleFile.1.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)provider2, (String)"jdkImage.elements.map { \u2026.resolve(\"lib/modules\") }");
        this.generatedModuleFile = provider2;
        Provider provider3 = this.jdkImage.getElements().map((Transformer)jrtFsJar.1.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)provider3, (String)"jdkImage.elements.map { \u2026olve(\"lib/$JRT_FS_JAR\") }");
        this.jrtFsJar = provider3;
    }

    @Classpath
    @NotNull
    public final Provider<File> getGeneratedModuleFile() {
        return this.generatedModuleFile;
    }

    @Classpath
    @NotNull
    public final Provider<File> getJrtFsJar() {
        return this.jrtFsJar;
    }

    @NotNull
    public List<String> asArguments() {
        Object[] objectArray = new String[2];
        objectArray[0] = "--system";
        File file = this.jdkImage.getSingleFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"jdkImage.singleFile");
        objectArray[1] = FilesKt.resolve((File)file, (String)"jdkImage").getAbsolutePath();
        return CollectionsKt.listOf((Object[])objectArray);
    }
}

