/*
 * Copyright (C) 2021 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.android.build.gradle.tasks.sync

import com.android.build.gradle.internal.tasks.BuildAnalyzer
import com.android.buildanalyzer.common.TaskCategory
import com.android.ide.common.build.filebasedproperties.variant.ArtifactOutputProperties
import org.gradle.api.provider.MapProperty
import org.gradle.api.tasks.Input
import org.gradle.work.DisableCachingByDefault

@DisableCachingByDefault
@BuildAnalyzer(primaryTaskCategory = TaskCategory.SYNC)
abstract class ModuleVariantModelTask: AbstractVariantModelTask() {

    @get:Input
    abstract val manifestPlaceholders: MapProperty<String, String>

    protected fun addVariantContent(artifactProperties: ArtifactOutputProperties.Builder) {
        artifactProperties.putAllManifestPlaceholders(manifestPlaceholders.get())
    }
}
