/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.dependency;

import com.android.build.gradle.internal.dependency.AndroidXDependencyCheck;
import com.android.build.gradle.internal.dependency.AndroidXDependencyCheckKt;
import com.android.build.gradle.internal.utils.ComponentPath;
import com.android.build.gradle.internal.utils.ResolutionResultUtils;
import com.android.build.gradle.options.BooleanOption;
import com.android.builder.errors.IssueReporter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.artifacts.ResolvableDependencies;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.artifacts.result.ResolutionResult;
import org.gradle.api.artifacts.result.ResolvedComponentResult;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0007B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0003\u001a\u00020\u0004*\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0004H\u0002\u00a8\u0006\b"}, d2={"Lcom/android/build/gradle/internal/dependency/AndroidXDependencyCheck;", "", "()V", "getConfigurationDisplayPath", "", "Lorg/gradle/api/Project;", "configurationName", "AndroidXDisabledJetifierDisabled", "gradle-core"})
public final class AndroidXDependencyCheck {
    @NotNull
    public static final AndroidXDependencyCheck INSTANCE = new AndroidXDependencyCheck();

    private AndroidXDependencyCheck() {
    }

    private final String getConfigurationDisplayPath(Project $this$getConfigurationDisplayPath, String configurationName) {
        return Intrinsics.areEqual((Object)$this$getConfigurationDisplayPath.getProject().getPath(), (Object)":") ? ":" + configurationName : $this$getConfigurationDisplayPath.getProject().getPath() + ":" + configurationName;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0002H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/android/build/gradle/internal/dependency/AndroidXDependencyCheck$AndroidXDisabledJetifierDisabled;", "Lorg/gradle/api/Action;", "Lorg/gradle/api/artifacts/ResolvableDependencies;", "project", "Lorg/gradle/api/Project;", "configurationName", "", "issueReporter", "Lcom/android/builder/errors/IssueReporter;", "(Lorg/gradle/api/Project;Ljava/lang/String;Lcom/android/builder/errors/IssueReporter;)V", "execute", "", "resolvableDependencies", "gradle-core"})
    @SourceDebugExtension(value={"SMAP\nAndroidXDependencyCheck.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AndroidXDependencyCheck.kt\ncom/android/build/gradle/internal/dependency/AndroidXDependencyCheck$AndroidXDisabledJetifierDisabled\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,92:1\n1549#2:93\n1620#2,3:94\n819#2:97\n847#2,2:98\n*S KotlinDebug\n*F\n+ 1 AndroidXDependencyCheck.kt\ncom/android/build/gradle/internal/dependency/AndroidXDependencyCheck$AndroidXDisabledJetifierDisabled\n*L\n57#1:93\n57#1:94,3\n59#1:97\n59#1:98,2\n*E\n"})
    public static final class AndroidXDisabledJetifierDisabled
    implements Action<ResolvableDependencies> {
        @NotNull
        private final Project project;
        @NotNull
        private final String configurationName;
        @NotNull
        private final IssueReporter issueReporter;

        public AndroidXDisabledJetifierDisabled(@NotNull Project project, @NotNull String configurationName, @NotNull IssueReporter issueReporter2) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)configurationName, (String)"configurationName");
            Intrinsics.checkNotNullParameter((Object)issueReporter2, (String)"issueReporter");
            this.project = project;
            this.configurationName = configurationName;
            this.issueReporter = issueReporter2;
        }

        /*
         * WARNING - void declaration
         */
        public void execute(@NotNull ResolvableDependencies resolvableDependencies) {
            void $this$filterNotTo$iv$iv;
            void $this$filterNot$iv;
            String it;
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)resolvableDependencies, (String)"resolvableDependencies");
            if (this.project.getExtensions().getExtraProperties().has(AndroidXDependencyCheckKt.access$getIssueReported$p())) {
                return;
            }
            ResolutionResult result2 = resolvableDependencies.getResolutionResult();
            Intrinsics.checkNotNullExpressionValue((Object)result2, (String)"result");
            List<ResolvedComponentResult> androidXDependencies2 = ResolutionResultUtils.getModuleComponents(result2, (Function1<? super ModuleComponentIdentifier, Boolean>)((Function1)execute.androidXDependencies.1.INSTANCE));
            String configurationDisplayPath = INSTANCE.getConfigurationDisplayPath(this.project, this.configurationName);
            Iterable $this$map$iv = androidXDependencies2;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                ResolvedComponentResult resolvedComponentResult = (ResolvedComponentResult)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(ComponentPath.getPathString$default(ResolutionResultUtils.getPathToComponent(result2, (ResolvedComponentResult)it), configurationDisplayPath, null, 2, null));
            }
            $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$filterNot = false;
            $this$mapTo$iv$iv = $this$filterNot$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterNotTo = false;
            for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
                it = (String)element$iv$iv;
                boolean bl = false;
                if (StringsKt.contains$default((CharSequence)it, (CharSequence)"androidx.databinding:databinding-compiler:", (boolean)false, (int)2, null)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List pathsToAndroidXDependencies = (List)destination$iv$iv;
            if (!((Collection)pathsToAndroidXDependencies).isEmpty()) {
                this.project.getExtensions().getExtraProperties().set(AndroidXDependencyCheckKt.access$getIssueReported$p(), (Object)true);
                String message2 = "Configuration `" + configurationDisplayPath + "` contains AndroidX dependencies, but the `" + BooleanOption.USE_ANDROID_X.getPropertyName() + "` property is not enabled, which may cause runtime issues.\nSet `" + BooleanOption.USE_ANDROID_X.getPropertyName() + "=true` in the `gradle.properties` file and retry.\nThe following AndroidX dependencies are detected:\n" + CollectionsKt.joinToString$default((Iterable)pathsToAndroidXDependencies, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
                IssueReporter.reportError$default((IssueReporter)this.issueReporter, (IssueReporter.Type)IssueReporter.Type.ANDROID_X_PROPERTY_NOT_ENABLED, (String)message2, (String)CollectionsKt.joinToString$default((Iterable)pathsToAndroidXDependencies, (CharSequence)",", null, null, (int)0, null, null, (int)62, null), null, (int)8, null);
            }
        }
    }
}

