/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.ide.dependencies;

import com.android.build.gradle.internal.ide.dependencies.BuildIdentifierMethods;
import com.android.build.gradle.internal.ide.dependencies.LibraryUtils;
import com.android.build.gradle.internal.ide.dependencies.MavenCoordinatesCacheBuildService;
import com.android.builder.dependency.MavenCoordinatesImpl;
import com.android.builder.internal.StringCachingService;
import com.android.builder.model.MavenCoordinates;
import java.io.File;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.artifacts.result.ResolvedArtifactResult;
import org.gradle.api.artifacts.result.ResolvedVariantResult;
import org.gradle.internal.component.local.model.OpaqueComponentArtifactIdentifier;
import org.gradle.internal.component.local.model.OpaqueComponentIdentifier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0019\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u00002\u00020\u0001:\u00018B=\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fBW\b\u0000\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0013\u001a\u00020\u000b\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\u0014J\t\u0010\"\u001a\u00020\u000eH\u00c6\u0003J\t\u0010#\u001a\u00020\u0010H\u00c6\u0003J\u000b\u0010$\u001a\u0004\u0018\u00010\u0012H\u00c6\u0003J\u000b\u0010%\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\t\u0010&\u001a\u00020\u000bH\u00c6\u0003J\u000b\u0010'\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u000b\u0010(\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\t\u0010)\u001a\u00020\tH\u00c6\u0003J\t\u0010*\u001a\u00020\u000bH\u00c6\u0003J\u000e\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.J\u000e\u0010/\u001a\u00020\u00122\u0006\u00100\u001a\u000201Jk\u00102\u001a\u00020\u00002\b\b\u0002\u0010\r\u001a\u00020\u000e2\b\b\u0002\u0010\u000f\u001a\u00020\u00102\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u00122\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\b\u0002\u0010\u0013\u001a\u00020\u000b2\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u00052\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u000bH\u00c6\u0001J\u0013\u00103\u001a\u00020\u000b2\b\u00104\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u00105\u001a\u000206H\u00d6\u0001J\t\u00107\u001a\u00020\u0012H\u00d6\u0001R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0016R\u0011\u0010\u0013\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u001cR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u001cR\u0013\u0010\u0007\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u0016R\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0013\u0010\u0011\u001a\u0004\u0018\u00010\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!\u00a8\u00069"}, d2={"Lcom/android/build/gradle/internal/ide/dependencies/ResolvedArtifact;", "", "mainArtifactResult", "Lorg/gradle/api/artifacts/result/ResolvedArtifactResult;", "artifactFile", "Ljava/io/File;", "extractedFolder", "publishedLintJar", "dependencyType", "Lcom/android/build/gradle/internal/ide/dependencies/ResolvedArtifact$DependencyType;", "isWrappedModule", "", "(Lorg/gradle/api/artifacts/result/ResolvedArtifactResult;Ljava/io/File;Ljava/io/File;Ljava/io/File;Lcom/android/build/gradle/internal/ide/dependencies/ResolvedArtifact$DependencyType;Z)V", "componentIdentifier", "Lorg/gradle/api/artifacts/component/ComponentIdentifier;", "variant", "Lorg/gradle/api/artifacts/result/ResolvedVariantResult;", "variantName", "", "isTestFixturesArtifact", "(Lorg/gradle/api/artifacts/component/ComponentIdentifier;Lorg/gradle/api/artifacts/result/ResolvedVariantResult;Ljava/lang/String;Ljava/io/File;ZLjava/io/File;Ljava/io/File;Lcom/android/build/gradle/internal/ide/dependencies/ResolvedArtifact$DependencyType;Z)V", "getArtifactFile", "()Ljava/io/File;", "getComponentIdentifier", "()Lorg/gradle/api/artifacts/component/ComponentIdentifier;", "getDependencyType", "()Lcom/android/build/gradle/internal/ide/dependencies/ResolvedArtifact$DependencyType;", "getExtractedFolder", "()Z", "getPublishedLintJar", "getVariant", "()Lorg/gradle/api/artifacts/result/ResolvedVariantResult;", "getVariantName", "()Ljava/lang/String;", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "computeMavenCoordinates", "Lcom/android/builder/model/MavenCoordinates;", "stringCachingService", "Lcom/android/builder/internal/StringCachingService;", "computeModelAddress", "mavenCoordinatesCache", "Lcom/android/build/gradle/internal/ide/dependencies/MavenCoordinatesCacheBuildService;", "copy", "equals", "other", "hashCode", "", "toString", "DependencyType", "gradle-core"})
@SourceDebugExtension(value={"SMAP\nResolvedArtifact.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ResolvedArtifact.kt\ncom/android/build/gradle/internal/ide/dependencies/ResolvedArtifact\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,188:1\n1#2:189\n*E\n"})
public final class ResolvedArtifact {
    @NotNull
    private final ComponentIdentifier componentIdentifier;
    @NotNull
    private final ResolvedVariantResult variant;
    @Nullable
    private final String variantName;
    @Nullable
    private final File artifactFile;
    private final boolean isTestFixturesArtifact;
    @Nullable
    private final File extractedFolder;
    @Nullable
    private final File publishedLintJar;
    @NotNull
    private final DependencyType dependencyType;
    private final boolean isWrappedModule;

    public ResolvedArtifact(@NotNull ComponentIdentifier componentIdentifier, @NotNull ResolvedVariantResult variant, @Nullable String variantName, @Nullable File artifactFile, boolean isTestFixturesArtifact, @Nullable File extractedFolder, @Nullable File publishedLintJar, @NotNull DependencyType dependencyType, boolean isWrappedModule) {
        Intrinsics.checkNotNullParameter((Object)componentIdentifier, (String)"componentIdentifier");
        Intrinsics.checkNotNullParameter((Object)variant, (String)"variant");
        Intrinsics.checkNotNullParameter((Object)((Object)dependencyType), (String)"dependencyType");
        this.componentIdentifier = componentIdentifier;
        this.variant = variant;
        this.variantName = variantName;
        this.artifactFile = artifactFile;
        this.isTestFixturesArtifact = isTestFixturesArtifact;
        this.extractedFolder = extractedFolder;
        this.publishedLintJar = publishedLintJar;
        this.dependencyType = dependencyType;
        this.isWrappedModule = isWrappedModule;
    }

    @NotNull
    public final ComponentIdentifier getComponentIdentifier() {
        return this.componentIdentifier;
    }

    @NotNull
    public final ResolvedVariantResult getVariant() {
        return this.variant;
    }

    @Nullable
    public final String getVariantName() {
        return this.variantName;
    }

    @Nullable
    public final File getArtifactFile() {
        return this.artifactFile;
    }

    public final boolean isTestFixturesArtifact() {
        return this.isTestFixturesArtifact;
    }

    @Nullable
    public final File getExtractedFolder() {
        return this.extractedFolder;
    }

    @Nullable
    public final File getPublishedLintJar() {
        return this.publishedLintJar;
    }

    @NotNull
    public final DependencyType getDependencyType() {
        return this.dependencyType;
    }

    public final boolean isWrappedModule() {
        return this.isWrappedModule;
    }

    public ResolvedArtifact(@NotNull ResolvedArtifactResult mainArtifactResult, @Nullable File artifactFile, @Nullable File extractedFolder, @Nullable File publishedLintJar, @NotNull DependencyType dependencyType, boolean isWrappedModule) {
        Intrinsics.checkNotNullParameter((Object)mainArtifactResult, (String)"mainArtifactResult");
        Intrinsics.checkNotNullParameter((Object)((Object)dependencyType), (String)"dependencyType");
        ComponentIdentifier componentIdentifier = mainArtifactResult.getId().getComponentIdentifier();
        Intrinsics.checkNotNullExpressionValue((Object)componentIdentifier, (String)"mainArtifactResult.id.componentIdentifier");
        ResolvedVariantResult resolvedVariantResult = mainArtifactResult.getVariant();
        Intrinsics.checkNotNullExpressionValue((Object)resolvedVariantResult, (String)"mainArtifactResult.variant");
        this(componentIdentifier, resolvedVariantResult, LibraryUtils.getVariantName(mainArtifactResult), artifactFile, LibraryUtils.hasProjectTestFixturesCapability(mainArtifactResult) || LibraryUtils.hasLibraryTestFixturesCapability(mainArtifactResult), extractedFolder, publishedLintJar, dependencyType, isWrappedModule);
    }

    @NotNull
    public final MavenCoordinates computeMavenCoordinates(@NotNull StringCachingService stringCachingService) {
        MavenCoordinates mavenCoordinates;
        Intrinsics.checkNotNullParameter((Object)stringCachingService, (String)"stringCachingService");
        ComponentIdentifier componentIdentifier = this.componentIdentifier;
        if (componentIdentifier instanceof ModuleComponentIdentifier) {
            String pattern;
            Pattern p;
            Matcher m;
            String module = ((ModuleComponentIdentifier)this.componentIdentifier).getModule();
            String version = ((ModuleComponentIdentifier)this.componentIdentifier).getVersion();
            String extension2 = this.dependencyType.getExtension();
            String classifier = null;
            File file = this.artifactFile;
            Intrinsics.checkNotNull((Object)file);
            if (!file.isDirectory() && (m = (p = Pattern.compile(pattern = "^" + module + "-" + version + "-(.+)\\." + extension2 + "$")).matcher(this.artifactFile.getName())).matches()) {
                classifier = m.group(1);
            }
            String string = ((ModuleComponentIdentifier)this.componentIdentifier).getGroup();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"componentIdentifier.group");
            Intrinsics.checkNotNullExpressionValue((Object)module, (String)"module");
            Intrinsics.checkNotNullExpressionValue((Object)version, (String)"version");
            mavenCoordinates = (MavenCoordinates)MavenCoordinatesImpl.Companion.create(stringCachingService, string, module, version, extension2, classifier);
        } else if (componentIdentifier instanceof ProjectComponentIdentifier) {
            mavenCoordinates = (MavenCoordinates)MavenCoordinatesImpl.Companion.create$default((MavenCoordinatesImpl.Companion)MavenCoordinatesImpl.Companion, (StringCachingService)stringCachingService, (String)"artifacts", (String)BuildIdentifierMethods.getIdString((ProjectComponentIdentifier)this.componentIdentifier), (String)"unspecified", null, null, (int)48, null);
        } else if (componentIdentifier instanceof OpaqueComponentArtifactIdentifier ? true : componentIdentifier instanceof OpaqueComponentIdentifier) {
            File file = this.artifactFile;
            Intrinsics.checkNotNull((Object)file);
            mavenCoordinates = (MavenCoordinates)MavenCoordinatesCacheBuildService.Companion.getMavenCoordForLocalFile(file, stringCachingService);
        } else {
            throw new RuntimeException("Don't know how to compute maven coordinate for artifact '" + this.componentIdentifier.getDisplayName() + "' with component identifier of type '" + this.componentIdentifier.getClass() + "'.");
        }
        return mavenCoordinates;
    }

    @NotNull
    public final String computeModelAddress(@NotNull MavenCoordinatesCacheBuildService mavenCoordinatesCache) {
        String string;
        Intrinsics.checkNotNullParameter((Object)mavenCoordinatesCache, (String)"mavenCoordinatesCache");
        ComponentIdentifier componentIdentifier = this.componentIdentifier;
        if (componentIdentifier instanceof ProjectComponentIdentifier) {
            StringBuilder stringBuilder;
            StringBuilder sb = stringBuilder = new StringBuilder(100).append(((ProjectComponentIdentifier)this.componentIdentifier).getBuild().getBuildPath()).append("@@").append(((ProjectComponentIdentifier)this.componentIdentifier).getProjectPath());
            boolean bl = false;
            String string2 = this.variantName;
            if (string2 != null) {
                String it = string2;
                boolean bl2 = false;
                sb.append("::").append(it);
            }
            if (this.isTestFixturesArtifact) {
                sb.append("::").append("testFixtures");
            }
            String string3 = stringBuilder.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"StringBuilder(100)\n     \u2026              .toString()");
            String string4 = string3.intern();
            string = string4;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"this as java.lang.String).intern()");
        } else if ((componentIdentifier instanceof ModuleComponentIdentifier ? true : componentIdentifier instanceof OpaqueComponentArtifactIdentifier) ? true : componentIdentifier instanceof OpaqueComponentIdentifier) {
            String string5 = (mavenCoordinatesCache.getMavenCoordinates(this) + (this.isTestFixturesArtifact ? "::testFixtures" : "")).intern();
            string = string5;
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"this as java.lang.String).intern()");
        } else {
            throw new RuntimeException("Don't know how to handle ComponentIdentifier '" + this.componentIdentifier.getDisplayName() + "'of type " + this.componentIdentifier.getClass());
        }
        return string;
    }

    @NotNull
    public final ComponentIdentifier component1() {
        return this.componentIdentifier;
    }

    @NotNull
    public final ResolvedVariantResult component2() {
        return this.variant;
    }

    @Nullable
    public final String component3() {
        return this.variantName;
    }

    @Nullable
    public final File component4() {
        return this.artifactFile;
    }

    public final boolean component5() {
        return this.isTestFixturesArtifact;
    }

    @Nullable
    public final File component6() {
        return this.extractedFolder;
    }

    @Nullable
    public final File component7() {
        return this.publishedLintJar;
    }

    @NotNull
    public final DependencyType component8() {
        return this.dependencyType;
    }

    public final boolean component9() {
        return this.isWrappedModule;
    }

    @NotNull
    public final ResolvedArtifact copy(@NotNull ComponentIdentifier componentIdentifier, @NotNull ResolvedVariantResult variant, @Nullable String variantName, @Nullable File artifactFile, boolean isTestFixturesArtifact, @Nullable File extractedFolder, @Nullable File publishedLintJar, @NotNull DependencyType dependencyType, boolean isWrappedModule) {
        Intrinsics.checkNotNullParameter((Object)componentIdentifier, (String)"componentIdentifier");
        Intrinsics.checkNotNullParameter((Object)variant, (String)"variant");
        Intrinsics.checkNotNullParameter((Object)((Object)dependencyType), (String)"dependencyType");
        return new ResolvedArtifact(componentIdentifier, variant, variantName, artifactFile, isTestFixturesArtifact, extractedFolder, publishedLintJar, dependencyType, isWrappedModule);
    }

    public static /* synthetic */ ResolvedArtifact copy$default(ResolvedArtifact resolvedArtifact, ComponentIdentifier componentIdentifier, ResolvedVariantResult resolvedVariantResult, String string, File file, boolean bl, File file2, File file3, DependencyType dependencyType, boolean bl2, int n, Object object) {
        if ((n & 1) != 0) {
            componentIdentifier = resolvedArtifact.componentIdentifier;
        }
        if ((n & 2) != 0) {
            resolvedVariantResult = resolvedArtifact.variant;
        }
        if ((n & 4) != 0) {
            string = resolvedArtifact.variantName;
        }
        if ((n & 8) != 0) {
            file = resolvedArtifact.artifactFile;
        }
        if ((n & 0x10) != 0) {
            bl = resolvedArtifact.isTestFixturesArtifact;
        }
        if ((n & 0x20) != 0) {
            file2 = resolvedArtifact.extractedFolder;
        }
        if ((n & 0x40) != 0) {
            file3 = resolvedArtifact.publishedLintJar;
        }
        if ((n & 0x80) != 0) {
            dependencyType = resolvedArtifact.dependencyType;
        }
        if ((n & 0x100) != 0) {
            bl2 = resolvedArtifact.isWrappedModule;
        }
        return resolvedArtifact.copy(componentIdentifier, resolvedVariantResult, string, file, bl, file2, file3, dependencyType, bl2);
    }

    @NotNull
    public String toString() {
        return "ResolvedArtifact(componentIdentifier=" + this.componentIdentifier + ", variant=" + this.variant + ", variantName=" + this.variantName + ", artifactFile=" + this.artifactFile + ", isTestFixturesArtifact=" + this.isTestFixturesArtifact + ", extractedFolder=" + this.extractedFolder + ", publishedLintJar=" + this.publishedLintJar + ", dependencyType=" + this.dependencyType + ", isWrappedModule=" + this.isWrappedModule + ")";
    }

    public int hashCode() {
        int result2 = this.componentIdentifier.hashCode();
        result2 = result2 * 31 + this.variant.hashCode();
        result2 = result2 * 31 + (this.variantName == null ? 0 : this.variantName.hashCode());
        result2 = result2 * 31 + (this.artifactFile == null ? 0 : this.artifactFile.hashCode());
        result2 = result2 * 31 + Boolean.hashCode(this.isTestFixturesArtifact);
        result2 = result2 * 31 + (this.extractedFolder == null ? 0 : this.extractedFolder.hashCode());
        result2 = result2 * 31 + (this.publishedLintJar == null ? 0 : this.publishedLintJar.hashCode());
        result2 = result2 * 31 + this.dependencyType.hashCode();
        result2 = result2 * 31 + Boolean.hashCode(this.isWrappedModule);
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ResolvedArtifact)) {
            return false;
        }
        ResolvedArtifact resolvedArtifact = (ResolvedArtifact)other;
        if (!Intrinsics.areEqual((Object)this.componentIdentifier, (Object)resolvedArtifact.componentIdentifier)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.variant, (Object)resolvedArtifact.variant)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.variantName, (Object)resolvedArtifact.variantName)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.artifactFile, (Object)resolvedArtifact.artifactFile)) {
            return false;
        }
        if (this.isTestFixturesArtifact != resolvedArtifact.isTestFixturesArtifact) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.extractedFolder, (Object)resolvedArtifact.extractedFolder)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.publishedLintJar, (Object)resolvedArtifact.publishedLintJar)) {
            return false;
        }
        if (this.dependencyType != resolvedArtifact.dependencyType) {
            return false;
        }
        return this.isWrappedModule == resolvedArtifact.isWrappedModule;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000b\u00a8\u0006\f"}, d2={"Lcom/android/build/gradle/internal/ide/dependencies/ResolvedArtifact$DependencyType;", "", "extension", "", "(Ljava/lang/String;ILjava/lang/String;)V", "getExtension", "()Ljava/lang/String;", "JAVA", "ANDROID", "ANDROID_SANDBOX_SDK", "RELOCATED_ARTIFACT", "NO_ARTIFACT_FILE", "gradle-core"})
    public static final class DependencyType
    extends Enum<DependencyType> {
        @NotNull
        private final String extension;
        public static final /* enum */ DependencyType JAVA = new DependencyType("jar");
        public static final /* enum */ DependencyType ANDROID = new DependencyType("aar");
        public static final /* enum */ DependencyType ANDROID_SANDBOX_SDK = new DependencyType("asar");
        public static final /* enum */ DependencyType RELOCATED_ARTIFACT = new DependencyType("");
        public static final /* enum */ DependencyType NO_ARTIFACT_FILE = new DependencyType("");
        private static final /* synthetic */ DependencyType[] $VALUES;

        private DependencyType(String extension2) {
            this.extension = extension2;
        }

        @NotNull
        public final String getExtension() {
            return this.extension;
        }

        public static DependencyType[] values() {
            return (DependencyType[])$VALUES.clone();
        }

        public static DependencyType valueOf(String value) {
            return Enum.valueOf(DependencyType.class, value);
        }

        static {
            $VALUES = dependencyTypeArray = new DependencyType[]{DependencyType.JAVA, DependencyType.ANDROID, DependencyType.ANDROID_SANDBOX_SDK, DependencyType.RELOCATED_ARTIFACT, DependencyType.NO_ARTIFACT_FILE};
        }
    }
}

