/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.transforms;

import com.android.build.gradle.internal.dependency.GenericTransformParameters;
import com.android.build.gradle.internal.transforms.LayoutlibFromMaven;
import com.android.builder.utils.ZipEntryUtils;
import com.google.common.io.ByteStreams;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.transform.InputArtifact;
import org.gradle.api.artifacts.transform.TransformAction;
import org.gradle.api.artifacts.transform.TransformOutputs;
import org.gradle.api.artifacts.transform.TransformSpec;
import org.gradle.api.artifacts.type.ArtifactTypeDefinition;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileSystemLocation;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Classpath;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u00072\u00020\u0001:\u0001\u0007B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\b"}, d2={"Lcom/android/build/gradle/internal/transforms/LayoutlibFromMaven;", "", "layoutlibDirectory", "Lorg/gradle/api/file/FileCollection;", "(Lorg/gradle/api/file/FileCollection;)V", "getLayoutlibDirectory", "()Lorg/gradle/api/file/FileCollection;", "Companion", "gradle-core"})
public final class LayoutlibFromMaven {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final FileCollection layoutlibDirectory;
    @NotNull
    private static final String MAVEN_LAYOUTLIB_DIR = "prebuilts/studio/";
    @NotNull
    private static final String OUT_LAYOUTLIB_DIR = "plugins/design-tools/resources/";
    @NotNull
    private static final String APP_INFO = "META-INF/Application";
    @NotNull
    private static final String MAVEN_GROUP = "com.android.screenshot.cli";
    @NotNull
    private static final String MAVEN_ARTIFACT = "screenshot";
    @NotNull
    private static final String VERSION = "31.2.0-dev";
    @NotNull
    private static final String TYPE_EXTRACTED_LAYOUTLIB = "_internal-android-extracted-layoutlib";
    @NotNull
    private static final Logger logger;

    public LayoutlibFromMaven(@NotNull FileCollection layoutlibDirectory2) {
        Intrinsics.checkNotNullParameter((Object)layoutlibDirectory2, (String)"layoutlibDirectory");
        this.layoutlibDirectory = layoutlibDirectory2;
    }

    @NotNull
    public final FileCollection getLayoutlibDirectory() {
        return this.layoutlibDirectory;
    }

    @JvmStatic
    @NotNull
    public static final LayoutlibFromMaven create(@NotNull Project project) {
        return Companion.create(project);
    }

    static {
        Logger logger = Logging.getLogger(Companion.getClass());
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(this.javaClass)");
        LayoutlibFromMaven.logger = logger;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001\u0011B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/android/build/gradle/internal/transforms/LayoutlibFromMaven$Companion;", "", "()V", "APP_INFO", "", "MAVEN_ARTIFACT", "MAVEN_GROUP", "MAVEN_LAYOUTLIB_DIR", "OUT_LAYOUTLIB_DIR", "TYPE_EXTRACTED_LAYOUTLIB", "VERSION", "logger", "Lorg/gradle/api/logging/Logger;", "create", "Lcom/android/build/gradle/internal/transforms/LayoutlibFromMaven;", "project", "Lorg/gradle/api/Project;", "LayoutLibExtractor", "gradle-core"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final LayoutlibFromMaven create(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Dependency[] dependencyArray = new Dependency[1];
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"group", (Object)LayoutlibFromMaven.MAVEN_GROUP), TuplesKt.to((Object)"name", (Object)LayoutlibFromMaven.MAVEN_ARTIFACT), TuplesKt.to((Object)"version", (Object)LayoutlibFromMaven.VERSION), TuplesKt.to((Object)"classifier", (Object)"")};
            dependencyArray[0] = project.getDependencies().create((Object)MapsKt.mapOf((Pair[])pairArray));
            Configuration configuration = project.getConfigurations().detachedConfiguration(dependencyArray);
            configuration.setCanBeConsumed(false);
            configuration.setCanBeResolved(true);
            project.getDependencies().registerTransform(LayoutLibExtractor.class, new Action(project){
                final /* synthetic */ Project $project;
                {
                    this.$project = $project;
                }

                public final void execute(TransformSpec<GenericTransformParameters> it) {
                    ((GenericTransformParameters)it.getParameters()).getProjectName().set((Object)this.$project.getName());
                    it.getFrom().attribute(ArtifactTypeDefinition.ARTIFACT_TYPE_ATTRIBUTE, (Object)"jar");
                    it.getTo().attribute(ArtifactTypeDefinition.ARTIFACT_TYPE_ATTRIBUTE, (Object)"_internal-android-extracted-layoutlib");
                }
            });
            FileCollection layoutlibDirectory2 = configuration.getIncoming().artifactView((Action)create.layoutlibDirectory.1.INSTANCE).getArtifacts().getArtifactFiles();
            Intrinsics.checkNotNullExpressionValue((Object)layoutlibDirectory2, (String)"layoutlibDirectory");
            return new LayoutlibFromMaven(layoutlibDirectory2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\r"}, d2={"Lcom/android/build/gradle/internal/transforms/LayoutlibFromMaven$Companion$LayoutLibExtractor;", "Lorg/gradle/api/artifacts/transform/TransformAction;", "Lcom/android/build/gradle/internal/dependency/GenericTransformParameters;", "()V", "inputArtifact", "Lorg/gradle/api/provider/Provider;", "Lorg/gradle/api/file/FileSystemLocation;", "getInputArtifact", "()Lorg/gradle/api/provider/Provider;", "transform", "", "transformOutputs", "Lorg/gradle/api/artifacts/transform/TransformOutputs;", "gradle-core"})
        public static abstract class LayoutLibExtractor
        implements TransformAction<GenericTransformParameters> {
            @Classpath
            @InputArtifact
            @NotNull
            public abstract Provider<FileSystemLocation> getInputArtifact();

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void transform(@NotNull TransformOutputs transformOutputs) {
                Intrinsics.checkNotNullParameter((Object)transformOutputs, (String)"transformOutputs");
                File input = ((FileSystemLocation)this.getInputArtifact().get()).getAsFile();
                Intrinsics.checkNotNullExpressionValue((Object)input, (String)"input");
                Path outDir = transformOutputs.dir((Object)FilesKt.getNameWithoutExtension((File)input)).toPath();
                Files.createDirectories(outDir, new FileAttribute[0]);
                Closeable closeable = new FileInputStream(input);
                int n = 8192;
                closeable = new ZipInputStream(closeable instanceof BufferedInputStream ? (BufferedInputStream)closeable : new BufferedInputStream((InputStream)closeable, n));
                Throwable throwable = null;
                try {
                    block12: {
                        Throwable throwable2;
                        Closeable closeable2;
                        ZipInputStream zipInputStream = (ZipInputStream)closeable;
                        boolean bl = false;
                        while (true) {
                            ZipEntry zipEntry;
                            ZipEntry zipEntry2 = zipEntry = zipInputStream.getNextEntry();
                            if (zipEntry2 == null) break block12;
                            Intrinsics.checkNotNullExpressionValue((Object)zipEntry2, (String)"zipInputStream.nextEntry ?: break");
                            ZipEntry entry = zipEntry;
                            if (!ZipEntryUtils.isValidZipEntryName((ZipEntry)entry) || entry.isDirectory()) continue;
                            String string = entry.getName();
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"entry.name");
                            boolean isLayoutLib = StringsKt.contains$default((CharSequence)string, (CharSequence)LayoutlibFromMaven.MAVEN_LAYOUTLIB_DIR, (boolean)false, (int)2, null);
                            String string2 = entry.getName();
                            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"entry.name");
                            boolean isAppInfoXml = StringsKt.startsWith$default((String)string2, (String)LayoutlibFromMaven.APP_INFO, (boolean)false, (int)2, null);
                            if (!isLayoutLib && !isAppInfoXml) continue;
                            String path = entry.getName();
                            if (isLayoutLib) {
                                String string3 = entry.getName();
                                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"entry.name");
                                path = StringsKt.replace$default((String)string3, (String)LayoutlibFromMaven.MAVEN_LAYOUTLIB_DIR, (String)LayoutlibFromMaven.OUT_LAYOUTLIB_DIR, (boolean)false, (int)4, null);
                            }
                            Path destinationFile = outDir.resolve(path);
                            Files.createDirectories(destinationFile.getParent(), new FileAttribute[0]);
                            OutputStream outputStream = Files.newOutputStream(destinationFile, new OpenOption[0]);
                            Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)"newOutputStream(destinationFile)");
                            closeable2 = outputStream;
                            int n2 = 8192;
                            closeable2 = closeable2 instanceof BufferedOutputStream ? (BufferedOutputStream)closeable2 : new BufferedOutputStream((OutputStream)closeable2, n2);
                            throwable2 = null;
                            try {
                                BufferedOutputStream output2 = (BufferedOutputStream)closeable2;
                                boolean bl2 = false;
                                long l = ByteStreams.copy((InputStream)zipInputStream, (OutputStream)output2);
                            }
                            catch (Throwable throwable3) {
                                throwable2 = throwable3;
                                throw throwable3;
                            }
                        }
                        finally {
                            CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
                        }
                    }
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            }
        }
    }
}

