/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.gradle.internal.tasks.GeneratePrivacySandboxProguardRulesTask;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Set;
import java.util.SortedSet;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.file.RegularFile;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000\u001e\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a$\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\u0001\u001a\u000e\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00010\u0005H\u0002\u001a\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"KEEP_RULE_CLASS_PREFIX", "", "KEEP_RULE_PREFIX", "KEEP_RULE_SUFFIX", "generateSandboxKeepRules", "", "applicationId", "sdkProviderClassName", "compatSdkProviderClassName", "getInterfaceKeepRules", "runTask", "", "parameters", "Lcom/android/build/gradle/internal/tasks/GeneratePrivacySandboxProguardRulesTask$GenerateProguardRulesWorkAction$Params;", "gradle-core"})
public final class GeneratePrivacySandboxProguardRulesTaskKt {
    @NotNull
    private static final String KEEP_RULE_CLASS_PREFIX = "-keep class ";
    @NotNull
    private static final String KEEP_RULE_PREFIX = "-keep ";
    @NotNull
    private static final String KEEP_RULE_SUFFIX = " { *; }";

    public static final void runTask(@NotNull GeneratePrivacySandboxProguardRulesTask.GenerateProguardRulesWorkAction.Params parameters) {
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        Path path = ((RegularFile)parameters.getProguardOutputFile().get()).getAsFile().toPath();
        Object object = parameters.getApplicationId().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"parameters.applicationId.get()");
        String string = (String)object;
        Object object2 = parameters.getSdkProviderClassName().get();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"parameters.sdkProviderClassName.get()");
        String string2 = (String)object2;
        Object object3 = parameters.getCompatSdkProviderClassName().get();
        Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"parameters.compatSdkProviderClassName.get()");
        Files.write(path, (Iterable<? extends CharSequence>)GeneratePrivacySandboxProguardRulesTaskKt.generateSandboxKeepRules(string, string2, (String)object3), new OpenOption[0]);
    }

    @NotNull
    public static final Set<String> generateSandboxKeepRules(@NotNull String applicationId2, @NotNull String sdkProviderClassName, @NotNull String compatSdkProviderClassName) {
        Intrinsics.checkNotNullParameter((Object)applicationId2, (String)"applicationId");
        Intrinsics.checkNotNullParameter((Object)sdkProviderClassName, (String)"sdkProviderClassName");
        Intrinsics.checkNotNullParameter((Object)compatSdkProviderClassName, (String)"compatSdkProviderClassName");
        SortedSet rules2 = SetsKt.sortedSetOf((Object[])new String[0]);
        rules2.add("# Generated by the privacy sandbox gradle plugin");
        rules2.addAll((Collection)GeneratePrivacySandboxProguardRulesTaskKt.getInterfaceKeepRules());
        rules2.add("-ignorewarnings");
        rules2.add(KEEP_RULE_CLASS_PREFIX + sdkProviderClassName + KEEP_RULE_SUFFIX);
        rules2.add(KEEP_RULE_CLASS_PREFIX + compatSdkProviderClassName + KEEP_RULE_SUFFIX);
        rules2.add(KEEP_RULE_CLASS_PREFIX + applicationId2 + ".RPackage { *; }");
        return rules2;
    }

    private static final Set<String> getInterfaceKeepRules() {
        Object[] objectArray = new String[]{"-keep @androidx.privacysandbox.tools.PrivacySandboxValue interface ** { *; }", "-keep @androidx.privacysandbox.tools.PrivacySandboxInterface interface ** { *; }", "-keep @androidx.privacysandbox.tools.PrivacySandboxService interface ** { *; }", "-keep @androidx.privacysandbox.tools.PrivacySandboxCallback interface ** { *; }", "-keep @androidx.privacysandbox.tools.PrivacySandboxValue class ** { *; }", "-keep @androidx.privacysandbox.tools.PrivacySandboxInterface class ** { *; }", "-keep @androidx.privacysandbox.tools.PrivacySandboxService class ** { *; }", "-keep @androidx.privacysandbox.tools.PrivacySandboxCallback class ** { *; }"};
        return SetsKt.sortedSetOf((Object[])objectArray);
    }
}

