/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.cxx.prefab;

import com.android.SdkConstants;
import com.android.build.gradle.internal.cxx.io.IoUtilsKt;
import com.android.build.gradle.internal.cxx.json.JsonHelpersKt;
import com.android.build.gradle.internal.cxx.logging.LoggingEnvironmentKt;
import com.android.build.gradle.internal.cxx.prefab.AndroidAbiMetadata;
import com.android.build.gradle.internal.cxx.prefab.ModuleMetadataV1;
import com.android.build.gradle.internal.cxx.prefab.PackageMetadataV1;
import com.android.build.gradle.internal.cxx.prefab.PayloadMapping;
import com.android.build.gradle.internal.cxx.prefab.PrefabAbiPublication;
import com.android.build.gradle.internal.cxx.prefab.PrefabModulePublication;
import com.android.build.gradle.internal.cxx.prefab.PrefabPackagePublication;
import com.android.build.gradle.internal.cxx.prefab.PrefabPublication;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.gradle.api.Action;
import org.gradle.api.file.CopySpec;
import org.gradle.api.file.FileSystemOperations;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0002J\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\t0\u00102\u0006\u0010\u0011\u001a\u00020\u0012J\u0018\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0018\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\u0018\u001a\u00020\r2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0018\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\rH\u0002J\u0018\u0010\u001d\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0018\u001a\u00020\rH\u0002J\u0018\u0010\u001e\u001a\u00020\u000b2\u0006\u0010\u001f\u001a\u00020\r2\u0006\u0010 \u001a\u00020!H\u0002J\u001a\u0010\"\u001a\u00020\u000b2\b\u0010#\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0018\u001a\u00020\rH\u0002J\u0014\u0010$\u001a\n &*\u0004\u0018\u00010%0%*\u00020\rH\u0002R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lcom/android/build/gradle/internal/cxx/prefab/PrefabPackageBuilder;", "", "fileOperations", "Lorg/gradle/api/file/FileSystemOperations;", "payloadIndirection", "", "(Lorg/gradle/api/file/FileSystemOperations;Z)V", "payloadMappings", "", "Lcom/android/build/gradle/internal/cxx/prefab/PayloadMapping;", "addPayloadMapping", "", "originModulePath", "Ljava/io/File;", "builtPackagePath", "configurePrefab", "", "publication", "Lcom/android/build/gradle/internal/cxx/prefab/PrefabPublication;", "createAbiJson", "libDir", "abi", "Lcom/android/build/gradle/internal/cxx/prefab/PrefabAbiPublication;", "createLibs", "moduleDir", "module", "Lcom/android/build/gradle/internal/cxx/prefab/PrefabModulePublication;", "createModule", "packageDir", "createModuleJson", "createPrefabJson", "installDir", "packageInfo", "Lcom/android/build/gradle/internal/cxx/prefab/PrefabPackagePublication;", "installHeaders", "headers", "platformSlashes", "", "kotlin.jvm.PlatformType", "gradle-core"})
@SourceDebugExtension(value={"SMAP\nPackageBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PackageBuilder.kt\ncom/android/build/gradle/internal/cxx/prefab/PrefabPackageBuilder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,247:1\n1#2:248\n*E\n"})
final class PrefabPackageBuilder {
    @Nullable
    private final FileSystemOperations fileOperations;
    private final boolean payloadIndirection;
    @NotNull
    private final List<PayloadMapping> payloadMappings;

    public PrefabPackageBuilder(@Nullable FileSystemOperations fileOperations, boolean payloadIndirection) {
        this.fileOperations = fileOperations;
        this.payloadIndirection = payloadIndirection;
        this.payloadMappings = new ArrayList();
    }

    @NotNull
    public final List<PayloadMapping> configurePrefab(@NotNull PrefabPublication publication) {
        Intrinsics.checkNotNullParameter((Object)publication, (String)"publication");
        publication.getInstallationFolder().mkdirs();
        this.createPrefabJson(publication.getInstallationFolder(), publication.getPackageInfo());
        for (PrefabModulePublication module : publication.getPackageInfo().getModules()) {
            this.createModule(module, publication.getInstallationFolder());
        }
        return this.payloadMappings;
    }

    private final void createPrefabJson(File installDir, PrefabPackagePublication packageInfo) {
        String string = packageInfo.getPackageName();
        int n = packageInfo.getPackageSchemaVersion();
        String string2 = packageInfo.getPackageVersion();
        List<String> list = packageInfo.getPackageDependencies();
        JsonHelpersKt.writeJsonFileIfDifferent(FilesKt.resolve((File)installDir, (String)"prefab.json"), new PackageMetadataV1(string, n, list, string2));
    }

    private final void createModule(PrefabModulePublication module, File packageDir) {
        File file;
        File $this$createModule_u24lambda_u240 = file = FilesKt.resolve((File)packageDir, (String)("modules/" + module.getModuleName()));
        boolean bl = false;
        $this$createModule_u24lambda_u240.mkdirs();
        File moduleDir = file;
        this.createModuleJson(module, moduleDir);
        this.installHeaders(module.getModuleHeaders(), moduleDir);
        this.createLibs(moduleDir, module);
    }

    private final void createModuleJson(PrefabModulePublication module, File moduleDir) {
        JsonHelpersKt.writeJsonFileIfDifferent(FilesKt.resolve((File)moduleDir, (String)"module.json"), new ModuleMetadataV1(module.getModuleExportLibraries(), module.getModuleLibraryName(), null, 4, null));
    }

    private final void installHeaders(File headers, File moduleDir) {
        File includeDir = FilesKt.resolve((File)moduleDir, (String)"include");
        if (headers == null) {
            FilesKt.deleteRecursively((File)includeDir);
            includeDir.mkdirs();
            return;
        }
        includeDir.mkdirs();
        if (this.payloadIndirection) {
            this.addPayloadMapping(headers, includeDir);
            if (headers.isDirectory()) {
                IoUtilsKt.writeTextIfDifferent(FilesKt.resolve((File)includeDir, (String)"placeholder.txt"), "");
            }
            return;
        }
        LoggingEnvironmentKt.infoln("Installing header " + headers + " to " + includeDir, new Object[0]);
        FileSystemOperations fileSystemOperations = this.fileOperations;
        Intrinsics.checkNotNull((Object)fileSystemOperations);
        fileSystemOperations.sync(new Action(headers, includeDir){
            final /* synthetic */ File $headers;
            final /* synthetic */ File $includeDir;
            {
                this.$headers = $headers;
                this.$includeDir = $includeDir;
            }

            public final void execute(CopySpec spec) {
                Object[] objectArray = new Object[]{this.$headers};
                spec.from(objectArray);
                spec.into((Object)this.$includeDir);
            }
        });
    }

    private final void createLibs(File moduleDir, PrefabModulePublication module) {
        File file = FilesKt.resolve((File)moduleDir, (String)"libs");
        File $this$createLibs_u24lambda_u241 = file;
        boolean bl = false;
        FilesKt.deleteRecursively((File)$this$createLibs_u24lambda_u241);
        File libsDir = file;
        for (PrefabAbiPublication abi : module.getAbis()) {
            File libDir = FilesKt.resolve((File)libsDir, (String)("android." + abi.getAbiName()));
            this.createAbiJson(libDir, abi);
        }
    }

    private final void createAbiJson(File libDir, PrefabAbiPublication abi) {
        libDir.mkdirs();
        File file = FilesKt.resolve((File)libDir, (String)"abi.json");
        String string = abi.getAbiName();
        int n = abi.getAbiApi();
        int n2 = abi.getAbiNdkMajor();
        String string2 = abi.getAbiStl();
        File file2 = abi.getAbiLibrary();
        Intrinsics.checkNotNull((Object)file2);
        String string3 = file2.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"abi.abiLibrary!!.name");
        JsonHelpersKt.writeJsonFileIfDifferent(file, new AndroidAbiMetadata(string, n, n2, string2, StringsKt.endsWith$default((String)string3, (String)".a", (boolean)false, (int)2, null)));
        File source = abi.getAbiLibrary();
        String string4 = source.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"source.name");
        File destination = FilesKt.resolve((File)libDir, (String)string4);
        if (this.payloadIndirection) {
            this.addPayloadMapping(source, destination);
            return;
        }
        LoggingEnvironmentKt.infoln("Installing " + source + " to " + destination, new Object[0]);
        IoUtilsKt.synchronizeFile$default(source, destination, null, 4, null);
    }

    private final void addPayloadMapping(File originModulePath, File builtPackagePath) {
        String string = this.platformSlashes(originModulePath);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"originModulePath.platformSlashes()");
        String string2 = this.platformSlashes(builtPackagePath);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"builtPackagePath.platformSlashes()");
        this.payloadMappings.add(new PayloadMapping(string, string2));
    }

    private final String platformSlashes(File $this$platformSlashes) {
        String string;
        if (SdkConstants.CURRENT_PLATFORM == 2) {
            String string2 = $this$platformSlashes.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"path");
            string = StringsKt.replace$default((String)string2, (String)"\\", (String)"/", (boolean)false, (int)4, null);
        } else {
            string = $this$platformSlashes.getPath();
        }
        return string;
    }
}

