/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.generators;

import com.android.build.api.variant.BuildConfigField;
import com.android.build.gradle.internal.generators.BuildConfigData;
import com.android.build.gradle.internal.generators.BuildConfigFieldUtilsKt;
import com.android.builder.compiling.GeneratedCodeFileCreator;
import com.google.common.base.Charsets;
import com.google.common.io.Closer;
import com.squareup.javawriter.JavaWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.io.Writer;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.Modifier;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0012\u001a\u00020\u0013H\u0016R\"\u0010\u0005\u001a\u0016\u0012\u0004\u0012\u00020\u0007\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\t0\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\rR\u000e\u0010\u0011\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/android/build/gradle/internal/generators/BuildConfigGenerator;", "Lcom/android/builder/compiling/GeneratedCodeFileCreator;", "buildConfigData", "Lcom/android/build/gradle/internal/generators/BuildConfigData;", "(Lcom/android/build/gradle/internal/generators/BuildConfigData;)V", "fields", "", "", "Lcom/android/build/api/variant/BuildConfigField;", "Ljava/io/Serializable;", "folderPath", "Ljava/io/File;", "getFolderPath", "()Ljava/io/File;", "genFolder", "generatedFilePath", "getGeneratedFilePath", "namespace", "generate", "", "Companion", "gradle-core"})
public final class BuildConfigGenerator
implements GeneratedCodeFileCreator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String genFolder;
    @NotNull
    private final String namespace;
    @NotNull
    private final Map<String, BuildConfigField<? extends Serializable>> fields;
    @NotNull
    private final File folderPath;
    @NotNull
    private final File generatedFilePath;
    @NotNull
    public static final String BUILD_CONFIG_NAME = "BuildConfig.java";
    @NotNull
    private static final Set<Modifier> PUBLIC_FINAL;

    public BuildConfigGenerator(@NotNull BuildConfigData buildConfigData) {
        Intrinsics.checkNotNullParameter((Object)buildConfigData, (String)"buildConfigData");
        this.genFolder = ((Object)buildConfigData.getOutputPath()).toString();
        this.namespace = buildConfigData.getNamespace();
        this.fields = buildConfigData.getBuildConfigFields();
        this.folderPath = new File(this.genFolder, StringsKt.replace$default((String)this.namespace, (char)'.', (char)File.separatorChar, (boolean)false, (int)4, null));
        this.generatedFilePath = new File(this.getFolderPath(), BUILD_CONFIG_NAME);
    }

    @NotNull
    public File getFolderPath() {
        return this.folderPath;
    }

    @NotNull
    public File getGeneratedFilePath() {
        return this.generatedFilePath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generate() throws IOException {
        if (!this.getFolderPath().isDirectory() && !this.getFolderPath().mkdirs()) {
            throw new RuntimeException("Failed to create " + this.getFolderPath().getAbsolutePath());
        }
        Closeable closeable = (Closeable)Closer.create();
        Throwable throwable = null;
        try {
            Closer closer = (Closer)closeable;
            boolean bl = false;
            FileOutputStream fos = (FileOutputStream)closer.register((Closeable)new FileOutputStream(this.getGeneratedFilePath()));
            OutputStreamWriter out = (OutputStreamWriter)closer.register((Closeable)new OutputStreamWriter((OutputStream)fos, Charsets.UTF_8));
            JavaWriter writer = (JavaWriter)closer.register((Closeable)new JavaWriter((Writer)out));
            writer.emitJavadoc("Automatically generated file. DO NOT MODIFY", new Object[0]).emitPackage(this.namespace).beginType("BuildConfig", "class", PUBLIC_FINAL);
            for (Map.Entry<String, BuildConfigField<? extends Serializable>> entry : this.fields.entrySet()) {
                String key = entry.getKey();
                BuildConfigField<? extends Serializable> value = entry.getValue();
                Intrinsics.checkNotNullExpressionValue((Object)writer, (String)"writer");
                BuildConfigFieldUtilsKt.emit(value, key, writer);
            }
            JavaWriter javaWriter = writer.endType();
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    static {
        EnumSet<Enum> enumSet = EnumSet.of((Enum)Modifier.PUBLIC, (Enum)Modifier.FINAL);
        Intrinsics.checkNotNullExpressionValue(enumSet, (String)"of(\n                Modi\u2026ifier.FINAL\n            )");
        PUBLIC_FINAL = enumSet;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/android/build/gradle/internal/generators/BuildConfigGenerator$Companion;", "", "()V", "BUILD_CONFIG_NAME", "", "PUBLIC_FINAL", "", "Ljavax/lang/model/element/Modifier;", "gradle-core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

