/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.variant;

import com.android.build.VariantOutput;
import com.android.build.api.artifact.impl.ArtifactsImpl;
import com.android.build.api.component.impl.DeviceTestImpl;
import com.android.build.api.component.impl.ScreenshotTestImpl;
import com.android.build.api.component.impl.TestFixturesImpl;
import com.android.build.api.component.impl.UnitTestImpl;
import com.android.build.api.dsl.CommonExtension;
import com.android.build.api.variant.ComponentIdentity;
import com.android.build.api.variant.VariantBuilder;
import com.android.build.api.variant.impl.DeviceTestBuilderImpl;
import com.android.build.gradle.internal.BuildTypeData;
import com.android.build.gradle.internal.ProductFlavorData;
import com.android.build.gradle.internal.api.BaseVariantImpl;
import com.android.build.gradle.internal.api.ReadOnlyObjectProvider;
import com.android.build.gradle.internal.component.AndroidTestCreationConfig;
import com.android.build.gradle.internal.component.ComponentCreationConfig;
import com.android.build.gradle.internal.component.HostTestCreationConfig;
import com.android.build.gradle.internal.component.TestFixturesCreationConfig;
import com.android.build.gradle.internal.component.VariantCreationConfig;
import com.android.build.gradle.internal.core.VariantSources;
import com.android.build.gradle.internal.core.dsl.AndroidTestComponentDslInfo;
import com.android.build.gradle.internal.core.dsl.HostTestComponentDslInfo;
import com.android.build.gradle.internal.core.dsl.TestFixturesComponentDslInfo;
import com.android.build.gradle.internal.core.dsl.VariantDslInfo;
import com.android.build.gradle.internal.dependency.VariantDependencies;
import com.android.build.gradle.internal.dsl.BuildType;
import com.android.build.gradle.internal.dsl.DefaultConfig;
import com.android.build.gradle.internal.dsl.ProductFlavor;
import com.android.build.gradle.internal.dsl.SigningConfig;
import com.android.build.gradle.internal.scope.BuildFeatureValues;
import com.android.build.gradle.internal.scope.MutableTaskContainer;
import com.android.build.gradle.internal.scope.UnitTestBuildFeatureValuesImpl;
import com.android.build.gradle.internal.services.DslServices;
import com.android.build.gradle.internal.services.TaskCreationServices;
import com.android.build.gradle.internal.services.VariantServices;
import com.android.build.gradle.internal.tasks.factory.GlobalTaskCreationConfig;
import com.android.build.gradle.internal.variant.BaseVariantData;
import com.android.build.gradle.internal.variant.TestVariantData;
import com.android.build.gradle.internal.variant.VariantFactory;
import com.android.build.gradle.internal.variant.VariantInputModel;
import com.android.build.gradle.internal.variant.VariantPathHelper;
import com.android.build.gradle.options.BooleanOption;
import com.android.builder.errors.IssueReporter;
import org.gradle.api.Project;

public abstract class BaseVariantFactory<VariantBuilderT extends VariantBuilder, VariantDslInfoT extends VariantDslInfo, VariantT extends VariantCreationConfig>
implements VariantFactory<VariantBuilderT, VariantDslInfoT, VariantT> {
    private static final String ANDROID_APT_PLUGIN_NAME = "com.neenbedankt.android-apt";
    protected final DslServices dslServices;

    public BaseVariantFactory(DslServices dslServices2) {
        this.dslServices = dslServices2;
    }

    @Override
    public TestFixturesCreationConfig createTestFixtures(ComponentIdentity componentIdentity, BuildFeatureValues buildFeatures, TestFixturesComponentDslInfo dslInfo, VariantDependencies variantDependencies2, VariantSources variantSources, VariantPathHelper paths, ArtifactsImpl artifacts2, MutableTaskContainer taskContainer, VariantCreationConfig mainVariant, VariantServices variantServices, TaskCreationServices taskCreationServices, GlobalTaskCreationConfig globalConfig2) {
        return this.dslServices.newInstance(TestFixturesImpl.class, componentIdentity, buildFeatures, dslInfo, variantDependencies2, variantSources, paths, artifacts2, taskContainer, mainVariant, variantServices, taskCreationServices, globalConfig2);
    }

    @Override
    public HostTestCreationConfig createUnitTest(ComponentIdentity componentIdentity, BuildFeatureValues buildFeatures, HostTestComponentDslInfo dslInfo, VariantDependencies variantDependencies2, VariantSources variantSources, VariantPathHelper paths, ArtifactsImpl artifacts2, TestVariantData variantData, MutableTaskContainer taskContainer, VariantCreationConfig testedVariant, VariantServices variantServices, TaskCreationServices taskCreationServices, GlobalTaskCreationConfig globalConfig2) {
        return this.dslServices.newInstance(UnitTestImpl.class, componentIdentity, this.createUnitTestBuildFeatures(buildFeatures), dslInfo, variantDependencies2, variantSources, paths, artifacts2, variantData, taskContainer, testedVariant, variantServices, taskCreationServices, globalConfig2);
    }

    @Override
    public HostTestCreationConfig createScreenshotTest(ComponentIdentity componentIdentity, BuildFeatureValues buildFeatures, HostTestComponentDslInfo dslInfo, VariantDependencies variantDependencies2, VariantSources variantSources, VariantPathHelper paths, ArtifactsImpl artifacts2, TestVariantData variantData, MutableTaskContainer taskContainer, VariantCreationConfig testedVariant, VariantServices variantServices, TaskCreationServices taskCreationServices, GlobalTaskCreationConfig globalConfig2) {
        return this.dslServices.newInstance(ScreenshotTestImpl.class, componentIdentity, this.createUnitTestBuildFeatures(buildFeatures), dslInfo, variantDependencies2, variantSources, paths, artifacts2, variantData, taskContainer, testedVariant, variantServices, taskCreationServices, globalConfig2);
    }

    @Override
    public AndroidTestCreationConfig createAndroidTest(ComponentIdentity componentIdentity, BuildFeatureValues buildFeatures, AndroidTestComponentDslInfo dslInfo, VariantDependencies variantDependencies2, VariantSources variantSources, VariantPathHelper paths, ArtifactsImpl artifacts2, TestVariantData variantData, MutableTaskContainer taskContainer, VariantCreationConfig testedVariant, VariantServices variantServices, TaskCreationServices taskCreationServices, GlobalTaskCreationConfig globalConfig2, DeviceTestBuilderImpl defaultDeviceTestBuilder) {
        return this.dslServices.newInstance(DeviceTestImpl.class, componentIdentity, buildFeatures, dslInfo, variantDependencies2, variantSources, paths, artifacts2, variantData, taskContainer, testedVariant, variantServices, taskCreationServices, globalConfig2, defaultDeviceTestBuilder);
    }

    @Override
    public BaseVariantImpl createVariantApi(ComponentCreationConfig component2, BaseVariantData variantData, ReadOnlyObjectProvider readOnlyObjectProvider) {
        Class<BaseVariantImpl> implementationClass = this.getVariantImplementationClass();
        return this.dslServices.newInstance(implementationClass, variantData, component2, this.dslServices, readOnlyObjectProvider, this.dslServices.domainObjectContainer(VariantOutput.class));
    }

    @Override
    public void preVariantCallback(Project project, CommonExtension<?, ?, ?, ?, ?, ?> dslExtension, VariantInputModel<DefaultConfig, BuildType, ProductFlavor, SigningConfig> model) {
        if (project.getPluginManager().hasPlugin(ANDROID_APT_PLUGIN_NAME)) {
            this.dslServices.getIssueReporter().reportError(IssueReporter.Type.INCOMPATIBLE_PLUGIN, "android-apt plugin is incompatible with the Android Gradle plugin.  Please use 'annotationProcessor' configuration instead.", "android-apt");
        }
        this.validateBuildConfig(model, dslExtension.getBuildFeatures().getBuildConfig());
        this.validateResValues(model, dslExtension.getBuildFeatures().getResValues());
    }

    void validateBuildConfig(VariantInputModel<DefaultConfig, BuildType, ProductFlavor, SigningConfig> model, Boolean buildConfig) {
        if (buildConfig == null) {
            buildConfig = this.dslServices.getProjectOptions().get(BooleanOption.BUILD_FEATURE_BUILDCONFIG);
        }
        if (!buildConfig.booleanValue()) {
            IssueReporter issueReporter2 = this.dslServices.getIssueReporter();
            String suggestion = "To enable the feature, add the following to your module-level build.gradle:\n`android.buildFeatures.buildConfig true`";
            if (!model.getDefaultConfigData().getDefaultConfig().getBuildConfigFields().isEmpty()) {
                issueReporter2.reportError(IssueReporter.Type.GENERIC, "defaultConfig contains custom BuildConfig fields, but the feature is disabled.\n" + suggestion);
            }
            for (BuildTypeData<BuildType> buildTypeData : model.getBuildTypes().values()) {
                if (buildTypeData.getBuildType().getBuildConfigFields().isEmpty()) continue;
                issueReporter2.reportError(IssueReporter.Type.GENERIC, String.format("Build Type '%s' contains custom BuildConfig fields, but the feature is disabled.\n" + suggestion, buildTypeData.getBuildType().getName()));
            }
            for (ProductFlavorData productFlavorData : model.getProductFlavors().values()) {
                if (((ProductFlavor)productFlavorData.getProductFlavor()).getBuildConfigFields().isEmpty()) continue;
                issueReporter2.reportError(IssueReporter.Type.GENERIC, String.format("Product Flavor '%s' contains custom BuildConfig fields, but the feature is disabled.\n" + suggestion, ((ProductFlavor)productFlavorData.getProductFlavor()).getName()));
            }
        }
    }

    void validateResValues(VariantInputModel<DefaultConfig, BuildType, ProductFlavor, SigningConfig> model, Boolean resValues2) {
        if (resValues2 == null) {
            resValues2 = this.dslServices.getProjectOptions().get(BooleanOption.BUILD_FEATURE_RESVALUES);
        }
        if (!resValues2.booleanValue()) {
            IssueReporter issueReporter2 = this.dslServices.getIssueReporter();
            if (!model.getDefaultConfigData().getDefaultConfig().getResValues().isEmpty()) {
                issueReporter2.reportError(IssueReporter.Type.GENERIC, "defaultConfig contains custom resource values, but the feature is disabled.");
            }
            for (BuildTypeData<BuildType> buildTypeData : model.getBuildTypes().values()) {
                if (buildTypeData.getBuildType().getResValues().isEmpty()) continue;
                issueReporter2.reportError(IssueReporter.Type.GENERIC, String.format("Build Type '%s' contains custom resource values, but the feature is disabled.", buildTypeData.getBuildType().getName()));
            }
            for (ProductFlavorData productFlavorData : model.getProductFlavors().values()) {
                if (((ProductFlavor)productFlavorData.getProductFlavor()).getResValues().isEmpty()) continue;
                issueReporter2.reportError(IssueReporter.Type.GENERIC, String.format("Product Flavor '%s' contains custom resource values, but the feature is disabled.", ((ProductFlavor)productFlavorData.getProductFlavor()).getName()));
            }
        }
    }

    private BuildFeatureValues createUnitTestBuildFeatures(BuildFeatureValues testedVariantBuildFeatures) {
        return new UnitTestBuildFeatureValuesImpl(testedVariantBuildFeatures);
    }
}

