/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.variant;

import com.android.build.gradle.internal.BuildTypeData;
import com.android.build.gradle.internal.ProductFlavorData;
import com.android.build.gradle.internal.SdkComponentsBuildService;
import com.android.build.gradle.internal.component.TestComponentCreationConfig;
import com.android.build.gradle.internal.component.VariantCreationConfig;
import com.android.build.gradle.internal.dsl.BuildType;
import com.android.build.gradle.internal.dsl.DefaultConfig;
import com.android.build.gradle.internal.dsl.ProductFlavor;
import com.android.build.gradle.internal.dsl.SigningConfig;
import com.android.build.gradle.internal.errors.SyncIssueReporter;
import com.android.build.gradle.internal.scope.BuildFeatureValues;
import com.android.build.gradle.internal.tasks.factory.GlobalTaskCreationConfig;
import com.android.build.gradle.internal.variant.BuildAuthorSpecifiedDefaultBuildTypeComparator;
import com.android.build.gradle.internal.variant.BuildAuthorSpecifiedDefaultsFlavorComparator;
import com.android.build.gradle.internal.variant.DefaultBuildTypeComparator;
import com.android.build.gradle.internal.variant.DefaultFlavorComparator;
import com.android.build.gradle.internal.variant.VariantInputModel;
import com.android.build.gradle.internal.variant.VariantModel;
import com.android.build.gradle.options.ProjectOptions;
import com.android.builder.errors.IssueReporter;
import com.android.builder.model.v2.ide.ProjectType;
import com.google.common.base.Joiner;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.RegularFile;
import org.gradle.api.provider.Provider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u008e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0000\u0018\u00002\u00020\u0001B\u0083\u0001\u0012\u001e\u0010\u0002\u001a\u001a\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0003\u0012\u000e\u0010\b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\t\u0012\u0012\u0010\u000b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\f0\t\u0012\u0012\u0010\u000e\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\f0\t\u0012\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\t\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u0012\u0006\u0010\u0014\u001a\u00020\u0015\u0012\u0006\u0010\u0016\u001a\u00020\u0017\u00a2\u0006\u0002\u0010\u0018J\n\u0010>\u001a\u0004\u0018\u00010\nH\u0002J\b\u0010?\u001a\u00020@H\u0002J\n\u0010A\u001a\u0004\u0018\u00010\nH\u0002J\u0014\u0010B\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0CH\u0002R\u0014\u0010\u0019\u001a\u00020\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001c\u001a\u0004\u0018\u00010\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR \u0010\u001f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020!0\f0 8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010#R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R,\u0010\u0002\u001a\u001a\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u0014\u0010&\u001a\u00020'8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b(\u0010)R\u0014\u0010*\u001a\u00020+8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b,\u0010-R\u0014\u0010\u0014\u001a\u00020\u0015X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010/R\u0014\u0010\u0012\u001a\u00020\u0013X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b0\u00101R\u0014\u00102\u001a\u0002038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b4\u00105R\u0016\u0010\b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\f0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u00106\u001a\b\u0012\u0004\u0012\u00020\u000f0\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b7\u00108R\u001a\u0010\u000b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\f0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u00109\u001a\b\u0012\u0004\u0012\u00020\r0\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b:\u00108R\u001a\u0010;\u001a\b\u0012\u0004\u0012\u00020<0 8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b=\u0010#\u00a8\u0006D"}, d2={"Lcom/android/build/gradle/internal/variant/VariantModelImpl;", "Lcom/android/build/gradle/internal/variant/VariantModel;", "inputs", "Lcom/android/build/gradle/internal/variant/VariantInputModel;", "Lcom/android/build/gradle/internal/dsl/DefaultConfig;", "Lcom/android/build/gradle/internal/dsl/BuildType;", "Lcom/android/build/gradle/internal/dsl/ProductFlavor;", "Lcom/android/build/gradle/internal/dsl/SigningConfig;", "testBuilderTypeProvider", "Lkotlin/Function0;", "", "variantProvider", "", "Lcom/android/build/gradle/internal/component/VariantCreationConfig;", "testComponentProvider", "Lcom/android/build/gradle/internal/component/TestComponentCreationConfig;", "buildFeaturesProvider", "Lcom/android/build/gradle/internal/scope/BuildFeatureValues;", "projectTypeV1", "", "projectType", "Lcom/android/builder/model/v2/ide/ProjectType;", "globalConfig", "Lcom/android/build/gradle/internal/tasks/factory/GlobalTaskCreationConfig;", "(Lcom/android/build/gradle/internal/variant/VariantInputModel;Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function0;ILcom/android/builder/model/v2/ide/ProjectType;Lcom/android/build/gradle/internal/tasks/factory/GlobalTaskCreationConfig;)V", "buildFeatures", "getBuildFeatures", "()Lcom/android/build/gradle/internal/scope/BuildFeatureValues;", "defaultVariant", "getDefaultVariant", "()Ljava/lang/String;", "filteredBootClasspath", "Lorg/gradle/api/provider/Provider;", "Lorg/gradle/api/file/RegularFile;", "getFilteredBootClasspath", "()Lorg/gradle/api/provider/Provider;", "getInputs", "()Lcom/android/build/gradle/internal/variant/VariantInputModel;", "mockableJarArtifact", "Lorg/gradle/api/file/FileCollection;", "getMockableJarArtifact", "()Lorg/gradle/api/file/FileCollection;", "projectOptions", "Lcom/android/build/gradle/options/ProjectOptions;", "getProjectOptions", "()Lcom/android/build/gradle/options/ProjectOptions;", "getProjectType", "()Lcom/android/builder/model/v2/ide/ProjectType;", "getProjectTypeV1", "()I", "syncIssueReporter", "Lcom/android/build/gradle/internal/errors/SyncIssueReporter;", "getSyncIssueReporter", "()Lcom/android/build/gradle/internal/errors/SyncIssueReporter;", "testComponents", "getTestComponents", "()Ljava/util/List;", "variants", "getVariants", "versionedSdkLoader", "Lcom/android/build/gradle/internal/SdkComponentsBuildService$VersionedSdkLoader;", "getVersionedSdkLoader", "computeDefaultVariant", "finalizeDefaultVariantDsl", "", "getBuildAuthorSpecifiedDefaultBuildType", "getBuildAuthorSpecifiedDefaultFlavors", "", "gradle-core"})
public final class VariantModelImpl
implements VariantModel {
    @NotNull
    private final VariantInputModel<DefaultConfig, BuildType, ProductFlavor, SigningConfig> inputs;
    @NotNull
    private final Function0<String> testBuilderTypeProvider;
    @NotNull
    private final Function0<List<VariantCreationConfig>> variantProvider;
    @NotNull
    private final Function0<List<TestComponentCreationConfig>> testComponentProvider;
    @NotNull
    private final Function0<BuildFeatureValues> buildFeaturesProvider;
    private final int projectTypeV1;
    @NotNull
    private final ProjectType projectType;
    @NotNull
    private final GlobalTaskCreationConfig globalConfig;

    public VariantModelImpl(@NotNull VariantInputModel<DefaultConfig, BuildType, ProductFlavor, SigningConfig> inputs, @NotNull Function0<String> testBuilderTypeProvider, @NotNull Function0<? extends List<? extends VariantCreationConfig>> variantProvider, @NotNull Function0<? extends List<? extends TestComponentCreationConfig>> testComponentProvider, @NotNull Function0<? extends BuildFeatureValues> buildFeaturesProvider, int projectTypeV1, @NotNull ProjectType projectType, @NotNull GlobalTaskCreationConfig globalConfig2) {
        Intrinsics.checkNotNullParameter(inputs, (String)"inputs");
        Intrinsics.checkNotNullParameter(testBuilderTypeProvider, (String)"testBuilderTypeProvider");
        Intrinsics.checkNotNullParameter(variantProvider, (String)"variantProvider");
        Intrinsics.checkNotNullParameter(testComponentProvider, (String)"testComponentProvider");
        Intrinsics.checkNotNullParameter(buildFeaturesProvider, (String)"buildFeaturesProvider");
        Intrinsics.checkNotNullParameter((Object)projectType, (String)"projectType");
        Intrinsics.checkNotNullParameter((Object)globalConfig2, (String)"globalConfig");
        this.inputs = inputs;
        this.testBuilderTypeProvider = testBuilderTypeProvider;
        this.variantProvider = variantProvider;
        this.testComponentProvider = testComponentProvider;
        this.buildFeaturesProvider = buildFeaturesProvider;
        this.projectTypeV1 = projectTypeV1;
        this.projectType = projectType;
        this.globalConfig = globalConfig2;
    }

    @Override
    @NotNull
    public VariantInputModel<DefaultConfig, BuildType, ProductFlavor, SigningConfig> getInputs() {
        return this.inputs;
    }

    @Override
    public int getProjectTypeV1() {
        return this.projectTypeV1;
    }

    @Override
    @NotNull
    public ProjectType getProjectType() {
        return this.projectType;
    }

    @Override
    @NotNull
    public ProjectOptions getProjectOptions() {
        return this.globalConfig.getServices().getProjectOptions();
    }

    @Override
    @NotNull
    public SyncIssueReporter getSyncIssueReporter() {
        IssueReporter issueReporter2 = this.globalConfig.getServices().getIssueReporter();
        Intrinsics.checkNotNull((Object)issueReporter2, (String)"null cannot be cast to non-null type com.android.build.gradle.internal.errors.SyncIssueReporter");
        return (SyncIssueReporter)issueReporter2;
    }

    @Override
    @NotNull
    public List<VariantCreationConfig> getVariants() {
        return (List)this.variantProvider.invoke();
    }

    @Override
    @NotNull
    public List<TestComponentCreationConfig> getTestComponents() {
        return (List)this.testComponentProvider.invoke();
    }

    @Override
    @Nullable
    public String getDefaultVariant() {
        return this.computeDefaultVariant();
    }

    @Override
    @NotNull
    public BuildFeatureValues getBuildFeatures() {
        return (BuildFeatureValues)this.buildFeaturesProvider.invoke();
    }

    @Override
    @NotNull
    public Provider<SdkComponentsBuildService.VersionedSdkLoader> getVersionedSdkLoader() {
        return this.globalConfig.getVersionedSdkLoader();
    }

    @Override
    @NotNull
    public FileCollection getMockableJarArtifact() {
        return this.globalConfig.getMockableJarArtifact();
    }

    @Override
    @NotNull
    public Provider<List<RegularFile>> getFilteredBootClasspath() {
        return this.globalConfig.getFilteredBootClasspath();
    }

    private final String computeDefaultVariant() {
        VariantCreationConfig defaultComponent;
        this.finalizeDefaultVariantDsl();
        if (this.getVariants().isEmpty()) {
            return null;
        }
        String chosenBuildType = this.getBuildAuthorSpecifiedDefaultBuildType();
        Map<String, String> chosenFlavors = this.getBuildAuthorSpecifiedDefaultFlavors();
        String string = (String)this.testBuilderTypeProvider.invoke();
        if (string == null) {
            string = "debug";
        }
        String fallbackDefaultBuildType = string;
        Comparator comparator = new BuildAuthorSpecifiedDefaultBuildTypeComparator(chosenBuildType).thenComparing(new BuildAuthorSpecifiedDefaultsFlavorComparator(chosenFlavors)).thenComparing(new DefaultBuildTypeComparator(fallbackDefaultBuildType)).thenComparing(new DefaultFlavorComparator());
        Intrinsics.checkNotNullExpressionValue(comparator, (String)"BuildAuthorSpecifiedDefa\u2026efaultFlavorComparator())");
        Comparator preferredDefaultVariantScopeComparator = comparator;
        VariantCreationConfig variantCreationConfig = defaultComponent = (VariantCreationConfig)CollectionsKt.minWithOrNull((Iterable)this.getVariants(), preferredDefaultVariantScopeComparator);
        return variantCreationConfig != null ? variantCreationConfig.getName() : null;
    }

    private final void finalizeDefaultVariantDsl() {
        for (BuildTypeData<BuildType> buildTypeData : this.getInputs().getBuildTypes().values()) {
            buildTypeData.getBuildType().getIsDefault().finalizeValue();
        }
        for (ProductFlavorData productFlavorData : this.getInputs().getProductFlavors().values()) {
            ((ProductFlavor)productFlavorData.getProductFlavor()).getIsDefault().finalizeValue();
        }
    }

    private final String getBuildAuthorSpecifiedDefaultBuildType() {
        List buildTypesMarkedAsDefault = new ArrayList(1);
        for (BuildTypeData<BuildType> buildType : this.getInputs().getBuildTypes().values()) {
            if (!buildType.getBuildType().isDefault()) continue;
            buildTypesMarkedAsDefault.add(buildType.getBuildType().getName());
        }
        CollectionsKt.sort((List)buildTypesMarkedAsDefault);
        if (buildTypesMarkedAsDefault.size() > 1) {
            IssueReporter.reportWarning$default((IssueReporter)this.globalConfig.getServices().getIssueReporter(), (IssueReporter.Type)IssueReporter.Type.AMBIGUOUS_BUILD_TYPE_DEFAULT, (String)("Ambiguous default build type: '" + Joiner.on((String)"', '").join((Iterable)buildTypesMarkedAsDefault) + "'.\nPlease only set `isDefault = true` for one build type."), (String)Joiner.on((char)',').join((Iterable)buildTypesMarkedAsDefault), null, (int)8, null);
        }
        return buildTypesMarkedAsDefault.isEmpty() ? null : (String)buildTypesMarkedAsDefault.get(0);
    }

    private final Map<String, String> getBuildAuthorSpecifiedDefaultFlavors() {
        ArrayListMultimap userDefaults = ArrayListMultimap.create();
        for (ProductFlavorData<ProductFlavor> flavor : this.getInputs().getProductFlavors().values()) {
            ProductFlavor productFlavor = flavor.getProductFlavor();
            String dimension = productFlavor.getDimension();
            Object object = productFlavor.getIsDefault().get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"productFlavor.getIsDefault().get()");
            if (!((Boolean)object).booleanValue()) continue;
            userDefaults.put((Object)dimension, (Object)productFlavor.getName());
        }
        ImmutableMap.Builder defaults = ImmutableMap.builder();
        for (String dimension : userDefaults.keySet()) {
            List userDefault = userDefaults.get((Object)dimension);
            Intrinsics.checkNotNullExpressionValue((Object)userDefault, (String)"userDefault");
            CollectionsKt.sort((List)userDefault);
            if (!((Collection)userDefault).isEmpty()) {
                defaults.put((Object)dimension, userDefault.get(0));
            }
            if (userDefault.size() <= 1) continue;
            IssueReporter.reportWarning$default((IssueReporter)this.globalConfig.getServices().getIssueReporter(), (IssueReporter.Type)IssueReporter.Type.AMBIGUOUS_PRODUCT_FLAVOR_DEFAULT, (String)("Ambiguous default product flavors for flavor dimension '" + dimension + "': '" + Joiner.on((String)"', '").join((Iterable)userDefault) + "'.\nPlease only set `isDefault = true` for one product flavor in each flavor dimension."), (String)dimension, null, (int)8, null);
        }
        ImmutableMap immutableMap = defaults.build();
        Intrinsics.checkNotNullExpressionValue((Object)immutableMap, (String)"defaults.build()");
        return (Map)immutableMap;
    }
}

