/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.cxx.settings;

import com.android.build.gradle.internal.cxx.logging.LoggingEnvironmentKt;
import com.android.build.gradle.internal.cxx.logging.PassThroughPrefixingLoggingEnvironment;
import com.android.build.gradle.internal.cxx.settings.Settings;
import com.android.build.gradle.internal.cxx.settings.SettingsConfiguration;
import com.android.utils.cxx.CxxDiagnosticCode;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import java.io.File;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gradle.api.file.ProjectLayout;
import org.gradle.api.provider.ProviderFactory;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000,\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u001e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u001a\u0018\u0010\b\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u000b\u001a\n\u0010\f\u001a\u00020\t*\u00020\u0001\u001a\n\u0010\f\u001a\u00020\t*\u00020\r\u00a8\u0006\u000e"}, d2={"createSettingsFromJsonFile", "Lcom/android/build/gradle/internal/cxx/settings/Settings;", "json", "Ljava/io/File;", "providers", "Lorg/gradle/api/provider/ProviderFactory;", "layout", "Lorg/gradle/api/file/ProjectLayout;", "createSettingsFromJsonString", "", "lenient", "", "toJsonString", "Lcom/android/build/gradle/internal/cxx/settings/SettingsConfiguration;", "gradle-core"})
@SourceDebugExtension(value={"SMAP\nJsonUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JsonUtil.kt\ncom/android/build/gradle/internal/cxx/settings/JsonUtilKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,100:1\n1549#2:101\n1620#2,3:102\n1#3:105\n*S KotlinDebug\n*F\n+ 1 JsonUtil.kt\ncom/android/build/gradle/internal/cxx/settings/JsonUtilKt\n*L\n53#1:101\n53#1:102,3\n*E\n"})
public final class JsonUtilKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Settings createSettingsFromJsonString(@NotNull String json, boolean lenient) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Object object;
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        JsonReader reader = new JsonReader((Reader)new StringReader(json));
        reader.setLenient(lenient);
        try {
            object = (Settings)new Gson().getAdapter((TypeToken)new TypeToken<Settings>(){}).read(reader);
        }
        catch (Throwable e) {
            String string = e.getMessage();
            if (string == null) {
                Throwable throwable = e.getCause();
                string = throwable != null ? throwable.getMessage() : null;
                if (string == null) {
                    string = e.getClass().getName();
                }
            }
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"e.message ?: e.cause?.message ?: e.javaClass.name");
            LoggingEnvironmentKt.errorln(CxxDiagnosticCode.BUILD_SETTINGS_PARSE_ERROR, string, new Object[0]);
            object = new Settings(null, null, 3, null);
        }
        Settings settings2 = object;
        object = CollectionsKt.filterNotNull((Iterable)settings2.getConfigurations());
        List list = CollectionsKt.filterNotNull((Iterable)settings2.getEnvironments());
        boolean $i$f$map = false;
        void var6_8 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void configuration;
            SettingsConfiguration settingsConfiguration = (SettingsConfiguration)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(SettingsConfiguration.copy$default((SettingsConfiguration)configuration, null, null, null, null, null, null, null, null, null, null, null, null, CollectionsKt.filterNotNull((Iterable)configuration.getVariables()), 4095, null));
        }
        List list2 = (List)destination$iv$iv;
        List list3 = list;
        return new Settings(list3, list2);
    }

    public static /* synthetic */ Settings createSettingsFromJsonString$default(String string, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        return JsonUtilKt.createSettingsFromJsonString(string, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final Settings createSettingsFromJsonFile(@NotNull File json, @NotNull ProviderFactory providers, @NotNull ProjectLayout layout) {
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        Intrinsics.checkNotNullParameter((Object)providers, (String)"providers");
        Intrinsics.checkNotNullParameter((Object)layout, (String)"layout");
        AutoCloseable autoCloseable = new PassThroughPrefixingLoggingEnvironment(json, null, false, 6, null);
        Throwable throwable = null;
        try {
            PassThroughPrefixingLoggingEnvironment it = (PassThroughPrefixingLoggingEnvironment)autoCloseable;
            boolean bl = false;
            String jsonContent2 = (String)providers.fileContents(layout.file(providers.provider(new Callable(json){
                final /* synthetic */ File $json;
                {
                    this.$json = $json;
                }

                public final File call() {
                    return this.$json;
                }
            }))).getAsText().get();
            Intrinsics.checkNotNullExpressionValue((Object)jsonContent2, (String)"jsonContent");
            Settings settings2 = JsonUtilKt.createSettingsFromJsonString$default(jsonContent2, false, 2, null);
            return settings2;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    @NotNull
    public static final String toJsonString(@NotNull Settings $this$toJsonString) {
        StringWriter stringWriter;
        Intrinsics.checkNotNullParameter((Object)$this$toJsonString, (String)"<this>");
        StringWriter writer = stringWriter = new StringWriter();
        boolean bl = false;
        new GsonBuilder().setPrettyPrinting().create().toJson((Object)$this$toJsonString, (Appendable)writer);
        String string = stringWriter.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringWriter()\n        .\u2026er) }\n        .toString()");
        return string;
    }

    @NotNull
    public static final String toJsonString(@NotNull SettingsConfiguration $this$toJsonString) {
        StringWriter stringWriter;
        Intrinsics.checkNotNullParameter((Object)$this$toJsonString, (String)"<this>");
        StringWriter writer = stringWriter = new StringWriter();
        boolean bl = false;
        new GsonBuilder().setPrettyPrinting().create().toJson((Object)$this$toJsonString, (Appendable)writer);
        String string = stringWriter.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringWriter()\n        .\u2026er) }\n        .toString()");
        return string;
    }
}

