/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.shrinker.usages;

import com.android.build.shrinker.ResourceShrinkerModel;
import com.android.build.shrinker.usages.ResourceUsageRecorder;
import com.android.build.shrinker.usages.ToolsAttributeUsageRecorder;
import com.android.utils.XmlUtils;
import com.google.common.collect.ImmutableMap;
import java.io.Closeable;
import java.io.Reader;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u001c\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\t\u001a\u00020\u0003H\u0002J\u0010\u0010\u000f\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"Lcom/android/build/shrinker/usages/ToolsAttributeUsageRecorder;", "Lcom/android/build/shrinker/usages/ResourceUsageRecorder;", "rawResourcesPath", "Ljava/nio/file/Path;", "(Ljava/nio/file/Path;)V", "getRawResourcesPath", "()Ljava/nio/file/Path;", "processRawXml", "", "path", "model", "Lcom/android/build/shrinker/ResourceShrinkerModel;", "processResourceToolsAttributes", "", "", "recordUsages", "Companion", "shrinker"})
public final class ToolsAttributeUsageRecorder
implements ResourceUsageRecorder {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Path rawResourcesPath;
    @NotNull
    private static final String TOOLS_NAMESPACE = "http://schemas.android.com/tools";

    public ToolsAttributeUsageRecorder(@NotNull Path rawResourcesPath) {
        Intrinsics.checkNotNullParameter((Object)rawResourcesPath, (String)"rawResourcesPath");
        this.rawResourcesPath = rawResourcesPath;
    }

    @NotNull
    public final Path getRawResourcesPath() {
        return this.rawResourcesPath;
    }

    @Override
    public void recordUsages(@NotNull ResourceShrinkerModel model) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        Files.walk(this.rawResourcesPath, new FileVisitOption[0]).filter(recordUsages.1.INSTANCE).forEach(new Consumer(this, model){
            final /* synthetic */ ToolsAttributeUsageRecorder this$0;
            final /* synthetic */ ResourceShrinkerModel $model;
            {
                this.this$0 = $receiver;
                this.$model = $model;
            }

            public final void accept(Path it) {
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                ToolsAttributeUsageRecorder.access$processRawXml(this.this$0, it, this.$model);
            }
        });
    }

    private final void processRawXml(Path path, ResourceShrinkerModel model) {
        this.processResourceToolsAttributes(path).forEach(new BiConsumer(model){
            final /* synthetic */ ResourceShrinkerModel $model;
            {
                this.$model = $model;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final void accept(@NotNull String key, @NotNull String value) {
                block9: {
                    Intrinsics.checkNotNullParameter((Object)key, (String)"key");
                    Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                    String string = key;
                    switch (string.hashCode()) {
                        case -1354971316: {
                            if (!string.equals("shrinkMode")) {
                                return;
                            }
                            break block9;
                        }
                        case 1671366814: {
                            if (string.equals("discard")) break;
                            return;
                        }
                        case 3287941: {
                            if (!string.equals("keep")) return;
                            this.$model.getResourceStore().recordKeepToolAttribute(value);
                            return;
                        }
                    }
                    this.$model.getResourceStore().recordDiscardToolAttribute(value);
                    return;
                }
                switch (value.hashCode()) {
                    case -891986231: {
                        if (!value.equals("strict")) return;
                        this.$model.getResourceStore().setSafeMode(false);
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Map<String, String> processResourceToolsAttributes(Path path) {
        Map toolsAttributes = new LinkedHashMap();
        Closeable closeable = XmlUtils.getUtfReader((Path)path);
        Throwable throwable = null;
        try {
            Reader reader = (Reader)closeable;
            boolean bl = false;
            XMLInputFactory factory2 = XMLInputFactory.newInstance();
            XMLStreamReader xmlStreamReader = factory2.createXMLStreamReader(reader);
            boolean rootElementProcessed = false;
            while (!rootElementProcessed && xmlStreamReader.hasNext()) {
                xmlStreamReader.next();
                if (!xmlStreamReader.isStartElement()) continue;
                if (Intrinsics.areEqual((Object)xmlStreamReader.getLocalName(), (Object)"resources")) {
                    int n = xmlStreamReader.getAttributeCount();
                    for (int i = 0; i < n; ++i) {
                        if (!Intrinsics.areEqual((Object)xmlStreamReader.getAttributeNamespace(i), (Object)TOOLS_NAMESPACE)) continue;
                        String string = xmlStreamReader.getAttributeLocalName(i);
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"xmlStreamReader.getAttributeLocalName(i)");
                        String string2 = xmlStreamReader.getAttributeValue(i);
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"xmlStreamReader.getAttributeValue(i)");
                        toolsAttributes.put(string, string2);
                    }
                }
                rootElementProcessed = true;
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        ImmutableMap immutableMap = ImmutableMap.copyOf((Map)toolsAttributes);
        Intrinsics.checkNotNullExpressionValue((Object)immutableMap, (String)"copyOf(toolsAttributes)");
        return (Map)immutableMap;
    }

    public static final /* synthetic */ void access$processRawXml(ToolsAttributeUsageRecorder $this, Path path, ResourceShrinkerModel model) {
        $this.processRawXml(path, model);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/android/build/shrinker/usages/ToolsAttributeUsageRecorder$Companion;", "", "()V", "TOOLS_NAMESPACE", "", "shrinker"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

