/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal;

import com.android.build.api.artifact.impl.InternalScopedArtifacts;
import com.android.build.gradle.internal.HostTestTaskManager;
import com.android.build.gradle.internal.component.HostTestCreationConfig;
import com.android.build.gradle.internal.component.VariantCreationConfig;
import com.android.build.gradle.internal.res.GenerateLibraryRFileTask;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.scope.MutableTaskContainer;
import com.android.build.gradle.internal.tasks.factory.GlobalTaskCreationConfig;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Project;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0006\u0010\u0010\u001a\u00020\rR\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0011"}, d2={"Lcom/android/build/gradle/internal/UnitTestTaskManager;", "Lcom/android/build/gradle/internal/HostTestTaskManager;", "project", "Lorg/gradle/api/Project;", "globalConfig", "Lcom/android/build/gradle/internal/tasks/factory/GlobalTaskCreationConfig;", "(Lorg/gradle/api/Project;Lcom/android/build/gradle/internal/tasks/factory/GlobalTaskCreationConfig;)V", "javaResMergingScopes", "", "Lcom/android/build/api/artifact/impl/InternalScopedArtifacts$InternalScope;", "getJavaResMergingScopes", "()Ljava/util/Set;", "createTasks", "", "hostTestCreationConfig", "Lcom/android/build/gradle/internal/component/HostTestCreationConfig;", "createTopLevelTasks", "gradle-core"})
public final class UnitTestTaskManager
extends HostTestTaskManager {
    @NotNull
    private final Set<InternalScopedArtifacts.InternalScope> javaResMergingScopes;

    public UnitTestTaskManager(@NotNull Project project, @NotNull GlobalTaskCreationConfig globalConfig2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)globalConfig2, (String)"globalConfig");
        super(project, globalConfig2);
        InternalScopedArtifacts.InternalScope[] internalScopeArray = new InternalScopedArtifacts.InternalScope[]{InternalScopedArtifacts.InternalScope.SUB_PROJECTS, InternalScopedArtifacts.InternalScope.EXTERNAL_LIBS};
        this.javaResMergingScopes = SetsKt.setOf((Object[])internalScopeArray);
    }

    public final void createTopLevelTasks() {
        super.createTopLevelTasksCore(this.globalConfig.getTaskNames().getTest(), "Run unit tests for all variants.");
    }

    public final void createTasks(@NotNull HostTestCreationConfig hostTestCreationConfig) {
        Intrinsics.checkNotNullParameter((Object)hostTestCreationConfig, (String)"hostTestCreationConfig");
        MutableTaskContainer taskContainer = hostTestCreationConfig.getTaskContainer();
        VariantCreationConfig testedVariant = hostTestCreationConfig.getMainVariant();
        boolean includeAndroidResources = this.globalConfig.getUnitTestOptions().isIncludeAndroidResources();
        this.createAnchorTasks(hostTestCreationConfig);
        this.createDependencyStreams(hostTestCreationConfig);
        this.createProcessJavaResTask(hostTestCreationConfig);
        if (includeAndroidResources) {
            this.setupAndroidRequiredTasks(testedVariant, hostTestCreationConfig);
            this.setupCompilationTaskDependencies(hostTestCreationConfig, taskContainer);
        } else if (testedVariant.getComponentType().isAar() && testedVariant.getBuildFeatures().getAndroidResources()) {
            this.taskFactory.register(new GenerateLibraryRFileTask.TestRuntimeStubRClassCreationAction(hostTestCreationConfig));
        }
        this.setupAssembleAndJavaCompilationTasks(hostTestCreationConfig, taskContainer, testedVariant, "assembleUnitTest");
        super.createRunHostTestTask(hostTestCreationConfig, this.globalConfig.getTaskNames().getTest(), "test", InternalArtifactType.UNIT_TEST_CODE_COVERAGE.INSTANCE);
    }

    @Override
    @NotNull
    protected Set<InternalScopedArtifacts.InternalScope> getJavaResMergingScopes() {
        return this.javaResMergingScopes;
    }
}

