/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.core.dsl.impl.features;

import com.android.build.api.dsl.BuildType;
import com.android.build.api.dsl.CommonExtension;
import com.android.build.api.dsl.ProductFlavor;
import com.android.build.gradle.internal.core.MergedExternalNativeBuildOptions;
import com.android.build.gradle.internal.core.MergedNdkConfig;
import com.android.build.gradle.internal.core.MergedOptions;
import com.android.build.gradle.internal.core.NativeBuiltType;
import com.android.build.gradle.internal.core.dsl.features.NativeBuildDslInfo;
import com.android.build.gradle.internal.core.dsl.impl.DslInfoUtilsKt;
import com.android.build.gradle.internal.core.dsl.impl.features.NativeBuildDslInfoImpl;
import com.android.build.gradle.internal.cxx.configure.ExperimentalPropertyExtensionsKt;
import com.android.build.gradle.internal.dsl.DefaultConfig;
import com.android.builder.core.ComponentType;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001BK\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u0012\u001e\u0010\u000b\u001a\u001a\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u00030\f\u00a2\u0006\u0002\u0010\rJ\b\u0010'\u001a\u00020(H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\u000b\u001a\u001a\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u00030\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R \u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00150\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0018\u001a\u00020\u00198VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u001aR\u0016\u0010\u001b\u001a\u0004\u0018\u00010\u001c8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR\u0014\u0010\u001f\u001a\u00020 X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00140$8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b%\u0010&\u00a8\u0006)"}, d2={"Lcom/android/build/gradle/internal/core/dsl/impl/features/NativeBuildDslInfoImpl;", "Lcom/android/build/gradle/internal/core/dsl/features/NativeBuildDslInfo;", "componentType", "Lcom/android/builder/core/ComponentType;", "defaultConfig", "Lcom/android/build/gradle/internal/dsl/DefaultConfig;", "buildTypeObj", "Lcom/android/build/api/dsl/BuildType;", "productFlavorList", "", "Lcom/android/build/api/dsl/ProductFlavor;", "extension", "Lcom/android/build/api/dsl/CommonExtension;", "(Lcom/android/builder/core/ComponentType;Lcom/android/build/gradle/internal/dsl/DefaultConfig;Lcom/android/build/api/dsl/BuildType;Ljava/util/List;Lcom/android/build/api/dsl/CommonExtension;)V", "externalNativeBuildOptions", "Lcom/android/build/gradle/internal/core/MergedExternalNativeBuildOptions;", "getExternalNativeBuildOptions", "()Lcom/android/build/gradle/internal/core/MergedExternalNativeBuildOptions;", "externalNativeExperimentalProperties", "", "", "", "getExternalNativeExperimentalProperties", "()Ljava/util/Map;", "isJniDebuggable", "", "()Z", "nativeBuildSystem", "Lcom/android/build/gradle/internal/core/NativeBuiltType;", "getNativeBuildSystem", "()Lcom/android/build/gradle/internal/core/NativeBuiltType;", "ndkConfig", "Lcom/android/build/gradle/internal/core/MergedNdkConfig;", "getNdkConfig", "()Lcom/android/build/gradle/internal/core/MergedNdkConfig;", "supportedAbis", "", "getSupportedAbis", "()Ljava/util/Set;", "mergeOptions", "", "gradle-core"})
public final class NativeBuildDslInfoImpl
implements NativeBuildDslInfo {
    @NotNull
    private final ComponentType componentType;
    @NotNull
    private final DefaultConfig defaultConfig;
    @NotNull
    private final BuildType buildTypeObj;
    @NotNull
    private final List<ProductFlavor> productFlavorList;
    @NotNull
    private final CommonExtension<?, ?, ?, ?, ?, ?> extension;
    @NotNull
    private final MergedNdkConfig ndkConfig;
    @NotNull
    private final MergedExternalNativeBuildOptions externalNativeBuildOptions;

    public NativeBuildDslInfoImpl(@NotNull ComponentType componentType, @NotNull DefaultConfig defaultConfig, @NotNull BuildType buildTypeObj, @NotNull List<? extends ProductFlavor> productFlavorList, @NotNull CommonExtension<?, ?, ?, ?, ?, ?> extension2) {
        Intrinsics.checkNotNullParameter((Object)componentType, (String)"componentType");
        Intrinsics.checkNotNullParameter((Object)defaultConfig, (String)"defaultConfig");
        Intrinsics.checkNotNullParameter((Object)buildTypeObj, (String)"buildTypeObj");
        Intrinsics.checkNotNullParameter(productFlavorList, (String)"productFlavorList");
        Intrinsics.checkNotNullParameter(extension2, (String)"extension");
        this.componentType = componentType;
        this.defaultConfig = defaultConfig;
        this.buildTypeObj = buildTypeObj;
        this.productFlavorList = productFlavorList;
        this.extension = extension2;
        this.ndkConfig = new MergedNdkConfig();
        this.externalNativeBuildOptions = new MergedExternalNativeBuildOptions();
        this.mergeOptions();
    }

    @Override
    @NotNull
    public MergedNdkConfig getNdkConfig() {
        return this.ndkConfig;
    }

    @Override
    @NotNull
    public MergedExternalNativeBuildOptions getExternalNativeBuildOptions() {
        return this.externalNativeBuildOptions;
    }

    @Override
    @NotNull
    public Map<String, Object> getExternalNativeExperimentalProperties() {
        Map mergedProperties = new LinkedHashMap();
        mergedProperties.putAll(this.extension.getExternalNativeBuild().getExperimentalProperties());
        Map<String, Object> map = this.getExternalNativeBuildOptions().getExternalNativeExperimentalProperties();
        Intrinsics.checkNotNullExpressionValue(map, (String)"getExternalNativeExperimentalProperties(...)");
        mergedProperties.putAll(map);
        return mergedProperties;
    }

    private final void mergeOptions() {
        DslInfoUtilsKt.computeMergedOptions(this.defaultConfig, this.buildTypeObj, this.productFlavorList, (MergedOptions)this.getNdkConfig(), mergeOptions.1.INSTANCE, mergeOptions.2.INSTANCE);
        DslInfoUtilsKt.computeMergedOptions(this.defaultConfig, this.buildTypeObj, this.productFlavorList, (MergedOptions)this.getExternalNativeBuildOptions(), mergeOptions.3.INSTANCE, mergeOptions.4.INSTANCE);
    }

    @Override
    public boolean isJniDebuggable() {
        return this.buildTypeObj.isJniDebuggable();
    }

    @Override
    @Nullable
    public NativeBuiltType getNativeBuildSystem() {
        if (ExperimentalPropertyExtensionsKt.getNinja(this.getExternalNativeExperimentalProperties()).getPath() != null) {
            return NativeBuiltType.NINJA;
        }
        if (this.extension.getExternalNativeBuild().getNdkBuild().getPath() != null) {
            return NativeBuiltType.NDK_BUILD;
        }
        if (this.extension.getExternalNativeBuild().getCmake().getPath() != null) {
            return NativeBuiltType.CMAKE;
        }
        return null;
    }

    @Override
    @NotNull
    public Set<String> getSupportedAbis() {
        Set<String> set;
        if (this.componentType.isDynamicFeature()) {
            set = SetsKt.emptySet();
        } else {
            Set<String> set2 = this.getNdkConfig().getAbiFilters();
            set = set2;
            Intrinsics.checkNotNullExpressionValue(set2, (String)"getAbiFilters(...)");
        }
        return set;
    }
}

