/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.cxx.logging;

import com.android.build.gradle.internal.cxx.logging.CxxStructuredLogCodecKt;
import com.android.build.gradle.internal.cxx.logging.NewList;
import com.android.build.gradle.internal.cxx.logging.NewString;
import com.android.build.gradle.internal.cxx.logging.PayloadHeader;
import com.android.build.gradle.internal.cxx.logging.StructuredLogRecord;
import com.android.build.gradle.internal.cxx.string.StringEncoder;
import com.android.build.gradle.internal.cxx.string.StringTable;
import com.google.common.base.Preconditions;
import com.google.protobuf.GeneratedMessageV3;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0016\u0010\u0016\u001a\u00020\u00132\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00150\u0018H\u0016J\u000e\u0010\u0019\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\u001bR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001c"}, d2={"Lcom/android/build/gradle/internal/cxx/logging/CxxStructuredLogEncoder;", "Lcom/android/build/gradle/internal/cxx/string/StringEncoder;", "Ljava/lang/AutoCloseable;", "file", "Ljava/io/File;", "(Ljava/io/File;)V", "getFile", "()Ljava/io/File;", "output", "Ljava/io/DataOutputStream;", "getOutput", "()Ljava/io/DataOutputStream;", "strings", "Lcom/android/build/gradle/internal/cxx/string/StringTable;", "getStrings", "()Lcom/android/build/gradle/internal/cxx/string/StringTable;", "close", "", "encode", "", "string", "", "encodeList", "list", "", "write", "message", "Lcom/google/protobuf/GeneratedMessageV3;", "gradle-core"})
@SourceDebugExtension(value={"SMAP\nCxxStructuredLogCodec.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CxxStructuredLogCodec.kt\ncom/android/build/gradle/internal/cxx/logging/CxxStructuredLogEncoder\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,328:1\n1549#2:329\n1620#2,3:330\n*S KotlinDebug\n*F\n+ 1 CxxStructuredLogCodec.kt\ncom/android/build/gradle/internal/cxx/logging/CxxStructuredLogEncoder\n*L\n138#1:329\n138#1:330,3\n*E\n"})
public final class CxxStructuredLogEncoder
implements StringEncoder,
AutoCloseable {
    @NotNull
    private final File file;
    @NotNull
    private final DataOutputStream output;
    @NotNull
    private final StringTable strings;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CxxStructuredLogEncoder(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        this.file = file;
        this.strings = new StringTable(1, null, null, null, null, 30, null);
        if (!this.file.exists()) {
            Preconditions.checkArgument((boolean)this.file.getParentFile().isDirectory());
            Closeable closeable = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(this.file)));
            Throwable throwable = null;
            try {
                DataOutputStream output2 = (DataOutputStream)closeable;
                boolean bl = false;
                output2.write(CxxStructuredLogCodecKt.access$getMAGIC$p());
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        if (this.file.exists()) {
            CxxStructuredLogCodecKt.access$streamCxxStructuredLogUntyped(this.file, this.strings, 2.INSTANCE);
        }
        this.output = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(this.file, true)));
    }

    @NotNull
    public final File getFile() {
        return this.file;
    }

    @NotNull
    public final DataOutputStream getOutput() {
        return this.output;
    }

    @NotNull
    public final StringTable getStrings() {
        return this.strings;
    }

    @Override
    public int encode(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        return this.strings.getIdCreateIfAbsent(string, (Function1<? super Integer, Unit>)((Function1)new Function1<Integer, Unit>(string, this){
            final /* synthetic */ String $string;
            final /* synthetic */ CxxStructuredLogEncoder this$0;
            {
                this.$string = $string;
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(int it) {
                StructuredLogRecord.newBuilder().setNewString(NewString.newBuilder().setData(this.$string).build()).build().writeDelimitedTo(this.this$0.getOutput());
            }
        }));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int encodeList(@NotNull List<String> list) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(list, (String)"list");
        Iterable $this$map$iv = list;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.encode((String)it));
        }
        List intList = (List)destination$iv$iv;
        return this.strings.getIdCreateIfAbsent(intList, (Function1<? super Integer, Unit>)((Function1)new Function1<Integer, Unit>((List<Integer>)intList, this){
            final /* synthetic */ List<Integer> $intList;
            final /* synthetic */ CxxStructuredLogEncoder this$0;
            {
                this.$intList = $intList;
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(int it) {
                StructuredLogRecord.newBuilder().setNewList(NewList.newBuilder().addAllData((Iterable<? extends Integer>)this.$intList).build()).build().writeDelimitedTo(this.this$0.getOutput());
            }
        }));
    }

    public final void write(@NotNull GeneratedMessageV3 message2) {
        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
        StructuredLogRecord.Builder builder = StructuredLogRecord.newBuilder();
        PayloadHeader.Builder builder2 = PayloadHeader.newBuilder().setTimeStampMs(System.currentTimeMillis());
        String string = message2.getClass().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        builder.setPayloadHeader(builder2.setTypeId(this.encode(string)).build()).build().writeDelimitedTo(this.output);
        message2.writeDelimitedTo((OutputStream)this.output);
    }

    @Override
    public void close() {
        this.output.flush();
        this.output.close();
    }
}

