/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.generators;

import com.android.build.api.variant.ResValue;
import com.android.ide.common.xml.XmlPrettyPrinter;
import com.android.resources.ResourceType;
import com.android.utils.XmlUtils;
import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableList;
import com.google.common.io.FileWriteMode;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u0000 \f2\u00020\u0001:\u0001\fB!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\u0002\u0010\bJ\u0006\u0010\n\u001a\u00020\u000bR\u000e\u0010\t\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/android/build/gradle/internal/generators/ResValueGenerator;", "", "genFolder", "Ljava/io/File;", "requests", "", "Lcom/android/build/api/variant/ResValue$Key;", "Lcom/android/build/api/variant/ResValue;", "(Ljava/io/File;Ljava/util/Map;)V", "folderPath", "generate", "", "Companion", "gradle-core"})
public final class ResValueGenerator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Map<ResValue.Key, ResValue> requests;
    @NotNull
    private final File folderPath;
    @NotNull
    public static final String RES_VALUE_FILENAME_XML = "gradleResValues.xml";
    @NotNull
    private static final List<ResourceType> RESOURCES_WITH_TAGS;

    public ResValueGenerator(@NotNull File genFolder, @NotNull Map<ResValue.Key, ResValue> requests) {
        Intrinsics.checkNotNullParameter((Object)genFolder, (String)"genFolder");
        Intrinsics.checkNotNullParameter(requests, (String)"requests");
        this.requests = requests;
        this.folderPath = new File(genFolder, "values");
    }

    /*
     * WARNING - void declaration
     */
    public final void generate() throws IOException, ParserConfigurationException {
        block9: {
            Iterator<Map.Entry<ResValue.Key, ResValue>> iterator2;
            void var8_11;
            File pkgFolder = this.folderPath;
            if (!pkgFolder.isDirectory() && !pkgFolder.mkdirs()) {
                throw new RuntimeException("Failed to create " + pkgFolder.getAbsolutePath());
            }
            File resFile = new File(pkgFolder, RES_VALUE_FILENAME_XML);
            DocumentBuilderFactory factory2 = DocumentBuilderFactory.newInstance();
            factory2.setNamespaceAware(true);
            factory2.setValidating(false);
            factory2.setIgnoringComments(true);
            DocumentBuilder builder = factory2.newDocumentBuilder();
            Document document = builder.newDocument();
            Element element = document.createElement("resources");
            Intrinsics.checkNotNullExpressionValue((Object)element, (String)"createElement(...)");
            Node rootNode = element;
            document.appendChild(rootNode);
            rootNode.appendChild(document.createTextNode("\n"));
            rootNode.appendChild(document.createComment("Automatically generated file. DO NOT MODIFY"));
            rootNode.appendChild(document.createTextNode("\n\n"));
            for (Map.Entry<ResValue.Key, ResValue> object2 : this.requests.entrySet()) {
                ResValue.Key key = object2.getKey();
                ResValue value = object2.getValue();
                if (value.getComment() != null) {
                    String string;
                    String it = string;
                    boolean bl = false;
                    rootNode.appendChild(document.createTextNode("\n"));
                    rootNode.appendChild(document.createComment(it));
                    rootNode.appendChild(document.createTextNode("\n"));
                }
                String type = key.getType();
                ResourceType resourceType = ResourceType.fromClassName((String)type);
                if (resourceType == null && Intrinsics.areEqual((Object)"declare-styleable", (Object)type)) {
                    resourceType = ResourceType.STYLEABLE;
                }
                boolean hasResourceTag = resourceType != null && RESOURCES_WITH_TAGS.contains(resourceType);
                Element element2 = document.createElement(hasResourceTag ? type : "item");
                Intrinsics.checkNotNullExpressionValue((Object)element2, (String)"createElement(...)");
                Node itemNode = element2;
                Attr nameAttr = document.createAttribute("name");
                nameAttr.setValue(key.getName());
                itemNode.getAttributes().setNamedItem(nameAttr);
                if (!hasResourceTag) {
                    Attr typeAttr = document.createAttribute("type");
                    typeAttr.setValue(type);
                    itemNode.getAttributes().setNamedItem(typeAttr);
                }
                if (resourceType == ResourceType.STRING) {
                    Attr translatable = document.createAttribute("translatable");
                    translatable.setValue("false");
                    itemNode.getAttributes().setNamedItem(translatable);
                }
                if (((CharSequence)value.getValue()).length() > 0) {
                    itemNode.appendChild(document.createTextNode(value.getValue()));
                }
                rootNode.appendChild(itemNode);
            }
            try {
                String string = XmlPrettyPrinter.prettyPrint((Node)document, (boolean)true);
            }
            catch (Throwable t) {
                String string = XmlUtils.toXml((Node)document);
            }
            Iterator<Map.Entry<ResValue.Key, ResValue>> object3 = var8_11;
            if (object3 == null) break block9;
            Iterator<Map.Entry<ResValue.Key, ResValue>> it = iterator2 = object3;
            boolean bl = false;
            Files.asCharSink((File)resFile, (Charset)Charsets.UTF_8, (FileWriteMode[])new FileWriteMode[0]).write((CharSequence)((Object)it));
        }
    }

    static {
        ImmutableList immutableList = ImmutableList.of((Object)ResourceType.ARRAY, (Object)ResourceType.ATTR, (Object)ResourceType.BOOL, (Object)ResourceType.COLOR, (Object)ResourceType.STYLEABLE, (Object)ResourceType.DIMEN, (Object)ResourceType.FRACTION, (Object)ResourceType.INTEGER, (Object)ResourceType.PLURALS, (Object)ResourceType.STRING, (Object)ResourceType.STYLE);
        Intrinsics.checkNotNullExpressionValue((Object)immutableList, (String)"of(...)");
        RESOURCES_WITH_TAGS = (List)immutableList;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/android/build/gradle/internal/generators/ResValueGenerator$Companion;", "", "()V", "RESOURCES_WITH_TAGS", "", "Lcom/android/resources/ResourceType;", "RES_VALUE_FILENAME_XML", "", "gradle-core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

