/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks;

import com.android.build.gradle.internal.utils.GuavaKtxKt;
import com.android.builder.files.SerializableChange;
import com.android.builder.files.SerializableFileChanges;
import com.android.builder.files.SerializableInputChanges;
import com.android.ide.common.resources.FileStatus;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileSystemLocation;
import org.gradle.api.file.FileType;
import org.gradle.api.provider.Provider;
import org.gradle.work.ChangeType;
import org.gradle.work.FileChange;
import org.gradle.work.InputChanges;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000<\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u001c\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0002\u001a\u0012\u0010\u0006\u001a\u00020\u0007*\u00020\b2\u0006\u0010\t\u001a\u00020\n\u001a\u001a\u0010\u0006\u001a\u00020\u0007*\u00020\b2\u000e\u0010\t\u001a\n\u0012\u0006\b\u0001\u0012\u00020\f0\u000b\u001a\u0010\u0010\r\u001a\u00020\u000e*\b\u0012\u0004\u0012\u00020\u00050\u0004\u001a\n\u0010\r\u001a\u00020\u000f*\u00020\u0010\u001a\n\u0010\r\u001a\u00020\u0002*\u00020\u0005\u00a8\u0006\u0011"}, d2={"convert", "", "Lcom/android/builder/files/SerializableChange;", "changes", "", "Lorg/gradle/work/FileChange;", "getChangesInSerializableForm", "Lcom/android/builder/files/SerializableInputChanges;", "Lorg/gradle/work/InputChanges;", "input", "Lorg/gradle/api/file/FileCollection;", "Lorg/gradle/api/provider/Provider;", "Lorg/gradle/api/file/FileSystemLocation;", "toSerializable", "Lcom/android/builder/files/SerializableFileChanges;", "Lcom/android/ide/common/resources/FileStatus;", "Lorg/gradle/work/ChangeType;", "gradle-core"})
@JvmName(name="IncrementalChangesUtils")
@SourceDebugExtension(value={"SMAP\nIncrementalChangesUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IncrementalChangesUtils.kt\ncom/android/build/gradle/tasks/IncrementalChangesUtils\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,83:1\n1549#2:84\n1620#2,3:85\n*S KotlinDebug\n*F\n+ 1 IncrementalChangesUtils.kt\ncom/android/build/gradle/tasks/IncrementalChangesUtils\n*L\n81#1:84\n81#1:85,3\n*E\n"})
public final class IncrementalChangesUtils {
    @NotNull
    public static final SerializableInputChanges getChangesInSerializableForm(@NotNull InputChanges $this$getChangesInSerializableForm, @NotNull Provider<? extends FileSystemLocation> input) {
        Intrinsics.checkNotNullParameter((Object)$this$getChangesInSerializableForm, (String)"<this>");
        Intrinsics.checkNotNullParameter(input, (String)"input");
        ImmutableList immutableList = ImmutableList.of((Object)((FileSystemLocation)input.get()).getAsFile());
        Intrinsics.checkNotNullExpressionValue((Object)immutableList, (String)"of(...)");
        List list = (List)immutableList;
        Iterable iterable = $this$getChangesInSerializableForm.getFileChanges(input);
        Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"getFileChanges(...)");
        return new SerializableInputChanges(list, IncrementalChangesUtils.convert(iterable));
    }

    @NotNull
    public static final SerializableInputChanges getChangesInSerializableForm(@NotNull InputChanges $this$getChangesInSerializableForm, @NotNull FileCollection input) {
        Intrinsics.checkNotNullParameter((Object)$this$getChangesInSerializableForm, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Set set = input.getFiles();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"getFiles(...)");
        List list = (List)GuavaKtxKt.toImmutableList(set);
        Iterable iterable = $this$getChangesInSerializableForm.getFileChanges(input);
        Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"getFileChanges(...)");
        return new SerializableInputChanges(list, IncrementalChangesUtils.convert(iterable));
    }

    private static final Collection<SerializableChange> convert(Iterable<? extends FileChange> changes) {
        ArrayList<SerializableChange> arrayList;
        ArrayList<SerializableChange> collection = arrayList = new ArrayList<SerializableChange>();
        boolean bl = false;
        for (FileChange fileChange : changes) {
            if (fileChange.getFileType() != FileType.FILE) continue;
            collection.add(IncrementalChangesUtils.toSerializable(fileChange));
        }
        Collection<SerializableChange> collection2 = Collections.unmodifiableCollection((Collection)arrayList);
        Intrinsics.checkNotNullExpressionValue(collection2, (String)"unmodifiableCollection(...)");
        return collection2;
    }

    @NotNull
    public static final FileStatus toSerializable(@NotNull ChangeType $this$toSerializable) {
        FileStatus fileStatus;
        Intrinsics.checkNotNullParameter((Object)$this$toSerializable, (String)"<this>");
        switch (WhenMappings.$EnumSwitchMapping$0[$this$toSerializable.ordinal()]) {
            case 1: {
                fileStatus = FileStatus.NEW;
                break;
            }
            case 2: {
                fileStatus = FileStatus.CHANGED;
                break;
            }
            case 3: {
                fileStatus = FileStatus.REMOVED;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return fileStatus;
    }

    @NotNull
    public static final SerializableChange toSerializable(@NotNull FileChange $this$toSerializable) {
        Intrinsics.checkNotNullParameter((Object)$this$toSerializable, (String)"<this>");
        File file = $this$toSerializable.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getFile(...)");
        ChangeType changeType = $this$toSerializable.getChangeType();
        Intrinsics.checkNotNullExpressionValue((Object)changeType, (String)"getChangeType(...)");
        FileStatus fileStatus = IncrementalChangesUtils.toSerializable(changeType);
        String string = $this$toSerializable.getNormalizedPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getNormalizedPath(...)");
        return new SerializableChange(file, fileStatus, string);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final SerializableFileChanges toSerializable(@NotNull Iterable<? extends FileChange> $this$toSerializable) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$toSerializable, (String)"<this>");
        Iterable<? extends FileChange> $this$map$iv = $this$toSerializable;
        boolean $i$f$map = false;
        Iterable<? extends FileChange> iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            FileChange fileChange = (FileChange)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(IncrementalChangesUtils.toSerializable((FileChange)it));
        }
        List list = (List)destination$iv$iv;
        return new SerializableFileChanges(list);
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ChangeType.values().length];
            try {
                nArray[ChangeType.ADDED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ChangeType.MODIFIED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ChangeType.REMOVED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

