/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.api.artifact.SingleArtifact;
import com.android.build.api.artifact.impl.ArtifactsImpl;
import com.android.build.api.variant.FilterConfiguration;
import com.android.build.api.variant.impl.AndroidResourcesImpl;
import com.android.build.api.variant.impl.BuiltArtifactImpl;
import com.android.build.api.variant.impl.BuiltArtifactsImpl;
import com.android.build.api.variant.impl.BuiltArtifactsLoaderImpl;
import com.android.build.gradle.internal.component.HostTestCreationConfig;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.tasks.BuildAnalyzer;
import com.android.build.gradle.internal.tasks.NonIncrementalTask;
import com.android.build.gradle.internal.tasks.PackageForHostTest;
import com.android.build.gradle.internal.tasks.factory.VariantTaskCreationAction;
import com.android.build.gradle.internal.utils.HasConfigurableValuesKt;
import com.android.buildanalyzer.common.TaskCategory;
import com.android.builder.internal.packaging.ApkFlinger;
import com.android.builder.packaging.PackagingUtils;
import com.android.tools.build.apkzlib.zfile.ApkCreatorFactory;
import com.android.tools.build.apkzlib.zfile.NativeLibrariesPackagingMode;
import com.android.utils.FileUtils;
import com.android.utils.PathUtils;
import com.google.common.base.Joiner;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Collection;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gradle.api.Task;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.work.DisableCachingByDefault;
import org.jetbrains.annotations.NotNull;

@DisableCachingByDefault(because="Simple merging task")
@BuildAnalyzer(primaryTaskCategory=TaskCategory.TEST, secondaryTaskCategories={TaskCategory.APK_PACKAGING})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b'\u0018\u00002\u00020\u0001:\u0001\u001aB\u0005\u00a2\u0006\u0002\u0010\u0002J\u001b\u0010\u0012\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015H\u0000\u00a2\u0006\u0002\b\u0017J\b\u0010\u0018\u001a\u00020\u0019H\u0014R\u0014\u0010\u0003\u001a\u00020\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\b8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\b8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\n\u00a8\u0006\u001b"}, d2={"Lcom/android/build/gradle/internal/tasks/PackageForHostTest;", "Lcom/android/build/gradle/internal/tasks/NonIncrementalTask;", "()V", "apkForHostTest", "Lorg/gradle/api/file/RegularFileProperty;", "getApkForHostTest", "()Lorg/gradle/api/file/RegularFileProperty;", "mergedAssetsDirectory", "Lorg/gradle/api/file/DirectoryProperty;", "getMergedAssetsDirectory", "()Lorg/gradle/api/file/DirectoryProperty;", "noCompress", "Lorg/gradle/api/provider/ListProperty;", "", "getNoCompress", "()Lorg/gradle/api/provider/ListProperty;", "resApk", "getResApk", "apkFrom", "Ljava/io/File;", "compiledResourcesZip", "Lorg/gradle/api/provider/Provider;", "Lorg/gradle/api/file/Directory;", "apkFrom$gradle_core", "doTaskAction", "", "CreationAction", "gradle-core"})
@SourceDebugExtension(value={"SMAP\nPackageForUnitTest.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PackageForUnitTest.kt\ncom/android/build/gradle/internal/tasks/PackageForHostTest\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,183:1\n1855#2,2:184\n1855#2,2:186\n*S KotlinDebug\n*F\n+ 1 PackageForUnitTest.kt\ncom/android/build/gradle/internal/tasks/PackageForHostTest\n*L\n125#1:184,2\n141#1:186,2\n*E\n"})
public abstract class PackageForHostTest
extends NonIncrementalTask {
    @InputFiles
    @PathSensitive(value=PathSensitivity.NONE)
    @NotNull
    public abstract DirectoryProperty getResApk();

    @InputFiles
    @PathSensitive(value=PathSensitivity.NONE)
    @NotNull
    public abstract DirectoryProperty getMergedAssetsDirectory();

    @Input
    @Optional
    @NotNull
    public abstract ListProperty<String> getNoCompress();

    @OutputFile
    @NotNull
    public abstract RegularFileProperty getApkForHostTest();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doTaskAction() {
        File apkForHostTest = ((RegularFile)this.getApkForHostTest().get()).getAsFile();
        FileUtils.copyFile((File)this.apkFrom$gradle_core((Provider<Directory>)((Provider)this.getResApk())), (File)apkForHostTest);
        ApkCreatorFactory.CreationData.Builder builder = ApkCreatorFactory.CreationData.builder().setApkPath(apkForHostTest).setNativeLibrariesPackagingMode(NativeLibrariesPackagingMode.COMPRESSED);
        Predicate predicate2 = PackagingUtils.getNoCompressPredicateForJavaRes((Collection)((Collection)this.getNoCompress().get()));
        Intrinsics.checkNotNullExpressionValue((Object)predicate2, (String)"getNoCompressPredicateForJavaRes(...)");
        Predicate predicate3 = predicate2;
        ApkCreatorFactory.CreationData creationData2 = builder.setNoCompressPredicate(new com.google.common.base.Predicate(predicate3){
            final /* synthetic */ Predicate<String> $tmp0;
            {
                this.$tmp0 = $tmp0;
            }

            public final boolean apply(String p0) {
                return this.$tmp0.test(p0);
            }
        }).build();
        Path apkAssetsPath = Paths.get("assets", new String[0]);
        File mergedAssets = ((Directory)this.getMergedAssetsDirectory().get()).getAsFile();
        if (!mergedAssets.exists()) {
            return;
        }
        Path mergedAssetsPath = mergedAssets.toPath();
        Intrinsics.checkNotNull((Object)creationData2);
        Closeable closeable = (Closeable)new ApkFlinger(creationData2, 1, false, false, false, 0L, 60, null);
        Throwable throwable = null;
        try {
            ApkFlinger apkCreator = (ApkFlinger)closeable;
            boolean bl = false;
            Path path = Files.walkFileTree(mergedAssetsPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(mergedAssetsPath, apkAssetsPath, apkCreator){
                final /* synthetic */ Path $mergedAssetsPath;
                final /* synthetic */ Path $apkAssetsPath;
                final /* synthetic */ ApkFlinger $apkCreator;
                {
                    this.$mergedAssetsPath = $mergedAssetsPath;
                    this.$apkAssetsPath = $apkAssetsPath;
                    this.$apkCreator = $apkCreator;
                }

                @NotNull
                public FileVisitResult visitFile(@NotNull Path path, @NotNull BasicFileAttributes basicFileAttributes) throws IOException {
                    Intrinsics.checkNotNullParameter((Object)path, (String)"path");
                    Intrinsics.checkNotNullParameter((Object)basicFileAttributes, (String)"basicFileAttributes");
                    String relativePath = PathUtils.toSystemIndependentPath((Path)this.$mergedAssetsPath.relativize(path));
                    String destPath = PathUtils.toSystemIndependentPath((Path)this.$apkAssetsPath.resolve(relativePath));
                    File file = path.toFile();
                    Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
                    Intrinsics.checkNotNull((Object)destPath);
                    this.$apkCreator.writeFile(file, destPath);
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    @NotNull
    public final File apkFrom$gradle_core(@NotNull Provider<Directory> compiledResourcesZip) {
        Intrinsics.checkNotNullParameter(compiledResourcesZip, (String)"compiledResourcesZip");
        BuiltArtifactsImpl builtArtifactsImpl = new BuiltArtifactsLoaderImpl().load(compiledResourcesZip);
        if (builtArtifactsImpl == null) {
            throw new RuntimeException("Cannot load resources from " + compiledResourcesZip);
        }
        BuiltArtifactsImpl builtArtifacts = builtArtifactsImpl;
        if (builtArtifacts.getElements().size() == 1) {
            return new File(((BuiltArtifactImpl)CollectionsKt.first((Iterable)builtArtifacts.getElements())).getOutputFile());
        }
        Iterable $this$forEach$iv = builtArtifacts.getElements();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            BuiltArtifactImpl builtArtifact = (BuiltArtifactImpl)element$iv;
            boolean bl = false;
            if (builtArtifact.getFilters().isEmpty()) {
                return new File(builtArtifact.getOutputFile());
            }
            if (builtArtifact.getFilters().size() != 1 || builtArtifact.getFilter(FilterConfiguration.FilterType.ABI) == null) continue;
            return new File(builtArtifact.getOutputFile());
        }
        if (builtArtifacts.getElements().isEmpty()) {
            throw new RuntimeException("No resources build output, please file a bug.");
        }
        StringBuilder sb = new StringBuilder("Found following build outputs : \n");
        Iterable $this$forEach$iv2 = builtArtifacts.getElements();
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv2) {
            BuiltArtifactImpl it = (BuiltArtifactImpl)element$iv;
            boolean bl = false;
            sb.append("BuildOutput: " + Joiner.on((char)',').join((Iterable)it.getFilters()) + "\n");
        }
        sb.append("Cannot find a build output with all resources, please file a bug.");
        throw new RuntimeException(sb.toString());
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0002H\u0016J\u0016\u0010\u0011\u001a\u00020\u000f2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00020\u0013H\u0016R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0014"}, d2={"Lcom/android/build/gradle/internal/tasks/PackageForHostTest$CreationAction;", "Lcom/android/build/gradle/internal/tasks/factory/VariantTaskCreationAction;", "Lcom/android/build/gradle/internal/tasks/PackageForHostTest;", "Lcom/android/build/gradle/internal/component/HostTestCreationConfig;", "creationConfig", "(Lcom/android/build/gradle/internal/component/HostTestCreationConfig;)V", "name", "", "getName", "()Ljava/lang/String;", "type", "Ljava/lang/Class;", "getType", "()Ljava/lang/Class;", "configure", "", "task", "handleProvider", "taskProvider", "Lorg/gradle/api/tasks/TaskProvider;", "gradle-core"})
    public static final class CreationAction
    extends VariantTaskCreationAction<PackageForHostTest, HostTestCreationConfig> {
        @NotNull
        private final String name;
        @NotNull
        private final Class<PackageForHostTest> type;

        public CreationAction(@NotNull HostTestCreationConfig creationConfig) {
            Intrinsics.checkNotNullParameter((Object)creationConfig, (String)"creationConfig");
            super(creationConfig, false, 2, null);
            this.name = this.computeTaskName("package", "For" + creationConfig.getComponentType().getSuffix());
            this.type = PackageForHostTest.class;
        }

        @Override
        @NotNull
        public String getName() {
            return this.name;
        }

        @Override
        @NotNull
        public Class<PackageForHostTest> getType() {
            return this.type;
        }

        @Override
        public void handleProvider(@NotNull TaskProvider<PackageForHostTest> taskProvider) {
            Intrinsics.checkNotNullParameter(taskProvider, (String)"taskProvider");
            super.handleProvider(taskProvider);
            ((HostTestCreationConfig)this.creationConfig).getArtifacts().setInitialProvider(taskProvider, (Function1)handleProvider.1.INSTANCE).withName("apk-for-local-test.ap_").on(InternalArtifactType.APK_FOR_LOCAL_TEST.INSTANCE);
        }

        @Override
        public void configure(@NotNull PackageForHostTest task) {
            block0: {
                Intrinsics.checkNotNullParameter((Object)task, (String)"task");
                super.configure((Task)task);
                ArtifactsImpl artifacts2 = ((HostTestCreationConfig)this.creationConfig).getArtifacts();
                artifacts2.setTaskInputToFinalProduct(InternalArtifactType.LINKED_RESOURCES_BINARY_FORMAT.INSTANCE, (Property)task.getResApk());
                HasConfigurableValuesKt.setDisallowChanges((Property)task.getMergedAssetsDirectory(), artifacts2.get((SingleArtifact)SingleArtifact.ASSETS.INSTANCE));
                AndroidResourcesImpl androidResourcesImpl = ((HostTestCreationConfig)this.creationConfig).getAndroidResources();
                if (androidResourcesImpl == null) break block0;
                AndroidResourcesImpl it = androidResourcesImpl;
                boolean bl = false;
                HasConfigurableValuesKt.setDisallowChanges(task.getNoCompress(), (Provider)it.getNoCompress());
            }
        }
    }
}

