/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.res;

import com.android.build.api.artifact.ArtifactTransformationRequest;
import com.android.build.api.variant.BuiltArtifact;
import com.android.build.api.variant.MultiOutputHandler;
import com.android.build.gradle.internal.component.ApkCreationConfig;
import com.android.build.gradle.internal.res.ConvertResourcesAction;
import com.android.build.gradle.internal.res.ConvertResourcesParams;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.services.Aapt2Input;
import com.android.build.gradle.internal.tasks.BuildAnalyzer;
import com.android.build.gradle.internal.tasks.NonIncrementalTask;
import com.android.build.gradle.internal.tasks.factory.VariantTaskCreationAction;
import com.android.build.gradle.internal.utils.HasConfigurableValuesKt;
import com.android.buildanalyzer.common.TaskCategory;
import java.io.File;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.Task;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.workers.WorkQueue;
import org.jetbrains.annotations.NotNull;

@CacheableTask
@BuildAnalyzer(primaryTaskCategory=TaskCategory.ANDROID_RESOURCES)
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b7\u0018\u0000*\u000e\b\u0000\u0010\u0001*\b\u0012\u0004\u0012\u0002H\u00010\u00002\u00020\u0002:\u0001!B\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u001f\u001a\u00020 H\u0014R\u0014\u0010\u0004\u001a\u00020\u00058gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R \u0010\b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\n0\t8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000e8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\t8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\fR\u001a\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00158gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0019\u001a\u00020\u001a8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u0014\u0010\u001d\u001a\u00020\u001a8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001c\u0082\u0001\u0002\"#\u00a8\u0006$"}, d2={"Lcom/android/build/gradle/internal/res/ConvertResourcesTask;", "TaskT", "Lcom/android/build/gradle/internal/tasks/NonIncrementalTask;", "()V", "aapt2Input", "Lcom/android/build/gradle/internal/services/Aapt2Input;", "getAapt2Input", "()Lcom/android/build/gradle/internal/services/Aapt2Input;", "artifactTransformationRequest", "Lorg/gradle/api/provider/Property;", "Lcom/android/build/api/artifact/ArtifactTransformationRequest;", "getArtifactTransformationRequest", "()Lorg/gradle/api/provider/Property;", "convertToProto", "", "getConvertToProto", "()Z", "multiOutputHandler", "Lcom/android/build/api/variant/MultiOutputHandler;", "getMultiOutputHandler", "outputArtifactType", "Lcom/android/build/gradle/internal/scope/InternalArtifactType;", "Lorg/gradle/api/file/Directory;", "getOutputArtifactType", "()Lcom/android/build/gradle/internal/scope/InternalArtifactType;", "resourcesInputDir", "Lorg/gradle/api/file/DirectoryProperty;", "getResourcesInputDir", "()Lorg/gradle/api/file/DirectoryProperty;", "resourcesOutputDir", "getResourcesOutputDir", "doTaskAction", "", "CreationAction", "Lcom/android/build/gradle/internal/res/ConvertLinkedResourcesToProtoTask;", "Lcom/android/build/gradle/internal/res/ConvertShrunkResourcesToBinaryTask;", "gradle-core"})
public abstract class ConvertResourcesTask<TaskT extends ConvertResourcesTask<TaskT>>
extends NonIncrementalTask {
    private ConvertResourcesTask() {
    }

    @InputDirectory
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @NotNull
    public abstract DirectoryProperty getResourcesInputDir();

    @OutputDirectory
    @NotNull
    public abstract DirectoryProperty getResourcesOutputDir();

    @Internal
    public abstract boolean getConvertToProto();

    @Internal
    @NotNull
    public abstract InternalArtifactType<Directory> getOutputArtifactType();

    @Internal
    @NotNull
    public abstract Property<ArtifactTransformationRequest<TaskT>> getArtifactTransformationRequest();

    @Nested
    @NotNull
    public abstract Property<MultiOutputHandler> getMultiOutputHandler();

    @Nested
    @NotNull
    public abstract Aapt2Input getAapt2Input();

    @Override
    protected void doTaskAction() {
        ArtifactTransformationRequest artifactTransformationRequest = (ArtifactTransformationRequest)this.getArtifactTransformationRequest().get();
        Intrinsics.checkNotNull((Object)this, (String)"null cannot be cast to non-null type TaskT of com.android.build.gradle.internal.res.ConvertResourcesTask");
        Task task = (Task)this;
        WorkQueue workQueue2 = this.getWorkerExecutor().noIsolation();
        Intrinsics.checkNotNullExpressionValue((Object)workQueue2, (String)"noIsolation(...)");
        artifactTransformationRequest.submit(task, workQueue2, ConvertResourcesAction.class, (Function3)new Function3<BuiltArtifact, Directory, ConvertResourcesParams, File>(this){
            final /* synthetic */ ConvertResourcesTask<TaskT> this$0;
            {
                this.this$0 = $receiver;
                super(3);
            }

            @NotNull
            public final File invoke(@NotNull BuiltArtifact builtArtifact, @NotNull Directory outputDir, @NotNull ConvertResourcesParams parameters) {
                Intrinsics.checkNotNullParameter((Object)builtArtifact, (String)"builtArtifact");
                Intrinsics.checkNotNullParameter((Object)outputDir, (String)"outputDir");
                Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
                parameters.getResourcesInputFile().set(new File(builtArtifact.getOutputFile()));
                RegularFileProperty regularFileProperty = parameters.getResourcesOutputFile();
                File file = outputDir.getAsFile();
                MultiOutputHandler multiOutputHandler = (MultiOutputHandler)this.this$0.getMultiOutputHandler().get();
                String string = this.this$0.getOutputArtifactType().name().toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
                regularFileProperty.set(new File(file, multiOutputHandler.getOutputNameForSplit(StringsKt.replace$default((String)string, (String)"_", (String)"-", (boolean)false, (int)4, null), "", builtArtifact.getOutputType(), builtArtifact.getFilters()) + ".ap_"));
                parameters.getConvertToProto().set((Object)this.this$0.getConvertToProto());
                parameters.getAapt2Input().set((Object)this.this$0.getAapt2Input());
                File file2 = ((RegularFile)parameters.getResourcesOutputFile().get()).getAsFile();
                Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"getAsFile(...)");
                return file2;
            }
        });
    }

    public /* synthetic */ ConvertResourcesTask(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000*\u000e\b\u0001\u0010\u0001*\b\u0012\u0004\u0012\u0002H\u00010\u00022\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u00020\u00040\u0003B\u000f\b\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0006J\u0015\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010\u0010R \u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00010\bX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\f\u0082\u0001\u0002\u0011\u0012\u00a8\u0006\u0013"}, d2={"Lcom/android/build/gradle/internal/res/ConvertResourcesTask$CreationAction;", "TaskT", "Lcom/android/build/gradle/internal/res/ConvertResourcesTask;", "Lcom/android/build/gradle/internal/tasks/factory/VariantTaskCreationAction;", "Lcom/android/build/gradle/internal/component/ApkCreationConfig;", "creationConfig", "(Lcom/android/build/gradle/internal/component/ApkCreationConfig;)V", "transformationRequest", "Lcom/android/build/api/artifact/ArtifactTransformationRequest;", "getTransformationRequest", "()Lcom/android/build/api/artifact/ArtifactTransformationRequest;", "setTransformationRequest", "(Lcom/android/build/api/artifact/ArtifactTransformationRequest;)V", "configure", "", "task", "(Lcom/android/build/gradle/internal/res/ConvertResourcesTask;)V", "Lcom/android/build/gradle/internal/res/ConvertLinkedResourcesToProtoTask$CreationAction;", "Lcom/android/build/gradle/internal/res/ConvertShrunkResourcesToBinaryTask$CreationAction;", "gradle-core"})
    public static abstract class CreationAction<TaskT extends ConvertResourcesTask<TaskT>>
    extends VariantTaskCreationAction<TaskT, ApkCreationConfig> {
        public ArtifactTransformationRequest<TaskT> transformationRequest;

        private CreationAction(ApkCreationConfig creationConfig) {
            super(creationConfig, false, 2, null);
        }

        @NotNull
        public final ArtifactTransformationRequest<TaskT> getTransformationRequest() {
            ArtifactTransformationRequest<TaskT> artifactTransformationRequest = this.transformationRequest;
            if (artifactTransformationRequest != null) {
                return artifactTransformationRequest;
            }
            Intrinsics.throwUninitializedPropertyAccessException((String)"transformationRequest");
            return null;
        }

        public final void setTransformationRequest(@NotNull ArtifactTransformationRequest<TaskT> artifactTransformationRequest) {
            Intrinsics.checkNotNullParameter(artifactTransformationRequest, (String)"<set-?>");
            this.transformationRequest = artifactTransformationRequest;
        }

        @Override
        public void configure(@NotNull TaskT task) {
            Intrinsics.checkNotNullParameter(task, (String)"task");
            super.configure((Task)task);
            HasConfigurableValuesKt.setDisallowChanges(((ConvertResourcesTask)task).getArtifactTransformationRequest(), this.getTransformationRequest());
            HasConfigurableValuesKt.setDisallowChanges(((ConvertResourcesTask)task).getMultiOutputHandler(), MultiOutputHandler.Companion.create(this.creationConfig));
            ((ApkCreationConfig)this.creationConfig).getServices().initializeAapt2Input(((ConvertResourcesTask)task).getAapt2Input(), (Task)task);
        }

        public /* synthetic */ CreationAction(ApkCreationConfig creationConfig, DefaultConstructorMarker $constructor_marker) {
            this(creationConfig);
        }
    }
}

