/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.transforms;

import com.android.build.gradle.internal.transforms.ShrinkAppBundleResourcesTask;
import com.android.build.gradle.internal.transforms.ShrinkProtoResourcesParams;
import com.android.build.gradle.internal.workeractions.WorkActionAdapter;
import com.android.build.shrinker.LinkedResourcesFormat;
import com.android.build.shrinker.LoggerAndFileDebugReporter;
import com.android.build.shrinker.ResourceShrinkerImpl;
import com.android.build.shrinker.ShrinkerDebugReporter;
import com.android.build.shrinker.gatherer.ProtoResourceTableGatherer;
import com.android.build.shrinker.graph.ProtoResourcesGraphBuilder;
import com.android.build.shrinker.obfuscation.ObfuscationMappingsRecorder;
import com.android.build.shrinker.obfuscation.ProguardMappingsRecorder;
import com.android.build.shrinker.usages.DexUsageRecorder;
import com.android.build.shrinker.usages.ProtoAndroidManifestUsageRecorder;
import com.android.build.shrinker.usages.ToolsAttributeUsageRecorder;
import com.android.utils.FileUtils;
import java.io.Closeable;
import java.io.File;
import java.io.Serializable;
import java.nio.file.FileSystem;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gradle.api.file.RegularFile;
import org.gradle.api.logging.LogLevel;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\b&\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0007\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002R\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/android/build/gradle/internal/transforms/ShrinkProtoResourcesAction;", "Lcom/android/build/gradle/internal/workeractions/WorkActionAdapter;", "Lcom/android/build/gradle/internal/transforms/ShrinkProtoResourcesParams;", "()V", "logger", "Lorg/gradle/api/logging/Logger;", "kotlin.jvm.PlatformType", "doExecute", "", "toKbString", "", "size", "", "gradle-core"})
@SourceDebugExtension(value={"SMAP\nShrinkResourcesNewShrinkerTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ShrinkResourcesNewShrinkerTask.kt\ncom/android/build/gradle/internal/transforms/ShrinkProtoResourcesAction\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,276:1\n1549#2:277\n1620#2,3:278\n1#3:281\n*S KotlinDebug\n*F\n+ 1 ShrinkResourcesNewShrinkerTask.kt\ncom/android/build/gradle/internal/transforms/ShrinkProtoResourcesAction\n*L\n216#1:277\n216#1:278,3\n*E\n"})
public abstract class ShrinkProtoResourcesAction
implements WorkActionAdapter<ShrinkProtoResourcesParams> {
    private final Logger logger = Logging.getLogger(ShrinkAppBundleResourcesTask.class);

    @Inject
    public ShrinkProtoResourcesAction() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public void doExecute() {
        File originalProtoFile = ((RegularFile)((ShrinkProtoResourcesParams)this.getParameters()).getOriginalProtoFile().get()).getAsFile();
        File shrunkProtoFile = ((RegularFile)((ShrinkProtoResourcesParams)this.getParameters()).getShrunkProtoFile().get()).getAsFile();
        Closeable closeable = FileUtils.createZipFilesystem((Path)originalProtoFile.toPath());
        Throwable throwable = null;
        try {
            ProguardMappingsRecorder proguardMappingsRecorder;
            Serializable serializable;
            File file;
            void $this$mapTo$iv$iv;
            FileSystem fs = (FileSystem)closeable;
            boolean bl = false;
            Set set = ((ShrinkProtoResourcesParams)this.getParameters()).getDex().getFiles();
            Intrinsics.checkNotNullExpressionValue((Object)set, (String)"getFiles(...)");
            Iterable $this$map$iv = set;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                file = (File)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                Path path = it.toPath();
                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toPath(...)");
                collection.add(new DexUsageRecorder(path));
            }
            List dexRecorders = (List)destination$iv$iv;
            Path path = fs.getPath("AndroidManifest.xml", new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"getPath(...)");
            ProtoAndroidManifestUsageRecorder manifestRecorder = new ProtoAndroidManifestUsageRecorder(path);
            Path path2 = ((File)((ShrinkProtoResourcesParams)this.getParameters()).getResourceDir().getAsFile().get()).toPath();
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"toPath(...)");
            ToolsAttributeUsageRecorder toolsRecorder = new ToolsAttributeUsageRecorder(path2);
            Path path3 = fs.getPath("resources.pb", new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"getPath(...)");
            ProtoResourceTableGatherer gatherer = new ProtoResourceTableGatherer(path3);
            Path path4 = fs.getPath("res", new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path4, (String)"getPath(...)");
            Path path5 = fs.getPath("resources.pb", new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path5, (String)"getPath(...)");
            ProtoResourcesGraphBuilder graphBuilder = new ProtoResourcesGraphBuilder(path4, path5);
            Object object = (RegularFile)((ShrinkProtoResourcesParams)this.getParameters()).getMappingFileSrc().getOrNull();
            if (object != null && (object = (serializable = object.getAsFile())) != null) {
                Intrinsics.checkNotNull((Object)object);
                File it = serializable;
                boolean bl3 = false;
                Path path6 = it.toPath();
                Intrinsics.checkNotNullExpressionValue((Object)path6, (String)"toPath(...)");
                proguardMappingsRecorder = new ProguardMappingsRecorder(path6);
            } else {
                proguardMappingsRecorder = null;
            }
            ProguardMappingsRecorder obfuscationMappings = proguardMappingsRecorder;
            List list = CollectionsKt.listOf((Object)gatherer);
            ObfuscationMappingsRecorder obfuscationMappingsRecorder = obfuscationMappings;
            List list2 = CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)dexRecorders, (Object)manifestRecorder), (Object)toolsRecorder);
            List list3 = CollectionsKt.listOf((Object)graphBuilder);
            RegularFile regularFile = (RegularFile)((ShrinkProtoResourcesParams)this.getParameters()).getReportFile().getOrNull();
            ShrinkerDebugReporter shrinkerDebugReporter = new LoggerAndFileDebugReporter((Function1<? super String, Unit>)((Function1)new Function1<String, Unit>(this){
                final /* synthetic */ ShrinkProtoResourcesAction this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                public final void invoke(@NotNull String debugMessage) {
                    Intrinsics.checkNotNullParameter((Object)debugMessage, (String)"debugMessage");
                    if (ShrinkProtoResourcesAction.access$getLogger$p(this.this$0).isEnabled(LogLevel.DEBUG)) {
                        ShrinkProtoResourcesAction.access$getLogger$p(this.this$0).log(LogLevel.DEBUG, debugMessage);
                    }
                }
            }), (Function1<? super String, Unit>)((Function1)new Function1<String, Unit>(this){
                final /* synthetic */ ShrinkProtoResourcesAction this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                public final void invoke(@NotNull String infoMessage) {
                    Intrinsics.checkNotNullParameter((Object)infoMessage, (String)"infoMessage");
                    if (ShrinkProtoResourcesAction.access$getLogger$p(this.this$0).isEnabled(LogLevel.DEBUG)) {
                        ShrinkProtoResourcesAction.access$getLogger$p(this.this$0).log(LogLevel.DEBUG, infoMessage);
                    }
                }
            }), regularFile != null ? regularFile.getAsFile() : null);
            Object object2 = ((ShrinkProtoResourcesParams)this.getParameters()).getUsePreciseShrinking().get();
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"get(...)");
            AutoCloseable autoCloseable = new ResourceShrinkerImpl(list, obfuscationMappingsRecorder, list2, list3, shrinkerDebugReporter, false, (Boolean)object2);
            serializable = null;
            try {
                ResourceShrinkerImpl shrinker = (ResourceShrinkerImpl)autoCloseable;
                boolean bl4 = false;
                shrinker.analyze();
                Intrinsics.checkNotNull((Object)originalProtoFile);
                Intrinsics.checkNotNull((Object)shrunkProtoFile);
                shrinker.rewriteResourcesInApkFormat(originalProtoFile, shrunkProtoFile, LinkedResourcesFormat.PROTO);
                if (shrinker.getUnusedResourceCount() > 0) {
                    long before = shrunkProtoFile.length();
                    long after = shrunkProtoFile.length();
                    int percent = (int)((before - after) * (long)100 / before);
                    String stat = "Removed unused resources: Proto resource data reduced from " + this.toKbString(before) + "KB to " + this.toKbString(after) + "KB. Removed " + percent + "%";
                    this.logger.info(stat);
                }
                file = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                serializable = throwable2;
                throw throwable2;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)serializable);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable3) {
            throwable = throwable3;
            throw throwable3;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    private final String toKbString(long size) {
        return String.valueOf((int)size / 1024);
    }

    public static final /* synthetic */ Logger access$getLogger$p(ShrinkProtoResourcesAction $this) {
        return $this.logger;
    }
}

