/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.utils;

import com.android.build.api.variant.ApkInstallGroup;
import com.android.build.api.variant.DeviceSpec;
import com.android.build.gradle.internal.LoggerWrapper;
import com.android.build.gradle.internal.utils.BundleApkFetcher;
import com.android.build.gradle.internal.utils.DefaultDeviceApkOutput;
import com.android.build.gradle.internal.utils.DeviceApkOutput;
import com.android.build.gradle.internal.utils.ViaBundleDeviceApkOutput;
import com.android.builder.internal.InstallUtils;
import com.android.bundle.Devices;
import com.android.sdklib.AndroidVersion;
import com.android.utils.ILogger;
import com.google.common.collect.Lists;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.RegularFile;
import org.gradle.api.provider.Provider;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B=\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\n\u0012\b\b\u0002\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0014\u001a\u00020\u0015H\u0016R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/android/build/gradle/internal/utils/ViaBundleDeviceApkOutput;", "Lcom/android/build/gradle/internal/utils/DeviceApkOutput;", "apkBundle", "Lorg/gradle/api/provider/Provider;", "Lorg/gradle/api/file/RegularFile;", "minSdkVersion", "Lcom/android/sdklib/AndroidVersion;", "privacySandboxSdkApks", "Lorg/gradle/api/file/FileCollection;", "variantName", "", "projectPath", "apkFetcher", "Lcom/android/build/gradle/internal/utils/BundleApkFetcher;", "(Lorg/gradle/api/provider/Provider;Lcom/android/sdklib/AndroidVersion;Lorg/gradle/api/file/FileCollection;Ljava/lang/String;Ljava/lang/String;Lcom/android/build/gradle/internal/utils/BundleApkFetcher;)V", "iLogger", "Lcom/android/build/gradle/internal/LoggerWrapper;", "getApks", "", "Lcom/android/build/api/variant/ApkInstallGroup;", "deviceSpec", "Lcom/android/build/api/variant/DeviceSpec;", "gradle-core"})
@SourceDebugExtension(value={"SMAP\nViaBundleDeviceApkOutput.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ViaBundleDeviceApkOutput.kt\ncom/android/build/gradle/internal/utils/ViaBundleDeviceApkOutput\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,78:1\n1855#2,2:79\n1549#2:82\n1620#2,3:83\n1#3:81\n*S KotlinDebug\n*F\n+ 1 ViaBundleDeviceApkOutput.kt\ncom/android/build/gradle/internal/utils/ViaBundleDeviceApkOutput\n*L\n52#1:79,2\n71#1:82\n71#1:83,3\n*E\n"})
public final class ViaBundleDeviceApkOutput
implements DeviceApkOutput {
    @NotNull
    private final Provider<RegularFile> apkBundle;
    @NotNull
    private final AndroidVersion minSdkVersion;
    @NotNull
    private final FileCollection privacySandboxSdkApks;
    @NotNull
    private final String variantName;
    @NotNull
    private final String projectPath;
    @NotNull
    private final BundleApkFetcher apkFetcher;
    @NotNull
    private final LoggerWrapper iLogger;

    public ViaBundleDeviceApkOutput(@NotNull Provider<RegularFile> apkBundle, @NotNull AndroidVersion minSdkVersion2, @NotNull FileCollection privacySandboxSdkApks, @NotNull String variantName, @NotNull String projectPath, @NotNull BundleApkFetcher apkFetcher) {
        Intrinsics.checkNotNullParameter(apkBundle, (String)"apkBundle");
        Intrinsics.checkNotNullParameter((Object)minSdkVersion2, (String)"minSdkVersion");
        Intrinsics.checkNotNullParameter((Object)privacySandboxSdkApks, (String)"privacySandboxSdkApks");
        Intrinsics.checkNotNullParameter((Object)variantName, (String)"variantName");
        Intrinsics.checkNotNullParameter((Object)projectPath, (String)"projectPath");
        Intrinsics.checkNotNullParameter((Object)apkFetcher, (String)"apkFetcher");
        this.apkBundle = apkBundle;
        this.minSdkVersion = minSdkVersion2;
        this.privacySandboxSdkApks = privacySandboxSdkApks;
        this.variantName = variantName;
        this.projectPath = projectPath;
        this.apkFetcher = apkFetcher;
        LoggerWrapper loggerWrapper = LoggerWrapper.getLogger(ViaBundleDeviceApkOutput.class);
        Intrinsics.checkNotNullExpressionValue((Object)loggerWrapper, (String)"getLogger(...)");
        this.iLogger = loggerWrapper;
    }

    public /* synthetic */ ViaBundleDeviceApkOutput(Provider provider2, AndroidVersion androidVersion, FileCollection fileCollection2, String string, String string2, BundleApkFetcher bundleApkFetcher, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x20) != 0) {
            bundleApkFetcher = new BundleApkFetcher(){};
        }
        this((Provider<RegularFile>)provider2, androidVersion, fileCollection2, string, string2, bundleApkFetcher);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<ApkInstallGroup> getApks(@NotNull DeviceSpec deviceSpec) {
        Intrinsics.checkNotNullParameter((Object)deviceSpec, (String)"deviceSpec");
        List apkInstallGroups = new ArrayList();
        if (InstallUtils.checkDeviceApiLevel((String)deviceSpec.getName(), (int)deviceSpec.getApiLevel(), (String)deviceSpec.getCodeName(), (AndroidVersion)this.minSdkVersion, (ILogger)this.iLogger, (String)this.projectPath, (String)this.variantName)) {
            void $this$mapTo$iv$iv;
            List $i$f$forEach2;
            boolean privacySandboxSdksPresent;
            boolean bl = privacySandboxSdksPresent = !this.privacySandboxSdkApks.isEmpty();
            if (privacySandboxSdksPresent && deviceSpec.getSupportsPrivacySandbox()) {
                Set set = this.privacySandboxSdkApks.getFiles();
                Intrinsics.checkNotNullExpressionValue((Object)set, (String)"getFiles(...)");
                Iterable $this$forEach$iv = set;
                boolean $i$f$forEach2 = false;
                for (Object element$iv : $this$forEach$iv) {
                    File file = (File)element$iv;
                    boolean bl2 = false;
                    Path path = file.toPath();
                    Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toPath(...)");
                    List sdkApkFiles2 = this.apkFetcher.getPrivacySandboxSdkApkFiles(path).stream().map(getApks.1.sdkApkFiles.1.INSTANCE).collect(Collectors.toUnmodifiableList());
                    RegularFile regularFile = new RegularFile(file){
                        final /* synthetic */ File $file;
                        {
                            this.$file = $file;
                        }

                        public final File getAsFile() {
                            return this.$file;
                        }
                    };
                    Intrinsics.checkNotNull(sdkApkFiles2);
                    apkInstallGroups.add(new DefaultDeviceApkOutput.DefaultSdkApkInstallGroup(regularFile, sdkApkFiles2));
                }
            }
            List $this$getApks_u24lambda_u241 = $i$f$forEach2 = CollectionsKt.createListBuilder();
            boolean bl3 = false;
            Path path = ((RegularFile)this.apkBundle.get()).getAsFile().toPath();
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toPath(...)");
            $this$getApks_u24lambda_u241.add(path);
            List apkBuiltArtifacts = CollectionsKt.build((List)$i$f$forEach2);
            List spec = $this$getApks_u24lambda_u241 = Devices.DeviceSpec.newBuilder();
            boolean bl4 = false;
            Object bl2 = deviceSpec.getApiLevel();
            int it = ((Number)bl2).intValue();
            boolean bl5 = false;
            Object object = it > 0 ? bl2 : null;
            if (object != null) {
                it = ((Number)object).intValue();
                boolean bl6 = false;
                spec.setSdkVersion(it);
            }
            String string = deviceSpec.getCodeName();
            if (string != null) {
                String it2 = string;
                boolean bl7 = false;
                spec.setCodename(it2);
            }
            Object it3 = bl2 = deviceSpec.getAbis();
            boolean bl8 = false;
            Object object2 = !((Collection)it3).isEmpty() ? bl2 : null;
            if (object2 != null) {
                it3 = object2;
                boolean bl9 = false;
                spec.addAllSupportedAbis((Iterable)it3);
            }
            bl2 = deviceSpec.getScreenDensity();
            int it2 = ((Number)bl2).intValue();
            boolean bl10 = false;
            Object object3 = it2 > 0 ? bl2 : null;
            if (object3 != null) {
                it2 = ((Number)object3).intValue();
                boolean bl11 = false;
                spec.setScreenDensity(it2);
            }
            spec.setSdkRuntime(Devices.SdkRuntime.newBuilder().setSupported(deviceSpec.getSupportsPrivacySandbox()).build());
            Devices.DeviceSpec spec2 = $this$getApks_u24lambda_u241.build();
            LinkedList linkedList = Lists.newLinkedList();
            Intrinsics.checkNotNullExpressionValue((Object)linkedList, (String)"newLinkedList(...)");
            List apkFiles2 = linkedList;
            Collection collection = apkBuiltArtifacts;
            Intrinsics.checkNotNull((Object)spec2);
            Iterable $this$map$iv = this.apkFetcher.getApkFiles(collection, spec2);
            boolean $i$f$map = false;
            Iterable it32 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it4;
                Path path2 = (Path)item$iv$iv;
                Collection collection2 = destination$iv$iv;
                boolean bl12 = false;
                collection2.add((RegularFile)new RegularFile((Path)it4){
                    final /* synthetic */ Path $it;
                    {
                        this.$it = $it;
                    }

                    public final File getAsFile() {
                        return this.$it.toFile();
                    }
                });
            }
            List bundleApkFiles2 = (List)destination$iv$iv;
            apkFiles2.addAll(bundleApkFiles2);
            apkInstallGroups.add(new DefaultDeviceApkOutput.DefaultApkInstallGroup(apkFiles2, "Apks from Main Bundle"));
        }
        return apkInstallGroups;
    }
}

