/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks;

import com.android.build.gradle.internal.component.ApkCreationConfig;
import com.android.build.gradle.internal.component.NestedComponentCreationConfig;
import com.android.build.gradle.internal.component.VariantCreationConfig;
import com.android.build.gradle.internal.dsl.ModulePropertyKey;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Transformer;
import org.gradle.api.provider.MapProperty;
import org.gradle.api.provider.Provider;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0016\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004H\u0000\u00a8\u0006\u0005"}, d2={"getPageSize", "Lorg/gradle/api/provider/Provider;", "", "creationConfig", "Lcom/android/build/gradle/internal/component/ApkCreationConfig;", "gradle-core"})
public final class PackageAndroidArtifactKt {
    @NotNull
    public static final Provider<Long> getPageSize(@NotNull ApkCreationConfig creationConfig) {
        MapProperty<String, Object> mapProperty;
        Intrinsics.checkNotNullParameter((Object)creationConfig, (String)"creationConfig");
        MapProperty<String, Object> experimentalProperties = null;
        long defaultPageSize = 16384L;
        ApkCreationConfig apkCreationConfig = creationConfig;
        if (apkCreationConfig instanceof VariantCreationConfig) {
            mapProperty = ((VariantCreationConfig)((Object)creationConfig)).getExperimentalProperties();
        } else if (apkCreationConfig instanceof NestedComponentCreationConfig) {
            mapProperty = ((NestedComponentCreationConfig)((Object)creationConfig)).getMainVariant().getExperimentalProperties();
        } else {
            return creationConfig.getServices().provider((Function0)new Function0<Long>(defaultPageSize){
                final /* synthetic */ long $defaultPageSize;
                {
                    this.$defaultPageSize = $defaultPageSize;
                    super(0);
                }

                public final Long invoke() {
                    return this.$defaultPageSize;
                }
            });
        }
        experimentalProperties = mapProperty;
        Provider provider2 = experimentalProperties.map(new Transformer(defaultPageSize){
            final /* synthetic */ long $defaultPageSize;
            {
                this.$defaultPageSize = $defaultPageSize;
            }

            public final Long transform(Map<String, Object> it) {
                Object pageSize;
                Intrinsics.checkNotNull(it);
                Object object = ModulePropertyKey.OptionalString.NATIVE_LIBRARY_PAGE_SIZE.getValue(it);
                if (object == null) {
                    return this.$defaultPageSize;
                }
                Object object2 = pageSize = object;
                Locale locale = Locale.US;
                Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"US");
                String string = ((String)object2).toLowerCase(locale);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
                String lowercasePageSize = string;
                switch (lowercasePageSize) {
                    case "4k": {
                        return 4096L;
                    }
                    case "16k": {
                        return 16384L;
                    }
                    case "64k": {
                        return 65536L;
                    }
                }
                throw new RuntimeException("Invalid value for " + ModulePropertyKey.OptionalString.NATIVE_LIBRARY_PAGE_SIZE.getKey() + ". Supported values are \"4k\", \"16k\", and \"64k\".");
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)provider2, (String)"map(...)");
        return provider2;
    }
}

