/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.gradle.internal.tasks.InputData;
import com.android.build.gradle.internal.tasks.JavaResMergingPriority;
import com.android.builder.files.IncrementalRelativeFileSets;
import com.android.builder.files.KeyedFileCache;
import com.android.builder.files.RelativeFile;
import com.android.builder.files.RelativeFiles;
import com.android.builder.files.SerializableChange;
import com.android.builder.files.SerializableInputChanges;
import com.android.builder.files.ZipCentralDirectory;
import com.android.builder.merge.IncrementalFileMergerInput;
import com.android.builder.merge.LazyIncrementalFileMergerInput;
import com.android.builder.merge.LazyIncrementalFileMergerInputs;
import com.android.ide.common.resources.FileStatus;
import com.android.tools.build.apkzlib.utils.CachedSupplier;
import com.android.tools.build.apkzlib.utils.IOExceptionRunnable;
import com.android.utils.FileUtils;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000f\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u001a\u001c\u0010\u0000\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u00012\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\u0002H\u0002\u001a\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\u000b\u001a\u00020\fH\u0002\u001a0\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00030\u000e2\u0006\u0010\t\u001a\u00020\u00022\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001H\u0002\u001a8\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00030\u00012\u0006\u0010\u000b\u001a\u00020\f2\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u00012\u0006\u0010\u0011\u001a\u00020\u0012H\u0002\u001a@\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00022\u0006\u0010\u0016\u001a\u00020\u00172\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u00012\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019\u001aJ\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u001c0\u000e2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001e2\b\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\u0006\u0010 \u001a\u00020!H\u0000\u001a.\u0010\"\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u00022\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019\u00a8\u0006#"}, d2={"collectChanges", "", "Ljava/io/File;", "Lcom/android/ide/common/resources/FileStatus;", "changes", "Lcom/android/builder/files/SerializableInputChanges;", "computeFilesFromDir", "", "Lcom/android/builder/files/RelativeFile;", "dir", "computeFilesFromJar", "jar", "Lcom/android/builder/files/ZipCentralDirectory;", "computeUpdatesFromDir", "Lcom/google/common/collect/ImmutableMap;", "changedInputs", "computeUpdatesFromJar", "zipCache", "Lcom/android/builder/files/KeyedFileCache;", "toIncrementalInput", "Lcom/android/builder/merge/IncrementalFileMergerInput;", "input", "name", "", "cacheUpdates", "", "Ljava/lang/Runnable;", "toInputs", "Lcom/android/build/gradle/internal/tasks/JavaResMergingPriority;", "inputs", "", "Lcom/android/build/gradle/internal/tasks/InputData;", "full", "", "toNonIncrementalInput", "gradle-core"})
@JvmName(name="IncrementalFileMergerTaskUtils")
@SourceDebugExtension(value={"SMAP\nIncrementalFileMergerTaskUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IncrementalFileMergerTaskUtils.kt\ncom/android/build/gradle/internal/tasks/IncrementalFileMergerTaskUtils\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,286:1\n1#2:287\n1855#3,2:288\n*S KotlinDebug\n*F\n+ 1 IncrementalFileMergerTaskUtils.kt\ncom/android/build/gradle/internal/tasks/IncrementalFileMergerTaskUtils\n*L\n272#1:288,2\n*E\n"})
public final class IncrementalFileMergerTaskUtils {
    @NotNull
    public static final IncrementalFileMergerInput toIncrementalInput(@NotNull File input, @NotNull String name, @NotNull Map<File, ? extends FileStatus> changedInputs, @NotNull KeyedFileCache zipCache2, @NotNull List<Runnable> cacheUpdates) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(changedInputs, (String)"changedInputs");
        Intrinsics.checkNotNullParameter((Object)zipCache2, (String)"zipCache");
        Intrinsics.checkNotNullParameter(cacheUpdates, (String)"cacheUpdates");
        String string = input.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        if (StringsKt.endsWith$default((String)string, (String)".jar", (boolean)false, (int)2, null)) {
            ZipCentralDirectory jarCDR = new ZipCentralDirectory(input);
            if (changedInputs.containsKey(input)) {
                Runnable runnable = IOExceptionRunnable.asRunnable((IOExceptionRunnable)new IOExceptionRunnable(input, zipCache2, jarCDR){
                    final /* synthetic */ File $input;
                    final /* synthetic */ KeyedFileCache $zipCache;
                    final /* synthetic */ ZipCentralDirectory $jarCDR;
                    {
                        this.$input = $input;
                        this.$zipCache = $zipCache;
                        this.$jarCDR = $jarCDR;
                    }

                    public final void run() {
                        if (this.$input.isFile()) {
                            this.$zipCache.add(this.$jarCDR);
                        } else {
                            this.$zipCache.remove(this.$input);
                        }
                    }
                });
                Intrinsics.checkNotNullExpressionValue((Object)runnable, (String)"asRunnable(...)");
                cacheUpdates.add(runnable);
            }
            return (IncrementalFileMergerInput)new LazyIncrementalFileMergerInput(name, new CachedSupplier(new Supplier(jarCDR, changedInputs, zipCache2){
                final /* synthetic */ ZipCentralDirectory $jarCDR;
                final /* synthetic */ Map<File, FileStatus> $changedInputs;
                final /* synthetic */ KeyedFileCache $zipCache;
                {
                    this.$jarCDR = $jarCDR;
                    this.$changedInputs = $changedInputs;
                    this.$zipCache = $zipCache;
                }

                public final Map<RelativeFile, FileStatus> get() {
                    return IncrementalFileMergerTaskUtils.access$computeUpdatesFromJar(this.$jarCDR, this.$changedInputs, this.$zipCache);
                }
            }), new CachedSupplier(new Supplier(jarCDR){
                final /* synthetic */ ZipCentralDirectory $jarCDR;
                {
                    this.$jarCDR = $jarCDR;
                }

                public final Set<RelativeFile> get() {
                    return IncrementalFileMergerTaskUtils.access$computeFilesFromJar(this.$jarCDR);
                }
            }));
        }
        Preconditions.checkState((!input.isFile() ? 1 : 0) != 0, (String)("Non-directory inputs must have .jar extension: " + input), (Object[])new Object[0]);
        return (IncrementalFileMergerInput)new LazyIncrementalFileMergerInput(name, new CachedSupplier(new Supplier(input, changedInputs){
            final /* synthetic */ File $input;
            final /* synthetic */ Map<File, FileStatus> $changedInputs;
            {
                this.$input = $input;
                this.$changedInputs = $changedInputs;
            }

            public final Map<RelativeFile, FileStatus> get() {
                return (Map)IncrementalFileMergerTaskUtils.access$computeUpdatesFromDir(this.$input, this.$changedInputs);
            }
        }), new CachedSupplier(new Supplier(input){
            final /* synthetic */ File $input;
            {
                this.$input = $input;
            }

            public final Set<RelativeFile> get() {
                return IncrementalFileMergerTaskUtils.access$computeFilesFromDir(this.$input);
            }
        }));
    }

    @Nullable
    public static final IncrementalFileMergerInput toNonIncrementalInput(@NotNull File input, @NotNull String name, @NotNull KeyedFileCache zipCache2, @NotNull List<Runnable> cacheUpdates) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)zipCache2, (String)"zipCache");
        Intrinsics.checkNotNullParameter(cacheUpdates, (String)"cacheUpdates");
        if (!input.isFile() && !input.isDirectory()) {
            return null;
        }
        if (input.isFile()) {
            Runnable runnable = IOExceptionRunnable.asRunnable((IOExceptionRunnable)new IOExceptionRunnable(zipCache2, input){
                final /* synthetic */ KeyedFileCache $zipCache;
                final /* synthetic */ File $input;
                {
                    this.$zipCache = $zipCache;
                    this.$input = $input;
                }

                public final void run() {
                    this.$zipCache.add(this.$input);
                }
            });
            Intrinsics.checkNotNullExpressionValue((Object)runnable, (String)"asRunnable(...)");
            cacheUpdates.add(runnable);
        }
        return (IncrementalFileMergerInput)LazyIncrementalFileMergerInputs.fromNew((String)name, (Set)((Set)ImmutableSet.of((Object)input)));
    }

    private static final Map<RelativeFile, FileStatus> computeUpdatesFromJar(ZipCentralDirectory jar, Map<File, ? extends FileStatus> changedInputs, KeyedFileCache zipCache2) {
        if (changedInputs.containsKey(jar.getFile())) {
            FileStatus fileStatus = changedInputs.get(jar.getFile());
            try {
                Map map;
                FileStatus fileStatus2 = fileStatus;
                switch (fileStatus2 == null ? -1 : WhenMappings.$EnumSwitchMapping$0[fileStatus2.ordinal()]) {
                    case 1: {
                        ImmutableMap immutableMap = IncrementalRelativeFileSets.fromZip((ZipCentralDirectory)jar, (FileStatus)FileStatus.NEW);
                        Intrinsics.checkNotNullExpressionValue((Object)immutableMap, (String)"fromZip(...)");
                        map = (Map)immutableMap;
                        break;
                    }
                    case 2: {
                        File file = zipCache2.get(jar.getFile());
                        if (file == null) {
                            throw new RuntimeException("File '" + jar + "' was deleted, but previous version not found in cache");
                        }
                        File cached = file;
                        ImmutableMap immutableMap = IncrementalRelativeFileSets.fromZip((File)cached, (FileStatus)FileStatus.REMOVED);
                        Intrinsics.checkNotNull((Object)immutableMap);
                        map = (Map)immutableMap;
                        break;
                    }
                    case 3: {
                        Map map2 = IncrementalRelativeFileSets.fromZip((ZipCentralDirectory)jar, (KeyedFileCache)zipCache2, (Set)new HashSet());
                        map = map2;
                        Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"fromZip(...)");
                        break;
                    }
                    default: {
                        throw new AssertionError((Object)("Unexpected FileStatus: " + fileStatus));
                    }
                }
                return map;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        ImmutableMap immutableMap = ImmutableMap.of();
        Intrinsics.checkNotNullExpressionValue((Object)immutableMap, (String)"of(...)");
        return (Map)immutableMap;
    }

    private static final Set<RelativeFile> computeFilesFromJar(ZipCentralDirectory jar) {
        if (!jar.getFile().isFile()) {
            ImmutableSet immutableSet = ImmutableSet.of();
            Intrinsics.checkNotNullExpressionValue((Object)immutableSet, (String)"of(...)");
            return (Set)immutableSet;
        }
        try {
            Set set = RelativeFiles.fromZip((ZipCentralDirectory)jar);
            Intrinsics.checkNotNullExpressionValue((Object)set, (String)"fromZip(...)");
            return set;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static final ImmutableMap<RelativeFile, FileStatus> computeUpdatesFromDir(File dir, Map<File, ? extends FileStatus> changedInputs) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Map.Entry<File, ? extends FileStatus> entry2 : changedInputs.entrySet()) {
            RelativeFile rf;
            File file = entry2.getKey();
            FileStatus status = entry2.getValue();
            if (!FileUtils.isFileInDirectory((File)file, (File)dir) || (rf = new RelativeFile(dir, file)).getFile().isDirectory()) continue;
            builder.put((Object)rf, (Object)status);
        }
        ImmutableMap immutableMap = builder.build();
        Intrinsics.checkNotNullExpressionValue((Object)immutableMap, (String)"build(...)");
        return immutableMap;
    }

    private static final Set<RelativeFile> computeFilesFromDir(File dir) {
        if (!dir.isDirectory()) {
            ImmutableSet immutableSet = ImmutableSet.of();
            Intrinsics.checkNotNullExpressionValue((Object)immutableSet, (String)"of(...)");
            return (Set)immutableSet;
        }
        Set set = RelativeFiles.fromDirectory((File)dir);
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"fromDirectory(...)");
        return set;
    }

    @NotNull
    public static final ImmutableMap<IncrementalFileMergerInput, JavaResMergingPriority> toInputs(@NotNull List<InputData> inputs, @Nullable SerializableInputChanges changes, @NotNull KeyedFileCache zipCache2, @NotNull List<Runnable> cacheUpdates, boolean full) {
        Map<File, FileStatus> map;
        Intrinsics.checkNotNullParameter(inputs, (String)"inputs");
        Intrinsics.checkNotNullParameter((Object)zipCache2, (String)"zipCache");
        Intrinsics.checkNotNullParameter(cacheUpdates, (String)"cacheUpdates");
        if (full) {
            Runnable runnable = IOExceptionRunnable.asRunnable((IOExceptionRunnable)new IOExceptionRunnable(zipCache2){
                final /* synthetic */ KeyedFileCache $zipCache;
                {
                    this.$zipCache = $zipCache;
                }

                public final void run() {
                    this.$zipCache.clear();
                }
            });
            Intrinsics.checkNotNullExpressionValue((Object)runnable, (String)"asRunnable(...)");
            cacheUpdates.add(runnable);
        }
        SerializableInputChanges serializableInputChanges = changes;
        if (serializableInputChanges != null) {
            SerializableInputChanges it = serializableInputChanges;
            boolean bl = false;
            map = IncrementalFileMergerTaskUtils.collectChanges(it);
        } else {
            map = null;
        }
        Map<File, FileStatus> changedInputs = map;
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (InputData input : inputs) {
            IncrementalFileMergerInput it;
            IncrementalFileMergerInput fileMergerInput;
            IncrementalFileMergerInput incrementalFileMergerInput;
            if (full) {
                incrementalFileMergerInput = IncrementalFileMergerTaskUtils.toNonIncrementalInput(input.getFile(), input.getSource(), zipCache2, cacheUpdates);
            } else {
                Map<File, FileStatus> map2 = changedInputs;
                if (map2 == null) {
                    throw new IllegalArgumentException("changes must be specified for incremental merging.");
                }
                incrementalFileMergerInput = fileMergerInput = IncrementalFileMergerTaskUtils.toIncrementalInput(input.getFile(), input.getSource(), map2, zipCache2, cacheUpdates);
            }
            if (fileMergerInput == null) continue;
            boolean bl = false;
            builder.put((Object)it, (Object)input.getPriority());
        }
        ImmutableMap immutableMap = builder.build();
        Intrinsics.checkNotNullExpressionValue((Object)immutableMap, (String)"build(...)");
        return immutableMap;
    }

    private static final Map<File, FileStatus> collectChanges(SerializableInputChanges changes) {
        Map map = new LinkedHashMap();
        Iterable $this$forEach$iv = changes.getChanges();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FileStatus fileStatus;
            SerializableChange change = (SerializableChange)element$iv;
            boolean bl = false;
            FileStatus currentState = (FileStatus)map.get(change.getFile());
            FileStatus changeState = change.getFileStatus();
            if (currentState == null) {
                fileStatus = changeState;
            } else if (currentState == FileStatus.NEW && changeState == FileStatus.REMOVED) {
                fileStatus = FileStatus.CHANGED;
            } else if (currentState == FileStatus.REMOVED && changeState == FileStatus.NEW) {
                fileStatus = FileStatus.CHANGED;
            } else {
                throw new IllegalStateException("Unexpected combination of states " + currentState + ", " + changeState + " for file " + change.getFile());
            }
            FileStatus newState = fileStatus;
            map.put(change.getFile(), newState);
        }
        Map<File, FileStatus> map2 = Collections.unmodifiableMap(map);
        Intrinsics.checkNotNullExpressionValue(map2, (String)"unmodifiableMap(...)");
        return map2;
    }

    public static final /* synthetic */ Map access$computeUpdatesFromJar(ZipCentralDirectory jar, Map changedInputs, KeyedFileCache zipCache2) {
        return IncrementalFileMergerTaskUtils.computeUpdatesFromJar(jar, changedInputs, zipCache2);
    }

    public static final /* synthetic */ Set access$computeFilesFromJar(ZipCentralDirectory jar) {
        return IncrementalFileMergerTaskUtils.computeFilesFromJar(jar);
    }

    public static final /* synthetic */ ImmutableMap access$computeUpdatesFromDir(File dir, Map changedInputs) {
        return IncrementalFileMergerTaskUtils.computeUpdatesFromDir(dir, changedInputs);
    }

    public static final /* synthetic */ Set access$computeFilesFromDir(File dir) {
        return IncrementalFileMergerTaskUtils.computeFilesFromDir(dir);
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[FileStatus.values().length];
            try {
                nArray[FileStatus.NEW.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FileStatus.REMOVED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FileStatus.CHANGED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

