/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.testing.utp;

import com.android.build.gradle.internal.testing.utp.UtpTestResultListener;
import com.android.build.gradle.internal.testing.utp.UtpTestRunResult;
import com.android.tools.utp.plugins.deviceprovider.profile.proto.DeviceProviderProfileProto;
import com.android.tools.utp.plugins.result.listener.gradle.proto.GradleAndroidTestResultListenerProto;
import com.google.wireless.android.sdk.stats.DeviceTestSpanProfile;
import com.google.wireless.android.sdk.stats.TestRun;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.time.Clock;
import java.time.Instant;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0002\"#B=\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0014\u0010\b\u001a\u0010\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n\u0018\u00010\t\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\n\u0010\u0018\u001a\u00060\u0019R\u00020\u0000J\b\u0010\u001a\u001a\u00020\u001bH\u0002J\u0006\u0010\u001c\u001a\u00020\u001bJ\u000e\u0010\u001d\u001a\u00020\u001b2\u0006\u0010\u001e\u001a\u00020\u001fJ\u0006\u0010 \u001a\u00020!R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\b\u001a\u0010\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/android/build/gradle/internal/testing/utp/UtpRunProfile;", "", "outputDirectory", "Ljava/io/File;", "device", "Lcom/google/wireless/android/sdk/stats/DeviceTestSpanProfile$DeviceType;", "profileId", "", "deviceLock", "Lkotlin/Pair;", "Ljava/time/Instant;", "clock", "Ljava/time/Clock;", "(Ljava/io/File;Lcom/google/wireless/android/sdk/stats/DeviceTestSpanProfile$DeviceType;Ljava/lang/String;Lkotlin/Pair;Ljava/time/Clock;)V", "deviceLockSpan", "Lcom/android/build/gradle/internal/testing/utp/UtpRunProfile$TimeSpan;", "deviceProvisionSpan", "deviceReleaseSpan", "profileFile", "resultStatus", "Lcom/google/wireless/android/sdk/stats/DeviceTestSpanProfile$TestProgressResult;", "testRunSpan", "utpSetupStartMs", "", "listener", "Lcom/android/build/gradle/internal/testing/utp/UtpRunProfile$TestResultListener;", "recordDeviceProviderProfileProtoFromUtpOutput", "", "recordSetupStart", "recordUtpRunFinished", "result", "Lcom/android/build/gradle/internal/testing/utp/UtpTestRunResult;", "toDeviceTestSpanProfileProto", "Lcom/google/wireless/android/sdk/stats/DeviceTestSpanProfile;", "TestResultListener", "TimeSpan", "gradle-core"})
public final class UtpRunProfile {
    @NotNull
    private final DeviceTestSpanProfile.DeviceType device;
    @NotNull
    private final String profileId;
    @Nullable
    private final Pair<Instant, Instant> deviceLock;
    @NotNull
    private final Clock clock;
    @Nullable
    private final TimeSpan deviceLockSpan;
    private long utpSetupStartMs;
    @NotNull
    private final TimeSpan deviceProvisionSpan;
    @NotNull
    private final TimeSpan testRunSpan;
    @NotNull
    private final TimeSpan deviceReleaseSpan;
    @NotNull
    private DeviceTestSpanProfile.TestProgressResult resultStatus;
    @NotNull
    private final File profileFile;

    /*
     * WARNING - void declaration
     */
    public UtpRunProfile(@NotNull File outputDirectory, @NotNull DeviceTestSpanProfile.DeviceType device, @NotNull String profileId, @Nullable Pair<Instant, Instant> deviceLock, @NotNull Clock clock) {
        TimeSpan timeSpan;
        Intrinsics.checkNotNullParameter((Object)outputDirectory, (String)"outputDirectory");
        Intrinsics.checkNotNullParameter((Object)device, (String)"device");
        Intrinsics.checkNotNullParameter((Object)profileId, (String)"profileId");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        this.device = device;
        this.profileId = profileId;
        this.deviceLock = deviceLock;
        this.clock = clock;
        UtpRunProfile utpRunProfile = this;
        Pair<Instant, Instant> pair = this.deviceLock;
        if (pair != null) {
            void it;
            TimeSpan timeSpan2;
            Pair<Instant, Instant> pair2 = pair;
            UtpRunProfile utpRunProfile2 = utpRunProfile;
            boolean bl = false;
            TimeSpan $this$deviceLockSpan_u24lambda_u241_u24lambda_u240 = timeSpan2 = new TimeSpan(this.clock);
            boolean bl2 = false;
            $this$deviceLockSpan_u24lambda_u241_u24lambda_u240.recordFromInstants((Instant)it.getFirst(), (Instant)it.getSecond());
            timeSpan = timeSpan2;
            utpRunProfile = utpRunProfile2;
        } else {
            timeSpan = null;
        }
        utpRunProfile.deviceLockSpan = timeSpan;
        this.deviceProvisionSpan = new TimeSpan(this.clock);
        this.testRunSpan = new TimeSpan(this.clock);
        this.deviceReleaseSpan = new TimeSpan(this.clock);
        this.resultStatus = DeviceTestSpanProfile.TestProgressResult.UNKNOWN_RESULT;
        this.profileFile = FilesKt.resolve((File)outputDirectory, (String)("profiling/" + this.profileId + "_profile.pb"));
    }

    @NotNull
    public final TestResultListener listener() {
        return new TestResultListener();
    }

    public final void recordSetupStart() {
        this.utpSetupStartMs = this.clock.instant().toEpochMilli();
    }

    public final void recordUtpRunFinished(@NotNull UtpTestRunResult result2) {
        Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
        this.recordDeviceProviderProfileProtoFromUtpOutput();
        this.resultStatus = result2.getResultsProto() == null ? DeviceTestSpanProfile.TestProgressResult.UNKNOWN_FAILURE : (result2.getResultsProto().hasPlatformError() ? DeviceTestSpanProfile.TestProgressResult.UTP_INFRASTRUCTURE_FAILURE : DeviceTestSpanProfile.TestProgressResult.TESTS_COMPLETED);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void recordDeviceProviderProfileProtoFromUtpOutput() {
        if (!this.profileFile.exists()) {
            return;
        }
        Closeable closeable = new FileInputStream(this.profileFile);
        Throwable throwable = null;
        try {
            FileInputStream file = (FileInputStream)closeable;
            boolean bl = false;
            DeviceProviderProfileProto.DeviceProviderProfile proto = DeviceProviderProfileProto.DeviceProviderProfile.parseFrom((InputStream)file);
            DeviceProviderProfileProto.TimeSpan timeSpan = proto.getDeviceProvision();
            Intrinsics.checkNotNullExpressionValue((Object)timeSpan, (String)"getDeviceProvision(...)");
            this.deviceProvisionSpan.recordFromProtoSpan(timeSpan);
            DeviceProviderProfileProto.TimeSpan timeSpan2 = proto.getDeviceRelease();
            Intrinsics.checkNotNullExpressionValue((Object)timeSpan2, (String)"getDeviceRelease(...)");
            this.deviceReleaseSpan.recordFromProtoSpan(timeSpan2);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    @NotNull
    public final DeviceTestSpanProfile toDeviceTestSpanProfileProto() {
        DeviceTestSpanProfile.Builder builder;
        DeviceTestSpanProfile.Builder $this$toDeviceTestSpanProfileProto_u24lambda_u247 = builder = DeviceTestSpanProfile.newBuilder();
        boolean bl = false;
        $this$toDeviceTestSpanProfileProto_u24lambda_u247.setDeviceType(this.device);
        $this$toDeviceTestSpanProfileProto_u24lambda_u247.setTestKind(TestRun.TestKind.INSTRUMENTATION_TEST);
        $this$toDeviceTestSpanProfileProto_u24lambda_u247.setProcessType(DeviceTestSpanProfile.ProcessType.EXTERNAL_UTP_PROCESS);
        TimeSpan timeSpan = this.deviceLockSpan;
        if (timeSpan != null) {
            TimeSpan it = timeSpan;
            boolean bl2 = false;
            $this$toDeviceTestSpanProfileProto_u24lambda_u247.setDeviceLockWaitStartTimeMs(it.getStartMs$gradle_core());
            $this$toDeviceTestSpanProfileProto_u24lambda_u247.setDeviceLockWaitDurationMs(it.getDurationMs());
        }
        if (this.utpSetupStartMs != 0L && this.deviceProvisionSpan.isSet()) {
            $this$toDeviceTestSpanProfileProto_u24lambda_u247.setUtpSetupStartTimeMs(this.utpSetupStartMs);
            $this$toDeviceTestSpanProfileProto_u24lambda_u247.setUtpSetupDurationMs(this.deviceProvisionSpan.getStartMs$gradle_core() - this.utpSetupStartMs);
        }
        TimeSpan it = this.deviceProvisionSpan;
        boolean bl3 = false;
        $this$toDeviceTestSpanProfileProto_u24lambda_u247.setUtpProvideDeviceStartTimeMs(it.getStartMs$gradle_core());
        $this$toDeviceTestSpanProfileProto_u24lambda_u247.setUtpProvideDeviceDurationMs(it.getDurationMs());
        if (this.deviceProvisionSpan.isSet() && this.testRunSpan.isSet()) {
            $this$toDeviceTestSpanProfileProto_u24lambda_u247.setUtpTestSetupStartTimeMs(this.deviceProvisionSpan.getEndMs$gradle_core());
            $this$toDeviceTestSpanProfileProto_u24lambda_u247.setUtpTestSetupDurationMs(this.testRunSpan.getStartMs$gradle_core() - this.deviceProvisionSpan.getEndMs$gradle_core());
        }
        it = this.testRunSpan;
        boolean bl4 = false;
        $this$toDeviceTestSpanProfileProto_u24lambda_u247.setUtpTestRunStartTimeMs(it.getStartMs$gradle_core());
        $this$toDeviceTestSpanProfileProto_u24lambda_u247.setUtpTestRunDurationMs(it.getDurationMs());
        it = this.deviceReleaseSpan;
        boolean bl5 = false;
        $this$toDeviceTestSpanProfileProto_u24lambda_u247.setUtpTearDownStartTimeMs(it.getStartMs$gradle_core());
        $this$toDeviceTestSpanProfileProto_u24lambda_u247.setUtpTearDownDurationMs(it.getDurationMs());
        $this$toDeviceTestSpanProfileProto_u24lambda_u247.setProgressResult(this.resultStatus);
        DeviceTestSpanProfile deviceTestSpanProfile = builder.build();
        Intrinsics.checkNotNullExpressionValue((Object)deviceTestSpanProfile, (String)"build(...)");
        return deviceTestSpanProfile;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/android/build/gradle/internal/testing/utp/UtpRunProfile$TestResultListener;", "Lcom/android/build/gradle/internal/testing/utp/UtpTestResultListener;", "(Lcom/android/build/gradle/internal/testing/utp/UtpRunProfile;)V", "onTestResultEvent", "", "testResultEvent", "Lcom/android/tools/utp/plugins/result/listener/gradle/proto/GradleAndroidTestResultListenerProto$TestResultEvent;", "gradle-core"})
    public final class TestResultListener
    implements UtpTestResultListener {
        @Override
        public void onTestResultEvent(@NotNull GradleAndroidTestResultListenerProto.TestResultEvent testResultEvent) {
            Intrinsics.checkNotNullParameter((Object)testResultEvent, (String)"testResultEvent");
            GradleAndroidTestResultListenerProto.TestResultEvent.StateCase stateCase = testResultEvent.getStateCase();
            switch (stateCase == null ? -1 : WhenMappings.$EnumSwitchMapping$0[stateCase.ordinal()]) {
                case 1: {
                    UtpRunProfile.this.testRunSpan.recordStart();
                    break;
                }
                case 2: {
                    UtpRunProfile.this.testRunSpan.recordEnd();
                }
            }
        }

        @Metadata(mv={1, 9, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[GradleAndroidTestResultListenerProto.TestResultEvent.StateCase.values().length];
                try {
                    nArray[GradleAndroidTestResultListenerProto.TestResultEvent.StateCase.TEST_SUITE_STARTED.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[GradleAndroidTestResultListenerProto.TestResultEvent.StateCase.TEST_SUITE_FINISHED.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u000e\u001a\u00020\u000fJ\u0006\u0010\u0010\u001a\u00020\u0011J\u0016\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014J\u000e\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u0018J\u0006\u0010\u0019\u001a\u00020\u0011R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u001e\u0010\n\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u0006@BX\u0080\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\bR\u001e\u0010\f\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u0006@BX\u0080\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\b\u00a8\u0006\u001a"}, d2={"Lcom/android/build/gradle/internal/testing/utp/UtpRunProfile$TimeSpan;", "", "clock", "Ljava/time/Clock;", "(Ljava/time/Clock;)V", "durationMs", "", "getDurationMs", "()J", "<set-?>", "endMs", "getEndMs$gradle_core", "startMs", "getStartMs$gradle_core", "isSet", "", "recordEnd", "", "recordFromInstants", "start", "Ljava/time/Instant;", "end", "recordFromProtoSpan", "span", "Lcom/android/tools/utp/plugins/deviceprovider/profile/proto/DeviceProviderProfileProto$TimeSpan;", "recordStart", "gradle-core"})
    private static final class TimeSpan {
        @NotNull
        private final Clock clock;
        private long startMs;
        private long endMs;

        public TimeSpan(@NotNull Clock clock) {
            Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
            this.clock = clock;
        }

        public final long getStartMs$gradle_core() {
            return this.startMs;
        }

        public final long getEndMs$gradle_core() {
            return this.endMs;
        }

        public final boolean isSet() {
            return this.startMs != 0L && this.endMs != 0L;
        }

        public final void recordStart() {
            this.startMs = this.clock.instant().toEpochMilli();
        }

        public final void recordEnd() {
            this.endMs = this.clock.instant().toEpochMilli();
        }

        public final void recordFromInstants(@NotNull Instant start, @NotNull Instant end) {
            Intrinsics.checkNotNullParameter((Object)start, (String)"start");
            Intrinsics.checkNotNullParameter((Object)end, (String)"end");
            this.startMs = start.toEpochMilli();
            this.endMs = end.toEpochMilli();
        }

        public final void recordFromProtoSpan(@NotNull DeviceProviderProfileProto.TimeSpan span) {
            Intrinsics.checkNotNullParameter((Object)span, (String)"span");
            if (span.getSpanBeginMs() == 0L) {
                return;
            }
            this.startMs = span.getSpanBeginMs();
            this.endMs = span.getSpanEndMs();
        }

        public final long getDurationMs() {
            return this.endMs - this.startMs;
        }
    }
}

