/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.attribution;

import com.android.build.gradle.internal.attribution.BuildAnalyzerConfiguratorService;
import com.android.build.gradle.internal.attribution.BuildAnalyzerPartialResult;
import com.android.build.gradle.internal.services.ServiceRegistrationAction;
import com.android.build.gradle.internal.utils.GradlePluginUtils;
import com.android.buildanalyzer.common.AndroidGradlePluginAttributionData;
import com.android.buildanalyzer.common.TaskCategoryIssue;
import com.android.builder.utils.ExceptionFunction;
import com.android.builder.utils.SynchronizedFile;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileWriter;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.gradle.api.Project;
import org.gradle.api.provider.MapProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.SetProperty;
import org.gradle.api.services.BuildService;
import org.gradle.api.services.BuildServiceParameters;
import org.gradle.build.event.BuildEventsListenerRegistry;
import org.gradle.tooling.events.FinishEvent;
import org.gradle.tooling.events.OperationCompletionListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\t\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u0000 \u00192\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u00032\u00060\u0004j\u0002`\u0005:\u0003\u0019\u001a\u001bB\u0007\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u000eJ\b\u0010\u0015\u001a\u00020\u0013H\u0016J\u0012\u0010\u0016\u001a\u00020\u00132\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0016R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R4\u0010\f\u001a&\u0012\f\u0012\n \u000f*\u0004\u0018\u00010\u000e0\u000e \u000f*\u0012\u0012\f\u0012\n \u000f*\u0004\u0018\u00010\u000e0\u000e\u0018\u00010\u00100\rX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0011\u00a8\u0006\u001c"}, d2={"Lcom/android/build/gradle/internal/attribution/BuildAnalyzerService;", "Lorg/gradle/api/services/BuildService;", "Lcom/android/build/gradle/internal/attribution/BuildAnalyzerService$Parameters;", "Lorg/gradle/tooling/events/OperationCompletionListener;", "Ljava/lang/AutoCloseable;", "Lkotlin/AutoCloseable;", "<init>", "()V", "initialGarbageCollectionData", "", "", "", "executionTimeTaskCategoryIssues", "", "Lcom/android/buildanalyzer/common/TaskCategoryIssue;", "kotlin.jvm.PlatformType", "", "Ljava/util/Set;", "reportBuildAnalyzerIssue", "", "issue", "close", "onFinish", "p0", "Lorg/gradle/tooling/events/FinishEvent;", "Companion", "Parameters", "RegistrationAction", "gradle-core"})
@SourceDebugExtension(value={"SMAP\nBuildAnalyzerService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BuildAnalyzerService.kt\ncom/android/build/gradle/internal/attribution/BuildAnalyzerService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,187:1\n1187#2,2:188\n1261#2,4:190\n1557#2:194\n1628#2,3:195\n774#2:198\n865#2,2:199\n*S KotlinDebug\n*F\n+ 1 BuildAnalyzerService.kt\ncom/android/build/gradle/internal/attribution/BuildAnalyzerService\n*L\n84#1:188,2\n84#1:190,4\n99#1:194\n99#1:195,3\n104#1:198\n104#1:199,2\n*E\n"})
public abstract class BuildAnalyzerService
implements BuildService<Parameters>,
OperationCompletionListener,
AutoCloseable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Map<String, Long> initialGarbageCollectionData;
    private final Set<TaskCategoryIssue> executionTimeTaskCategoryIssues;

    /*
     * WARNING - void declaration
     */
    public BuildAnalyzerService() {
        void $this$associateTo$iv$iv;
        void $this$associate$iv;
        List<GarbageCollectorMXBean> list = ManagementFactory.getGarbageCollectorMXBeans();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getGarbageCollectorMXBeans(...)");
        Iterable iterable = list;
        BuildAnalyzerService buildAnalyzerService = this;
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        void var4_5 = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map = destination$iv$iv;
            GarbageCollectorMXBean it = (GarbageCollectorMXBean)element$iv$iv;
            boolean bl = false;
            Pair pair = TuplesKt.to((Object)it.getName(), (Object)it.getCollectionTime());
            map.put(pair.getFirst(), pair.getSecond());
        }
        buildAnalyzerService.initialGarbageCollectionData = destination$iv$iv;
        this.executionTimeTaskCategoryIssues = Collections.synchronizedSet(new LinkedHashSet());
    }

    public final void reportBuildAnalyzerIssue(@NotNull TaskCategoryIssue issue) {
        Intrinsics.checkNotNullParameter((Object)((Object)issue), (String)"issue");
        this.executionTimeTaskCategoryIssues.add(issue);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void close() {
        void $this$filterTo$iv$iv;
        Pair it;
        Iterable $this$mapTo$iv$iv;
        if (!((Parameters)this.getParameters()).getAttributionFileLocation().isPresent()) {
            return;
        }
        List<GarbageCollectorMXBean> list = ManagementFactory.getGarbageCollectorMXBeans();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getGarbageCollectorMXBeans(...)");
        Iterable $this$map$iv = list;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            GarbageCollectorMXBean garbageCollectorMXBean = (GarbageCollectorMXBean)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string = it.getName();
            long l = it.getCollectionTime();
            String string2 = it.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
            collection.add(TuplesKt.to((Object)string, (Object)(l - ((Number)this.initialGarbageCollectionData.getOrDefault(string2, 0L)).longValue())));
        }
        Iterable $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (Pair)element$iv$iv;
            boolean bl = false;
            if (!(((Number)it.getSecond()).longValue() > 0L)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Map gcData = MapsKt.toMap((Iterable)((List)destination$iv$iv));
        BuildAnalyzerService.Companion.saveAttributionData(new File((String)((Parameters)this.getParameters()).getAttributionFileLocation().get()), (Function0<AndroidGradlePluginAttributionData>)((Function0)new Function0<AndroidGradlePluginAttributionData>(this, (Map<String, Long>)gcData){
            final /* synthetic */ BuildAnalyzerService this$0;
            final /* synthetic */ Map<String, Long> $gcData;
            {
                this.this$0 = $receiver;
                this.$gcData = $gcData;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            public final AndroidGradlePluginAttributionData invoke() {
                void $this$forEach$iv;
                Set set = BuildAnalyzerService.access$getExecutionTimeTaskCategoryIssues$p(this.this$0);
                Intrinsics.checkNotNullExpressionValue((Object)set, (String)"access$getExecutionTimeTaskCategoryIssues$p(...)");
                Object object = ((Parameters)this.this$0.getParameters()).getTaskCategoryIssues().get();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
                Set taskCategoryIssues = SetsKt.plus((Set)set, (Iterable)((Iterable)object));
                BuildAnalyzerPartialResult partialResults = new BuildAnalyzerPartialResult(taskCategoryIssues);
                File partialResultsOutputDir = AndroidGradlePluginAttributionData.Companion.getPartialResultsDir(new File((String)((Parameters)this.this$0.getParameters()).getAttributionFileLocation().get()));
                Iterable iterable = BuildAnalyzerPartialResult.Companion.getAllPartialResults(partialResultsOutputDir);
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    BuildAnalyzerPartialResult it = (BuildAnalyzerPartialResult)element$iv;
                    boolean bl = false;
                    partialResults.combineWith(it);
                }
                partialResults.saveToDir(partialResultsOutputDir);
                Object object2 = ((Parameters)this.this$0.getParameters()).getTasksSharingOutputs().get();
                Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"get(...)");
                Map map = (Map)object2;
                ClassLoader classLoader = this.this$0.getClass().getClassLoader();
                Intrinsics.checkNotNullExpressionValue((Object)classLoader, (String)"getClassLoader(...)");
                Set<String> set2 = GradlePluginUtils.getBuildSrcPlugins(classLoader);
                Object object3 = ((Parameters)this.this$0.getParameters()).getJavaInfo().get();
                Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"get(...)");
                AndroidGradlePluginAttributionData.JavaInfo javaInfo = (AndroidGradlePluginAttributionData.JavaInfo)object3;
                Object object4 = ((Parameters)this.this$0.getParameters()).getBuildscriptDependenciesInfo().get();
                Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"get(...)");
                Set set3 = (Set)object4;
                AndroidGradlePluginAttributionData.BuildInfo buildInfo = (AndroidGradlePluginAttributionData.BuildInfo)((Parameters)this.this$0.getParameters()).getBuildInfo().get();
                Object object5 = ((Parameters)this.this$0.getParameters()).getTaskNameToTaskInfoMap().get();
                Intrinsics.checkNotNullExpressionValue((Object)object5, (String)"get(...)");
                return new AndroidGradlePluginAttributionData(map, this.$gcData, set2, javaInfo, set3, buildInfo, (Map)object5, CollectionsKt.toList((Iterable)partialResults.getIssues()));
            }
        }));
    }

    public void onFinish(@Nullable FinishEvent p0) {
    }

    public static final /* synthetic */ Set access$getExecutionTimeTaskCategoryIssues$p(BuildAnalyzerService $this) {
        return $this.executionTimeTaskCategoryIssues;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0002\u00a8\u0006\u000b"}, d2={"Lcom/android/build/gradle/internal/attribution/BuildAnalyzerService$Companion;", "", "<init>", "()V", "saveAttributionData", "", "outputDir", "Ljava/io/File;", "attributionData", "Lkotlin/Function0;", "Lcom/android/buildanalyzer/common/AndroidGradlePluginAttributionData;", "gradle-core"})
    public static final class Companion {
        private Companion() {
        }

        private final void saveAttributionData(File outputDir, Function0<AndroidGradlePluginAttributionData> attributionData) {
            File file = AndroidGradlePluginAttributionData.Companion.getAttributionFile(outputDir);
            file.getParentFile().mkdirs();
            SynchronizedFile.getInstanceWithMultiProcessLocking((File)file).write(new ExceptionFunction(file, attributionData){
                final /* synthetic */ File $file;
                final /* synthetic */ Function0<AndroidGradlePluginAttributionData> $attributionData;
                {
                    this.$file = $file;
                    this.$attributionData = $attributionData;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public final void accept(File it) {
                    Closeable closeable = new BufferedWriter(new FileWriter(this.$file));
                    Function0<AndroidGradlePluginAttributionData> function0 = this.$attributionData;
                    Throwable throwable = null;
                    try {
                        BufferedWriter it2 = (BufferedWriter)closeable;
                        boolean bl = false;
                        it2.write(AndroidGradlePluginAttributionData.AttributionDataAdapter.INSTANCE.toJson(function0.invoke()));
                        Unit unit = Unit.INSTANCE;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                    }
                }
            });
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001R\u0018\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R$\u0010\u0007\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\t0\bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0018\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u0006R\u0018\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00040\u0010X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0018\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0006R\u001e\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00170\bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u000bR\u0018\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0010X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u0012\u00a8\u0006\u001c\u00c0\u0006\u0003"}, d2={"Lcom/android/build/gradle/internal/attribution/BuildAnalyzerService$Parameters;", "Lorg/gradle/api/services/BuildServiceParameters;", "attributionFileLocation", "Lorg/gradle/api/provider/Property;", "", "getAttributionFileLocation", "()Lorg/gradle/api/provider/Property;", "tasksSharingOutputs", "Lorg/gradle/api/provider/MapProperty;", "", "getTasksSharingOutputs", "()Lorg/gradle/api/provider/MapProperty;", "javaInfo", "Lcom/android/buildanalyzer/common/AndroidGradlePluginAttributionData$JavaInfo;", "getJavaInfo", "buildscriptDependenciesInfo", "Lorg/gradle/api/provider/SetProperty;", "getBuildscriptDependenciesInfo", "()Lorg/gradle/api/provider/SetProperty;", "buildInfo", "Lcom/android/buildanalyzer/common/AndroidGradlePluginAttributionData$BuildInfo;", "getBuildInfo", "taskNameToTaskInfoMap", "Lcom/android/buildanalyzer/common/AndroidGradlePluginAttributionData$TaskInfo;", "getTaskNameToTaskInfoMap", "taskCategoryIssues", "Lcom/android/buildanalyzer/common/TaskCategoryIssue;", "getTaskCategoryIssues", "gradle-core"})
    public static interface Parameters
    extends BuildServiceParameters {
        @NotNull
        public Property<String> getAttributionFileLocation();

        @NotNull
        public MapProperty<String, List<String>> getTasksSharingOutputs();

        @NotNull
        public Property<AndroidGradlePluginAttributionData.JavaInfo> getJavaInfo();

        @NotNull
        public SetProperty<String> getBuildscriptDependenciesInfo();

        @NotNull
        public Property<AndroidGradlePluginAttributionData.BuildInfo> getBuildInfo();

        @NotNull
        public MapProperty<String, AndroidGradlePluginAttributionData.TaskInfo> getTaskNameToTaskInfoMap();

        @NotNull
        public SetProperty<TaskCategoryIssue> getTaskCategoryIssues();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B'\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0003H\u0016J\u000e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00020\u0012H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/android/build/gradle/internal/attribution/BuildAnalyzerService$RegistrationAction;", "Lcom/android/build/gradle/internal/services/ServiceRegistrationAction;", "Lcom/android/build/gradle/internal/attribution/BuildAnalyzerService;", "Lcom/android/build/gradle/internal/attribution/BuildAnalyzerService$Parameters;", "project", "Lorg/gradle/api/Project;", "attributionFileLocation", "", "listenersRegistry", "Lorg/gradle/build/event/BuildEventsListenerRegistry;", "buildAnalyzerConfiguratorService", "Lcom/android/build/gradle/internal/attribution/BuildAnalyzerConfiguratorService;", "<init>", "(Lorg/gradle/api/Project;Ljava/lang/String;Lorg/gradle/build/event/BuildEventsListenerRegistry;Lcom/android/build/gradle/internal/attribution/BuildAnalyzerConfiguratorService;)V", "configure", "", "parameters", "execute", "Lorg/gradle/api/provider/Provider;", "gradle-core"})
    public static final class RegistrationAction
    extends ServiceRegistrationAction<BuildAnalyzerService, Parameters> {
        @NotNull
        private final String attributionFileLocation;
        @NotNull
        private final BuildEventsListenerRegistry listenersRegistry;
        @NotNull
        private final BuildAnalyzerConfiguratorService buildAnalyzerConfiguratorService;

        public RegistrationAction(@NotNull Project project, @NotNull String attributionFileLocation, @NotNull BuildEventsListenerRegistry listenersRegistry, @NotNull BuildAnalyzerConfiguratorService buildAnalyzerConfiguratorService) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)attributionFileLocation, (String)"attributionFileLocation");
            Intrinsics.checkNotNullParameter((Object)listenersRegistry, (String)"listenersRegistry");
            Intrinsics.checkNotNullParameter((Object)buildAnalyzerConfiguratorService, (String)"buildAnalyzerConfiguratorService");
            super(project, BuildAnalyzerService.class, null, null, 12, null);
            this.attributionFileLocation = attributionFileLocation;
            this.listenersRegistry = listenersRegistry;
            this.buildAnalyzerConfiguratorService = buildAnalyzerConfiguratorService;
        }

        @Override
        public void configure(@NotNull Parameters parameters) {
            Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
            this.buildAnalyzerConfiguratorService.initBuildAnalyzerService(this.getProject(), this.attributionFileLocation, parameters);
        }

        @Override
        @NotNull
        public Provider<BuildAnalyzerService> execute() {
            Provider provider2;
            Provider it = provider2 = super.execute();
            boolean bl = false;
            this.listenersRegistry.onTaskCompletion(it);
            return provider2;
        }
    }
}

