/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.cxx.timing;

import com.android.build.gradle.internal.cxx.timing.TimingEnvironment;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0003\b\u0000\u0018\u0000 \u00172\u00060\u0001j\u0002`\u0002:\u0002\u0016\u0017B'\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\u0004\b\n\u0010\u000bJ\b\u0010\u000f\u001a\u00020\u0010H\u0016J\r\u0010\u0011\u001a\u00020\u0004H\u0000\u00a2\u0006\u0002\b\u0012J\u0010\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0015H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/android/build/gradle/internal/cxx/timing/TimingEnvironment;", "Ljava/lang/AutoCloseable;", "Lkotlin/AutoCloseable;", "timingFolder", "Ljava/io/File;", "outerTimingOperation", "", "currentTimeMillis", "Lkotlin/Function0;", "", "<init>", "(Ljava/io/File;Ljava/lang/String;Lkotlin/jvm/functions/Function0;)V", "timingScopeList", "", "Lcom/android/build/gradle/internal/cxx/timing/TimingEnvironment$TimingScope;", "close", "", "getTimingFile", "getTimingFile$gradle_core", "openParentsIfNeeded", "index", "", "TimingScope", "Companion", "gradle-core"})
public final class TimingEnvironment
implements AutoCloseable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final File timingFolder;
    @NotNull
    private final String outerTimingOperation;
    @NotNull
    private final Function0<Long> currentTimeMillis;
    @NotNull
    private final List<TimingScope> timingScopeList;
    @NotNull
    private static final ThreadLocal<Companion.TimingStack> stack;

    public TimingEnvironment(@NotNull File timingFolder, @NotNull String outerTimingOperation, @NotNull Function0<Long> currentTimeMillis) {
        Intrinsics.checkNotNullParameter((Object)timingFolder, (String)"timingFolder");
        Intrinsics.checkNotNullParameter((Object)outerTimingOperation, (String)"outerTimingOperation");
        Intrinsics.checkNotNullParameter(currentTimeMillis, (String)"currentTimeMillis");
        this.timingFolder = timingFolder;
        this.outerTimingOperation = outerTimingOperation;
        this.currentTimeMillis = currentTimeMillis;
        this.timingScopeList = new ArrayList();
        TimingEnvironment.Companion.push(this);
        File timingFile = this.getTimingFile$gradle_core();
        timingFile.getParentFile().mkdirs();
        FilesKt.appendText$default((File)timingFile, (String)"# C/C++ build system timings", null, (int)2, null);
        Companion.openTimingScope$gradle_core(this.outerTimingOperation);
    }

    public /* synthetic */ TimingEnvironment(File file, String string, Function0 function0, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            function0 = 1.INSTANCE;
        }
        this(file, string, (Function0<Long>)function0);
    }

    @Override
    public void close() {
        Companion.closeTimingScope$gradle_core();
        FilesKt.appendText$default((File)this.getTimingFile$gradle_core(), (String)"\n\n", null, (int)2, null);
        TimingEnvironment.Companion.pop();
    }

    @NotNull
    public final File getTimingFile$gradle_core() {
        return FilesKt.resolve((File)this.timingFolder, (String)(this.outerTimingOperation + "_" + Thread.currentThread().getId() + "_timing.txt"));
    }

    private final void openParentsIfNeeded(int index) {
        if (index >= this.timingScopeList.size() || this.timingScopeList.get(index).getOpenHasBeenReported()) {
            return;
        }
        this.openParentsIfNeeded(index + 1);
        File timingFile = this.getTimingFile$gradle_core();
        String indent = StringsKt.repeat((CharSequence)" ", (int)((this.timingScopeList.size() - index - 1) * 2));
        TimingScope parent = this.timingScopeList.get(index);
        FilesKt.appendText$default((File)timingFile, (String)("\n" + indent + parent.getOperation()), null, (int)2, null);
        parent.setOpenHasBeenReported(true);
    }

    static {
        ThreadLocal threadLocal = ThreadLocal.withInitial(Companion.stack.1.INSTANCE);
        Intrinsics.checkNotNullExpressionValue(threadLocal, (String)"withInitial(...)");
        stack = threadLocal;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001\u0016B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\b\u0010\u000b\u001a\u00020\bH\u0002J\u0015\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0000\u00a2\u0006\u0002\b\u0013J\r\u0010\u0014\u001a\u00020\bH\u0000\u00a2\u0006\u0002\b\u0015R\u0016\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0017"}, d2={"Lcom/android/build/gradle/internal/cxx/timing/TimingEnvironment$Companion;", "", "<init>", "()V", "stack", "Ljava/lang/ThreadLocal;", "Lcom/android/build/gradle/internal/cxx/timing/TimingEnvironment$Companion$TimingStack;", "push", "", "timing", "Lcom/android/build/gradle/internal/cxx/timing/TimingEnvironment;", "pop", "timerStackDepth", "", "getTimerStackDepth", "()I", "openTimingScope", "operation", "", "openTimingScope$gradle_core", "closeTimingScope", "closeTimingScope$gradle_core", "TimingStack", "gradle-core"})
    public static final class Companion {
        private Companion() {
        }

        private final void push(TimingEnvironment timing) {
            stack.set(new TimingStack(timing, (TimingStack)stack.get()));
        }

        private final void pop() {
            TimingStack next;
            TimingStack timingStack = (TimingStack)stack.get();
            TimingStack timingStack2 = next = timingStack != null ? timingStack.getNext() : null;
            if (next != null) {
                stack.set(next);
            } else {
                stack.remove();
            }
        }

        private final int getTimerStackDepth() {
            Object object = (TimingStack)stack.get();
            if (object == null || (object = ((TimingStack)object).getEnvironment()) == null) {
                throw new IllegalStateException("No active timing environment".toString());
            }
            Object environment = object;
            return ((TimingEnvironment)environment).timingScopeList.size();
        }

        public final void openTimingScope$gradle_core(@NotNull String operation) {
            Intrinsics.checkNotNullParameter((Object)operation, (String)"operation");
            Object object = (TimingStack)stack.get();
            if (object == null || (object = ((TimingStack)object).getEnvironment()) == null) {
                return;
            }
            Object environment = object;
            ((TimingEnvironment)environment).timingScopeList.add(0, new TimingScope(operation, ((Number)((TimingEnvironment)environment).currentTimeMillis.invoke()).longValue()));
        }

        public final void closeTimingScope$gradle_core() {
            Object object = (TimingStack)stack.get();
            if (object == null || (object = ((TimingStack)object).getEnvironment()) == null) {
                return;
            }
            Object environment = object;
            TimingScope timing = (TimingScope)CollectionsKt.first((List)((TimingEnvironment)environment).timingScopeList);
            File timingFile = ((TimingEnvironment)environment).getTimingFile$gradle_core();
            long end = ((Number)((TimingEnvironment)environment).currentTimeMillis.invoke()).longValue();
            long elapsed = end - timing.getStart();
            String indent = StringsKt.repeat((CharSequence)" ", (int)((this.getTimerStackDepth() - 1) * 2));
            TimingScope parent = (TimingScope)CollectionsKt.firstOrNull((List)CollectionsKt.drop((Iterable)((TimingEnvironment)environment).timingScopeList, (int)1));
            if (timing.getChildTimings() == 0) {
                if (elapsed >= 10L) {
                    ((TimingEnvironment)environment).openParentsIfNeeded(1);
                    if (parent != null) {
                        long gapElapsed = timing.getStart() - parent.getLastChildTimeReportedMs();
                        if (gapElapsed >= 10L) {
                            FilesKt.appendText$default((File)timingFile, (String)("\n" + indent + "[gap of " + gapElapsed + "ms]"), null, (int)2, null);
                        }
                        parent.setLastChildTimeReportedMs(end);
                        int n = parent.getChildTimings();
                        parent.setChildTimings(n + 1);
                    }
                    timing.setOpenHasBeenReported(true);
                    FilesKt.appendText$default((File)timingFile, (String)("\n" + indent + timing.getOperation() + " " + elapsed + "ms"), null, (int)2, null);
                }
            } else {
                ((TimingEnvironment)environment).openParentsIfNeeded(2);
                long gapElapsed = end - timing.getLastChildTimeReportedMs();
                if (gapElapsed >= 10L) {
                    FilesKt.appendText$default((File)timingFile, (String)("\n" + indent + "  [gap of " + gapElapsed + "ms]"), null, (int)2, null);
                }
                FilesKt.appendText$default((File)timingFile, (String)("\n" + indent + timing.getOperation() + " completed in " + elapsed + "ms"), null, (int)2, null);
                if (parent != null) {
                    parent.setLastChildTimeReportedMs(end);
                    int n = parent.getChildTimings();
                    parent.setChildTimings(n + 1);
                }
            }
            ((TimingEnvironment)environment).timingScopeList.remove(0);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0000\u00a2\u0006\u0004\b\u0005\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\f\u001a\u0004\u0018\u00010\u0000H\u00c6\u0003J\u001f\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0000H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0000\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Lcom/android/build/gradle/internal/cxx/timing/TimingEnvironment$Companion$TimingStack;", "", "environment", "Lcom/android/build/gradle/internal/cxx/timing/TimingEnvironment;", "next", "<init>", "(Lcom/android/build/gradle/internal/cxx/timing/TimingEnvironment;Lcom/android/build/gradle/internal/cxx/timing/TimingEnvironment$Companion$TimingStack;)V", "getEnvironment", "()Lcom/android/build/gradle/internal/cxx/timing/TimingEnvironment;", "getNext", "()Lcom/android/build/gradle/internal/cxx/timing/TimingEnvironment$Companion$TimingStack;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "gradle-core"})
        private static final class TimingStack {
            @NotNull
            private final TimingEnvironment environment;
            @Nullable
            private final TimingStack next;

            public TimingStack(@NotNull TimingEnvironment environment, @Nullable TimingStack next) {
                Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
                this.environment = environment;
                this.next = next;
            }

            @NotNull
            public final TimingEnvironment getEnvironment() {
                return this.environment;
            }

            @Nullable
            public final TimingStack getNext() {
                return this.next;
            }

            @NotNull
            public final TimingEnvironment component1() {
                return this.environment;
            }

            @Nullable
            public final TimingStack component2() {
                return this.next;
            }

            @NotNull
            public final TimingStack copy(@NotNull TimingEnvironment environment, @Nullable TimingStack next) {
                Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
                return new TimingStack(environment, next);
            }

            public static /* synthetic */ TimingStack copy$default(TimingStack timingStack, TimingEnvironment timingEnvironment, TimingStack timingStack2, int n, Object object) {
                if ((n & 1) != 0) {
                    timingEnvironment = timingStack.environment;
                }
                if ((n & 2) != 0) {
                    timingStack2 = timingStack.next;
                }
                return timingStack.copy(timingEnvironment, timingStack2);
            }

            @NotNull
            public String toString() {
                return "TimingStack(environment=" + this.environment + ", next=" + this.next + ")";
            }

            public int hashCode() {
                int result2 = this.environment.hashCode();
                result2 = result2 * 31 + (this.next == null ? 0 : this.next.hashCode());
                return result2;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof TimingStack)) {
                    return false;
                }
                TimingStack timingStack = (TimingStack)other;
                if (!Intrinsics.areEqual((Object)this.environment, (Object)timingStack.environment)) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.next, (Object)timingStack.next);
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010\b\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u000b\"\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0016\u001a\u00020\u0017X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001b\u00a8\u0006\u001c"}, d2={"Lcom/android/build/gradle/internal/cxx/timing/TimingEnvironment$TimingScope;", "", "operation", "", "start", "", "<init>", "(Ljava/lang/String;J)V", "getOperation", "()Ljava/lang/String;", "getStart", "()J", "openHasBeenReported", "", "getOpenHasBeenReported", "()Z", "setOpenHasBeenReported", "(Z)V", "lastChildTimeReportedMs", "getLastChildTimeReportedMs", "setLastChildTimeReportedMs", "(J)V", "childTimings", "", "getChildTimings", "()I", "setChildTimings", "(I)V", "gradle-core"})
    private static final class TimingScope {
        @NotNull
        private final String operation;
        private final long start;
        private boolean openHasBeenReported;
        private long lastChildTimeReportedMs;
        private int childTimings;

        public TimingScope(@NotNull String operation, long start) {
            Intrinsics.checkNotNullParameter((Object)operation, (String)"operation");
            this.operation = operation;
            this.lastChildTimeReportedMs = this.start = start;
        }

        @NotNull
        public final String getOperation() {
            return this.operation;
        }

        public final long getStart() {
            return this.start;
        }

        public final boolean getOpenHasBeenReported() {
            return this.openHasBeenReported;
        }

        public final void setOpenHasBeenReported(boolean bl) {
            this.openHasBeenReported = bl;
        }

        public final long getLastChildTimeReportedMs() {
            return this.lastChildTimeReportedMs;
        }

        public final void setLastChildTimeReportedMs(long l) {
            this.lastChildTimeReportedMs = l;
        }

        public final int getChildTimings() {
            return this.childTimings;
        }

        public final void setChildTimings(int n) {
            this.childTimings = n;
        }
    }
}

