/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.variant;

import com.android.build.api.dsl.ApkSigningConfig;
import com.android.build.api.dsl.DefaultConfig;
import com.android.build.api.dsl.ProductFlavor;
import com.android.build.gradle.internal.BuildTypeData;
import com.android.build.gradle.internal.ProductFlavorData;
import com.android.build.gradle.internal.api.LazyAndroidSourceSet;
import com.android.build.gradle.internal.dependency.SourceSetManager;
import com.android.build.gradle.internal.dsl.BuildType;
import com.android.build.gradle.internal.dsl.SigningConfig;
import com.android.build.gradle.internal.plugins.DslContainerProvider;
import com.android.build.gradle.internal.services.DslServices;
import com.android.build.gradle.internal.variant.VariantInputModel;
import com.android.build.gradle.options.BooleanOption;
import com.android.builder.core.ComponentType;
import com.android.builder.core.ComponentTypeImpl;
import com.android.utils.StringHelper;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.gradle.api.Named;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\n\b&\u0018\u0000 **\b\b\u0000\u0010\u0001*\u00020\u0002*\b\b\u0001\u0010\u0003*\u00020\u0004*\b\b\u0002\u0010\u0005*\u00020\u0006*\b\b\u0003\u0010\u0007*\u00020\b2\u001a\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u0003\u0012\u0004\u0012\u0002H\u0005\u0012\u0004\u0012\u0002H\u00070\t2\u001a\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u0003\u0012\u0004\u0012\u0002H\u0005\u0012\u0004\u0012\u0002H\u00070\n:\u0001*B\u001f\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0015\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00028\u0003H\u0004\u00a2\u0006\u0002\u0010#J\u0015\u0010$\u001a\u00020!2\u0006\u0010%\u001a\u00028\u0001H\u0004\u00a2\u0006\u0002\u0010&J\u0015\u0010'\u001a\u00020!2\u0006\u0010(\u001a\u00028\u0002H\u0004\u00a2\u0006\u0002\u0010)R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\u00020\u0010X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R&\u0010\u0015\u001a\u0014\u0012\u0004\u0012\u00020\u0017\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\u00180\u0016X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR&\u0010\u001b\u001a\u0014\u0012\u0004\u0012\u00020\u0017\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00020\u001c0\u0016X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001aR \u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00028\u00030\u0016X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u001a\u00a8\u0006+"}, d2={"Lcom/android/build/gradle/internal/variant/AbstractVariantInputManager;", "DefaultConfigT", "Lcom/android/build/api/dsl/DefaultConfig;", "BuildTypeT", "Lcom/android/build/api/dsl/BuildType;", "ProductFlavorT", "Lcom/android/build/api/dsl/ProductFlavor;", "SigningConfigT", "Lcom/android/build/api/dsl/ApkSigningConfig;", "Lcom/android/build/gradle/internal/variant/VariantInputModel;", "Lcom/android/build/gradle/internal/plugins/DslContainerProvider;", "dslServices", "Lcom/android/build/gradle/internal/services/DslServices;", "componentType", "Lcom/android/builder/core/ComponentType;", "sourceSetManager", "Lcom/android/build/gradle/internal/dependency/SourceSetManager;", "<init>", "(Lcom/android/build/gradle/internal/services/DslServices;Lcom/android/builder/core/ComponentType;Lcom/android/build/gradle/internal/dependency/SourceSetManager;)V", "getSourceSetManager", "()Lcom/android/build/gradle/internal/dependency/SourceSetManager;", "buildTypes", "", "", "Lcom/android/build/gradle/internal/BuildTypeData;", "getBuildTypes", "()Ljava/util/Map;", "productFlavors", "Lcom/android/build/gradle/internal/ProductFlavorData;", "getProductFlavors", "signingConfigs", "getSigningConfigs", "addSigningConfig", "", "signingConfig", "(Lcom/android/build/api/dsl/ApkSigningConfig;)V", "addBuildType", "buildType", "(Lcom/android/build/api/dsl/BuildType;)V", "addProductFlavor", "productFlavor", "(Lcom/android/build/api/dsl/ProductFlavor;)V", "Companion", "gradle-core"})
@SourceDebugExtension(value={"SMAP\nAbstractVariantInputManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbstractVariantInputManager.kt\ncom/android/build/gradle/internal/variant/AbstractVariantInputManager\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,263:1\n1#2:264\n*E\n"})
public abstract class AbstractVariantInputManager<DefaultConfigT extends DefaultConfig, BuildTypeT extends com.android.build.api.dsl.BuildType, ProductFlavorT extends ProductFlavor, SigningConfigT extends ApkSigningConfig>
implements VariantInputModel<DefaultConfigT, BuildTypeT, ProductFlavorT, SigningConfigT>,
DslContainerProvider<DefaultConfigT, BuildTypeT, ProductFlavorT, SigningConfigT> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DslServices dslServices;
    @NotNull
    private final ComponentType componentType;
    @NotNull
    private final SourceSetManager sourceSetManager;
    @NotNull
    private final Map<String, BuildTypeData<BuildTypeT>> buildTypes;
    @NotNull
    private final Map<String, ProductFlavorData<ProductFlavorT>> productFlavors;
    @NotNull
    private final Map<String, SigningConfigT> signingConfigs;

    public AbstractVariantInputManager(@NotNull DslServices dslServices2, @NotNull ComponentType componentType, @NotNull SourceSetManager sourceSetManager) {
        Intrinsics.checkNotNullParameter((Object)dslServices2, (String)"dslServices");
        Intrinsics.checkNotNullParameter((Object)componentType, (String)"componentType");
        Intrinsics.checkNotNullParameter((Object)sourceSetManager, (String)"sourceSetManager");
        this.dslServices = dslServices2;
        this.componentType = componentType;
        this.sourceSetManager = sourceSetManager;
        this.buildTypes = new LinkedHashMap();
        this.productFlavors = new LinkedHashMap();
        this.signingConfigs = new LinkedHashMap();
    }

    @Override
    @NotNull
    public SourceSetManager getSourceSetManager() {
        return this.sourceSetManager;
    }

    @Override
    @NotNull
    public Map<String, BuildTypeData<BuildTypeT>> getBuildTypes() {
        return this.buildTypes;
    }

    @Override
    @NotNull
    public Map<String, ProductFlavorData<ProductFlavorT>> getProductFlavors() {
        return this.productFlavors;
    }

    @Override
    @NotNull
    public Map<String, SigningConfigT> getSigningConfigs() {
        return this.signingConfigs;
    }

    protected final void addSigningConfig(@NotNull SigningConfigT signingConfig2) {
        Intrinsics.checkNotNullParameter(signingConfig2, (String)"signingConfig");
        this.getSigningConfigs().put(((Named)signingConfig2).getName(), signingConfig2);
    }

    protected final void addBuildType(@NotNull BuildTypeT buildType) {
        Intrinsics.checkNotNullParameter(buildType, (String)"buildType");
        String name = ((Named)buildType).getName();
        Intrinsics.checkNotNull((Object)name);
        AbstractVariantInputManager.Companion.checkName(name, "BuildType");
        if (this.getProductFlavors().containsKey(name)) {
            throw new RuntimeException("BuildType names cannot collide with ProductFlavor names");
        }
        if (buildType instanceof BuildType) {
            if (this.componentType.isDynamicFeature()) {
                ((BuildType)buildType).init();
            } else {
                BuildType buildType2 = (BuildType)buildType;
                Object object = this.getSigningConfigContainer().findByName("debug");
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type com.android.build.gradle.internal.dsl.SigningConfig");
                buildType2.init((SigningConfig)object);
            }
        } else {
            throw new RuntimeException("Unexpected instance of BuildTypeT");
        }
        LazyAndroidSourceSet androidTestSourceSet = this.componentType.getHasTestComponents() ? this.getSourceSetManager().setUpSourceSet(AbstractVariantInputManager.Companion.computeSourceSetName(((BuildType)buildType).getName(), (ComponentType)ComponentTypeImpl.ANDROID_TEST), (ComponentType)ComponentTypeImpl.ANDROID_TEST) : null;
        LazyAndroidSourceSet unitTestSourceSet = this.componentType.getHasTestComponents() ? this.getSourceSetManager().setUpSourceSet(AbstractVariantInputManager.Companion.computeSourceSetName(((BuildType)buildType).getName(), (ComponentType)ComponentTypeImpl.UNIT_TEST), (ComponentType)ComponentTypeImpl.UNIT_TEST) : null;
        LazyAndroidSourceSet testFixturesSourceSet = this.componentType.getHasTestComponents() ? this.getSourceSetManager().setUpSourceSet(AbstractVariantInputManager.Companion.computeSourceSetName(((BuildType)buildType).getName(), (ComponentType)ComponentTypeImpl.TEST_FIXTURES), (ComponentType)ComponentTypeImpl.TEST_FIXTURES) : null;
        boolean screenshotTestEnabled = this.dslServices.getProjectOptions().get(BooleanOption.ENABLE_SCREENSHOT_TEST);
        LazyAndroidSourceSet screenshotTestSourceSet = screenshotTestEnabled ? (this.componentType.getHasTestComponents() ? this.getSourceSetManager().setUpSourceSet(AbstractVariantInputManager.Companion.computeSourceSetName(((BuildType)buildType).getName(), (ComponentType)ComponentTypeImpl.SCREENSHOT_TEST), (ComponentType)ComponentTypeImpl.SCREENSHOT_TEST) : null) : null;
        this.getBuildTypes().put(name, new BuildTypeData<BuildTypeT>(buildType, this.getSourceSetManager().setUpSourceSet(((BuildType)buildType).getName(), this.componentType).get(), testFixturesSourceSet, androidTestSourceSet, unitTestSourceSet, screenshotTestSourceSet, this.dslServices.getProjectOptions().get(BooleanOption.ENABLE_NEW_TEST_DSL)));
    }

    protected final void addProductFlavor(@NotNull ProductFlavorT productFlavor) {
        Intrinsics.checkNotNullParameter(productFlavor, (String)"productFlavor");
        String name = productFlavor.getName();
        String string = productFlavor.getDimension();
        if (string != null) {
            String it = string;
            boolean bl = false;
            AbstractVariantInputManager.Companion.checkName(it, "FlavorDimension");
        }
        AbstractVariantInputManager.Companion.checkName(name, "ProductFlavor");
        if (this.getBuildTypes().containsKey(name)) {
            throw new RuntimeException("ProductFlavor names cannot collide with BuildType names");
        }
        LazyAndroidSourceSet mainSourceSet = this.getSourceSetManager().setUpSourceSet(productFlavor.getName(), this.componentType);
        LazyAndroidSourceSet testFixturesSourceSet = null;
        LazyAndroidSourceSet androidTestSourceSet = null;
        LazyAndroidSourceSet unitTestSourceSet = null;
        LazyAndroidSourceSet screenshotTestSourceSet = null;
        if (this.componentType.getHasTestComponents()) {
            androidTestSourceSet = this.getSourceSetManager().setUpSourceSet(AbstractVariantInputManager.Companion.computeSourceSetName(productFlavor.getName(), (ComponentType)ComponentTypeImpl.ANDROID_TEST), (ComponentType)ComponentTypeImpl.ANDROID_TEST);
            unitTestSourceSet = this.getSourceSetManager().setUpSourceSet(AbstractVariantInputManager.Companion.computeSourceSetName(productFlavor.getName(), (ComponentType)ComponentTypeImpl.UNIT_TEST), (ComponentType)ComponentTypeImpl.UNIT_TEST);
            testFixturesSourceSet = this.getSourceSetManager().setUpSourceSet(AbstractVariantInputManager.Companion.computeSourceSetName(productFlavor.getName(), (ComponentType)ComponentTypeImpl.TEST_FIXTURES), (ComponentType)ComponentTypeImpl.TEST_FIXTURES);
            boolean screenshotTestEnabled = this.dslServices.getProjectOptions().get(BooleanOption.ENABLE_SCREENSHOT_TEST);
            screenshotTestSourceSet = screenshotTestEnabled ? this.getSourceSetManager().setUpSourceSet(AbstractVariantInputManager.Companion.computeSourceSetName(productFlavor.getName(), (ComponentType)ComponentTypeImpl.SCREENSHOT_TEST), (ComponentType)ComponentTypeImpl.SCREENSHOT_TEST) : null;
        }
        ProductFlavorData<ProductFlavorT> productFlavorData = new ProductFlavorData<ProductFlavorT>(productFlavor, mainSourceSet.get(), testFixturesSourceSet, androidTestSourceSet, unitTestSourceSet, screenshotTestSourceSet, this.dslServices.getProjectOptions().get(BooleanOption.ENABLE_NEW_TEST_DSL));
        this.getProductFlavors().put(productFlavor.getName(), productFlavorData);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u0005H\u0002J\u0018\u0010\r\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u0005H\u0002J \u0010\u000e\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0005H\u0002\u00a8\u0006\u0010"}, d2={"Lcom/android/build/gradle/internal/variant/AbstractVariantInputManager$Companion;", "", "<init>", "()V", "computeSourceSetName", "", "baseName", "componentType", "Lcom/android/builder/core/ComponentType;", "checkWhitespace", "", "name", "displayName", "checkName", "checkPrefix", "prefix", "gradle-core"})
    public static final class Companion {
        private Companion() {
        }

        private final String computeSourceSetName(String baseName2, ComponentType componentType) {
            String name = baseName2;
            if (StringsKt.endsWith$default((String)name, (String)componentType.getSuffix(), (boolean)false, (int)2, null)) {
                String string = name.substring(0, name.length() - componentType.getSuffix().length());
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                name = string;
            }
            if (!(((CharSequence)componentType.getPrefix()).length() == 0)) {
                name = StringHelper.appendCapitalized((String)componentType.getPrefix(), (String)name);
            }
            return name;
        }

        private final void checkWhitespace(String name, String displayName) {
            CharSequence charSequence = name;
            if (new Regex("\\s+").containsMatchIn(charSequence)) {
                String string = "%1$s names cannot contain whitespace";
                Object[] objectArray = new Object[]{displayName};
                String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
                throw new RuntimeException(string2);
            }
        }

        private final void checkName(String name, String displayName) {
            this.checkWhitespace(name, displayName);
            this.checkPrefix(name, displayName, "androidTest");
            this.checkPrefix(name, displayName, "test");
            if (Intrinsics.areEqual((Object)"lint", (Object)name)) {
                String string = "%1$s names cannot be %2$s";
                Object[] objectArray = new Object[]{displayName, "lint"};
                String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
                throw new RuntimeException(string2);
            }
        }

        private final void checkPrefix(String name, String displayName, String prefix) {
            if (StringsKt.startsWith$default((String)name, (String)prefix, (boolean)false, (int)2, null)) {
                String string = "%1$s names cannot start with '%2$s'";
                Object[] objectArray = new Object[]{displayName, prefix};
                String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
                throw new RuntimeException(string2);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

