/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.external.gnumake;

import com.android.build.gradle.external.gnumake.BuildStepInfo;
import com.android.utils.SparseArray;
import com.google.common.base.Joiner;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

class FlowAnalyzer {
    FlowAnalyzer() {
    }

    static ListMultimap<String, List<BuildStepInfo>> analyze(List<BuildStepInfo> commandSummaries) {
        HashMap<String, Integer> outputToCommand = new HashMap<String, Integer>();
        ArrayList outputToTerminals = new ArrayList();
        SparseArray commandOutputsConsumed = new SparseArray();
        for (int i = 0; i < commandSummaries.size(); ++i) {
            BuildStepInfo current = commandSummaries.get(i);
            if (current.getInputsAreSourceFiles() && current.getInputs().size() != 1) {
                throw new RuntimeException(String.format("GNUMAKE: Expected exactly one source file in compile step: %s\nbut received: \n%s", current, Joiner.on((String)"\n").join(current.getInputs())));
            }
            commandOutputsConsumed.put(i, new HashSet());
            HashSet<BuildStepInfo> terminals = new HashSet<BuildStepInfo>();
            for (String input : current.getInputs()) {
                if (outputToCommand.containsKey(input)) {
                    int inputCommandIndex = (Integer)outputToCommand.get(input);
                    terminals.addAll((Collection)outputToTerminals.get(inputCommandIndex));
                    ((Set)commandOutputsConsumed.get(inputCommandIndex)).add(input);
                    continue;
                }
                if (!current.getInputsAreSourceFiles()) continue;
                terminals.add(current);
            }
            outputToTerminals.add(terminals);
            for (String output2 : current.getOutputs()) {
                outputToCommand.put(output2, i);
            }
        }
        ArrayListMultimap result2 = ArrayListMultimap.create();
        for (int i = 0; i < commandSummaries.size(); ++i) {
            BuildStepInfo current = commandSummaries.get(i);
            Set outputsConsumed = (Set)commandOutputsConsumed.get(i);
            for (String output3 : current.getOutputs()) {
                if (outputsConsumed.contains(output3) && current.getInputsAreSourceFiles()) continue;
                ArrayList ordered = new ArrayList();
                ordered.addAll((Collection)outputToTerminals.get(i));
                Collections.sort(ordered, Comparator.comparing(BuildStepInfo::getOnlyInput));
                result2.put((Object)output3, ordered);
            }
        }
        return result2;
    }
}

