/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.gradle.internal.tasks.AarMetadataArtifact;
import com.android.build.gradle.internal.tasks.AarMetadataReader;
import com.android.build.gradle.internal.tasks.CheckAarMetadataWorkParameters;
import com.android.build.gradle.internal.utils.AarMetadataCheckKt;
import com.android.build.gradle.internal.utils.CompileData;
import com.android.build.gradle.internal.utils.SdkUtilsKt;
import com.android.ide.common.repository.AgpVersion;
import com.android.repository.Revision;
import com.android.sdklib.SdkVersionInfo;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.gradle.workers.WorkAction;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b&\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0014B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\u001e\u0010\u0007\u001a\u00020\u0006*\u00060\bj\u0002`\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0002J\u001e\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u0010H\u0002J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\fH\u0002\u00a8\u0006\u0015"}, d2={"Lcom/android/build/gradle/internal/tasks/CheckAarMetadataWorkAction;", "Lorg/gradle/workers/WorkAction;", "Lcom/android/build/gradle/internal/tasks/CheckAarMetadataWorkParameters;", "<init>", "()V", "execute", "", "appendNumberedErrorMessages", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "errorMessages", "", "", "checkAarMetadataArtifact", "aarMetadataArtifact", "Lcom/android/build/gradle/internal/tasks/AarMetadataArtifact;", "", "getApiIntFromString", "", "sdkVersion", "DesugarJdkVariant", "gradle-core"})
@SourceDebugExtension(value={"SMAP\nCheckAarMetadataTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CheckAarMetadataTask.kt\ncom/android/build/gradle/internal/tasks/CheckAarMetadataWorkAction\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,681:1\n1863#2,2:682\n1863#2,2:684\n1872#2,2:686\n1872#2,3:688\n1874#2:691\n1#3:692\n*S KotlinDebug\n*F\n+ 1 CheckAarMetadataTask.kt\ncom/android/build/gradle/internal/tasks/CheckAarMetadataWorkAction\n*L\n270#1:682,2\n273#1:684,2\n318#1:686,2\n322#1:688,3\n318#1:691\n*E\n"})
public abstract class CheckAarMetadataWorkAction
implements WorkAction<CheckAarMetadataWorkParameters> {
    public void execute() {
        Object it;
        List errorMessages = new ArrayList();
        Object object = ((CheckAarMetadataWorkParameters)this.getParameters()).getAarMetadataArtifacts().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        Iterable $this$forEach$iv = (Iterable)object;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (AarMetadataArtifact)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            this.checkAarMetadataArtifact((AarMetadataArtifact)it, errorMessages);
        }
        Object object2 = ((CheckAarMetadataWorkParameters)this.getParameters()).getDisallowedAsarArtifacts().get();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"get(...)");
        $this$forEach$iv = (Iterable)object2;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (String)element$iv;
            boolean bl = false;
            errorMessages.add(StringsKt.trimIndent((String)("\n                Dependency " + (String)it + " is an Android Privacy Sandbox SDK library, and needs\n                Privacy Sandbox support to be enabled in projects that depend on it.\n\n                Recommended action: Enable privacy sandbox consumption in this project by setting\n                    android {\n                        privacySandbox {\n                            enable = true\n                        }\n                    }\n                in this project's build.gradle\n                ")));
        }
        if (errorMessages.size() > 0) {
            StringBuilder stringBuilder;
            StringBuilder $this$execute_u24lambda_u242 = stringBuilder = new StringBuilder();
            boolean bl = false;
            StringBuilder stringBuilder2 = errorMessages.size() == 1 ? $this$execute_u24lambda_u242.append("An issue was") : $this$execute_u24lambda_u242.append(errorMessages.size()).append(" issues were");
            $this$execute_u24lambda_u242.append(" found when checking AAR metadata:");
            this.appendNumberedErrorMessages($this$execute_u24lambda_u242, errorMessages);
            String string = stringBuilder.toString();
            throw new RuntimeException(string);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void appendNumberedErrorMessages(StringBuilder $this$appendNumberedErrorMessages, List<String> errorMessages) {
        Iterable $this$forEachIndexed$iv = errorMessages;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void errorMessage;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            String string = (String)item$iv;
            int index = n;
            boolean bl = false;
            $this$appendNumberedErrorMessages.append("\n\n");
            String string2 = "%3d";
            Locale locale = Locale.US;
            Object[] objectArray = new Object[]{index + 1};
            String string3 = String.format(locale, string2, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(...)");
            $this$appendNumberedErrorMessages.append(string3);
            $this$appendNumberedErrorMessages.append(".  ");
            Iterable $this$forEachIndexed$iv2 = StringsKt.lines((CharSequence)((CharSequence)errorMessage));
            boolean $i$f$forEachIndexed2 = false;
            int index$iv2 = 0;
            for (Object item$iv2 : $this$forEachIndexed$iv2) {
                void line;
                int n2;
                if ((n2 = index$iv2++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                String string4 = (String)item$iv2;
                int lineIndex = n2;
                boolean bl2 = false;
                if (lineIndex > 0) {
                    $this$appendNumberedErrorMessages.append("\n");
                    if (((CharSequence)line).length() > 0) {
                        $this$appendNumberedErrorMessages.append("      ");
                    }
                }
                $this$appendNumberedErrorMessages.append((String)line);
            }
        }
    }

    private final void checkAarMetadataArtifact(AarMetadataArtifact aarMetadataArtifact, List<String> errorMessages) {
        block31: {
            Object object;
            Object object2;
            String coreLibraryDesugaringEnabled;
            String minAgpVersion;
            File aarMetadataFile = aarMetadataArtifact.getFile();
            String displayName = aarMetadataArtifact.getDisplayName();
            AarMetadataReader aarMetadataReader = new AarMetadataReader(aarMetadataFile);
            String aarFormatVersion = aarMetadataReader.getAarFormatVersion();
            if (aarFormatVersion == null) {
                errorMessages.add(StringsKt.trimIndent((String)("\n                    The AAR metadata for dependency '" + displayName + "' does not specify an\n                    aarFormatVersion value, which is a required value.\n                    ")));
            } else {
                Boolean majorAarVersion22;
                try {
                    int majorAarVersion22 = Revision.parseRevision((String)aarFormatVersion).getMajor();
                    int maxMajorAarVersion = Revision.parseRevision((String)((String)((CheckAarMetadataWorkParameters)this.getParameters()).getAarFormatVersion().get())).getMajor();
                    if (majorAarVersion22 > maxMajorAarVersion) {
                        errorMessages.add(StringsKt.trimIndent((String)("\n                            Dependency '" + displayName + "' has an aarFormatVersion value of\n                            '" + aarFormatVersion + "', which is not compatible with this version of the\n                            Android Gradle plugin.\n\n                            Please upgrade to a newer version of the Android Gradle plugin.\n                            ")));
                    }
                    majorAarVersion22 = Unit.INSTANCE;
                }
                catch (NumberFormatException e) {
                    majorAarVersion22 = errorMessages.add(StringsKt.trimIndent((String)("\n                        The AAR metadata for dependency '" + displayName + "' has an invalid\n                        aarFormatVersion value (" + aarFormatVersion + ").\n\n                        " + e.getMessage() + "\n                        ")));
                }
            }
            String aarMetadataVersion = aarMetadataReader.getAarMetadataVersion();
            if (aarMetadataVersion == null) {
                errorMessages.add(StringsKt.trimIndent((String)("\n                    The AAR metadata for dependency '" + displayName + "' does not specify an\n                    aarMetadataVersion value, which is a required value.\n                    ")));
            } else {
                try {
                    int majorAarMetadataVersion22 = Revision.parseRevision((String)aarMetadataVersion).getMajor();
                    int maxMajorAarMetadataVersion = Revision.parseRevision((String)((String)((CheckAarMetadataWorkParameters)this.getParameters()).getAarMetadataVersion().get())).getMajor();
                    if (majorAarMetadataVersion22 > maxMajorAarMetadataVersion) {
                        errorMessages.add(StringsKt.trimIndent((String)("\n                            Dependency '" + displayName + "' has an aarMetadataVersion value of\n                            '" + aarMetadataVersion + "', which is not compatible with this version of the\n                            Android Gradle plugin.\n\n                            Please upgrade to a newer version of the Android Gradle plugin.\n                            ")));
                    }
                    Unit majorAarMetadataVersion22 = Unit.INSTANCE;
                }
                catch (NumberFormatException e) {
                    Boolean majorAarMetadataVersion22 = errorMessages.add(StringsKt.trimIndent((String)("\n                        The AAR metadata for dependency '" + displayName + "' has an invalid\n                        aarMetadataVersion value (" + aarMetadataVersion + ").\n\n                        " + e.getMessage() + "\n                        ")));
                }
            }
            if (!((Boolean)((CheckAarMetadataWorkParameters)this.getParameters()).getDisableCompileSdkChecks().get()).booleanValue()) {
                String minCompileSdkExtension;
                String minCompileSdk;
                String forceCompileSdkPreview = aarMetadataReader.getForceCompileSdkPreview();
                if (forceCompileSdkPreview != null) {
                    String compileSdkVersion2 = (String)((CheckAarMetadataWorkParameters)this.getParameters()).getCompileSdkVersion().get();
                    Object object3 = ((CheckAarMetadataWorkParameters)this.getParameters()).getCompileSdkVersion().get();
                    Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"get(...)");
                    String compileSdkPreview = SdkUtilsKt.parseTargetHash((String)object3).getCodeName();
                    if (!Intrinsics.areEqual((Object)compileSdkPreview, (Object)forceCompileSdkPreview)) {
                        errorMessages.add(StringsKt.trimIndent((String)("\n                            Dependency '" + displayName + "' requires libraries and applications that\n                            depend on it to compile against codename \"" + forceCompileSdkPreview + "\" of the\n                            Android APIs.\n\n                            " + ((CheckAarMetadataWorkParameters)this.getParameters()).getProjectPath().get() + " is currently compiled against " + compileSdkVersion2 + ".\n\n                            Recommended action: Use a different version of dependency '" + displayName + "',\n                            or set compileSdkPreview to \"" + forceCompileSdkPreview + "\" in your build.gradle\n                            file if you intend to experiment with that preview SDK.\n                        ")));
                    }
                }
                if ((minCompileSdk = aarMetadataReader.getMinCompileSdk()) != null) {
                    Integer minCompileSdkInt = StringsKt.toIntOrNull((String)minCompileSdk);
                    if (minCompileSdkInt == null) {
                        errorMessages.add(StringsKt.trimIndent((String)("\n                            The AAR metadata for dependency '" + displayName + "' has an invalid\n                            minCompileSdk value (" + minCompileSdk + ").\n\n                            minCompileSdk must be an integer.\n                            ")));
                    } else {
                        String compileSdkVersion3 = (String)((CheckAarMetadataWorkParameters)this.getParameters()).getCompileSdkVersion().get();
                        Intrinsics.checkNotNull((Object)compileSdkVersion3);
                        int it = this.getApiIntFromString(compileSdkVersion3);
                        boolean bl = false;
                        Integer compileSdkVersionInt = it > 35 ? (Integer)((CheckAarMetadataWorkParameters)this.getParameters()).getPlatformSdkApiLevel().get() : Integer.valueOf(it);
                        if (minCompileSdkInt > compileSdkVersionInt) {
                            Integer maxRecommendedCompileSdk = (Integer)((CheckAarMetadataWorkParameters)this.getParameters()).getMaxRecommendedStableCompileSdkVersionForThisAgp().get();
                            String recommendation = minCompileSdkInt <= maxRecommendedCompileSdk ? StringsKt.trimIndent((String)("\n                                Recommended action: Update this project to use a newer compileSdk\n                                of at least " + minCompileSdk + ", for example " + maxRecommendedCompileSdk + ".\n                            ")) : StringsKt.trimIndent((String)("\n                                Also, the maximum recommended compile SDK version for Android Gradle\n                                plugin " + ((CheckAarMetadataWorkParameters)this.getParameters()).getAgpVersion().get() + " is " + maxRecommendedCompileSdk + ".\n\n                                Recommended action: Update this project's version of the Android Gradle\n                                plugin to one that supports " + minCompileSdk + ", then update this project to use\n                                compileSdk of at least " + minCompileSdk + ".\n                            "));
                            errorMessages.add(StringsKt.trimIndent((String)("\n                                Dependency '" + displayName + "' requires libraries and applications that\n                                depend on it to compile against version " + minCompileSdk + " or later of the\n                                Android APIs.\n\n                                " + ((CheckAarMetadataWorkParameters)this.getParameters()).getProjectPath().get() + " is currently compiled against " + compileSdkVersion3 + ".\n                            ")) + "\n\n" + recommendation + "\n\nNote that updating a library or application's compileSdk (which\nallows newer APIs to be used) can be done separately from updating\ntargetSdk (which opts the app in to new runtime behavior) and\nminSdk (which determines which devices the app can be installed\non).");
                        }
                    }
                }
                if ((minCompileSdkExtension = aarMetadataReader.getMinCompileSdkExtension()) != null) {
                    Integer minCompileSdkExtensionInt = StringsKt.toIntOrNull((String)minCompileSdkExtension);
                    if (minCompileSdkExtensionInt == null) {
                        errorMessages.add(StringsKt.trimIndent((String)("\n                        The AAR metadata for dependency '" + displayName + "' has an invalid\n                        minCompileSdkExtension value (" + minCompileSdkExtension + ").\n\n                        minCompileSdkExtension must be an integer.\n                        ")));
                    } else {
                        int compileSdkExtension;
                        int n;
                        Object object4 = ((CheckAarMetadataWorkParameters)this.getParameters()).getCompileSdkVersion().get();
                        Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"get(...)");
                        Integer n2 = SdkUtilsKt.parseTargetHash((String)object4).getSdkExtension();
                        if (n2 != null) {
                            n = n2;
                        } else {
                            Integer n3 = (Integer)((CheckAarMetadataWorkParameters)this.getParameters()).getPlatformSdkExtension().getOrNull();
                            n = compileSdkExtension = n3 != null ? n3 : 0;
                        }
                        if (minCompileSdkExtensionInt > compileSdkExtension) {
                            errorMessages.add(StringsKt.trimIndent((String)("\n                            Dependency '" + displayName + "' requires libraries and applications that\n                            depend on it to compile against an SDK with an extension level of\n                            " + minCompileSdkExtension + " or higher.\n\n                            Recommended action: Update this project to use a compileSdkExtension\n                            value of at least " + minCompileSdkExtension + ".\n                        ")));
                        }
                    }
                }
            }
            if ((minAgpVersion = aarMetadataReader.getMinAgpVersion()) != null) {
                AgpVersion parsedMinAgpVersion = AgpVersion.Companion.tryParseStable(minAgpVersion);
                if (parsedMinAgpVersion == null) {
                    errorMessages.add(StringsKt.trimIndent((String)("\n                        The AAR metadata for dependency '" + displayName + "' has an invalid\n                        minAndroidGradlePluginVersion value (" + minAgpVersion + ").\n\n                        minAndroidGradlePluginVersion must be a stable AGP version,\n                        formatted with major, minor, and micro values (for example \"4.0.0\").\n                        ")));
                } else {
                    Object object5 = ((CheckAarMetadataWorkParameters)this.getParameters()).getAgpVersion().get();
                    Intrinsics.checkNotNullExpressionValue((Object)object5, (String)"get(...)");
                    AgpVersion parsedAgpVersion = AgpVersion.Companion.parse((String)object5);
                    if (parsedMinAgpVersion.compareTo(parsedAgpVersion) > 0) {
                        errorMessages.add(StringsKt.trimIndent((String)("\n                            Dependency '" + displayName + "' requires Android Gradle plugin " + minAgpVersion + " or higher.\n\n                            This build currently uses Android Gradle plugin " + ((CheckAarMetadataWorkParameters)this.getParameters()).getAgpVersion().get() + ".\n                            ")));
                    }
                }
            }
            if ((coreLibraryDesugaringEnabled = aarMetadataReader.getCoreLibraryDesugaringEnabled()) == null || !((Boolean)((CheckAarMetadataWorkParameters)this.getParameters()).getCheckCoreLibraryDesugaring().get()).booleanValue()) break block31;
            if (Boolean.parseBoolean(coreLibraryDesugaringEnabled) && !((Boolean)((CheckAarMetadataWorkParameters)this.getParameters()).getCoreLibraryDesugaringEnabled().get()).booleanValue()) {
                errorMessages.add(StringsKt.trimIndent((String)("\n                        Dependency '" + displayName + "' requires core library desugaring to be enabled\n                        for " + ((CheckAarMetadataWorkParameters)this.getParameters()).getProjectPath().get() + ".\n\n                        See https://developer.android.com/studio/write/java8-support.html for more\n                        details.\n                    ")));
            }
            if ((object2 = aarMetadataReader.getDesugarJdkLibId()) != null && (object2 = StringsKt.split$default((CharSequence)((CharSequence)object2), (String[])(object = new String[]{":"}), (boolean)false, (int)0, (int)6, null)) != null) {
                Object it = object = object2;
                boolean bl = false;
                if (!(it.size() == 3)) {
                    boolean $i$a$-check-CheckAarMetadataWorkAction$checkAarMetadataArtifact$1$22 = false;
                    String $i$a$-check-CheckAarMetadataWorkAction$checkAarMetadataArtifact$1$22 = "Unexpected desugarJdkLib ID format from AAR metadata";
                    throw new IllegalStateException($i$a$-check-CheckAarMetadataWorkAction$checkAarMetadataArtifact$1$22.toString());
                }
                String variantFromAar = (String)it.get(1);
                String versionFromAar = (String)it.get(2);
                if (((CheckAarMetadataWorkParameters)this.getParameters()).getDesugarJdkVariant().isPresent() && ((CheckAarMetadataWorkParameters)this.getParameters()).getDesugarJdkVersion().isPresent()) {
                    Object object6 = ((CheckAarMetadataWorkParameters)this.getParameters()).getDesugarJdkVariant().get();
                    Intrinsics.checkNotNullExpressionValue((Object)object6, (String)"get(...)");
                    String string = (String)object6;
                    Object object7 = ((CheckAarMetadataWorkParameters)this.getParameters()).getProjectPath().get();
                    Intrinsics.checkNotNullExpressionValue((Object)object7, (String)"get(...)");
                    AarMetadataCheckKt.checkDesugarJdkVariant(variantFromAar, string, errorMessages, displayName, (String)object7);
                    Object object8 = ((CheckAarMetadataWorkParameters)this.getParameters()).getDesugarJdkVersion().get();
                    Intrinsics.checkNotNullExpressionValue((Object)object8, (String)"get(...)");
                    String string2 = (String)object8;
                    Object object9 = ((CheckAarMetadataWorkParameters)this.getParameters()).getProjectPath().get();
                    Intrinsics.checkNotNullExpressionValue((Object)object9, (String)"get(...)");
                    AarMetadataCheckKt.checkDesugarJdkVersion(versionFromAar, string2, errorMessages, displayName, (String)object9);
                }
            }
        }
    }

    private final int getApiIntFromString(String sdkVersion) {
        CompileData compileData = SdkUtilsKt.parseTargetHash(sdkVersion);
        if (compileData.getApiLevel() != null) {
            return compileData.getApiLevel();
        }
        if (compileData.getCodeName() != null) {
            return SdkVersionInfo.getApiByPreviewName((String)compileData.getCodeName(), (boolean)true);
        }
        throw new RuntimeException("Unsupported target hash: " + sdkVersion);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\b\n\u0002\b\b\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0011\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\n\u00a8\u0006\u000b"}, d2={"Lcom/android/build/gradle/internal/tasks/CheckAarMetadataWorkAction$DesugarJdkVariant;", "", "size", "", "<init>", "(Ljava/lang/String;II)V", "getSize", "()I", "MINIMAL", "BASIC", "NIO", "gradle-core"})
    public static final class DesugarJdkVariant
    extends Enum<DesugarJdkVariant> {
        private final int size;
        public static final /* enum */ DesugarJdkVariant MINIMAL = new DesugarJdkVariant(0);
        public static final /* enum */ DesugarJdkVariant BASIC = new DesugarJdkVariant(1);
        public static final /* enum */ DesugarJdkVariant NIO = new DesugarJdkVariant(2);
        private static final /* synthetic */ DesugarJdkVariant[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private DesugarJdkVariant(int size) {
            this.size = size;
        }

        public final int getSize() {
            return this.size;
        }

        public static DesugarJdkVariant[] values() {
            return (DesugarJdkVariant[])$VALUES.clone();
        }

        public static DesugarJdkVariant valueOf(String value) {
            return Enum.valueOf(DesugarJdkVariant.class, value);
        }

        @NotNull
        public static EnumEntries<DesugarJdkVariant> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = desugarJdkVariantArray = new DesugarJdkVariant[]{DesugarJdkVariant.MINIMAL, DesugarJdkVariant.BASIC, DesugarJdkVariant.NIO};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

