/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.gradle.internal.component.ComponentCreationConfig;
import com.android.build.gradle.internal.dependency.VariantDependencies;
import com.android.build.gradle.internal.publishing.AndroidArtifacts;
import com.android.build.gradle.internal.tasks.BuildAnalyzer;
import com.android.build.gradle.internal.tasks.NonIncrementalTask;
import com.android.build.gradle.internal.tasks.factory.VariantTaskCreationAction;
import com.android.build.gradle.internal.tasks.featuresplit.PackagedDependenciesWriterTaskKt;
import com.android.buildanalyzer.common.TaskCategory;
import com.google.common.io.Files;
import java.io.File;
import java.nio.charset.Charset;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.apache.commons.io.Charsets;
import org.gradle.api.GradleException;
import org.gradle.api.Task;
import org.gradle.api.Transformer;
import org.gradle.api.artifacts.ArtifactCollection;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.artifacts.result.ResolvedArtifactResult;
import org.gradle.api.file.Directory;
import org.gradle.api.file.FileCollection;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.jetbrains.annotations.NotNull;

@CacheableTask
@BuildAnalyzer(primaryTaskCategory=TaskCategory.VERIFICATION)
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010%\n\u0002\u0010!\n\u0002\b\u0002\b'\u0018\u00002\u00020\u0001:\u0001\u0019B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0006\u001a\u00020\u0007H\u0007J\b\u0010\u000e\u001a\u00020\u000fH\u0014J2\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0018\u0010\u0016\u001a\u0014\u0012\u0004\u0012\u00020\u0015\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00150\u00180\u0017H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082.\u00a2\u0006\u0002\n\u0000R,\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t8G@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u001a"}, d2={"Lcom/android/build/gradle/internal/tasks/CheckMultiApkLibrariesTask;", "Lcom/android/build/gradle/internal/tasks/NonIncrementalTask;", "<init>", "()V", "featureTransitiveDeps", "Lorg/gradle/api/artifacts/ArtifactCollection;", "getFeatureTransitiveDepsFiles", "Lorg/gradle/api/file/FileCollection;", "value", "Lorg/gradle/api/provider/Provider;", "Lorg/gradle/api/file/Directory;", "fakeOutputDir", "getFakeOutputDir", "()Lorg/gradle/api/provider/Provider;", "doTaskAction", "", "checkAndUpdateLibraryMap", "", "file", "Ljava/io/File;", "projectPath", "", "map", "", "", "CreationAction", "gradle-core"})
public abstract class CheckMultiApkLibrariesTask
extends NonIncrementalTask {
    private ArtifactCollection featureTransitiveDeps;
    private Provider<Directory> fakeOutputDir;

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @NotNull
    public final FileCollection getFeatureTransitiveDepsFiles() {
        ArtifactCollection artifactCollection = this.featureTransitiveDeps;
        if (artifactCollection == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"featureTransitiveDeps");
            artifactCollection = null;
        }
        FileCollection fileCollection2 = artifactCollection.getArtifactFiles();
        Intrinsics.checkNotNullExpressionValue((Object)fileCollection2, (String)"getArtifactFiles(...)");
        return fileCollection2;
    }

    @OutputDirectory
    @NotNull
    public final Provider<Directory> getFakeOutputDir() {
        Provider<Directory> provider2 = this.fakeOutputDir;
        if (provider2 != null) {
            return provider2;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"fakeOutputDir");
        return null;
    }

    @Override
    protected void doTaskAction() {
        Map map = new LinkedHashMap();
        boolean found = false;
        ArtifactCollection artifactCollection = this.featureTransitiveDeps;
        if (artifactCollection == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"featureTransitiveDeps");
            artifactCollection = null;
        }
        for (ResolvedArtifactResult artifact : artifactCollection) {
            if (!(artifact.getId().getComponentIdentifier() instanceof ProjectComponentIdentifier)) {
                throw new GradleException(artifact.getId().getComponentIdentifier().getDisplayName() + " is not a Gradle project.");
            }
            ComponentIdentifier componentIdentifier = artifact.getId().getComponentIdentifier();
            Intrinsics.checkNotNull((Object)componentIdentifier, (String)"null cannot be cast to non-null type org.gradle.api.artifacts.component.ProjectComponentIdentifier");
            String projectPath = ((ProjectComponentIdentifier)componentIdentifier).getProjectPath();
            if (!artifact.getFile().isFile()) continue;
            File file = artifact.getFile();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getFile(...)");
            Intrinsics.checkNotNull((Object)projectPath);
            boolean newlyFound = this.checkAndUpdateLibraryMap(file, projectPath, map);
            found = found || newlyFound;
        }
        if (found) {
            StringBuilder output2 = new StringBuilder();
            for (Map.Entry entry2 : ((Map)MapsKt.toSortedMap((Map)map)).entrySet()) {
                String library = (String)entry2.getKey();
                List projectPaths = (List)entry2.getValue();
                if (projectPaths.size() <= 1) continue;
                Intrinsics.checkNotNull((Object)projectPaths);
                output2.append(CollectionsKt.joinToString$default((Iterable)CollectionsKt.sorted((Iterable)projectPaths), null, (CharSequence)"[", (CharSequence)"]", (int)0, null, null, (int)57, null)).append(" all package the same library [" + library + "].\n");
            }
            output2.append("\nMultiple APKs packaging the same library can cause runtime errors.\nPlacing each of the above libraries in its own dynamic feature and adding that\nfeature as a dependency of modules requiring it will resolve this issue.\nLibraries that are always used together can be combined into a single feature\nmodule to be imported by their dependents. If a library is required by all\nfeature modules it can be added to the base module instead.");
            throw new GradleException(output2.toString());
        }
    }

    private final boolean checkAndUpdateLibraryMap(File file, String projectPath, Map<String, List<String>> map) {
        boolean found = false;
        for (String library : Files.readLines((File)file, (Charset)Charsets.UTF_8)) {
            Intrinsics.checkNotNull((Object)library);
            String key = PackagedDependenciesWriterTaskKt.removeVariantNameFromId(library);
            if (map.containsKey(key)) {
                found = true;
                List<String> list = map.get(key);
                if (list != null) {
                    list.add(projectPath);
                }
                continue;
            }
            Map<String, List<String>> map2 = map;
            Object object = new String[]{projectPath};
            object = CollectionsKt.mutableListOf((Object[])object);
            map2.put(key, (List<String>)object);
        }
        return found;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0002H\u0016R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0012"}, d2={"Lcom/android/build/gradle/internal/tasks/CheckMultiApkLibrariesTask$CreationAction;", "Lcom/android/build/gradle/internal/tasks/factory/VariantTaskCreationAction;", "Lcom/android/build/gradle/internal/tasks/CheckMultiApkLibrariesTask;", "Lcom/android/build/gradle/internal/component/ComponentCreationConfig;", "creationConfig", "<init>", "(Lcom/android/build/gradle/internal/component/ComponentCreationConfig;)V", "name", "", "getName", "()Ljava/lang/String;", "type", "Ljava/lang/Class;", "getType", "()Ljava/lang/Class;", "configure", "", "task", "gradle-core"})
    public static final class CreationAction
    extends VariantTaskCreationAction<CheckMultiApkLibrariesTask, ComponentCreationConfig> {
        public CreationAction(@NotNull ComponentCreationConfig creationConfig) {
            Intrinsics.checkNotNullParameter((Object)creationConfig, (String)"creationConfig");
            super(creationConfig, false);
        }

        @Override
        @NotNull
        public String getName() {
            return this.computeTaskName("check", "Libraries");
        }

        @Override
        @NotNull
        public Class<CheckMultiApkLibrariesTask> getType() {
            return CheckMultiApkLibrariesTask.class;
        }

        @Override
        public void configure(@NotNull CheckMultiApkLibrariesTask task) {
            Intrinsics.checkNotNullParameter((Object)task, (String)"task");
            super.configure((Task)task);
            task.featureTransitiveDeps = VariantDependencies.getArtifactCollection$default(this.creationConfig.getVariantDependencies(), AndroidArtifacts.ConsumedConfigType.REVERSE_METADATA_VALUES, AndroidArtifacts.ArtifactScope.PROJECT, AndroidArtifacts.ArtifactType.PACKAGED_DEPENDENCIES, null, 8, null);
            Function1 function1 = (Function1)new Function1<Directory, Directory>(this){
                final /* synthetic */ CreationAction this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                public final Directory invoke(Directory it) {
                    return it.dir("check-libraries").dir(CreationAction.access$getCreationConfig$p(this.this$0).getDirName());
                }
            };
            task.fakeOutputDir = this.creationConfig.getServices().getProjectInfo().getIntermediatesDirectory().map(new Transformer(function1){
                private final /* synthetic */ Function1 function;
                {
                    Intrinsics.checkNotNullParameter((Object)function, (String)"function");
                    this.function = function;
                }

                public final /* synthetic */ Object transform(Object in) {
                    return this.function.invoke(in);
                }
            });
        }

        public static final /* synthetic */ ComponentCreationConfig access$getCreationConfig$p(CreationAction $this) {
            return $this.creationConfig;
        }
    }
}

