/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.ide.dependencies;

import com.android.build.gradle.internal.ide.AndroidLibraryImpl;
import com.android.build.gradle.internal.ide.DependenciesImpl;
import com.android.build.gradle.internal.ide.JavaLibraryImpl;
import com.android.build.gradle.internal.ide.dependencies.ArtifactHandler;
import com.android.build.gradle.internal.ide.dependencies.LibraryDependencyCacheBuildService;
import com.android.build.gradle.internal.ide.dependencies.MavenCoordinatesCacheBuildService;
import com.android.build.gradle.internal.services.BuildServicesKt;
import com.android.builder.model.AndroidLibrary;
import com.android.builder.model.Dependencies;
import com.android.builder.model.JavaLibrary;
import com.android.builder.model.MavenCoordinates;
import com.android.ide.common.caching.CreatingCache;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.services.BuildServiceRegistry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006JT\u0010\u0016\u001a\u00020\u00022\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00182\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00180\u000f2\u0006\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u001e0 H\u0014Jb\u0010#\u001a\u00020\u00022\u0006\u0010$\u001a\u00020\u001e2\u0006\u0010%\u001a\u00020\u001e2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010&\u001a\u00020\u001c2\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\b\u0010'\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u001b\u001a\u00020\u001c2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u001e0 H\u0014J4\u0010(\u001a\u00020\u00022\u0006\u0010)\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u001c2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u001e0 H\u0014J8\u0010*\u001a\u00020\u00022\u0006\u0010$\u001a\u00020\u001e2\u0006\u0010%\u001a\u00020\u001e2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010&\u001a\u00020\u001c2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u001e0 H\u0014R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\t0\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0017\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0011R\u0017\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\r0\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0011\u00a8\u0006+"}, d2={"Lcom/android/build/gradle/internal/ide/dependencies/Level1ArtifactHandler;", "Lcom/android/build/gradle/internal/ide/dependencies/ArtifactHandler;", "", "buildServiceRegistry", "Lorg/gradle/api/services/BuildServiceRegistry;", "<init>", "(Lorg/gradle/api/services/BuildServiceRegistry;)V", "_projects", "Lcom/google/common/collect/ImmutableList$Builder;", "Lcom/android/builder/model/Dependencies$ProjectIdentifier;", "_androidLibraries", "Lcom/android/builder/model/AndroidLibrary;", "_javaLibraries", "Lcom/android/builder/model/JavaLibrary;", "projects", "", "getProjects", "()Ljava/util/List;", "androidLibraries", "getAndroidLibraries", "javaLibraries", "getJavaLibraries", "handleAndroidLibrary", "aarFile", "Ljava/io/File;", "folder", "localJavaLibraries", "isProvided", "", "variantName", "", "coordinatesSupplier", "Lkotlin/Function0;", "Lcom/android/builder/model/MavenCoordinates;", "addressSupplier", "handleAndroidModule", "projectPath", "buildId", "isTestFixtures", "lintJar", "handleJavaLibrary", "jarFile", "handleJavaModule", "gradle-core"})
public final class Level1ArtifactHandler
extends ArtifactHandler<Unit> {
    @NotNull
    private final ImmutableList.Builder<Dependencies.ProjectIdentifier> _projects;
    @NotNull
    private final ImmutableList.Builder<AndroidLibrary> _androidLibraries;
    @NotNull
    private final ImmutableList.Builder<JavaLibrary> _javaLibraries;

    public Level1ArtifactHandler(@NotNull BuildServiceRegistry buildServiceRegistry) {
        Intrinsics.checkNotNullParameter((Object)buildServiceRegistry, (String)"buildServiceRegistry");
        CreatingCache<File, List<File>> creatingCache = ((LibraryDependencyCacheBuildService)BuildServicesKt.getBuildService(buildServiceRegistry, LibraryDependencyCacheBuildService.class).get()).getLocalJarCache();
        Object object = BuildServicesKt.getBuildService(buildServiceRegistry, MavenCoordinatesCacheBuildService.class).get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        super(creatingCache, (MavenCoordinatesCacheBuildService)object);
        ImmutableList.Builder builder = ImmutableList.builder();
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"builder(...)");
        this._projects = builder;
        ImmutableList.Builder builder2 = ImmutableList.builder();
        Intrinsics.checkNotNullExpressionValue((Object)builder2, (String)"builder(...)");
        this._androidLibraries = builder2;
        ImmutableList.Builder builder3 = ImmutableList.builder();
        Intrinsics.checkNotNullExpressionValue((Object)builder3, (String)"builder(...)");
        this._javaLibraries = builder3;
    }

    @NotNull
    public final List<Dependencies.ProjectIdentifier> getProjects() {
        ImmutableList immutableList = this._projects.build();
        Intrinsics.checkNotNullExpressionValue((Object)immutableList, (String)"build(...)");
        return (List)immutableList;
    }

    @NotNull
    public final List<AndroidLibrary> getAndroidLibraries() {
        ImmutableList immutableList = this._androidLibraries.build();
        Intrinsics.checkNotNullExpressionValue((Object)immutableList, (String)"build(...)");
        return (List)immutableList;
    }

    @NotNull
    public final List<JavaLibrary> getJavaLibraries() {
        ImmutableList immutableList = this._javaLibraries.build();
        Intrinsics.checkNotNullExpressionValue((Object)immutableList, (String)"build(...)");
        return (List)immutableList;
    }

    @Override
    protected void handleAndroidLibrary(@NotNull File aarFile, @NotNull File folder2, @NotNull List<? extends File> localJavaLibraries, boolean isProvided, @Nullable String variantName, @NotNull Function0<? extends MavenCoordinates> coordinatesSupplier2, @NotNull Function0<String> addressSupplier) {
        Intrinsics.checkNotNullParameter((Object)aarFile, (String)"aarFile");
        Intrinsics.checkNotNullParameter((Object)folder2, (String)"folder");
        Intrinsics.checkNotNullParameter(localJavaLibraries, (String)"localJavaLibraries");
        Intrinsics.checkNotNullParameter(coordinatesSupplier2, (String)"coordinatesSupplier");
        Intrinsics.checkNotNullParameter(addressSupplier, (String)"addressSupplier");
        this._androidLibraries.add((Object)new AndroidLibraryImpl((MavenCoordinates)coordinatesSupplier2.invoke(), null, null, aarFile, folder2, variantName, isProvided, false, (List)ImmutableList.of(), (Collection)ImmutableList.of(), (Collection<File>)localJavaLibraries, null));
    }

    @Override
    protected void handleAndroidModule(@NotNull String projectPath, @NotNull String buildId, @Nullable String variantName, boolean isTestFixtures, @Nullable File aarFile, @Nullable File lintJar, boolean isProvided, @NotNull Function0<? extends MavenCoordinates> coordinatesSupplier2, @NotNull Function0<String> addressSupplier) {
        Intrinsics.checkNotNullParameter((Object)projectPath, (String)"projectPath");
        Intrinsics.checkNotNullParameter((Object)buildId, (String)"buildId");
        Intrinsics.checkNotNullParameter(coordinatesSupplier2, (String)"coordinatesSupplier");
        Intrinsics.checkNotNullParameter(addressSupplier, (String)"addressSupplier");
        this._androidLibraries.add((Object)new AndroidLibraryImpl((MavenCoordinates)coordinatesSupplier2.invoke(), buildId, projectPath, aarFile, aarFile, variantName, isProvided, false, (List)ImmutableList.of(), (Collection)ImmutableList.of(), CollectionsKt.emptyList(), lintJar));
    }

    @Override
    protected void handleJavaLibrary(@NotNull File jarFile, boolean isProvided, @NotNull Function0<? extends MavenCoordinates> coordinatesSupplier2, @NotNull Function0<String> addressSupplier) {
        Intrinsics.checkNotNullParameter((Object)jarFile, (String)"jarFile");
        Intrinsics.checkNotNullParameter(coordinatesSupplier2, (String)"coordinatesSupplier");
        Intrinsics.checkNotNullParameter(addressSupplier, (String)"addressSupplier");
        this._javaLibraries.add((Object)new JavaLibraryImpl(jarFile, null, null, (List)ImmutableList.of(), null, (MavenCoordinates)coordinatesSupplier2.invoke(), false, isProvided));
    }

    @Override
    protected void handleJavaModule(@NotNull String projectPath, @NotNull String buildId, @Nullable String variantName, boolean isTestFixtures, @NotNull Function0<String> addressSupplier) {
        Intrinsics.checkNotNullParameter((Object)projectPath, (String)"projectPath");
        Intrinsics.checkNotNullParameter((Object)buildId, (String)"buildId");
        Intrinsics.checkNotNullParameter(addressSupplier, (String)"addressSupplier");
        this._projects.add((Object)new DependenciesImpl.ProjectIdentifierImpl(buildId, projectPath));
    }
}

