/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.plugins;

import com.android.build.gradle.internal.services.RunOnceBuildService;
import com.android.build.gradle.internal.services.RunOnceBuildServiceImpl;
import com.android.build.gradle.options.BooleanOption;
import com.android.ide.common.repository.GradleVersion;
import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.logging.Logger;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u0000 \u000b2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u000bB\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0002H\u0016J\u0010\u0010\b\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0002H\u0007J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\u0002H\u0002\u00a8\u0006\f"}, d2={"Lcom/android/build/gradle/internal/plugins/VersionCheckPlugin;", "Lorg/gradle/api/Plugin;", "Lorg/gradle/api/Project;", "<init>", "()V", "apply", "", "project", "doApply", "getVersionCheckOverridePropertyValue", "", "Companion", "gradle-core"})
public final class VersionCheckPlugin
implements Plugin<Project> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @JvmField
    public static final GradleVersion GRADLE_MIN_VERSION = GradleVersion.parse((String)"8.11.1");

    public void apply(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        RunOnceBuildService runOnceBuildService = (RunOnceBuildService)new RunOnceBuildServiceImpl.RegistrationAction(project).execute().get();
        String string = VersionCheckPlugin.class.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        runOnceBuildService.runOnce("apply", string, (Function0<Unit>)((Function0)new Function0<Unit>(this, project){
            final /* synthetic */ VersionCheckPlugin this$0;
            final /* synthetic */ Project $project;
            {
                this.this$0 = $receiver;
                this.$project = $project;
                super(0);
            }

            public final void invoke() {
                this.this$0.doApply(this.$project);
            }
        }));
    }

    @VisibleForTesting
    public final void doApply(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Logger logger = project.getLogger();
        String currentVersion = project.getGradle().getGradleVersion();
        if (GRADLE_MIN_VERSION.compareTo(currentVersion) > 0) {
            File file = new File(project.getRootProject().getProjectDir(), "gradle" + File.separator + "wrapper" + File.separator + "gradle-wrapper.properties");
            String string = "Minimum supported Gradle version is " + GRADLE_MIN_VERSION + ". Current version is " + currentVersion + ". If using the gradle wrapper, try editing the distributionUrl in " + file.getAbsolutePath() + " to gradle-" + GRADLE_MIN_VERSION + "-all.zip";
            Object[] objectArray = new Object[]{};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
            String errorMessage = string2;
            if (this.getVersionCheckOverridePropertyValue(project)) {
                logger.warn(errorMessage);
                logger.warn("As " + BooleanOption.VERSION_CHECK_OVERRIDE_PROPERTY.getPropertyName() + " is set, continuing anyway.");
            } else {
                throw new RuntimeException(errorMessage);
            }
        }
    }

    private final boolean getVersionCheckOverridePropertyValue(Project project) {
        Object value = project.getExtensions().getExtraProperties().getProperties().get(BooleanOption.VERSION_CHECK_OVERRIDE_PROPERTY.getPropertyName());
        return value == null ? BooleanOption.VERSION_CHECK_OVERRIDE_PROPERTY.getDefaultValue().booleanValue() : BooleanOption.VERSION_CHECK_OVERRIDE_PROPERTY.parse(value).booleanValue();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001a\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u00058\u0006X\u0087\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/android/build/gradle/internal/plugins/VersionCheckPlugin$Companion;", "", "<init>", "()V", "GRADLE_MIN_VERSION", "Lcom/android/ide/common/repository/GradleVersion;", "kotlin.jvm.PlatformType", "Lcom/android/ide/common/repository/GradleVersion;", "gradle-core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

