/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.profile;

import com.android.build.gradle.internal.profile.AnalyticsResourceManager;
import com.android.build.gradle.internal.profile.TaskProfilingRecord;
import com.android.build.gradle.internal.profile.WorkerProfilingRecord;
import com.google.common.annotations.VisibleForTesting;
import com.google.wireless.android.sdk.stats.GradleBuildProfileSpan;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import javax.annotation.concurrent.GuardedBy;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0004\b\u0016\u0018\u0000 92\u00020\u0001:\u000289B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\b\u0010\t\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0006\u0010$\u001a\u00020%J\u0010\u0010&\u001a\u00020%2\u0006\u0010'\u001a\u00020\u0007H\u0016J\u0018\u0010&\u001a\u00020%2\u0006\u0010'\u001a\u00020\u00072\u0006\u0010(\u001a\u00020)H\u0016J\u0012\u0010*\u001a\u0004\u0018\u00010\u00142\u0006\u0010'\u001a\u00020\u0007H\u0016J\u0006\u0010+\u001a\u00020,J\u000e\u0010-\u001a\u00020%2\u0006\u0010.\u001a\u00020\u0014J\u0006\u0010/\u001a\u00020%J\u0006\u00100\u001a\u000201J\u0006\u00102\u001a\u000201J\u000e\u00103\u001a\u00020%2\u0006\u00104\u001a\u00020\u0005J\u000e\u00105\u001a\u00020%2\u0006\u0010\u0015\u001a\u000206J\u000e\u00107\u001a\u00020%2\u0006\u0010\u0019\u001a\u000206R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\u0007X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0016\u0010\t\u001a\u0004\u0018\u00010\u0007X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\rR\u0011\u0010\u000f\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00140\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0015\u001a\n \u0017*\u0004\u0018\u00010\u00160\u0016X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0018R\u0018\u0010\u0019\u001a\n \u0017*\u0004\u0018\u00010\u00160\u0016X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0018R\"\u0010\u001a\u001a\u0010\u0012\f\u0012\n \u0017*\u0004\u0018\u00010\u001c0\u001c0\u001bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0019\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 8G\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#\u00a8\u0006:"}, d2={"Lcom/android/build/gradle/internal/profile/TaskProfilingRecord;", "", "resourceManager", "Lcom/android/build/gradle/internal/profile/AnalyticsResourceManager;", "span", "Lcom/google/wireless/android/sdk/stats/GradleBuildProfileSpan$Builder;", "taskPath", "", "projectPath", "variant", "<init>", "(Lcom/android/build/gradle/internal/profile/AnalyticsResourceManager;Lcom/google/wireless/android/sdk/stats/GradleBuildProfileSpan$Builder;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getProjectPath$gradle_core", "()Ljava/lang/String;", "getVariant$gradle_core", "spanBuilder", "getSpanBuilder", "()Lcom/google/wireless/android/sdk/stats/GradleBuildProfileSpan$Builder;", "workerRecordList", "", "Lcom/android/build/gradle/internal/profile/WorkerProfilingRecord;", "startTime", "Ljava/time/Instant;", "kotlin.jvm.PlatformType", "Ljava/time/Instant;", "endTime", "status", "Ljava/util/concurrent/atomic/AtomicReference;", "Lcom/android/build/gradle/internal/profile/TaskProfilingRecord$Status;", "getStatus$gradle_core", "()Ljava/util/concurrent/atomic/AtomicReference;", "taskSpans", "", "Lcom/google/wireless/android/sdk/stats/GradleBuildProfileSpan;", "getTaskSpans", "()Ljava/util/List;", "setTaskWaiting", "", "addWorker", "key", "type", "Lcom/google/wireless/android/sdk/stats/GradleBuildProfileSpan$ExecutionType;", "get", "allWorkersFinished", "", "workerFinished", "workerRecord", "writeTaskSpan", "minimumWaitTime", "Ljava/time/Duration;", "duration", "addSpan", "builder", "setTaskStartTime", "", "setTaskEndTime", "Status", "Companion", "gradle-core"})
public class TaskProfilingRecord {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AnalyticsResourceManager resourceManager;
    @NotNull
    private final String taskPath;
    @NotNull
    private final String projectPath;
    @Nullable
    private final String variant;
    @NotNull
    private final GradleBuildProfileSpan.Builder spanBuilder;
    @NotNull
    private final Map<String, WorkerProfilingRecord> workerRecordList;
    private Instant startTime;
    private Instant endTime;
    @NotNull
    private final AtomicReference<Status> status;
    @NotNull
    private final List<GradleBuildProfileSpan> taskSpans;
    @NotNull
    private static Clock clock;

    public TaskProfilingRecord(@NotNull AnalyticsResourceManager resourceManager, @NotNull GradleBuildProfileSpan.Builder span, @NotNull String taskPath, @NotNull String projectPath, @Nullable String variant) {
        Intrinsics.checkNotNullParameter((Object)resourceManager, (String)"resourceManager");
        Intrinsics.checkNotNullParameter((Object)span, (String)"span");
        Intrinsics.checkNotNullParameter((Object)taskPath, (String)"taskPath");
        Intrinsics.checkNotNullParameter((Object)projectPath, (String)"projectPath");
        this.resourceManager = resourceManager;
        this.taskPath = taskPath;
        this.projectPath = projectPath;
        this.variant = variant;
        this.spanBuilder = span;
        this.workerRecordList = new LinkedHashMap();
        this.startTime = Instant.MIN;
        this.endTime = Instant.MIN;
        this.status = new AtomicReference<Status>(Status.RUNNING);
        this.taskSpans = new ArrayList();
    }

    @NotNull
    public final String getProjectPath$gradle_core() {
        return this.projectPath;
    }

    @Nullable
    public final String getVariant$gradle_core() {
        return this.variant;
    }

    @NotNull
    public final GradleBuildProfileSpan.Builder getSpanBuilder() {
        return this.spanBuilder;
    }

    @NotNull
    public final AtomicReference<Status> getStatus$gradle_core() {
        return this.status;
    }

    @GuardedBy(value="this")
    @NotNull
    public final List<GradleBuildProfileSpan> getTaskSpans() {
        return this.taskSpans;
    }

    public final void setTaskWaiting() {
        this.status.set(Status.AWAIT);
    }

    public void addWorker(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        this.addWorker(key, GradleBuildProfileSpan.ExecutionType.THREAD_EXECUTION);
    }

    public synchronized void addWorker(@NotNull String key, @NotNull GradleBuildProfileSpan.ExecutionType type) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Instant instant = clock.instant();
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"instant(...)");
        WorkerProfilingRecord workerRecord = new WorkerProfilingRecord(this.taskPath, type, instant);
        this.workerRecordList.put(key, workerRecord);
    }

    @Nullable
    public synchronized WorkerProfilingRecord get(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return this.workerRecordList.get(key);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final synchronized boolean allWorkersFinished() {
        if (this.workerRecordList.isEmpty()) return true;
        Function1 function1 = allWorkersFinished.1.INSTANCE;
        if (!this.workerRecordList.values().stream().allMatch(new Predicate(function1){
            private final /* synthetic */ Function1 function;
            {
                Intrinsics.checkNotNullParameter((Object)function, (String)"function");
                this.function = function;
            }

            public final /* synthetic */ boolean test(Object p0) {
                return (Boolean)this.function.invoke(p0);
            }
        })) return false;
        return true;
    }

    public final synchronized void workerFinished(@NotNull WorkerProfilingRecord workerRecord) {
        Intrinsics.checkNotNullParameter((Object)workerRecord, (String)"workerRecord");
        GradleBuildProfileSpan.Builder workerSpan = GradleBuildProfileSpan.newBuilder().setId(this.resourceManager.allocateRecordId()).setParentId(this.spanBuilder.getId());
        Intrinsics.checkNotNull((Object)workerSpan);
        workerRecord.fillSpanRecord(workerSpan);
        this.resourceManager.writeRecord(this.projectPath, this.variant, workerSpan, CollectionsKt.emptyList());
    }

    public final synchronized void writeTaskSpan() {
        if (this.status.get() == Status.SPAN_CLOSED) {
            return;
        }
        this.status.set(Status.SPAN_CLOSED);
        this.spanBuilder.setStartTimeInMs(this.startTime.toEpochMilli());
        this.spanBuilder.setType(GradleBuildProfileSpan.ExecutionType.TASK_EXECUTION);
        this.spanBuilder.setDurationInMs(this.duration().toMillis());
        this.resourceManager.writeRecord(this.projectPath, this.variant, this.spanBuilder, this.taskSpans);
    }

    @NotNull
    public final Duration minimumWaitTime() {
        Duration duration = (Duration)SequencesKt.minOrNull((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)this.workerRecordList.values()), (Function1)minimumWaitTime.1.INSTANCE));
        if (duration == null) {
            Duration duration2 = Duration.ZERO;
            duration = duration2;
            Intrinsics.checkNotNullExpressionValue((Object)duration2, (String)"ZERO");
        }
        return duration;
    }

    @NotNull
    public final Duration duration() {
        Duration duration = Duration.between(this.startTime, this.endTime);
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"between(...)");
        return duration;
    }

    public final synchronized void addSpan(@NotNull GradleBuildProfileSpan.Builder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        builder.setParentId(this.spanBuilder.getId());
        GradleBuildProfileSpan gradleBuildProfileSpan = builder.build();
        Intrinsics.checkNotNullExpressionValue((Object)gradleBuildProfileSpan, (String)"build(...)");
        this.taskSpans.add(gradleBuildProfileSpan);
    }

    public final void setTaskStartTime(long startTime) {
        this.startTime = Instant.ofEpochMilli(startTime);
    }

    public final void setTaskEndTime(long endTime) {
        this.status.set(Status.FINISHED);
        this.endTime = Instant.ofEpochMilli(endTime);
    }

    static {
        Clock clock = Clock.systemDefaultZone();
        Intrinsics.checkNotNullExpressionValue((Object)clock, (String)"systemDefaultZone(...)");
        TaskProfilingRecord.clock = clock;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R$\u0010\u0004\u001a\u00020\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\u0006\u0010\u0003\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/android/build/gradle/internal/profile/TaskProfilingRecord$Companion;", "", "<init>", "()V", "clock", "Ljava/time/Clock;", "getClock$annotations", "getClock", "()Ljava/time/Clock;", "setClock", "(Ljava/time/Clock;)V", "gradle-core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Clock getClock() {
            return clock;
        }

        public final void setClock(@NotNull Clock clock) {
            Intrinsics.checkNotNullParameter((Object)clock, (String)"<set-?>");
            TaskProfilingRecord.clock = clock;
        }

        @VisibleForTesting
        public static /* synthetic */ void getClock$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0007\b\u0080\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\b"}, d2={"Lcom/android/build/gradle/internal/profile/TaskProfilingRecord$Status;", "", "<init>", "(Ljava/lang/String;I)V", "RUNNING", "AWAIT", "FINISHED", "SPAN_CLOSED", "gradle-core"})
    public static final class Status
    extends Enum<Status> {
        public static final /* enum */ Status RUNNING = new Status();
        public static final /* enum */ Status AWAIT = new Status();
        public static final /* enum */ Status FINISHED = new Status();
        public static final /* enum */ Status SPAN_CLOSED = new Status();
        private static final /* synthetic */ Status[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static Status[] values() {
            return (Status[])$VALUES.clone();
        }

        public static Status valueOf(String value) {
            return Enum.valueOf(Status.class, value);
        }

        @NotNull
        public static EnumEntries<Status> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = statusArray = new Status[]{Status.RUNNING, Status.AWAIT, Status.FINISHED, Status.SPAN_CLOSED};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

