/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.api.artifact.Artifact;
import com.android.build.api.artifact.SingleArtifact;
import com.android.build.gradle.internal.component.VariantCreationConfig;
import com.android.build.gradle.internal.profile.ProfileAwareWorkAction;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.tasks.AndroidVariantTask;
import com.android.build.gradle.internal.tasks.BuildAnalyzer;
import com.android.build.gradle.internal.tasks.LibraryJniLibsTask;
import com.android.build.gradle.internal.tasks.LibraryJniLibsTaskKt;
import com.android.build.gradle.internal.tasks.NonIncrementalTask;
import com.android.build.gradle.internal.tasks.factory.VariantTaskCreationAction;
import com.android.build.gradle.internal.utils.HasConfigurableValuesKt;
import com.android.buildanalyzer.common.TaskCategory;
import com.android.utils.FileUtils;
import com.google.common.base.Preconditions;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.Action;
import org.gradle.api.Task;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.work.DisableCachingByDefault;
import org.gradle.workers.WorkerExecutor;
import org.jetbrains.annotations.NotNull;

@DisableCachingByDefault
@BuildAnalyzer(primaryTaskCategory=TaskCategory.NATIVE)
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0006\b'\u0018\u00002\u00020\u0001:\u0005\u0010\u0011\u0012\u0013\u0014B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u000e\u001a\u00020\u000fH\u0014R\u0014\u0010\u0004\u001a\u00020\u00058gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\t8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\u00058gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u0007\u00a8\u0006\u0015"}, d2={"Lcom/android/build/gradle/internal/tasks/LibraryJniLibsTask;", "Lcom/android/build/gradle/internal/tasks/NonIncrementalTask;", "<init>", "()V", "projectNativeLibs", "Lorg/gradle/api/file/DirectoryProperty;", "getProjectNativeLibs", "()Lorg/gradle/api/file/DirectoryProperty;", "localJarsNativeLibs", "Lorg/gradle/api/file/ConfigurableFileCollection;", "getLocalJarsNativeLibs", "()Lorg/gradle/api/file/ConfigurableFileCollection;", "outputDirectory", "getOutputDirectory", "doTaskAction", "", "LibraryJniLibsDelegate", "LibraryJniLibsRunnable", "CreationAction", "ProjectOnlyCreationAction", "ProjectAndLocalJarsCreationAction", "gradle-core"})
public abstract class LibraryJniLibsTask
extends NonIncrementalTask {
    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @NotNull
    public abstract DirectoryProperty getProjectNativeLibs();

    @Classpath
    @Optional
    @NotNull
    public abstract ConfigurableFileCollection getLocalJarsNativeLibs();

    @OutputDirectory
    @NotNull
    public abstract DirectoryProperty getOutputDirectory();

    @Override
    protected void doTaskAction() {
        File file = ((Directory)this.getProjectNativeLibs().get()).getAsFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getAsFile(...)");
        Set set = this.getLocalJarsNativeLibs().getFiles();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"getFiles(...)");
        Collection collection = set;
        File file2 = ((Directory)this.getOutputDirectory().get()).getAsFile();
        Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"getAsFile(...)");
        new LibraryJniLibsDelegate(file, collection, file2, this.getWorkerExecutor(), this).copyFiles();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u001d\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u0016\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00020\u0013H\u0016R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0014"}, d2={"Lcom/android/build/gradle/internal/tasks/LibraryJniLibsTask$CreationAction;", "Lcom/android/build/gradle/internal/tasks/factory/VariantTaskCreationAction;", "Lcom/android/build/gradle/internal/tasks/LibraryJniLibsTask;", "Lcom/android/build/gradle/internal/component/VariantCreationConfig;", "creationConfig", "artifactType", "Lcom/android/build/gradle/internal/scope/InternalArtifactType;", "Lorg/gradle/api/file/Directory;", "<init>", "(Lcom/android/build/gradle/internal/component/VariantCreationConfig;Lcom/android/build/gradle/internal/scope/InternalArtifactType;)V", "getArtifactType", "()Lcom/android/build/gradle/internal/scope/InternalArtifactType;", "type", "Ljava/lang/Class;", "getType", "()Ljava/lang/Class;", "handleProvider", "", "taskProvider", "Lorg/gradle/api/tasks/TaskProvider;", "gradle-core"})
    public static abstract class CreationAction
    extends VariantTaskCreationAction<LibraryJniLibsTask, VariantCreationConfig> {
        @NotNull
        private final InternalArtifactType<Directory> artifactType;
        @NotNull
        private final Class<LibraryJniLibsTask> type;

        public CreationAction(@NotNull VariantCreationConfig creationConfig, @NotNull InternalArtifactType<Directory> artifactType) {
            Intrinsics.checkNotNullParameter((Object)creationConfig, (String)"creationConfig");
            Intrinsics.checkNotNullParameter(artifactType, (String)"artifactType");
            super(creationConfig, false, 2, null);
            this.artifactType = artifactType;
            this.type = LibraryJniLibsTask.class;
        }

        @NotNull
        public final InternalArtifactType<Directory> getArtifactType() {
            return this.artifactType;
        }

        @Override
        @NotNull
        public Class<LibraryJniLibsTask> getType() {
            return this.type;
        }

        @Override
        public void handleProvider(@NotNull TaskProvider<LibraryJniLibsTask> taskProvider) {
            Intrinsics.checkNotNullParameter(taskProvider, (String)"taskProvider");
            super.handleProvider(taskProvider);
            ((VariantCreationConfig)this.creationConfig).getArtifacts().setInitialProvider(taskProvider, (Function1)handleProvider.1.INSTANCE).withName("jni").on((Artifact.Single)this.artifactType);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0006\u0010\u0011\u001a\u00020\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/android/build/gradle/internal/tasks/LibraryJniLibsTask$LibraryJniLibsDelegate;", "", "projectNativeLibs", "Ljava/io/File;", "localJarsNativeLibs", "", "outputDirectory", "workers", "Lorg/gradle/workers/WorkerExecutor;", "instantiator", "Lcom/android/build/gradle/internal/tasks/AndroidVariantTask;", "<init>", "(Ljava/io/File;Ljava/util/Collection;Ljava/io/File;Lorg/gradle/workers/WorkerExecutor;Lcom/android/build/gradle/internal/tasks/AndroidVariantTask;)V", "getOutputDirectory", "()Ljava/io/File;", "getWorkers", "()Lorg/gradle/workers/WorkerExecutor;", "copyFiles", "", "gradle-core"})
    public static final class LibraryJniLibsDelegate {
        @NotNull
        private final File projectNativeLibs;
        @NotNull
        private final Collection<File> localJarsNativeLibs;
        @NotNull
        private final File outputDirectory;
        @NotNull
        private final WorkerExecutor workers;
        @NotNull
        private final AndroidVariantTask instantiator;

        public LibraryJniLibsDelegate(@NotNull File projectNativeLibs, @NotNull Collection<? extends File> localJarsNativeLibs, @NotNull File outputDirectory, @NotNull WorkerExecutor workers, @NotNull AndroidVariantTask instantiator) {
            Intrinsics.checkNotNullParameter((Object)projectNativeLibs, (String)"projectNativeLibs");
            Intrinsics.checkNotNullParameter(localJarsNativeLibs, (String)"localJarsNativeLibs");
            Intrinsics.checkNotNullParameter((Object)outputDirectory, (String)"outputDirectory");
            Intrinsics.checkNotNullParameter((Object)workers, (String)"workers");
            Intrinsics.checkNotNullParameter((Object)instantiator, (String)"instantiator");
            this.projectNativeLibs = projectNativeLibs;
            this.localJarsNativeLibs = localJarsNativeLibs;
            this.outputDirectory = outputDirectory;
            this.workers = workers;
            this.instantiator = instantiator;
        }

        @NotNull
        public final File getOutputDirectory() {
            return this.outputDirectory;
        }

        @NotNull
        public final WorkerExecutor getWorkers() {
            return this.workers;
        }

        public final void copyFiles() {
            FileUtils.cleanOutputDir((File)this.outputDirectory);
            List inputFiles = CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)this.projectNativeLibs), (Iterable)CollectionsKt.toList((Iterable)this.localJarsNativeLibs));
            for (File inputFile : inputFiles) {
                Function1 function1 = (Function1)new Function1<LibraryJniLibsRunnable.Params, Unit>(this, inputFile){
                    final /* synthetic */ LibraryJniLibsDelegate this$0;
                    final /* synthetic */ File $inputFile;
                    {
                        this.this$0 = $receiver;
                        this.$inputFile = $inputFile;
                        super(1);
                    }

                    public final void invoke(LibraryJniLibsRunnable.Params it) {
                        it.initializeFromBaseTask(LibraryJniLibsDelegate.access$getInstantiator$p(this.this$0));
                        it.getInputFile().set((Object)this.$inputFile);
                        it.getOutputDirectory().set(this.this$0.getOutputDirectory());
                    }
                };
                this.workers.noIsolation().submit(LibraryJniLibsRunnable.class, new Action(function1){
                    private final /* synthetic */ Function1 function;
                    {
                        Intrinsics.checkNotNullParameter((Object)function, (String)"function");
                        this.function = function;
                    }

                    public final /* synthetic */ void execute(Object p0) {
                        this.function.invoke(p0);
                    }
                });
            }
        }

        public static final /* synthetic */ AndroidVariantTask access$getInstantiator$p(LibraryJniLibsDelegate $this) {
            return $this.instantiator;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\b&\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0007B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\b"}, d2={"Lcom/android/build/gradle/internal/tasks/LibraryJniLibsTask$LibraryJniLibsRunnable;", "Lcom/android/build/gradle/internal/profile/ProfileAwareWorkAction;", "Lcom/android/build/gradle/internal/tasks/LibraryJniLibsTask$LibraryJniLibsRunnable$Params;", "<init>", "()V", "run", "", "Params", "gradle-core"})
    public static abstract class LibraryJniLibsRunnable
    extends ProfileAwareWorkAction<Params> {
        /*
         * Unable to fully structure code
         */
        @Override
        public void run() {
            block3: {
                block2: {
                    inputFile = (File)((Params)this.getParameters()).getInputFile().get();
                    if (!inputFile.isFile()) break block2;
                    v0 = inputFile.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"getName(...)");
                    if (StringsKt.endsWith$default((String)v0, (String)".jar", (boolean)false, (int)2, null)) ** GOTO lbl-1000
                    v1 = inputFile.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"getName(...)");
                    if (StringsKt.endsWith$default((String)v1, (String)".aar", (boolean)false, (int)2, null)) lbl-1000:
                    // 2 sources

                    {
                        v2 = true;
                    } else {
                        v2 = false;
                    }
                    Preconditions.checkState((boolean)v2, (String)("Non-directory inputs must have .jar or .aar extension: " + inputFile), (Object[])new Object[0]);
                    Intrinsics.checkNotNull((Object)inputFile);
                    v3 = ((Params)this.getParameters()).getOutputDirectory().getAsFile().get();
                    Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"get(...)");
                    LibraryJniLibsTaskKt.access$copyFromJar(inputFile, (File)v3);
                    break block3;
                }
                Intrinsics.checkNotNull((Object)inputFile);
                v4 = ((Params)this.getParameters()).getOutputDirectory().getAsFile().get();
                Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"get(...)");
                LibraryJniLibsTaskKt.access$copyFromFolder(inputFile, (File)v4);
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0018\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0012\u0010\t\u001a\u00020\nX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Lcom/android/build/gradle/internal/tasks/LibraryJniLibsTask$LibraryJniLibsRunnable$Params;", "Lcom/android/build/gradle/internal/profile/ProfileAwareWorkAction$Parameters;", "<init>", "()V", "inputFile", "Lorg/gradle/api/provider/Property;", "Ljava/io/File;", "getInputFile", "()Lorg/gradle/api/provider/Property;", "outputDirectory", "Lorg/gradle/api/file/DirectoryProperty;", "getOutputDirectory", "()Lorg/gradle/api/file/DirectoryProperty;", "gradle-core"})
        public static abstract class Params
        extends ProfileAwareWorkAction.Parameters {
            @NotNull
            public abstract Property<File> getInputFile();

            @NotNull
            public abstract DirectoryProperty getOutputDirectory();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0011"}, d2={"Lcom/android/build/gradle/internal/tasks/LibraryJniLibsTask$ProjectAndLocalJarsCreationAction;", "Lcom/android/build/gradle/internal/tasks/LibraryJniLibsTask$CreationAction;", "creationConfig", "Lcom/android/build/gradle/internal/component/VariantCreationConfig;", "artifactType", "Lcom/android/build/gradle/internal/scope/InternalArtifactType;", "Lorg/gradle/api/file/Directory;", "<init>", "(Lcom/android/build/gradle/internal/component/VariantCreationConfig;Lcom/android/build/gradle/internal/scope/InternalArtifactType;)V", "name", "", "getName", "()Ljava/lang/String;", "configure", "", "task", "Lcom/android/build/gradle/internal/tasks/LibraryJniLibsTask;", "gradle-core"})
    public static final class ProjectAndLocalJarsCreationAction
    extends CreationAction {
        @NotNull
        private final String name;

        public ProjectAndLocalJarsCreationAction(@NotNull VariantCreationConfig creationConfig, @NotNull InternalArtifactType<Directory> artifactType) {
            Intrinsics.checkNotNullParameter((Object)creationConfig, (String)"creationConfig");
            Intrinsics.checkNotNullParameter(artifactType, (String)"artifactType");
            super(creationConfig, artifactType);
            this.name = this.computeTaskName("copy", "JniLibsProjectAndLocalJars");
        }

        @Override
        @NotNull
        public String getName() {
            return this.name;
        }

        @Override
        public void configure(@NotNull LibraryJniLibsTask task) {
            Intrinsics.checkNotNullParameter((Object)task, (String)"task");
            super.configure((Task)task);
            HasConfigurableValuesKt.setDisallowChanges((Property)task.getProjectNativeLibs(), ((VariantCreationConfig)this.creationConfig).getArtifacts().get(InternalArtifactType.STRIPPED_NATIVE_LIBS.INSTANCE));
            Object[] objectArray = new Object[]{((VariantCreationConfig)this.creationConfig).computeLocalPackagedJars()};
            HasConfigurableValuesKt.fromDisallowChanges(task.getLocalJarsNativeLibs(), objectArray);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0011"}, d2={"Lcom/android/build/gradle/internal/tasks/LibraryJniLibsTask$ProjectOnlyCreationAction;", "Lcom/android/build/gradle/internal/tasks/LibraryJniLibsTask$CreationAction;", "creationConfig", "Lcom/android/build/gradle/internal/component/VariantCreationConfig;", "artifactType", "Lcom/android/build/gradle/internal/scope/InternalArtifactType;", "Lorg/gradle/api/file/Directory;", "<init>", "(Lcom/android/build/gradle/internal/component/VariantCreationConfig;Lcom/android/build/gradle/internal/scope/InternalArtifactType;)V", "name", "", "getName", "()Ljava/lang/String;", "configure", "", "task", "Lcom/android/build/gradle/internal/tasks/LibraryJniLibsTask;", "gradle-core"})
    public static final class ProjectOnlyCreationAction
    extends CreationAction {
        @NotNull
        private final String name;

        public ProjectOnlyCreationAction(@NotNull VariantCreationConfig creationConfig, @NotNull InternalArtifactType<Directory> artifactType) {
            Intrinsics.checkNotNullParameter((Object)creationConfig, (String)"creationConfig");
            Intrinsics.checkNotNullParameter(artifactType, (String)"artifactType");
            super(creationConfig, artifactType);
            this.name = this.computeTaskName("copy", "JniLibsProjectOnly");
        }

        @Override
        @NotNull
        public String getName() {
            return this.name;
        }

        @Override
        public void configure(@NotNull LibraryJniLibsTask task) {
            Intrinsics.checkNotNullParameter((Object)task, (String)"task");
            super.configure((Task)task);
            HasConfigurableValuesKt.setDisallowChanges((Property)task.getProjectNativeLibs(), ((VariantCreationConfig)this.creationConfig).getArtifacts().get((SingleArtifact)SingleArtifact.MERGED_NATIVE_LIBS.INSTANCE));
            task.getLocalJarsNativeLibs().disallowChanges();
        }
    }
}

