/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal;

import com.android.build.api.artifact.impl.InternalScopedArtifacts;
import com.android.build.api.variant.VariantBuilder;
import com.android.build.gradle.internal.TaskManager;
import com.android.build.gradle.internal.VariantTaskManager;
import com.android.build.gradle.internal.component.ApkCreationConfig;
import com.android.build.gradle.internal.component.ApplicationCreationConfig;
import com.android.build.gradle.internal.component.ComponentCreationConfig;
import com.android.build.gradle.internal.component.ConsumableCreationConfig;
import com.android.build.gradle.internal.component.DynamicFeatureCreationConfig;
import com.android.build.gradle.internal.component.TestComponentCreationConfig;
import com.android.build.gradle.internal.component.TestFixturesCreationConfig;
import com.android.build.gradle.internal.component.VariantCreationConfig;
import com.android.build.gradle.internal.feature.BundleAllClasses;
import com.android.build.gradle.internal.profile.AnalyticsConfiguratorService;
import com.android.build.gradle.internal.publishing.AndroidArtifacts;
import com.android.build.gradle.internal.services.BuildServicesKt;
import com.android.build.gradle.internal.tasks.ApkZipPackagingTask;
import com.android.build.gradle.internal.tasks.AppClasspathCheckTask;
import com.android.build.gradle.internal.tasks.AppPreBuildTask;
import com.android.build.gradle.internal.tasks.ApplicationIdWriterTask;
import com.android.build.gradle.internal.tasks.CheckManifest;
import com.android.build.gradle.internal.tasks.CheckMultiApkLibrariesTask;
import com.android.build.gradle.internal.tasks.CompressAssetsTask;
import com.android.build.gradle.internal.tasks.ExtractNativeDebugMetadataTask;
import com.android.build.gradle.internal.tasks.ExtractProfilerNativeDependenciesTask;
import com.android.build.gradle.internal.tasks.ModuleMetadataWriterTask;
import com.android.build.gradle.internal.tasks.ProcessNavigationXmlTask;
import com.android.build.gradle.internal.tasks.StripDebugSymbolsTask;
import com.android.build.gradle.internal.tasks.factory.GlobalTaskCreationConfig;
import com.android.build.gradle.internal.tasks.factory.TaskFactoryUtils;
import com.android.build.gradle.internal.tasks.factory.TaskManagerConfig;
import com.android.build.gradle.internal.tasks.featuresplit.PackagedDependenciesWriterTask;
import com.android.build.gradle.internal.variant.ComponentInfo;
import com.android.build.gradle.options.BooleanOption;
import com.android.build.gradle.options.ProjectOptions;
import com.android.build.gradle.tasks.CompileNavigationXmlTask;
import com.android.build.gradle.tasks.ExtractDeepLinksTask;
import com.android.build.gradle.tasks.MergeResources;
import com.android.builder.core.ComponentType;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Set;
import org.gradle.api.Project;
import org.gradle.api.resources.TextResourceFactory;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.compile.JavaCompile;

public abstract class AbstractAppTaskManager<VariantBuilderT extends VariantBuilder, VariantT extends VariantCreationConfig>
extends VariantTaskManager<VariantBuilderT, VariantT> {
    protected AbstractAppTaskManager(Project project, Collection<? extends ComponentInfo<VariantBuilderT, VariantT>> variants, Collection<? extends TestComponentCreationConfig> testComponents, Collection<? extends TestFixturesCreationConfig> testFixturesComponents, GlobalTaskCreationConfig globalConfig2, TaskManagerConfig localConfig) {
        super(project, variants, testComponents, testFixturesComponents, globalConfig2, localConfig);
    }

    protected void createCommonTasks(ComponentInfo<VariantBuilderT, VariantT> variant) {
        ApkCreationConfig creationConfig = (ApkCreationConfig)variant.getVariant();
        if (!(creationConfig instanceof DynamicFeatureCreationConfig) && !creationConfig.getDebuggable()) {
            ((AnalyticsConfiguratorService)BuildServicesKt.getBuildService(this.project.getGradle().getSharedServices(), AnalyticsConfiguratorService.class).get()).recordApplicationId(creationConfig.getApplicationId());
        }
        this.createAnchorTasks(creationConfig);
        this.taskFactory.register(new ExtractDeepLinksTask.CreationAction(creationConfig));
        this.createDependencyStreams(creationConfig);
        this.createApplicationIdWriterTask(creationConfig);
        this.taskFactory.register(new CheckManifest.CreationAction(creationConfig));
        this.createMergeApkManifestsTask(creationConfig);
        this.createGenerateResValuesTask(creationConfig);
        this.createRenderscriptTask(creationConfig);
        this.createMergeResourcesTasks(creationConfig);
        this.createNavigationProcessingTasks(creationConfig);
        this.createShaderTask(creationConfig);
        this.createMergeAssetsTask(creationConfig, true);
        this.taskFactory.register(new CompressAssetsTask.CreationAction(creationConfig));
        this.createBuildConfigTask(creationConfig);
        this.createApkProcessResTask(creationConfig);
        this.createProcessJavaResTask(creationConfig);
        this.createAidlTask(creationConfig);
        this.maybeExtractProfilerDependencies(creationConfig);
        this.createMergeJniLibFoldersTasks(creationConfig);
        this.createDataBindingTasksIfNecessary(creationConfig);
        this.createMlkitTask(creationConfig);
        this.createCompileTask(creationConfig);
        this.taskFactory.register(new StripDebugSymbolsTask.CreationAction((ConsumableCreationConfig)variant.getVariant()));
        this.taskFactory.register(new ExtractNativeDebugMetadataTask.FullCreationAction((VariantCreationConfig)variant.getVariant()));
        this.taskFactory.register(new ExtractNativeDebugMetadataTask.SymbolTableCreationAction((VariantCreationConfig)variant.getVariant()));
        this.createPackagingTask(creationConfig);
        this.taskFactory.register(new PackagedDependenciesWriterTask.CreationAction(creationConfig));
        this.taskFactory.register(new ApkZipPackagingTask.CreationAction(creationConfig));
    }

    private void createCompileTask(ApkCreationConfig creationConfig) {
        TaskProvider<? extends JavaCompile> javacTask = this.createJavacTask(creationConfig);
        AbstractAppTaskManager.setJavaCompilerTask(javacTask, creationConfig);
        this.createPostCompilationTasks(creationConfig);
    }

    @Override
    protected void postJavacCreation(ComponentCreationConfig creationConfig) {
        super.postJavacCreation(creationConfig);
        this.taskFactory.register(new BundleAllClasses.CreationAction(creationConfig, AndroidArtifacts.PublishedConfigType.API_ELEMENTS));
        this.taskFactory.register(new BundleAllClasses.CreationAction(creationConfig, AndroidArtifacts.PublishedConfigType.RUNTIME_ELEMENTS));
    }

    @Override
    protected void createVariantPreBuildTask(ComponentCreationConfig creationConfig) {
        ComponentType componentType = creationConfig.getComponentType();
        boolean useDependencyConstraints = creationConfig.getServices().getProjectOptions().get(BooleanOption.USE_DEPENDENCY_CONSTRAINTS);
        boolean enableClasspathCheckTask = creationConfig.getServices().getProjectOptions().get(BooleanOption.ENABLE_CLASSPATH_CHECK_TASKS);
        TaskProvider task = this.taskFactory.register(AppPreBuildTask.getCreationAction(creationConfig));
        if (!useDependencyConstraints && enableClasspathCheckTask) {
            TaskProvider<AppClasspathCheckTask> classpathCheck = this.taskFactory.register(new AppClasspathCheckTask.CreationAction(creationConfig));
            TaskFactoryUtils.dependsOn(task, classpathCheck);
        }
        if (componentType.isBaseModule() && this.globalConfig.getHasDynamicFeatures()) {
            TaskProvider<CheckMultiApkLibrariesTask> checkMultiApkLibrariesTask = this.taskFactory.register(new CheckMultiApkLibrariesTask.CreationAction(creationConfig));
            TaskFactoryUtils.dependsOn(task, checkMultiApkLibrariesTask);
        }
    }

    @Override
    protected Set<InternalScopedArtifacts.InternalScope> getJavaResMergingScopes() {
        return Set.of(InternalScopedArtifacts.InternalScope.SUB_PROJECTS, InternalScopedArtifacts.InternalScope.EXTERNAL_LIBS);
    }

    private void createApplicationIdWriterTask(ApkCreationConfig creationConfig) {
        if (creationConfig.getComponentType().isBaseModule()) {
            this.taskFactory.register(new ModuleMetadataWriterTask.CreationAction((ApplicationCreationConfig)creationConfig));
        }
        TaskProvider<ApplicationIdWriterTask> applicationIdWriterTask = this.taskFactory.register(new ApplicationIdWriterTask.CreationAction(creationConfig));
        TextResourceFactory resources = this.project.getResources().getText();
        creationConfig.getOldVariantApiLegacySupport().getVariantData().applicationIdTextResource = resources.fromFile(applicationIdWriterTask);
    }

    private void createMergeResourcesTasks(ApkCreationConfig creationConfig) {
        this.createMergeResourcesTask(creationConfig, true, (Set<? extends MergeResources.Flag>)Sets.immutableEnumSet((Enum)MergeResources.Flag.PROCESS_VECTOR_DRAWABLES, (Enum[])new MergeResources.Flag[0]));
        ProjectOptions projectOptions = creationConfig.getServices().getProjectOptions();
        boolean nonTransitiveR = projectOptions.get(BooleanOption.NON_TRANSITIVE_R_CLASS);
        boolean appCompileRClass = projectOptions.get(BooleanOption.ENABLE_APP_COMPILE_TIME_R_CLASS);
        boolean namespaced = creationConfig.getGlobal().getNamespacedAndroidResources();
        if (namespaced) {
            return;
        }
        if (creationConfig.getComponentType().isForTesting() && !this.isTestApkCompileRClassEnabled(appCompileRClass, creationConfig.getComponentType())) {
            return;
        }
        if (appCompileRClass || nonTransitiveR) {
            this.basicCreateMergeResourcesTask(creationConfig, TaskManager.MergeType.PACKAGE, false, false, false, (Set<? extends MergeResources.Flag>)ImmutableSet.of(), null);
        }
    }

    private void createNavigationProcessingTasks(ApkCreationConfig creationConfig) {
        this.taskFactory.register(new ProcessNavigationXmlTask.ApplicationCreationAction(creationConfig));
        this.taskFactory.register(new CompileNavigationXmlTask.CreationAction(creationConfig));
    }

    private boolean isTestApkCompileRClassEnabled(boolean compileRClassFlag, ComponentType componentType) {
        return compileRClassFlag && componentType.isForTesting() && componentType.isApk();
    }

    private void maybeExtractProfilerDependencies(ApkCreationConfig apkCreationConfig) {
        if (apkCreationConfig.getShouldPackageProfilerDependencies()) {
            this.taskFactory.register(new ExtractProfilerNativeDependenciesTask.CreationAction(apkCreationConfig));
        }
    }
}

