/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.coverage;

import com.android.Version;
import com.google.common.collect.ImmutableList;
import com.google.common.io.Closeables;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.ArrayIteratorKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.logging.Logger;
import org.jacoco.core.analysis.Analyzer;
import org.jacoco.core.analysis.CoverageBuilder;
import org.jacoco.core.analysis.IBundleCoverage;
import org.jacoco.core.analysis.ICoverageVisitor;
import org.jacoco.core.data.ExecutionDataStore;
import org.jacoco.core.data.SessionInfoStore;
import org.jacoco.core.tools.ExecFileLoader;
import org.jacoco.report.DirectorySourceFileLocator;
import org.jacoco.report.FileMultiReportOutput;
import org.jacoco.report.IMultiReportOutput;
import org.jacoco.report.IReportVisitor;
import org.jacoco.report.ISourceFileLocator;
import org.jacoco.report.MultiReportVisitor;
import org.jacoco.report.MultiSourceFileLocator;
import org.jacoco.report.html.HTMLFormatter;
import org.jacoco.report.xml.XMLFormatter;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u00000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u001aR\u0010\u0000\u001a\u00020\u00012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\u0005\u001a\u00020\u00042\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0000\u001a\u001e\u0010\u000e\u001a\u00020\u00012\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0002\u001a&\u0010\u0011\u001a\u00020\u00012\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00042\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0002\u00a8\u0006\u0014"}, d2={"generateReport", "", "coverageFiles", "", "Ljava/io/File;", "reportDir", "classFolders", "sourceFolders", "tabWidth", "", "reportName", "", "logger", "Lorg/gradle/api/logging/Logger;", "analyzeAll", "analyzer", "Lorg/jacoco/core/analysis/Analyzer;", "analyze", "file", "originalClassFolders", "gradle-core"})
public final class CoverageUtilsKt {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void generateReport(@NotNull Collection<? extends File> coverageFiles, @NotNull File reportDir, @NotNull Collection<? extends File> classFolders, @NotNull Collection<? extends File> sourceFolders, int tabWidth, @NotNull String reportName, @NotNull Logger logger) throws IOException {
        Intrinsics.checkNotNullParameter(coverageFiles, (String)"coverageFiles");
        Intrinsics.checkNotNullParameter((Object)reportDir, (String)"reportDir");
        Intrinsics.checkNotNullParameter(classFolders, (String)"classFolders");
        Intrinsics.checkNotNullParameter(sourceFolders, (String)"sourceFolders");
        Intrinsics.checkNotNullParameter((Object)reportName, (String)"reportName");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        ExecFileLoader loader = new ExecFileLoader();
        for (File file : coverageFiles) {
            loader.load(file);
        }
        SessionInfoStore sessionInfoStore = loader.getSessionInfoStore();
        ExecutionDataStore executionDataStore = loader.getExecutionDataStore();
        HTMLFormatter htmlFormatter = new HTMLFormatter();
        htmlFormatter.setOutputEncoding("UTF-8");
        htmlFormatter.setLocale(Locale.US);
        htmlFormatter.setFooterText("Generated by the Android Gradle plugin " + Version.ANDROID_GRADLE_PLUGIN_VERSION);
        FileMultiReportOutput output2 = new FileMultiReportOutput(reportDir);
        IReportVisitor htmlReport = htmlFormatter.createVisitor((IMultiReportOutput)output2);
        XMLFormatter xmlFormatter = new XMLFormatter();
        xmlFormatter.setOutputEncoding("UTF-8");
        OutputStream xmlReportOutput = output2.createFile("report.xml");
        try {
            IReportVisitor xmlReport = xmlFormatter.createVisitor(xmlReportOutput);
            IReportVisitor visitor2 = (IReportVisitor)new MultiReportVisitor((List)ImmutableList.of((Object)htmlReport, (Object)xmlReport));
            visitor2.visitInfo(sessionInfoStore.getInfos(), executionDataStore.getContents());
            CoverageBuilder builder = new CoverageBuilder();
            Analyzer analyzer = new Analyzer(executionDataStore, (ICoverageVisitor)builder);
            CoverageUtilsKt.analyzeAll(analyzer, classFolders);
            MultiSourceFileLocator locator = new MultiSourceFileLocator(0);
            for (File file : sourceFolders) {
                locator.add((ISourceFileLocator)new DirectorySourceFileLocator(file, "UTF-8", tabWidth));
            }
            IBundleCoverage bundle = builder.getBundle(reportName);
            visitor2.visitBundle(bundle, (ISourceFileLocator)locator);
            visitor2.visitEnd();
        }
        finally {
            try {
                xmlReportOutput.close();
            }
            catch (IOException e) {
                logger.error("Could not close xml report file", (Throwable)e);
            }
        }
    }

    private static final void analyzeAll(Analyzer analyzer, Collection<? extends File> classFolders) throws IOException {
        for (File file : classFolders) {
            CoverageUtilsKt.analyze(analyzer, file, classFolders);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void analyze(Analyzer analyzer, File file, Collection<? extends File> originalClassFolders) throws IOException {
        block6: {
            block5: {
                if (!file.isDirectory()) break block5;
                Object[] files = file.listFiles();
                if (files == null) break block6;
                Iterator iterator2 = ArrayIteratorKt.iterator((Object[])files);
                while (iterator2.hasNext()) {
                    File f = (File)iterator2.next();
                    if (originalClassFolders.contains(f)) continue;
                    Intrinsics.checkNotNull((Object)f);
                    CoverageUtilsKt.analyze(analyzer, f, originalClassFolders);
                }
                break block6;
            }
            String name = file.getName();
            Intrinsics.checkNotNull((Object)name);
            if (!StringsKt.endsWith$default((String)name, (String)".class", (boolean)false, (int)2, null) || Intrinsics.areEqual((Object)name, (Object)"R.class") || StringsKt.startsWith$default((String)name, (String)"R$", (boolean)false, (int)2, null) || Intrinsics.areEqual((Object)name, (Object)"Manifest.class") || StringsKt.startsWith$default((String)name, (String)"Manifest$", (boolean)false, (int)2, null) || Intrinsics.areEqual((Object)name, (Object)"BuildConfig.class")) {
                return;
            }
            InputStream in = new FileInputStream(file);
            try {
                analyzer.analyzeClass(in, file.getAbsolutePath());
            }
            finally {
                Closeables.closeQuietly((InputStream)in);
            }
        }
    }
}

