/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.coverage;

import com.android.build.api.artifact.ScopedArtifact;
import com.android.build.api.variant.ScopedArtifacts;
import com.android.build.api.variant.impl.FlatSourceDirectoriesImpl;
import com.android.build.gradle.internal.component.TestComponentCreationConfig;
import com.android.build.gradle.internal.coverage.CoverageUtilsKt;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.tasks.BuildAnalyzer;
import com.android.build.gradle.internal.tasks.NonIncrementalTask;
import com.android.build.gradle.internal.tasks.factory.VariantTaskCreationAction;
import com.android.build.gradle.internal.utils.HasConfigurableValuesKt;
import com.android.buildanalyzer.common.TaskCategory;
import com.android.utils.StringHelper;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.gradle.api.Action;
import org.gradle.api.Task;
import org.gradle.api.Transformer;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.ConfigurableFileTree;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.work.DisableCachingByDefault;
import org.gradle.workers.ClassLoaderWorkerSpec;
import org.gradle.workers.WorkAction;
import org.gradle.workers.WorkParameters;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@DisableCachingByDefault
@BuildAnalyzer(primaryTaskCategory=TaskCategory.TEST)
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0007\b'\u0018\u00002\u00020\u0001:\u0006%&'()*B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010#\u001a\u00020$H\u0014R\u0014\u0010\u0004\u001a\u00020\u00058gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\t8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u00128gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\u00020\u00128gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0014R&\u0010\u0017\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001b0\u001a0\u00190\u00188gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR\u001a\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001f0\r8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010\u0010R\u0014\u0010!\u001a\u00020\u00058gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010\u0007\u00a8\u0006+"}, d2={"Lcom/android/build/gradle/internal/coverage/JacocoReportTask;", "Lcom/android/build/gradle/internal/tasks/NonIncrementalTask;", "<init>", "()V", "jacocoConnectedTestsCoverageDir", "Lorg/gradle/api/file/DirectoryProperty;", "getJacocoConnectedTestsCoverageDir", "()Lorg/gradle/api/file/DirectoryProperty;", "jacocoHostTestCoverageFile", "Lorg/gradle/api/file/RegularFileProperty;", "getJacocoHostTestCoverageFile", "()Lorg/gradle/api/file/RegularFileProperty;", "reportName", "Lorg/gradle/api/provider/Property;", "", "getReportName", "()Lorg/gradle/api/provider/Property;", "classFileCollection", "Lorg/gradle/api/file/ConfigurableFileCollection;", "getClassFileCollection", "()Lorg/gradle/api/file/ConfigurableFileCollection;", "jacocoClasspath", "getJacocoClasspath", "sources", "Lorg/gradle/api/provider/ListProperty;", "Lorg/gradle/api/provider/Provider;", "", "Lorg/gradle/api/file/ConfigurableFileTree;", "getSources", "()Lorg/gradle/api/provider/ListProperty;", "tabWidth", "", "getTabWidth", "outputReportDir", "getOutputReportDir", "doTaskAction", "", "BaseCreationAction", "CreateActionHostTest", "CreationActionConnectedTest", "CreationActionManagedDeviceTest", "JacocoWorkParameters", "JacocoReportWorkerAction", "gradle-core"})
@SourceDebugExtension(value={"SMAP\nJacocoReportTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JacocoReportTask.kt\ncom/android/build/gradle/internal/coverage/JacocoReportTask\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,297:1\n774#2:298\n865#2,2:299\n1563#2:301\n1634#2,2:302\n1563#2:304\n1634#2,3:305\n1636#2:308\n1669#2,8:309\n*S KotlinDebug\n*F\n+ 1 JacocoReportTask.kt\ncom/android/build/gradle/internal/coverage/JacocoReportTask\n*L\n126#1:298\n126#1:299,2\n136#1:301\n136#1:302,2\n137#1:304\n137#1:305,3\n136#1:308\n138#1:309,8\n*E\n"})
public abstract class JacocoReportTask
extends NonIncrementalTask {
    @InputDirectory
    @PathSensitive(value=PathSensitivity.NONE)
    @Optional
    @NotNull
    public abstract DirectoryProperty getJacocoConnectedTestsCoverageDir();

    @InputFile
    @PathSensitive(value=PathSensitivity.NAME_ONLY)
    @Optional
    @NotNull
    public abstract RegularFileProperty getJacocoHostTestCoverageFile();

    @Input
    @NotNull
    public abstract Property<String> getReportName();

    @Classpath
    @NotNull
    public abstract ConfigurableFileCollection getClassFileCollection();

    @Classpath
    @NotNull
    public abstract ConfigurableFileCollection getJacocoClasspath();

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @NotNull
    public abstract ListProperty<Provider<List<ConfigurableFileTree>>> getSources();

    @Internal
    @NotNull
    public abstract Property<Integer> getTabWidth();

    @OutputDirectory
    @NotNull
    public abstract DirectoryProperty getOutputReportDir();

    /*
     * WARNING - void declaration
     */
    @Override
    protected void doTaskAction() {
        void $this$mapTo$iv$iv;
        File p0;
        Iterable $this$filterTo$iv$iv;
        Collection destination$iv$iv;
        Set set;
        if (!this.getJacocoConnectedTestsCoverageDir().isPresent() && !this.getJacocoHostTestCoverageFile().isPresent()) {
            throw new IOException("No coverage data found. Please enable code coverage for this build type in build.gradle.");
        }
        if (this.getJacocoHostTestCoverageFile().isPresent()) {
            set = SetsKt.setOf((Object)((RegularFile)this.getJacocoHostTestCoverageFile().get()).getAsFile());
        } else {
            Set set2 = ((Directory)this.getJacocoConnectedTestsCoverageDir().get()).getAsFileTree().getFiles();
            Intrinsics.checkNotNullExpressionValue((Object)set2, (String)"getFiles(...)");
            Iterable $this$filter$iv = set2;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                p0 = (File)element$iv$iv;
                boolean bl = false;
                if (!p0.isFile()) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List connectedTestJacocoFiles = (List)destination$iv$iv;
            if (CollectionsKt.none((Iterable)connectedTestJacocoFiles)) {
                String path = ((Directory)this.getJacocoConnectedTestsCoverageDir().get()).getAsFile().getAbsolutePath();
                throw new IOException("No coverage data to process in directories [" + path + "]");
            }
            set = CollectionsKt.toSet((Iterable)connectedTestJacocoFiles);
        }
        Set coverageFiles = set;
        Object object = this.getSources().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        Iterable $this$map$iv = (Iterable)object;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void $this$mapTo$iv$iv2;
            void it;
            p0 = (Provider)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Object object2 = it.get();
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"get(...)");
            Iterable $this$map$iv2 = (Iterable)object2;
            boolean $i$f$map2 = false;
            Iterable iterable = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
                void p02;
                ConfigurableFileTree configurableFileTree = (ConfigurableFileTree)item$iv$iv2;
                Collection collection2 = destination$iv$iv2;
                boolean bl2 = false;
                collection2.add(p02.getDir());
            }
            collection.add((List)destination$iv$iv2);
        }
        Iterable $this$distinctBy$iv = CollectionsKt.flatten((Iterable)((List)destination$iv$iv));
        boolean $i$f$distinctBy = false;
        HashSet<String> set$iv = new HashSet<String>();
        ArrayList list$iv = new ArrayList();
        for (Object e$iv : $this$distinctBy$iv) {
            File it = (File)e$iv;
            boolean bl = false;
            String key$iv = it.getAbsolutePath();
            if (!set$iv.add(key$iv)) continue;
            list$iv.add(e$iv);
        }
        List sourceFolders = list$iv;
        this.getWorkerExecutor().classLoaderIsolation(new Action(this){
            final /* synthetic */ JacocoReportTask this$0;
            {
                this.this$0 = $receiver;
            }

            public final void execute(ClassLoaderWorkerSpec classpath) {
                Intrinsics.checkNotNullParameter((Object)classpath, (String)"classpath");
                Object[] objectArray = new Object[]{this.this$0.getJacocoClasspath().getFiles()};
                classpath.getClasspath().from(objectArray);
            }
        }).submit(JacocoReportWorkerAction.class, new Action(coverageFiles, this, sourceFolders){
            final /* synthetic */ Set<File> $coverageFiles;
            final /* synthetic */ JacocoReportTask this$0;
            final /* synthetic */ List<File> $sourceFolders;
            {
                this.$coverageFiles = $coverageFiles;
                this.this$0 = $receiver;
                this.$sourceFolders = $sourceFolders;
            }

            public final void execute(JacocoWorkParameters it) {
                it.getCoverageFiles().setFrom((Iterable)this.$coverageFiles);
                it.getReportDir().set((Provider)this.this$0.getOutputReportDir());
                it.getClassFolders().setFrom((Iterable)this.this$0.getClassFileCollection());
                it.getSourceFolders().setFrom((Iterable)this.$sourceFolders);
                it.getTabWidth().set((Provider)this.this$0.getTabWidth());
                it.getReportName().set((Provider)this.this$0.getReportName());
            }
        });
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B%\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0016\u0010\u0014\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u0002H\u0016R\u0016\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00020\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u001a"}, d2={"Lcom/android/build/gradle/internal/coverage/JacocoReportTask$BaseCreationAction;", "Lcom/android/build/gradle/internal/tasks/factory/VariantTaskCreationAction;", "Lcom/android/build/gradle/internal/coverage/JacocoReportTask;", "Lcom/android/build/gradle/internal/component/TestComponentCreationConfig;", "testComponentProperties", "jacocoAntConfiguration", "Lorg/gradle/api/artifacts/Configuration;", "coverageReportSubDirName", "", "<init>", "(Lcom/android/build/gradle/internal/component/TestComponentCreationConfig;Lorg/gradle/api/artifacts/Configuration;Ljava/lang/String;)V", "getJacocoAntConfiguration", "()Lorg/gradle/api/artifacts/Configuration;", "name", "getName", "()Ljava/lang/String;", "type", "Ljava/lang/Class;", "getType", "()Ljava/lang/Class;", "handleProvider", "", "taskProvider", "Lorg/gradle/api/tasks/TaskProvider;", "configure", "task", "gradle-core"})
    public static abstract class BaseCreationAction
    extends VariantTaskCreationAction<JacocoReportTask, TestComponentCreationConfig> {
        @Nullable
        private final Configuration jacocoAntConfiguration;
        @NotNull
        private final String coverageReportSubDirName;

        public BaseCreationAction(@NotNull TestComponentCreationConfig testComponentProperties, @Nullable Configuration jacocoAntConfiguration, @NotNull String coverageReportSubDirName) {
            Intrinsics.checkNotNullParameter((Object)testComponentProperties, (String)"testComponentProperties");
            Intrinsics.checkNotNullParameter((Object)coverageReportSubDirName, (String)"coverageReportSubDirName");
            super(testComponentProperties, false, 2, null);
            this.jacocoAntConfiguration = jacocoAntConfiguration;
            this.coverageReportSubDirName = coverageReportSubDirName;
        }

        public /* synthetic */ BaseCreationAction(TestComponentCreationConfig testComponentCreationConfig, Configuration configuration, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                configuration = null;
            }
            if ((n & 4) != 0) {
                string = "";
            }
            this(testComponentCreationConfig, configuration, string);
        }

        @Nullable
        protected Configuration getJacocoAntConfiguration() {
            return this.jacocoAntConfiguration;
        }

        @Override
        @NotNull
        public String getName() {
            return this.computeTaskName("create", "CoverageReport");
        }

        @Override
        @NotNull
        public Class<JacocoReportTask> getType() {
            return JacocoReportTask.class;
        }

        @Override
        public void handleProvider(@NotNull TaskProvider<JacocoReportTask> taskProvider) {
            Intrinsics.checkNotNullParameter(taskProvider, (String)"taskProvider");
            super.handleProvider(taskProvider);
            ((TestComponentCreationConfig)this.creationConfig).getTaskContainer().setCoverageReportTask(taskProvider);
        }

        @Override
        public void configure(@NotNull JacocoReportTask task) {
            Intrinsics.checkNotNullParameter((Object)task, (String)"task");
            super.configure((Task)task);
            task.getJacocoClasspath().setFrom((Iterable)this.getJacocoAntConfiguration());
            if (!StringsKt.isBlank((CharSequence)this.coverageReportSubDirName)) {
                task.getOutputReportDir().set(((TestComponentCreationConfig)this.creationConfig).getPaths().getCoverageReportDir().map(new Transformer(this){
                    final /* synthetic */ BaseCreationAction this$0;
                    {
                        this.this$0 = $receiver;
                    }

                    public final Directory transform(Directory it) {
                        return it.dir(BaseCreationAction.access$getCoverageReportSubDirName$p(this.this$0));
                    }
                }));
            } else {
                task.getOutputReportDir().set(((TestComponentCreationConfig)this.creationConfig).getPaths().getCoverageReportDir());
            }
            task.getOutputReportDir().disallowChanges();
            HasConfigurableValuesKt.setDisallowChanges(task.getReportName(), ((TestComponentCreationConfig)this.creationConfig).getMainVariant().getName());
            HasConfigurableValuesKt.setDisallowChanges(task.getTabWidth(), 4);
            ((TestComponentCreationConfig)this.creationConfig).getMainVariant().getSources().java((Function1<? super FlatSourceDirectoriesImpl, Unit>)((Function1)new Function1<FlatSourceDirectoriesImpl, Unit>(task){
                final /* synthetic */ JacocoReportTask $task;
                {
                    this.$task = $task;
                    super(1);
                }

                public final void invoke(FlatSourceDirectoriesImpl javaSources) {
                    Intrinsics.checkNotNullParameter((Object)javaSources, (String)"javaSources");
                    this.$task.getSources().addAll(javaSources.getAsFileTrees$gradle_core());
                }
            }));
            ((TestComponentCreationConfig)this.creationConfig).getMainVariant().getSources().kotlin((Function1<? super FlatSourceDirectoriesImpl, Unit>)((Function1)new Function1<FlatSourceDirectoriesImpl, Unit>(task){
                final /* synthetic */ JacocoReportTask $task;
                {
                    this.$task = $task;
                    super(1);
                }

                public final void invoke(FlatSourceDirectoriesImpl kotlinSources) {
                    Intrinsics.checkNotNullParameter((Object)kotlinSources, (String)"kotlinSources");
                    this.$task.getSources().addAll(kotlinSources.getAsFileTrees$gradle_core());
                }
            }));
            task.getSources().disallowChanges();
            Object[] objectArray = new Object[]{((TestComponentCreationConfig)this.creationConfig).getMainVariant().getArtifacts().forScope(ScopedArtifacts.Scope.PROJECT).getScopedArtifactsContainer$gradle_core((ScopedArtifact)ScopedArtifact.CLASSES.INSTANCE).getFinalScopedContent()};
            HasConfigurableValuesKt.fromDisallowChanges(task.getClassFileCollection(), objectArray);
        }

        public static final /* synthetic */ String access$getCoverageReportSubDirName$p(BaseCreationAction $this) {
            return $this.coverageReportSubDirName;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u0016\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/android/build/gradle/internal/coverage/JacocoReportTask$CreateActionHostTest;", "Lcom/android/build/gradle/internal/coverage/JacocoReportTask$BaseCreationAction;", "testComponentProperties", "Lcom/android/build/gradle/internal/component/TestComponentCreationConfig;", "jacocoAntConfiguration", "Lorg/gradle/api/artifacts/Configuration;", "testTaskName", "", "internalArtifactType", "Lcom/android/build/gradle/internal/scope/InternalArtifactType;", "Lorg/gradle/api/file/RegularFile;", "<init>", "(Lcom/android/build/gradle/internal/component/TestComponentCreationConfig;Lorg/gradle/api/artifacts/Configuration;Ljava/lang/String;Lcom/android/build/gradle/internal/scope/InternalArtifactType;)V", "getJacocoAntConfiguration", "()Lorg/gradle/api/artifacts/Configuration;", "configure", "", "task", "Lcom/android/build/gradle/internal/coverage/JacocoReportTask;", "gradle-core"})
    public static final class CreateActionHostTest
    extends BaseCreationAction {
        @Nullable
        private final Configuration jacocoAntConfiguration;
        @NotNull
        private final String testTaskName;
        @NotNull
        private final InternalArtifactType<RegularFile> internalArtifactType;

        public CreateActionHostTest(@NotNull TestComponentCreationConfig testComponentProperties, @Nullable Configuration jacocoAntConfiguration, @NotNull String testTaskName, @NotNull InternalArtifactType<RegularFile> internalArtifactType) {
            Intrinsics.checkNotNullParameter((Object)testComponentProperties, (String)"testComponentProperties");
            Intrinsics.checkNotNullParameter((Object)testTaskName, (String)"testTaskName");
            Intrinsics.checkNotNullParameter(internalArtifactType, (String)"internalArtifactType");
            super(testComponentProperties, jacocoAntConfiguration, null, 4, null);
            this.jacocoAntConfiguration = jacocoAntConfiguration;
            this.testTaskName = testTaskName;
            this.internalArtifactType = internalArtifactType;
        }

        public /* synthetic */ CreateActionHostTest(TestComponentCreationConfig testComponentCreationConfig, Configuration configuration, String string, InternalArtifactType internalArtifactType, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                configuration = null;
            }
            this(testComponentCreationConfig, configuration, string, internalArtifactType);
        }

        @Override
        @Nullable
        protected Configuration getJacocoAntConfiguration() {
            return this.jacocoAntConfiguration;
        }

        @Override
        public void configure(@NotNull JacocoReportTask task) {
            Intrinsics.checkNotNullParameter((Object)task, (String)"task");
            super.configure(task);
            String testName = ((TestComponentCreationConfig)this.creationConfig).getComponentType().isForScreenshotPreview() ? "screenshot" : "unit";
            task.setDescription("Generates a Jacoco code coverage report from " + testName + " tests.");
            ((TestComponentCreationConfig)this.creationConfig).getArtifacts().setTaskInputToFinalProduct(this.internalArtifactType, (Property)task.getJacocoHostTestCoverageFile());
            Object[] objectArray = new Object[]{this.testTaskName + StringHelper.usLocaleCapitalize((String)((TestComponentCreationConfig)this.creationConfig).getName())};
            task.dependsOn(objectArray);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u000e"}, d2={"Lcom/android/build/gradle/internal/coverage/JacocoReportTask$CreationActionConnectedTest;", "Lcom/android/build/gradle/internal/coverage/JacocoReportTask$BaseCreationAction;", "testComponentProperties", "Lcom/android/build/gradle/internal/component/TestComponentCreationConfig;", "jacocoAntConfiguration", "Lorg/gradle/api/artifacts/Configuration;", "<init>", "(Lcom/android/build/gradle/internal/component/TestComponentCreationConfig;Lorg/gradle/api/artifacts/Configuration;)V", "getJacocoAntConfiguration", "()Lorg/gradle/api/artifacts/Configuration;", "configure", "", "task", "Lcom/android/build/gradle/internal/coverage/JacocoReportTask;", "gradle-core"})
    public static final class CreationActionConnectedTest
    extends BaseCreationAction {
        @NotNull
        private final Configuration jacocoAntConfiguration;

        public CreationActionConnectedTest(@NotNull TestComponentCreationConfig testComponentProperties, @NotNull Configuration jacocoAntConfiguration) {
            Intrinsics.checkNotNullParameter((Object)testComponentProperties, (String)"testComponentProperties");
            Intrinsics.checkNotNullParameter((Object)jacocoAntConfiguration, (String)"jacocoAntConfiguration");
            super(testComponentProperties, jacocoAntConfiguration, "connected");
            this.jacocoAntConfiguration = jacocoAntConfiguration;
        }

        @Override
        @NotNull
        protected Configuration getJacocoAntConfiguration() {
            return this.jacocoAntConfiguration;
        }

        @Override
        public void configure(@NotNull JacocoReportTask task) {
            Intrinsics.checkNotNullParameter((Object)task, (String)"task");
            super.configure(task);
            task.setDescription("Creates JaCoCo test coverage report from data gathered on the device.");
            ((TestComponentCreationConfig)this.creationConfig).getArtifacts().setTaskInputToFinalProduct(InternalArtifactType.CODE_COVERAGE.INSTANCE, (Property)task.getJacocoConnectedTestsCoverageDir());
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0012"}, d2={"Lcom/android/build/gradle/internal/coverage/JacocoReportTask$CreationActionManagedDeviceTest;", "Lcom/android/build/gradle/internal/coverage/JacocoReportTask$BaseCreationAction;", "testComponentProperties", "Lcom/android/build/gradle/internal/component/TestComponentCreationConfig;", "jacocoAntConfiguration", "Lorg/gradle/api/artifacts/Configuration;", "<init>", "(Lcom/android/build/gradle/internal/component/TestComponentCreationConfig;Lorg/gradle/api/artifacts/Configuration;)V", "getJacocoAntConfiguration", "()Lorg/gradle/api/artifacts/Configuration;", "name", "", "getName", "()Ljava/lang/String;", "configure", "", "task", "Lcom/android/build/gradle/internal/coverage/JacocoReportTask;", "gradle-core"})
    public static final class CreationActionManagedDeviceTest
    extends BaseCreationAction {
        @NotNull
        private final Configuration jacocoAntConfiguration;

        public CreationActionManagedDeviceTest(@NotNull TestComponentCreationConfig testComponentProperties, @NotNull Configuration jacocoAntConfiguration) {
            Intrinsics.checkNotNullParameter((Object)testComponentProperties, (String)"testComponentProperties");
            Intrinsics.checkNotNullParameter((Object)jacocoAntConfiguration, (String)"jacocoAntConfiguration");
            super(testComponentProperties, jacocoAntConfiguration, "managedDevice");
            this.jacocoAntConfiguration = jacocoAntConfiguration;
        }

        @Override
        @NotNull
        protected Configuration getJacocoAntConfiguration() {
            return this.jacocoAntConfiguration;
        }

        @Override
        @NotNull
        public String getName() {
            return this.computeTaskName("createManagedDevice", "CoverageReport");
        }

        @Override
        public void configure(@NotNull JacocoReportTask task) {
            Intrinsics.checkNotNullParameter((Object)task, (String)"task");
            super.configure(task);
            task.setDescription("Creates JaCoCo test coverage report from data gathered on the Gradle managed device.");
            ((TestComponentCreationConfig)this.creationConfig).getArtifacts().setTaskInputToFinalProduct(InternalArtifactType.MANAGED_DEVICE_CODE_COVERAGE.INSTANCE, (Property)task.getJacocoConnectedTestsCoverageDir());
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\b&\u0018\u0000 \u00072\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0007B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\b"}, d2={"Lcom/android/build/gradle/internal/coverage/JacocoReportTask$JacocoReportWorkerAction;", "Lorg/gradle/workers/WorkAction;", "Lcom/android/build/gradle/internal/coverage/JacocoReportTask$JacocoWorkParameters;", "<init>", "()V", "execute", "", "Companion", "gradle-core"})
    public static abstract class JacocoReportWorkerAction
    implements WorkAction<JacocoWorkParameters> {
        @NotNull
        public static final Companion Companion = new Companion(null);
        private static final Logger logger = Logging.getLogger(JacocoReportWorkerAction.class);

        public void execute() {
            try {
                Set set = ((JacocoWorkParameters)this.getParameters()).getCoverageFiles().getFiles();
                Intrinsics.checkNotNullExpressionValue((Object)set, (String)"getFiles(...)");
                Collection collection = set;
                Object object = ((JacocoWorkParameters)this.getParameters()).getReportDir().getAsFile().get();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
                File file = (File)object;
                Set set2 = ((JacocoWorkParameters)this.getParameters()).getClassFolders().getFiles();
                Intrinsics.checkNotNullExpressionValue((Object)set2, (String)"getFiles(...)");
                Collection collection2 = set2;
                Set set3 = ((JacocoWorkParameters)this.getParameters()).getSourceFolders().getFiles();
                Intrinsics.checkNotNullExpressionValue((Object)set3, (String)"getFiles(...)");
                Collection collection3 = set3;
                Object object2 = ((JacocoWorkParameters)this.getParameters()).getTabWidth().get();
                Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"get(...)");
                int n = ((Number)object2).intValue();
                Object object3 = ((JacocoWorkParameters)this.getParameters()).getReportName().get();
                Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"get(...)");
                String string = (String)object3;
                Logger logger = JacocoReportWorkerAction.logger;
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"logger");
                CoverageUtilsKt.generateReport(collection, file, collection2, collection3, n, string, logger);
            }
            catch (IOException e) {
                throw new UncheckedIOException("Unable to generate Jacoco report", e);
            }
            URI reportLocation = ((Directory)((JacocoWorkParameters)this.getParameters()).getReportDir().getLocationOnly().get()).file("index.html").getAsFile().toURI();
            logger.lifecycle("View coverage report at " + reportLocation);
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0019\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lcom/android/build/gradle/internal/coverage/JacocoReportTask$JacocoReportWorkerAction$Companion;", "", "<init>", "()V", "logger", "Lorg/gradle/api/logging/Logger;", "kotlin.jvm.PlatformType", "getLogger", "()Lorg/gradle/api/logging/Logger;", "gradle-core"})
        public static final class Companion {
            private Companion() {
            }

            public final Logger getLogger() {
                return logger;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0012\u0010\u0006\u001a\u00020\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0012\u0010\n\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\u0005R\u0012\u0010\f\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u0005R\u0018\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0018\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u000fX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0012\u00a8\u0006\u0016\u00c0\u0006\u0003"}, d2={"Lcom/android/build/gradle/internal/coverage/JacocoReportTask$JacocoWorkParameters;", "Lorg/gradle/workers/WorkParameters;", "coverageFiles", "Lorg/gradle/api/file/ConfigurableFileCollection;", "getCoverageFiles", "()Lorg/gradle/api/file/ConfigurableFileCollection;", "reportDir", "Lorg/gradle/api/file/DirectoryProperty;", "getReportDir", "()Lorg/gradle/api/file/DirectoryProperty;", "classFolders", "getClassFolders", "sourceFolders", "getSourceFolders", "tabWidth", "Lorg/gradle/api/provider/Property;", "", "getTabWidth", "()Lorg/gradle/api/provider/Property;", "reportName", "", "getReportName", "gradle-core"})
    public static interface JacocoWorkParameters
    extends WorkParameters {
        @NotNull
        public ConfigurableFileCollection getCoverageFiles();

        @NotNull
        public DirectoryProperty getReportDir();

        @NotNull
        public ConfigurableFileCollection getClassFolders();

        @NotNull
        public ConfigurableFileCollection getSourceFolders();

        @NotNull
        public Property<Integer> getTabWidth();

        @NotNull
        public Property<String> getReportName();
    }
}

