/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.cxx.configure;

import com.android.SdkConstants;
import com.android.build.gradle.internal.cxx.configure.CompileCommandsKt;
import com.android.build.gradle.internal.cxx.logging.LoggingEnvironmentKt;
import com.android.utils.TokenizedCommandLineMap;
import com.android.utils.cxx.CompileCommandsCodecKt;
import com.android.utils.cxx.CompileCommandsEncoder;
import com.android.utils.cxx.CxxDiagnosticCode;
import com.google.gson.stream.JsonReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.List;
import kotlin.Metadata;
import kotlin.Triple;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\"\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\u001a6\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\u0014\b\u0002\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00030\b\u001a\u0010\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\u0003H\u0002\u00a8\u0006\f"}, d2={"convertCMakeToCompileCommandsBin", "", "json", "Ljava/io/File;", "bin", "platform", "", "stringToFile", "Lkotlin/Function1;", "", "extractCMakeTargetFromObjectFile", "objectFile", "gradle-core"})
public final class CompileCommandsKt {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void convertCMakeToCompileCommandsBin(@NotNull File json, @NotNull File bin, int platform, @NotNull Function1<? super String, ? extends File> stringToFile) {
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        Intrinsics.checkNotNullParameter((Object)bin, (String)"bin");
        Intrinsics.checkNotNullParameter(stringToFile, (String)"stringToFile");
        if (bin.exists() && !CompileCommandsCodecKt.compileCommandsFileIsCurrentVersion((File)bin)) {
            LoggingEnvironmentKt.infoln("Deleting prior " + bin + " because it was invalid", new Object[0]);
            Files.delete(bin.toPath());
        }
        if (json.isFile()) {
            if (json.lastModified() == bin.lastModified()) {
                LoggingEnvironmentKt.infoln(bin + " was up-to-date with respect to " + json, new Object[0]);
                return;
            }
        } else {
            LoggingEnvironmentKt.infoln(bin + " existed but not " + json, new Object[0]);
            return;
        }
        Object object = json;
        Charset charset = StandardCharsets.UTF_8;
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
        Object object2 = charset;
        object = (Closeable)new JsonReader((Reader)new InputStreamReader((InputStream)new FileInputStream((File)object), (Charset)object2));
        object2 = null;
        try {
            JsonReader reader = (JsonReader)object;
            boolean bl = false;
            AutoCloseable autoCloseable = (AutoCloseable)new CompileCommandsEncoder(bin, 0, 2, null);
            Throwable throwable = null;
            try {
                CompileCommandsEncoder encoder = (CompileCommandsEncoder)autoCloseable;
                boolean bl2 = false;
                TokenizedCommandLineMap tokenMap2 = new TokenizedCommandLineMap(false, platform, (Function2)convertCMakeToCompileCommandsBin.2.1.tokenMap.1.INSTANCE);
                reader.beginArray();
                while (reader.hasNext()) {
                    String string;
                    String string2;
                    reader.beginObject();
                    String directory2 = null;
                    String command = null;
                    String sourceFile = null;
                    block23: while (reader.hasNext()) {
                        block37: {
                            string2 = reader.nextName();
                            if (string2 == null) break block37;
                            int n = -1;
                            switch (string2.hashCode()) {
                                case 3143036: {
                                    if (string2.equals("file")) {
                                        n = 1;
                                    }
                                    break;
                                }
                                case -962584979: {
                                    if (string2.equals("directory")) {
                                        n = 2;
                                    }
                                    break;
                                }
                                case 950394699: {
                                    if (string2.equals("command")) {
                                        n = 3;
                                    }
                                    break;
                                }
                            }
                            switch (n) {
                                case 2: {
                                    Intrinsics.checkNotNullExpressionValue((Object)reader.nextString(), (String)"nextString(...)");
                                    continue block23;
                                }
                                case 3: {
                                    Intrinsics.checkNotNullExpressionValue((Object)reader.nextString(), (String)"nextString(...)");
                                    continue block23;
                                }
                                case 1: {
                                    Intrinsics.checkNotNullExpressionValue((Object)reader.nextString(), (String)"nextString(...)");
                                    continue block23;
                                }
                            }
                        }
                        reader.skipValue();
                    }
                    reader.endObject();
                    String string3 = command;
                    if (string3 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"command");
                        string3 = null;
                    }
                    if ((string = sourceFile) == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"sourceFile");
                        string = null;
                    }
                    string2 = (Triple)tokenMap2.computeIfAbsent(string3, string, (Function1)convertCMakeToCompileCommandsBin.2.1.1.INSTANCE);
                    String compiler = (String)string2.component1();
                    List flags = (List)string2.component2();
                    String output2 = (String)string2.component3();
                    if (output2 == null) {
                        LoggingEnvironmentKt.errorln(CxxDiagnosticCode.COULD_NOT_EXTRACT_OUTPUT_FILE_FROM_CLANG_COMMAND, "Expected to find output file in command-line: " + CollectionsKt.joinToString$default((Iterable)flags, null, null, null, (int)0, null, null, (int)63, null), new Object[0]);
                        return;
                    }
                    File file = (File)stringToFile.invoke((Object)sourceFile);
                    File file2 = (File)stringToFile.invoke((Object)compiler);
                    String string4 = directory2;
                    if (string4 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"directory");
                        string4 = null;
                    }
                    encoder.writeCompileCommand(file, file2, flags, (File)stringToFile.invoke((Object)string4), (File)stringToFile.invoke((Object)output2), CompileCommandsKt.extractCMakeTargetFromObjectFile((File)stringToFile.invoke((Object)output2)));
                }
                reader.endArray();
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable) {
            object2 = throwable;
            throw throwable;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)object2);
        }
        bin.setLastModified(json.lastModified());
        LoggingEnvironmentKt.infoln("Exiting generation of " + bin + " normally", new Object[0]);
    }

    public static /* synthetic */ void convertCMakeToCompileCommandsBin$default(File file, File file2, int n, Function1 function1, int n2, Object object) {
        if ((n2 & 4) != 0) {
            n = SdkConstants.currentPlatform();
        }
        if ((n2 & 8) != 0) {
            function1 = convertCMakeToCompileCommandsBin.1.INSTANCE;
        }
        CompileCommandsKt.convertCMakeToCompileCommandsBin(file, file2, n, (Function1<? super String, ? extends File>)function1);
    }

    private static final String extractCMakeTargetFromObjectFile(File objectFile) {
        File current = objectFile.getParentFile();
        while (current != null) {
            if (Intrinsics.areEqual((Object)FilesKt.getExtension((File)current), (Object)"dir")) {
                String targetCandidate = FilesKt.getNameWithoutExtension((File)current);
                if ((current = current.getParentFile()) == null || !Intrinsics.areEqual((Object)current.getName(), (Object)"CMakeFiles")) continue;
                return targetCandidate;
            }
            current = current.getParentFile();
        }
        LoggingEnvironmentKt.errorln(CxxDiagnosticCode.OBJECT_FILE_CANT_BE_CONVERTED_TO_TARGET_NAME, "Could not determine target from [" + objectFile + "]", new Object[0]);
        return "unknown-target";
    }
}

