/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.dependency;

import com.android.build.gradle.internal.dependency.CollectPackagesForR8Transform;
import com.android.build.gradle.internal.dependency.GenericTransformParameters;
import com.android.build.gradle.internal.r8.TargetedR8Rules;
import com.android.build.gradle.internal.r8.TargetedR8RulesReadWriter;
import com.android.ide.common.xml.AndroidManifestParser;
import com.android.utils.PathUtils;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.gradle.api.artifacts.transform.InputArtifact;
import org.gradle.api.artifacts.transform.TransformAction;
import org.gradle.api.artifacts.transform.TransformOutputs;
import org.gradle.api.file.FileSystemLocation;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Classpath;
import org.gradle.work.DisableCachingByDefault;
import org.jetbrains.annotations.NotNull;

@DisableCachingByDefault
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0010\u000e\n\u0002\b\u0002\b'\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\rH\u0002J\u0018\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\rH\u0002J\u001a\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0012\u001a\u00020\u00102\b\b\u0002\u0010\u0015\u001a\u00020\u0014H\u0002J\u0016\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\u0006\u0010\u0019\u001a\u00020\u0010H\u0002R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\u001a"}, d2={"Lcom/android/build/gradle/internal/dependency/CollectPackagesForR8Transform;", "Lorg/gradle/api/artifacts/transform/TransformAction;", "Lcom/android/build/gradle/internal/dependency/GenericTransformParameters;", "<init>", "()V", "inputArtifact", "Lorg/gradle/api/provider/Provider;", "Lorg/gradle/api/file/FileSystemLocation;", "getInputArtifact", "()Lorg/gradle/api/provider/Provider;", "transform", "", "transformOutputs", "Lorg/gradle/api/artifacts/transform/TransformOutputs;", "transformExplodedAar", "explodedAarDirectory", "Ljava/io/File;", "transformJar", "jarFile", "containsConsumerProguardRules", "", "isClassesJarInAar", "getPackageNamesFromJar", "", "", "jar", "gradle-core"})
@SourceDebugExtension(value={"SMAP\nCollectPackagesForR8Transform.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CollectPackagesForR8Transform.kt\ncom/android/build/gradle/internal/dependency/CollectPackagesForR8Transform\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,134:1\n1869#2,2:135\n*S KotlinDebug\n*F\n+ 1 CollectPackagesForR8Transform.kt\ncom/android/build/gradle/internal/dependency/CollectPackagesForR8Transform\n*L\n88#1:135,2\n*E\n"})
public abstract class CollectPackagesForR8Transform
implements TransformAction<GenericTransformParameters> {
    @Classpath
    @InputArtifact
    @NotNull
    public abstract Provider<FileSystemLocation> getInputArtifact();

    public void transform(@NotNull TransformOutputs transformOutputs) {
        Intrinsics.checkNotNullParameter((Object)transformOutputs, (String)"transformOutputs");
        File inputFile = ((FileSystemLocation)this.getInputArtifact().get()).getAsFile();
        if (inputFile.isDirectory()) {
            Intrinsics.checkNotNull((Object)inputFile);
            this.transformExplodedAar(inputFile, transformOutputs);
        } else {
            Intrinsics.checkNotNull((Object)inputFile);
            this.transformJar(inputFile, transformOutputs);
        }
    }

    private final void transformExplodedAar(File explodedAarDirectory, TransformOutputs transformOutputs) {
        File file;
        File localJarsDir;
        Set packageNames = new LinkedHashSet();
        File jarsDir = FilesKt.resolve((File)explodedAarDirectory, (String)"jars");
        File classesJar = FilesKt.resolve((File)jarsDir, (String)"classes.jar");
        if (!classesJar.isFile()) {
            return;
        }
        Object[] objectArray = new File[]{classesJar};
        List allJars = CollectionsKt.mutableListOf((Object[])objectArray);
        if (!FilesKt.resolve((File)explodedAarDirectory, (String)"proguard.txt").isFile() && !this.containsConsumerProguardRules(classesJar, true)) {
            return;
        }
        File manifestFile = FilesKt.resolve((File)explodedAarDirectory, (String)"AndroidManifest.xml");
        String packageNameFromManifest = AndroidManifestParser.parse((Path)manifestFile.toPath()).getPackage();
        CharSequence charSequence = packageNameFromManifest;
        if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence))) {
            packageNames.add(packageNameFromManifest + ".*");
        }
        if ((localJarsDir = FilesKt.resolve((File)jarsDir, (String)"libs")).isDirectory()) {
            Object[] objectArray2 = localJarsDir.listFiles(transformExplodedAar.localJars.1.INSTANCE);
            Intrinsics.checkNotNull((Object)objectArray2);
            List localJars2 = ArraysKt.toList((Object[])objectArray2);
            allJars.addAll(localJars2);
        }
        Iterable $this$forEach$iv = allJars;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            File jar = (File)element$iv;
            boolean bl = false;
            Collection<String> packageNamesFromJar = this.getPackageNamesFromJar(jar);
            packageNames.addAll(packageNamesFromJar);
        }
        File $this$transformExplodedAar_u24lambda_u241 = file = transformOutputs.file((Object)"packages.txt");
        boolean bl = false;
        Intrinsics.checkNotNull((Object)$this$transformExplodedAar_u24lambda_u241);
        FilesKt.writeText$default((File)$this$transformExplodedAar_u24lambda_u241, (String)CollectionsKt.joinToString$default((Iterable)packageNames, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null), null, (int)2, null);
    }

    private final void transformJar(File jarFile, TransformOutputs transformOutputs) {
        File file;
        Set packageNames = new LinkedHashSet();
        if (!CollectPackagesForR8Transform.containsConsumerProguardRules$default(this, jarFile, false, 2, null)) {
            return;
        }
        packageNames.addAll(this.getPackageNamesFromJar(jarFile));
        File $this$transformJar_u24lambda_u242 = file = transformOutputs.file((Object)"packages.txt");
        boolean bl = false;
        Intrinsics.checkNotNull((Object)$this$transformJar_u24lambda_u242);
        FilesKt.writeText$default((File)$this$transformJar_u24lambda_u242, (String)CollectionsKt.joinToString$default((Iterable)packageNames, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null), null, (int)2, null);
    }

    private final boolean containsConsumerProguardRules(File jarFile, boolean isClassesJarInAar) {
        TargetedR8Rules targetedR8Rules = TargetedR8RulesReadWriter.INSTANCE.readFromJar(jarFile, isClassesJarInAar);
        return !((Collection)targetedR8Rules.getR8Rules()).isEmpty() || !((Collection)targetedR8Rules.getLegacyProguardRules()).isEmpty();
    }

    static /* synthetic */ boolean containsConsumerProguardRules$default(CollectPackagesForR8Transform collectPackagesForR8Transform, File file, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: containsConsumerProguardRules");
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        return collectPackagesForR8Transform.containsConsumerProguardRules(file, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Collection<String> getPackageNamesFromJar(File jar) {
        Set packageNames = new LinkedHashSet();
        Closeable closeable = new FileInputStream(jar);
        int n = 8192;
        closeable = new ZipInputStream(closeable instanceof BufferedInputStream ? (BufferedInputStream)closeable : new BufferedInputStream((InputStream)closeable, n));
        Throwable throwable = null;
        try {
            ZipInputStream stream2 = (ZipInputStream)closeable;
            boolean bl = false;
            while (stream2.getNextEntry() != null) {
                String packagePath;
                ZipEntry jarEntry;
                String string = jarEntry.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                if (!StringsKt.endsWith$default((String)string, (String)".class", (boolean)false, (int)2, null)) continue;
                Path entryPath = Paths.get(jarEntry.getName(), new String[0]);
                String systemIndependentPath = PathUtils.toSystemIndependentPath((Path)entryPath);
                Intrinsics.checkNotNull((Object)systemIndependentPath);
                int lastSeparatorIndex = StringsKt.lastIndexOf$default((CharSequence)systemIndependentPath, (String)"/", (int)0, (boolean)false, (int)6, null);
                if (lastSeparatorIndex == -1) continue;
                Intrinsics.checkNotNullExpressionValue((Object)systemIndependentPath.substring(0, lastSeparatorIndex), (String)"substring(...)");
                packageNames.add(StringsKt.replace$default((String)packagePath, (String)"/", (String)".", (boolean)false, (int)4, null) + ".*");
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return packageNames;
    }
}

